/*---------------------------------------------------------------------------*
  Project:  CTR_TRIAL
  File:     sys_AppType.h

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef SYS_APPTYPE_H_INCLUDED
#define SYS_APPTYPE_H_INCLUDED

#include <nn.h>
#include <string>

#define TESTLIST_ID_LCDANDKEY    0
#define TESTLIST_ID_ICAM         1
#define TESTLIST_ID_GYRO         2
#define TESTLIST_ID_AGING        3
#define TESTLIST_ID_TP           4
#define TESTLIST_ID_SCRATCH      5
#define TESTLIST_ID_ACC          6
#define TESTLIST_ID_MIC          7
#define TESTLIST_ID_SLIDEPAD     8
#define TESTLIST_ID_PRE_PROCCHK  9
#define TESTLIST_ID_PROCCHK     10
#define TESTLIST_ID_REENTRY     11
#define TESTLIST_ID_IMPORT      12
#define TESTLIST_ID_BACKUP      13
#define TESTLIST_ID_RESTORE     14
#define TESTLIST_ID_UPDATE      15
#define TESTLIST_ID_OCAM_WB     16
#define TESTLIST_ID_SP_AND_TP   17
#define TESTLIST_ID_CAM_CAPTURE 18
#define TESTLIST_ID_AGING_I     19
#define TESTLIST_ID_APP_I       20

// TestListΏۊO
#define TESTLIST_ID_WIRELESS    94
#define TESTLIST_ID_OCAM        95
#define TESTLIST_ID_INTERFACE   96
#define TESTLIST_ID_WL_AUDIO    97
#define TESTLIST_ID_PARALLAX    98
#define TESTLIST_ID_CAM_AND_IF  99

namespace uji{
namespace sys{

inline u8  AppTypeToTestListId(char * app_type1)
{
    u8 id = 0;

//    NN_LOG("AppTypeToTestListId called.\n");
//    NN_LOG(" %s,0x%p\n", __func__, &uji::sys::AppTypeToTestListId);
    std::string app_type(app_type1);

#ifdef EVA_IMPORT
    if(( "IMPORT"         == app_type ) && 
       ( "UPDATE_ONLY"    == UJI_REGION )){ app_type = "UPDATE"; }
#endif

// ( AvOMakefileł̖)           ( eXgXgIDj
    if ( "LCD_AND_KEY"    == app_type ) { id =  TESTLIST_ID_LCDANDKEY   ;}
    if ( "ICAM"           == app_type ) { id =  TESTLIST_ID_ICAM        ;}
    if ( "AGING"          == app_type ) { id =  TESTLIST_ID_AGING       ;}
    if ( "TP"             == app_type ) { id =  TESTLIST_ID_TP          ;}
    if ( "GYRO_M"         == app_type ) { id =  TESTLIST_ID_GYRO        ;}
    if ( "ACC"            == app_type ) { id =  TESTLIST_ID_ACC         ;}
    if ( "MIC_TESTER"     == app_type ) { id =  TESTLIST_ID_MIC         ;}
    if ( "MIC_TESTER_QC"  == app_type ) { id =  TESTLIST_ID_MIC         ;}
    if ( "MIC_FPC"        == app_type ) { id =  TESTLIST_ID_MIC         ;}
    if ( "SLIDEPAD"       == app_type ) { id =  TESTLIST_ID_SLIDEPAD    ;}
    if ( "SLIDEPAD_AUTO"  == app_type ) { id =  TESTLIST_ID_SLIDEPAD    ;}
    if ( "PRE_PROCCHK"    == app_type ) { id =  TESTLIST_ID_PRE_PROCCHK ;}
    if ( "PROCCHK"        == app_type ) { id =  TESTLIST_ID_PROCCHK     ;}
    if ( "REENTRY"        == app_type ) { id =  TESTLIST_ID_REENTRY     ;}
    if ( "IMPORT"         == app_type ) { id =  TESTLIST_ID_IMPORT      ;}
    if ( "BACKUP"         == app_type ) { id =  TESTLIST_ID_BACKUP      ;}
    if ( "RESTORE"        == app_type ) { id =  TESTLIST_ID_RESTORE     ;}
    if ( "UPDATE"         == app_type ) { id =  TESTLIST_ID_UPDATE      ;}
    if ( "OCAM_WB"        == app_type ) { id =  TESTLIST_ID_OCAM_WB     ;}
    if ( "SP_AND_TP"      == app_type ) { id =  TESTLIST_ID_SP_AND_TP   ;}
    if ( "CAM_CAPTURE"    == app_type ) { id =  TESTLIST_ID_CAM_CAPTURE ;}
    if ( "AGING_I"        == app_type ) { id =  TESTLIST_ID_AGING_I     ;}
    if ( "APP_I"          == app_type ) { id =  TESTLIST_ID_APP_I       ;}

    return id;
}

}//namespace sys
}//namespace uji

/* SYS_APPTYPE_H_INCLUDED */
#endif
