/*--------------------------------------------------------------------------*
 Project:
 File: sys_App.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_APP_H_
#define _UJI_SYS_APP_H_

#include <nw/types.h>
#include "sys_Memory.h"


namespace uji {
namespace sys {
    
class SysApp
{
public:
    //! @brief CX^X擾܂B
    //!
    //! @return VOg̃CX^XԂ܂B
    static SysApp* GetInstance() 
    {
        if (m_pInstance == 0)
        {
            m_pInstance = new SysApp;
        }
        return m_pInstance;
    }    
 
    /*---------------------------------------------------------------------------
     Desc:  C烁m
    
     Args:  size        mۂTCY
            alignment   mۂ郁̃ACg  
    
     Rtns:  mۂւ̃AhX
    ---------------------------------------------------------------------------*/
    static void* Allocate(size_t size, u8 alignment = 4)
    {
        return uji::sys::Alloc(size, alignment);   
    }
    
    /*---------------------------------------------------------------------------
     Desc:  foCX烁m
 
     Args:  size        mۂTCY
            alignment   mۂ郁̃ACg
         
     Rtns:  mۂւ̃AhX
    ---------------------------------------------------------------------------*/
    void* AllocateDeviceMemory(size_t size, u8 alignment = 4)
    {
        return uji::sys::AllocDeviceMemory(size, alignment);
    }

    /*---------------------------------------------------------------------------
     Desc:  
 
     Args:  ptr     郁ւ̃AhX
                    CƃfoCX͋ʂɉł܂B
    ---------------------------------------------------------------------------*/
    void Free(void* ptr)
    {
        uji::sys::Free(ptr);
    }

protected:
    //! 
    //! @bierf RXgN^łB
    //!
    //! pꍇSysApp::GetInstance()͎g܂B
    //!
    SysApp()
    {
        if (m_pInstance != NULL)
        {
            NW_FATAL_ERROR("nw::demo::SysApp instance already exists.");
        }
        m_pInstance = this;
    }

    //! VOgIuWFNgւ̃|C^łB
    static SysApp* m_pInstance;    
};    

}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_APP_H_ */
#endif

