/************************************************************************

ۃAvP[VNX

 *************************************************************************/
#include <nn.h>
#include <nn/hid.h>
#include <nn/fs.h>
#include <nw/demo.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include "sys_AbstractApplication.h"
#include "sys_GraphicsDrawing.h"
#include "sys_Memory.h"
#include "sys_Sleep.h"
#include <nn/srv.h>
#include <nn/fs/fs_APILoader.h>
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/applet.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/ns/CTR/ns_ApiShell.h>
#include <nn/ns/CTR/ns_Shell.h>
#include <nn/am/am_Api.h>

#include "AccessRestriction.h"
#include "sys_GetPlatform.h"

using namespace uji::sys;


/************************************************************************
 ************************************************************************/
void AbstractApplication::Initialize(void)
{
    nn::Result result;
    nn::os::Initialize();

    result = nn::srv::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);

    //eȑ
    nn::fs::Initialize();

    // NAND A[JCu}Eg debug
    // gp鎞}Eg
//#if (!(defined(EVA_LCD_RED) || defined(EVA_CAL2CFG)))

#ifdef AR_MOUNT_CTR_NAND
    nn::fs::MountSpecialArchive("nand:", nn::fs::CTR::ARCHIVE_TYPE_CTR_NAND);
#endif

#ifdef AR_MOUNT_CTR_NANDROWRITE
    result = nn::fs::MountSpecialArchive("nandro:", nn::fs::CTR::ARCHIVE_TYPE_CTR_NAND_RO_WRITE);
    if( result.IsFailure())
    {
        NN_LOG( "Mount nandro failed.\n");
        nn::dbg::Panic();
    }
#endif

//#endif

    /************************************************************************
     nn::ns͑Sgp\
     ************************************************************************/
#if (!(defined(EVA_LCD_RED) || defined(EVA_CAL2CFG)))
    NN_UTIL_PANIC_IF_FAILED(nn::ns::CTR::InitializeForShell());

    /************************************************************************
     nn::am͎gpꍇ̂Initialize
     ************************************************************************/
#ifdef AR_AM_U
    NN_UTIL_PANIC_IF_FAILED(nn::am::InitializeForLocalImporter());
#endif

#endif

    const size_t ROMFS_BUFFER_SIZE = 1024 * 64;
    static char buffer[ROMFS_BUFFER_SIZE];
    NN_UTIL_PANIC_IF_FAILED(
            nn::fs::MountRom(16, 16, buffer, ROMFS_BUFFER_SIZE));

#ifdef EVA_AGING_I
    nn::applet::CTR::Enable();
#else

    // ۂɃX[vɓAv"EVA_ENABLE_SLEEP"L
    SleepHandler::Initialize();
#endif

    // A[VXȅ
    // ̊֐͏폜\܂
    nn::os::InitializeAlarmSystem();

    //AvŎgpq[v̏
    InitializeDemoMemory();

    // OtBbNX̏
    GraphicsDrawing::GetInstance()->Initialize();

    //HID̏AȂReadergȂB
    //HID:SPVŘƂ̂ݓȏ
#ifdef AR_HID_SPVR
    result = nn::hid::InitializeWithPrivilege();
#else
    result = nn::hid::Initialize();
#endif
    NN_UTIL_PANIC_IF_FAILED(result);

    // cfg:i ̏
#if (!defined(EVA_LCD_RED))
    nn::cfg::CTR::init::Initialize();
    SetPlatformType();
#endif
}

