/**************************************************************************
通常のＲｅｎｄｅｒＳｙｓｔｅｍＥｘｔに、８００×２４０のモードとフレームバッファを追加したもの


８００×２４０を表示したい場合は以下のように記述

gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );

 *************************************************************************/

#include "demo_RenderSystemUji.h"

namespace demo
{
RenderSystemUji::RenderSystemUji(void) :
RenderSystemExt()
{
}

RenderSystemUji::~RenderSystemUji(void)
{
    Finalize();
}

/**************************************************************************
初期化
レンダバッファサイズは８００×２４０
ディスプレイバッファは通常に追加して８００×２４０を一系統用意

*************************************************************************/
void RenderSystemUji::Initialize(const uptr fcramAddress, const size_t memorySize,
        const u32 commandBufferSize, const u32 requestNum,
        const bool serialRunMode,
        const DisplayBuffersDescription& displayBuffers0Desc,
        const DisplayBuffersDescription& displayBuffers1Desc,
        const FrameBufferDescription& frameBuffer0Desc,
        const DisplayBuffersDescription& displayBuffers0ExtDesc,
        const bool isFillBlackLCD)
{
#ifdef EVA_ENABLE_GPUTEST
    const u32 HEIGHT = 400;
#else
    const u32 HEIGHT = 800; 
#endif    
	FrameBufferDescription fdesc = frameBuffer0Desc;
	fdesc.m_RenderBufferDescriptionArray[DEMO_COLOR_BUFFER_INDEX].m_Height=HEIGHT;
	fdesc.m_RenderBufferDescriptionArray[DEMO_DEPTH_STENCIL_BUFFER_INDEX].m_Height=HEIGHT;

#ifndef EVA_ENABLE_GPUTEST
	DisplayBuffersDescription ddescHD = DisplayBuffersDescription::GetDefaultDisplay0Description();
	ddescHD.m_Height = HEIGHT;
#endif
    
	RenderSystemExt::Initialize(fcramAddress, memorySize,
        commandBufferSize, requestNum, serialRunMode, 
        displayBuffers0Desc, displayBuffers1Desc,
		fdesc, displayBuffers0ExtDesc, isFillBlackLCD);
#ifndef EVA_ENABLE_GPUTEST
	DisplayBuffers::Create( ddescHD, m_DisplayBuffers0HD );
#endif
    m_InitializeFlag = true;
	NN_LOG("RenderSystemuji has initialized\n" );
}

/**************************************************************************
ファイナライズ
追加で用意したディスプレイバッファを削除
*************************************************************************/
void RenderSystemUji::Finalize(void)
{
    DisplayBuffers::Destroy(m_DisplayBuffers0HD);
    RenderSystemExt::Finalize();        
}

/**************************************************************************
液晶モードの設定
ＲｅｎｄｅｒＳｙｓｔｅｍＥｘｔでのモード制限を取り払った
*************************************************************************/
void RenderSystemUji::SetLcdModeUji(const GLenum& lcdMode)
{
    if ( m_LcdMode != lcdMode )
    {
        m_ChangeLcdMode = true;
        m_LcdMode = lcdMode;
    }
}

/**************************************************************************
レンダーターゲットの設定
８００×２４０モードに対応した
*************************************************************************/
void RenderSystemUji::SetRenderTarget(const GLenum targetDisplay)
{
    if (! m_InitializeFlag )
    {
        NN_TPANIC_("Initialize() is not called.\n");
    }

    if ( targetDisplay == NN_GX_DISPLAY0 )
    {
        m_TargetDisplay = targetDisplay;
        m_CurrentFrameBufferPtr = &m_FrameBuffer0;
        m_CurrentDisplayBuffersPtr = &m_DisplayBuffers0;

    }
    else if ( targetDisplay == NN_GX_DISPLAY1 )
    {
        m_TargetDisplay = targetDisplay;

        m_CurrentFrameBufferPtr = &m_FrameBuffer0;
        m_CurrentDisplayBuffersPtr = &m_DisplayBuffers1;
    }
    else if ( targetDisplay == NN_GX_DISPLAY0_EXT )
    {
        if ( m_LcdMode == NN_GX_DISPLAYMODE_STEREO )
        {
            m_TargetDisplay = targetDisplay;

            m_CurrentFrameBufferPtr = &m_FrameBuffer0;
            m_CurrentDisplayBuffersPtr = &m_DisplayBuffers0Ext;
        }
        else
        {
            NN_PANIC("LcdMode must be NN_GX_DISPLAYMODE_STEREO.\n");
        }
    }
    else if ( targetDisplay == NN_GX_DISPLAY0_HD )
    {
		m_TargetDisplay = NN_GX_DISPLAY0;
		m_CurrentFrameBufferPtr = &m_FrameBuffer0;
        m_CurrentDisplayBuffersPtr = &m_DisplayBuffers0HD;
    }
    else
    {
        NN_TPANIC_("Invalid display.\n");
    }

    m_CurrentFrameBufferPtr->Bind();
    SetViewport(0, 0, m_CurrentDisplayBuffersPtr->GetWidth(), m_CurrentDisplayBuffersPtr->GetHeight());
}

/**************************************************************************
標準SwapBuffersをRenderSystemDraingのものを割り当てる
*************************************************************************/
void RenderSystemUji::SwapBuffers(void)
{
	RenderSystemDrawing::SwapBuffers();
}

/**************************************************************************
視差バリアＯＮ時のSwapBuffersをRenderSystemExtのものを割り当てる
*************************************************************************/
void RenderSystemUji::SwapBuffers_ParallaxBarrier(void)
{
	RenderSystemExt::SwapBuffers();
}


}
