#include "Util.h"

using namespace TesterCommunication;

const string Util::ValidMark("^ \\$%\\+-./\\dA-Za-z_");//gp\

bool Util::HexToInt(int *ret, string datStr)
{
    if (sscanf(datStr.c_str(), "%x", ret) == EOF)
    {
        return false;
    }
    return true;
}

bool Util::HexToUInt(unsigned int *ret, string datStr)
{
    if (sscanf(datStr.c_str(), "%x", ret) == EOF)
    {
        return false;
    }
    return true;
}

string Util::EliminateSharp(string data)
{
    string ret = "";
    int index = data.find('#', 0);

    if ( index != string::npos )
    {
        ret = data.substr(0, index);
    }
    else
    {
        ret = data;
    }
    
    return ret;
}

Result Util::ToString(string *buf, int data, int length, string name)
{
    stringstream ss;

    ss << std::hex << data;
    string dataS = ss.str();
    
    if (dataS.size() > length)
    {
        ss << dataS.size();
        string dataSizeStr = ss.str();
        ss << length;
        string lengthStr = ss.str();
        
        string msg = "\"" + name + "\" argument length : " + dataSizeStr + "\n" +
            "Expected length : " + lengthStr + "\n";
        return Result( Error::InvalidEntrySize, msg );
    }

    ss.str("");
    ss.clear(stringstream::goodbit);
    ss << std::setw(length) << std::setfill('0') << std::right << std::hex << std::uppercase << data;
    *buf = ss.str();

    return Result( Error::None, "" );
}

/*TCY`FbNL*/
Result Util::CheckString( string str, int length, string name)
{
    Result result;
    
    if( str.size() != length )
    {
        stringstream strSizeStream;
        strSizeStream << str.size();
        stringstream lengthStream;
        lengthStream << length;
        
        string msg = "\"" + name + "\".Length : " + strSizeStream.str() + "\n" +
            "Argument \"" + name + "Size\" : " + lengthStream.str() + "\n";
        return Result( Error::InvalidEntrySize, msg );
    }
    else if( (result = CheckString(str, name)).GetErrorType() != Error::None)
    {
        return result;
    }
    else
    {
        return Result( Error::None, "" );
    }
}

/*TCY`FbN*/
Result Util::CheckString( string str, string name )
{
    for (int i = 0; i < str.size(); i++)
    {
        locale loc;//CP[
        if ( isalnum( str[i], loc) )//lAt@xbg
        {
            continue;
        }
        else//ĂL
        {
            bool validFlg = false;
            for (int j = 0; j < ValidMark.size(); j++)
            {
                if(str[i] == ValidMark[j])
                {
                    validFlg = true;
                    break;
                }
            }
            if(!validFlg)
            {
                return Result( Error::InvalidCharacter, name + " : Invalid character found." );
            }
        }
    }
    
    return Result( Error::None, "" );
}

Result Util::PaddingString( string *buf, string str, int length, string name)
{
    /*`FbN*/
    if( str.size() > length )
    {
        stringstream strSizeStream;
        strSizeStream << str.size();
        stringstream lengthStream;
        lengthStream << length;
                
        string msg = "\"" + name + "\" argument length : " + strSizeStream.str() + "\n" +
            "Expected length : " + lengthStream.str() + "\n";
        return Result( Error::InvalidEntrySize, msg);
    }

    /*ᔽ`FbN*/
    Result result;
    if( (result = CheckString(str, name)).GetErrorType() != Error::None )
    {
        return result;
    }

    /*pfBO*/
    stringstream ss;
    ss << std::setw(length) << std::setfill('#') << std::left << str;
    *buf = ss.str();

    return Result( Error::None, "" );
}
