#pragma once

#include<string>

#include "Result.h"
#include "Util.h"
#include "DataFormat.h"

using namespace std;

namespace TesterCommunication
{
    class TestTrace : public DataFormat
    {
    public:
        /*f[^tH[}bgID 0x04*/
        static const int FormatId = 0x04;

        /**/
        static const int Line = 0x1;
        static const int Qc = 0x2;
        static const int Accept = 0x3;
        static const int Repair = 0x4;

        /**/
        static const int TestOk = 0x1;
        static const int TestNg = 0x2;

        /*Ggf[^*/
        int packetId;
        int retryCount;
        int targetId;
        int testId;
        int testKindId;
        int testResult;
        string errorCode;
        string testerProgramVer;
        string testerSequenceCheckCode;
        string testerConfigurationCheckCode;
        string dutProgramVer;
        string dutSequenceCheckCode;
        string dutConfigurationCheckCode;
        string jigNo;
        string nclSerialNo;
        int emsSerialNoSize;
        string emsSerialNo;
        int extendedEntrySize;
        string extendedEntry;

        /**/
        TestTrace();

        /*NA*/
        virtual void Clear();

        /*lZbg*/
        Result SetEntry( int argPacketId,
                         int argRetryCount,
                         int argTargetId,
                         int argTestId,
                         int argTestKindId,
                         int argTestResult,
                         string argErrorCode,
                         string argTesterProgramVer,
                         string argTesterSequenceCheckCode,
                         string argTesterConfigurationCheckCode,
                         string argDutProgramVer,
                         string argDutSequenceCheckCode,
                         string argDutConfigurationCheckCode,
                         string argJigNo,
                         string argNclSerialNo,
                         int argEmsSerialNoSize,
                         string argEmsSerialNo,
                         int argExtendedEntrySize,
                         string argExtendedEntry );

        /*f[^TCY擾*/
        virtual int GetDataSize();

        /*tH[}bgID擾*/
        virtual int GetFormatId();

        /*f[^񂩂GgZbg*/
        virtual Result SetEntryFromString( string packetMainDataS );

    private:
        /*f[^Zbg*/
        /*GgSĖ܂Ă邱*/
        Result SetMainDataString();
    };
}
