#include "TestTrace.h"

using namespace TesterCommunication;

/**/
TestTrace::TestTrace()
{
    Clear();
}

/*NA*/
void TestTrace::Clear()
{
    packetId = Uninitialized;
    retryCount = Uninitialized;
    targetId = Uninitialized;
    testId = Uninitialized;
    testKindId = Uninitialized;
    testResult = Uninitialized;
    errorCode = "";
    testerProgramVer = "";
    testerSequenceCheckCode = "";
    testerConfigurationCheckCode = "";
    dutProgramVer = "";
    dutSequenceCheckCode = "";
    dutConfigurationCheckCode = "";
    jigNo = "";
    nclSerialNo = "";
    emsSerialNoSize = Uninitialized;
    emsSerialNo = "";
    extendedEntrySize = Uninitialized;
    extendedEntry = "";

    mainDataString = "";
}

/*lZbg*/
Result TestTrace::SetEntry( int argPacketId,
                            int argRetryCount,
                            int argTargetId,
                            int argTestId,
                            int argTestKindId,
                            int argTestResult,
                            string argErrorCode,
                            string argTesterProgramVer,
                            string argTesterSequenceCheckCode,
                            string argTesterConfigurationCheckCode,
                            string argDutProgramVer,
                            string argDutSequenceCheckCode,
                            string argDutConfigurationCheckCode,
                            string argJigNo,
                            string argNclSerialNo,
                            int argEmsSerialNoSize,
                            string argEmsSerialNo,
                            int argExtendedEntrySize,
                            string argExtendedEntry )
{
    Clear();
    
    packetId = argPacketId;
    retryCount = argRetryCount;
    targetId = argTargetId;
    testId = argTestId;
    testKindId = argTestKindId;
    testResult = argTestResult;
    errorCode = argErrorCode;
    testerProgramVer = argTesterProgramVer;
    testerSequenceCheckCode = argTesterSequenceCheckCode;
    testerConfigurationCheckCode = argTesterConfigurationCheckCode;
    dutProgramVer = argDutProgramVer;
    dutSequenceCheckCode = argDutSequenceCheckCode;
    dutConfigurationCheckCode = argDutConfigurationCheckCode;
    jigNo = argJigNo;
    nclSerialNo = argNclSerialNo;
    emsSerialNoSize = argEmsSerialNoSize;
    emsSerialNo = argEmsSerialNo;
    extendedEntrySize = argExtendedEntrySize;
    extendedEntry = argExtendedEntry;

    return SetMainDataString();
}

/*f[^TCY擾*/
int TestTrace::GetDataSize()
{
    /*Œf[^TCY*/
    const int FixedDataSize = 91;

    if( emsSerialNoSize == Uninitialized || extendedEntrySize == Uninitialized )
    {
        return Uninitialized;
    }

    return FixedDataSize + emsSerialNoSize + extendedEntrySize;
}

/*tH[}bgID擾*/
int TestTrace::GetFormatId()
{
    return FormatId;
}

/*f[^񂩂GgZbg*/
Result TestTrace::SetEntryFromString( string packetMainDataS )
{
    Result result;

    Clear();
    mainDataString = packetMainDataS;

    /*lGg͐lɕϊAGg͕ɕϊ#폜*/
    
    if ( !Util::HexToInt(&packetId, mainDataString.substr( 0, 2 ) ) || 
         !Util::HexToInt(&retryCount, mainDataString.substr( 2, 1 ) ) ||
         !Util::HexToInt(&targetId, mainDataString.substr( 3, 2 ) ) ||
         !Util::HexToInt(&testId, mainDataString.substr( 5, 2 ) ) ||
         !Util::HexToInt(&testKindId, mainDataString.substr( 7, 1 ) ) ||
         !Util::HexToInt(&testResult, mainDataString.substr( 8, 1 ) ) ||
         !Util::HexToInt(&emsSerialNoSize, mainDataString.substr( 85, 2 ) ) ||
         !Util::HexToInt(&extendedEntrySize, mainDataString.substr( 87 + emsSerialNoSize, 4 ) )  )
    {
        return Result( Error::InvalidEntryFormat, "Found Unexpected Value." );
    }
        
    errorCode = Util::EliminateSharp( mainDataString.substr(9, 16) );
    testerProgramVer = Util::EliminateSharp( mainDataString.substr( 25, 8 ) );
    testerSequenceCheckCode = Util::EliminateSharp( mainDataString.substr( 33, 4 ) );
    testerConfigurationCheckCode = Util::EliminateSharp( mainDataString.substr( 37, 4 ) );
    dutProgramVer = Util::EliminateSharp( mainDataString.substr( 41, 8 ) );
    dutSequenceCheckCode = Util::EliminateSharp( mainDataString.substr( 49, 4 ) );
    dutConfigurationCheckCode = Util::EliminateSharp( mainDataString.substr( 53, 4 ) );
    jigNo = Util::EliminateSharp( mainDataString.substr( 57) );
    nclSerialNo = Util::EliminateSharp( mainDataString.substr( 73, 12 ) );
    emsSerialNo = mainDataString.substr( 87, emsSerialNoSize );
    extendedEntry = mainDataString.substr( 91 + emsSerialNoSize, extendedEntrySize );
        
    /*Ggᔽ`FbN*/
    if( ( result = Util::CheckString( errorCode, "errorCode" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( testerProgramVer, "testerProgramVer" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( testerSequenceCheckCode, "testerSequenceCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( testerConfigurationCheckCode, "testerConfigurationCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( dutProgramVer, "dutProgramVer" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( dutSequenceCheckCode, "dutSequenceCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( dutConfigurationCheckCode, "dutConfigurationCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( jigNo, "jigNo" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( nclSerialNo, "nclSerialNo" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( emsSerialNo, emsSerialNoSize, "emsSerialNo" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( extendedEntry, extendedEntrySize, "extendedEntry" ) ).GetErrorType() != Error::None )
    {
        return result;
    }

    return Result( Error::None, "" );
}

/*f[^Zbg*/
/*GgSĖ܂Ă邱*/
Result TestTrace::SetMainDataString()
{
    Result result;

    string packetIdS = "";
    string retryCountS = "";
    string targetIdS = "";
    string emsSerialNoSizeS = "";
    string testIdS = "";
    string testKindIdS = "";
    string testResultS = "";
    string extendedEntrySizeS = "";

    string errorCodeS = "";
    string testerProgramVerS = "";
    string testerSequenceCheckCodeS = "";
    string testerConfigurationCheckCodeS = "";
    string dutProgramVerS = "";
    string dutSequenceCheckCodeS = "";
    string dutConfigurationCheckCodeS = "";
    string jigNoS = "";
    string nclSerialNoS = "";

    /*`FbN*/
    if( packetId == Uninitialized ||
        retryCount == Uninitialized ||
        targetId == Uninitialized ||
        testId == Uninitialized ||
        testKindId == Uninitialized ||
        testResult == Uninitialized ||
        emsSerialNoSize == Uninitialized ||
        extendedEntrySize == Uninitialized )
    {
        return Result( Error::Uninitialized, "" );
    }

    /*Gg̃pfBOƃtH[}bgmF*/
    if( ( result = Util::PaddingString( &errorCodeS, errorCode, 16, "errorCode" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &testerProgramVerS, testerProgramVer, 8, "testerProgramVer" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &testerSequenceCheckCodeS, testerSequenceCheckCode, 4, "testerSequenceCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &testerConfigurationCheckCodeS, testerConfigurationCheckCode, 4, "testerConfigurationCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &dutProgramVerS, dutProgramVer, 8, "dutProgramVer" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &dutSequenceCheckCodeS, dutSequenceCheckCode, 4, "dutSequenceCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &dutConfigurationCheckCodeS, dutConfigurationCheckCode, 4, "dutConfigurationCheckCode" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &jigNoS, jigNo, 16, "jigNo" ) ).GetErrorType() != Error::None
        || ( result = Util::PaddingString( &nclSerialNoS, nclSerialNo, 12, "nclSerialNo" ) ).GetErrorType() != Error::None )
    {
        return result;
    }

    /*ϒGg̃TCYƃtH[}bgmF*/
    if( ( result = Util::CheckString( emsSerialNo, emsSerialNoSize, "emsSerialNo" ) ).GetErrorType() != Error::None
        || ( result = Util::CheckString( extendedEntry, extendedEntrySize, "extendedEntry" ) ).GetErrorType() != Error::None )
    {
        return result;
    }

    /*ϊ*/
    if( ( result = Util::ToString( &packetIdS, packetId, 2, "PacketId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &retryCountS, retryCount, 1, "retryCount" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &targetIdS, targetId, 2, "TargetId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &testIdS, testId, 2, "TestId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &testKindIdS, testKindId, 1, "testKindIdS" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &testResultS, testResult, 1, "testResult" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &emsSerialNoSizeS, emsSerialNoSize, 2, "emsSerialNoSize" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &extendedEntrySizeS, extendedEntrySize, 4, "extendedEntrySize" ) ).GetErrorType() != Error::None )
    {

        return result;
    }

    /*M쐬*/
    mainDataString = packetIdS + retryCountS + targetIdS + testIdS + testKindIdS + testResultS + errorCodeS + testerProgramVerS + testerSequenceCheckCodeS + testerConfigurationCheckCodeS +
        dutProgramVerS + dutSequenceCheckCodeS + dutConfigurationCheckCodeS + jigNoS + nclSerialNoS + emsSerialNoSizeS + emsSerialNo + extendedEntrySizeS + extendedEntry;

    return Result( Error::None, "" );
}


