#pragma once

#include<string>

#include "Result.h"
#include "Util.h"
#include "DataFormat.h"

using namespace std;

namespace TesterCommunication
{
    class TestStatus : public DataFormat
    {
    public:
        /*f[^tH[}bgID 0x01*/
        static const int FormatId = 0x01;

        /*Xe[^X*/
        static const int TestSequenceStart = 0x00;
        static const int TestSequenceOk = 0xA1;
        static const int TestSequenceNg = 0xA2;

        /*Jn҂TestSequenceId*/
        static const unsigned int WaitTestStart = 0xFFFFFFF0;

        /*Ggf[^*/
        int packetId;
        int retryCount;
        int targetId;
        int testId;
        unsigned int testSequenceId;
        int testStatusId;
        int errorCodeSize;
        string errorCode;

        /**/
        TestStatus();

        /*NA*/
        virtual void Clear();

        /*lZbg*/
        virtual Result SetEntry( int argPacketId,
                                 int argRetryCount,
                                 int argTargetId,
                                 int argTestId,
                                 unsigned int argTestSequenceId,
                                 int argTestStatusId,
                                 int argErrorCodeSize,
                                 string argErrorCode );
        
        /*f[^TCY擾*/
        virtual int GetDataSize();

        /*tH[}bgID擾*/
        virtual int GetFormatId();

        /*f[^񂩂GgZbg*/
        virtual Result SetEntryFromString ( string packetMainDataS );
        
    private:
        /*f[^Zbg*/
        /*GgSĖ܂Ă邱*/
        Result SetMainDataString();
    };
}
