#include "TestStatus.h"

using namespace TesterCommunication;


/**/
TestStatus::TestStatus()
{
    Clear();
}


/*NA*/
void TestStatus::Clear()
{
    packetId = Uninitialized;
    retryCount = Uninitialized;
    targetId = Uninitialized;
    testId = Uninitialized;
    testSequenceId = (unsigned int)Uninitialized;
    testStatusId = Uninitialized;
    errorCodeSize = Uninitialized;
    errorCode = "";
}


/*lZbg*/
Result TestStatus::SetEntry( int argPacketId,
                             int argRetryCount,
                             int argTargetId,
                             int argTestId,
                             unsigned int argTestSequenceId,
                             int argTestStatusId,
                             int argErrorCodeSize,
                             string argErrorCode )
{
    Clear();

    packetId = argPacketId;
    retryCount = argRetryCount;
    targetId = argTargetId;
    testId = argTestId;
    testSequenceId = argTestSequenceId;
    testStatusId = argTestStatusId;
    errorCodeSize = argErrorCodeSize;
    errorCode = argErrorCode;

    return SetMainDataString();
}


/*f[^TCY擾*/
int TestStatus::GetDataSize()
{
    /*Œf[^TCY*/
    const int FixedDataSize = 19;

    if (errorCodeSize == Uninitialized)
    {
        return Uninitialized;
    }

    return FixedDataSize + errorCodeSize;
}


/*tH[}bgID擾*/
int TestStatus::GetFormatId()
{
    return FormatId;
}


/*f[^񂩂GgZbg*/
Result TestStatus::SetEntryFromString( string packetMainDataS )
{
    mainDataString = packetMainDataS;

    if ( !Util::HexToInt( &packetId, packetMainDataS.substr( 0, 2 ) ) ||
         !Util::HexToInt( &retryCount, packetMainDataS.substr( 2, 1 ) ) ||
         !Util::HexToInt( &targetId, packetMainDataS.substr( 3, 2 ) ) ||
         !Util::HexToInt( &testId, packetMainDataS.substr( 5, 2 ) ) ||
         !Util::HexToUInt( &testSequenceId, packetMainDataS.substr( 7, 8 ) ) ||
         !Util::HexToInt( &testStatusId, packetMainDataS.substr( 15, 2 ) ) ||
         !Util::HexToInt( &errorCodeSize, packetMainDataS.substr( 17, 2 ) ) )
        
    {
        return Result( Error::InvalidEntryFormat, "Unexpected Value Found." );
    }
    
    errorCode = packetMainDataS.substr( 19, errorCodeSize );
    
    return Result( Error::None, "" );
}


/*M̎擾*/
Result TestStatus::SetMainDataString ()
{
    Result result;

    string packetSizeS = "";
    string packetFormatIdS = "";
    string packetIdS = "";
    string retryCountS = "";
    string targetIdS = "";
    string testIdS = "";
    string testSequenceIdS = "";
    string testStatusIdS = "";
    string errorCodeSizeS = "";
    string checkSumS = "";

    /*`FbN*/
    if( packetId == Uninitialized ||
        retryCount == Uninitialized ||
        targetId == Uninitialized ||
        testId == Uninitialized ||
        testSequenceId == (unsigned int)Uninitialized ||
        testStatusId == Uninitialized ||
        errorCodeSize == Uninitialized )
    {
        return Result( Error::Uninitialized, "" );
    }

    /*ϒGg̃TCYƃtH[}bgmF*/
    result = Util::CheckString( errorCode, errorCodeSize, "errorCode" );
    if( result.GetErrorType() != Error::None )
    {
        return result;
    }

    /*ϊ*/
    if( ( result = Util::ToString( &packetIdS, packetId, 2, "PacketId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &retryCountS, retryCount, 1, "retryCount" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &targetIdS, targetId, 2, "TargetId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &testIdS, testId, 2, "TestId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &testSequenceIdS, (int)testSequenceId, 8, "TestSequenceId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &testStatusIdS, testStatusId, 2, "TestStatusId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &errorCodeSizeS, errorCodeSize, 2, "ErrorCodeSize" ) ).GetErrorType() != Error::None )
    {

        return result;
    }


    /*M쐬*/
    mainDataString = packetIdS + retryCountS + targetIdS +
        testIdS + testSequenceIdS + testStatusIdS + errorCodeSizeS + errorCode;

    return Result( Error::None, "" );
}
