#pragma once

#include <string>

using namespace std;

namespace TesterCommunication
{
    namespace Error
    {
        enum ErrorType
        {
            None = 0x0000,
            Uninitialized = 0x0001,
            
            Timeout = 0x0010,
            
            PacketBroken = 0x0100,
            IncorrectPacketSize,
            IncorrectCheckSum,
            
            InvalidEntryFormat = 0x0200,
            InvalidEntrySize,
            InvalidCharacter,
            
            SerialPortError = 0x1000,
            
            Undefined = 0xFFFE,
            Fatal = 0xFFFF
        };
    }


    class Result
    {
    private:
        string Message;
        enum Error::ErrorType mErrorType;
        char padding[2];//\̃pfBOpϐ

    public:
        Result()
        {
            mErrorType = Error::Fatal;
            Message = "";
        }

        Result( Error::ErrorType argErrType, string msg )
        {
            mErrorType = argErrType;
            Message = msg;
        }
        
        string GetMsg()
        {
            return Message;
        }
        
        Error::ErrorType GetErrorType()
        {
            return mErrorType;
        }
    };
}
