#include "Reply.h"

using namespace TesterCommunication;

/**/
Reply::Reply()
{
    Clear();
}

/*NA*/
void Reply::Clear()
{
    targetPacketId = Uninitialized;
    targetRetryCount = Uninitialized;
    replyStatus = Uninitialized;
}

/*lZbg*/
Result Reply::SetEntry( int argTargetPacketId, int argTargetRetryCount, int argReplyStatus )
{
    Clear();
    
    targetPacketId = argTargetPacketId;
    targetRetryCount = argTargetRetryCount;
    replyStatus = argReplyStatus;
    
    return SetMainDataString();
}

/*f[^TCY擾*/
int Reply::GetDataSize()
{
    const int DataSize = 5;
    return DataSize;
}

/*tH[}bgID擾*/
int Reply::GetFormatId()
{
    return FormatId;
}


/*f[^񂩂GgZbg*/
Result Reply::SetEntryFromString ( string packetMainDataS )
{
    mainDataString = packetMainDataS;

    /*lGg̕ϊ*/
    if ( !Util::HexToInt( &replyStatus, mainDataString.substr( 3, 2 ) ) )
    {
        stringstream ss;
        ss<<mainDataString.substr( 3, 2 );
        return Result( Error::InvalidEntryFormat, "Found Unexpected Value(replyStatus).");
    }
    
    /*󋖉lGg̕ϊ*/
    if( mainDataString.substr( 0, 2 ) == "##" )
    {
        targetPacketId = Reply::Empty;
    }
    else if ( !Util::HexToInt( &targetPacketId, mainDataString.substr( 0, 2 ) ) )
    {
        return Result( Error::InvalidEntryFormat, "Found Unexpected Value(targetPacketId)." );
    }
    
    if( mainDataString.substr( 2, 1 ) == "#" )
    {
        targetRetryCount = Reply::Empty;
    }
    else if ( !Util::HexToInt( &targetRetryCount, mainDataString.substr( 2, 1 ) ) )
    {
        return Result( Error::InvalidEntryFormat, "Found Unexpected Value(targetRetryCount)." );
    }

    return Result( Error::None, "" );
}


/*f[^Zbg*/
/*GgSĖ܂Ă邱*/
Result Reply::SetMainDataString()
{
    Result result;

    /*`FbN*/
    if( targetPacketId == Uninitialized ||
        targetRetryCount == Uninitialized ||
        replyStatus == Uninitialized )
    {
        return Result( Error::Uninitialized, "" );
    }


    /*Gg𕶎ϊ*/
    string packetSizeS = "";
    string formatIdS = "";
    string targetPacketIdS = "";
    string targetRetryCountS = "";
    string replyStatusS = "";
    string checkSumS = "";

    if( ( result = Util::ToString( &formatIdS, FormatId, 2, "FormatId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &replyStatusS, replyStatus, 2, "ReplyStatus" ) ).GetErrorType() != Error::None )
    {
        return result;
    }

    /*󋖉̐lGgϊ*/
    if(targetPacketId == Reply::Empty)
    {
        targetPacketIdS = "##";
    }
    else
    {
        if( ( result = Util::ToString( &targetPacketIdS, targetPacketId, 2, "TargetPacketId" ) ).GetErrorType() != Error::None )
        {
            return result;
        }
    }

    if(targetRetryCount == Reply::Empty)
    {
        targetRetryCountS = "#";
    }
    else
    {
        if ( ( result = Util::ToString( &targetRetryCountS, targetRetryCount, 1, "TargetRetryCount" ) ).GetErrorType() != Error::None)
        {
            return result;
        }
    }

    /*M쐬*/
    mainDataString = targetPacketIdS + targetRetryCountS + replyStatusS;

    return Result( Error::None, "" ) ;
}
