#pragma once

#include <string>
#include <sstream>

#include "CheckSum.h"
#include "DataFormat.h"
#include "Result.h"
#include "Util.h"
#include "Reply.h"
#include "TestStatus.h"
#include "TestTrace.h"

using namespace std;

namespace TesterCommunication
{
    class Packet
    {

    public:
        /*萔*/
        static const int Uninitialized = -1;//0xFFFFFFFF;//

        /*Œ̃GgTCY*/
        static const int FixedEntrySize = 14;

        /*pPbgŒGg̐l `FbNTvZɎgp*/
        static const int FixedDigitNum = 6;

        /*Ggf[^*/
        const string Header;// "!!"
        int packetSize;
        int formatId;
        DataFormat *mainData;//f[^
        int checkSum;
        const string Footer;//"\r\n";

        
    private:
        /*pPbg̕*/
        string packetString;


    public:
        /**/
        Packet();

        /*mainDatadelete*/
        ~Packet();

        /*pPbgNA*/
        void Clear();

        /*MainDatä̗J*/
        void DeleteMainData();

        /*f[^tH[}bgZbgApPbg̃Ggf[^vZ*/
        Result SetEntry( DataFormat *argPacketMainData );

        /*pPbg̕Ԃ*/
        string ToString();

        /*M󂯎AGgɒlZbg*/
        Result Recv( string recvString );

    private:
        /*pPbgTCYvZĕԂ*/
        int GetPacketSize( DataFormat *argPacketMainData );
 
        /*`FbNTZbg*/
        /*`FbNTȊÕGg܂Ă邱*/
        Result SetCheckSum();
        
        /*pPbgZbg*/
        /*GgSĖ܂Ă邱*/
        Result SetPacketString();

        /*pPbǵE`FbNAGgɒlZbg*/
        /*packetStringZbgĂg(Recv̂݌Ă΂Ă)*/
        Result SetEntryFromPacketString();        

        /*FormatIDƃCf[^̕񂩂烁Cf[^擾*/
        /*packetStringFormatIdZbgɌĂяo*/
        Result SetPacketMainData( string packetMainDataS );
        
    };
}
