#include "Packet.h"

using namespace TesterCommunication;

/**/
Packet::Packet() : Header("!!"), Footer("\r\n")
{
    Clear();
}

Packet::~Packet()
{
    DeleteMainData();
}

/*pPbgNA*/
void Packet::Clear()
{
    packetString = "";
    packetSize = Uninitialized;
    formatId = Uninitialized;
    mainData = NULL;
    checkSum = Uninitialized;
}


void Packet::DeleteMainData()
{
    if (mainData != NULL)
        delete(mainData);
    mainData = NULL;
}

/*f[^tH[}bgZbgApPbg̃Ggf[^vZ*/
Result Packet::SetEntry( DataFormat *argPacketMainData )
{
    Clear();

    mainData = argPacketMainData;
    packetSize = GetPacketSize( argPacketMainData );
    formatId = argPacketMainData->GetFormatId();

    Result checkSumResult = SetCheckSum();
    if( checkSumResult.GetErrorType() != Error::None )//ŌvZpacketSize,formatIdKv
    {
        return checkSumResult;
    }

    return SetPacketString();//ŌvZpacketSize,formatId,checkSumKv
}


/*pPbg̕Ԃ*/
string Packet::ToString()
{
    return packetString;
}


/*M󂯎AGgɒlZbg*/
Result Packet::Recv( string recvString )
{
    Clear();

    packetString = recvString;
    
    Result result = SetEntryFromPacketString();
    if( result.GetErrorType() != Error::None )
    {
        Clear();
        return result;
    }

    return Result( Error::None, "" );
}


/*pPbgTCYvZĕԂ*/
int Packet::GetPacketSize( DataFormat *argPacketMainData )
{
    int mainDataSize = argPacketMainData->GetDataSize();

    if ( mainDataSize != Uninitialized )
        return FixedEntrySize + mainDataSize;
    else
        return Uninitialized;
}


/*`FbNTZbg*/
/*`FbNTȊÕGg܂Ă邱*/
Result Packet::SetCheckSum()
{
    if ( packetSize == Uninitialized ||
         formatId == Uninitialized ||
         mainData == NULL ||
         mainData->ToString() == "" )
    {
        return Result( Error::Uninitialized, "" );
    }

    checkSum = CheckSum::GetFromDigit( 6, 2, packetSize, formatId ) + CheckSum::GetFromString( mainData->ToString() );

    return Result( Error::None, "" );
}


/*pPbgZbg*/
/*GgSĖ܂Ă邱*/
Result Packet::SetPacketString()
{
    Result result;

    if ( packetSize == Uninitialized ||
         formatId == Uninitialized ||
         mainData == NULL ||
         checkSum == Uninitialized )
    {
        return Result( Error::Uninitialized, "" );
    }

    string packetSizeS = "";
    string formatIdS = "";
    string checkSumS = "";

    if( ( result = Util::ToString( &packetSizeS, packetSize, 4, "PacketSize" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &formatIdS, formatId, 2, "FormatId" ) ).GetErrorType() != Error::None
        || ( result = Util::ToString( &checkSumS, checkSum, 4, "CheckSum" ) ).GetErrorType() != Error::None )
    {
        return result;
    }

    packetString = Header + packetSizeS + formatIdS + mainData->ToString()
        + checkSumS + Footer;

    return Result( Error::None, "" );
}


/*pPbǵE`FbNAGgɒlZbg*/
/*packetStringZbgĂg(Recv̂݌Ă΂Ă)*/
Result Packet::SetEntryFromPacketString()
{
    /*`FbN*/
    if( packetString == "" )
    {
        return Result( Error::Uninitialized, "" );
    }

    /*p[VO*/
    string Header = packetString.substr( 0, 2 );
    string packetSizeS = packetString.substr( 2, 4 );
    string formatIdS = packetString.substr( 6, 2 );
    string packetMainDataS = packetString.substr( 8, packetString.size() - 14 );
    string packetCheckSumS = packetString.substr( packetString.size() - 6, 4 );
    string Footer = packetString.substr( packetString.size() - 2, 2 );

    /*`FbNTvZ*/
    int calcCheckSum = CheckSum::GetFromString( packetString.substr( 2, packetString.size() - 8 ) );

    /*pPbgtH[}bg`FbN*/
    if( Header != "!!" )
    {
        return Result( Error::PacketBroken, "Found Broken Header." );
    }
    else if( Footer != "\r\n" )
    {
        return Result( Error::PacketBroken, "Found Broken Footer." );
    }

    /*Ggf[^Zbg*/

    if ( !Util::HexToInt( &packetSize, packetSizeS ) ||
         !Util::HexToInt( &formatId, formatIdS ) ||
         !Util::HexToInt( &checkSum, packetCheckSumS ) )
    {
        return Result( Error::PacketBroken, "" );
    }

    /*pPbg + `FbNTmF*/
    if( packetSize != packetString.size() )
    {
        stringstream packetSizeSS;
        packetSizeSS << packetSize;
        stringstream stringSizeSS;
        stringSizeSS << packetString.size();
        return Result( Error::IncorrectPacketSize, "Expected : " + packetSizeSS.str() + "\nPacket Length : " + stringSizeSS.str() + "\n" );
    }
    else if( calcCheckSum != checkSum )
    {
        stringstream ss;
        ss << std::hex << calcCheckSum;
        string calcCheckSumS = ss.str();

        string msg = "calcCheckSum : " + calcCheckSumS + "\n" + "packetCheckSum : " + packetCheckSumS + "\n";
        return Result( Error::IncorrectCheckSum, msg );
    }

    /*Cf[^Zbg*/
    Result result = SetPacketMainData( packetMainDataS );
    if( result.GetErrorType() != Error::None )
    {
        return result;
    }

    /*pPbgtH[}bg`FbN*/
    if( formatId != mainData->GetFormatId() )
    {
        return Result( Error::InvalidEntryFormat, "Undefined Format ID." );
    }

    return Result( Error::None, "" );
}

/*FormatIDƃCf[^̕񂩂烁Cf[^擾*/
/*packetStringFormatIdZbgɌĂяo*/
Result Packet::SetPacketMainData( string packetMainDataS )
{
    /*`FbN*/
    if( packetMainDataS == "" || formatId == Uninitialized )
    {
        return Result( Error::Uninitialized, "" );
    }

    /*FormatIDPacketMainDataɃZbg*/
    if( formatId == 0x00 )
    {
        Reply *reply = new Reply();
        Result result = reply->SetEntryFromString( packetMainDataS );
        if( result.GetErrorType() != Error::None )
        {
            return result;
        }
        mainData = reply;
    }
    else if( formatId == 0x01 )
    {
        TestStatus *testStatus = new TestStatus();
        Result result = testStatus->SetEntryFromString( packetMainDataS );
        if( result.GetErrorType() != Error::None )
        {
            return result;
        }
        mainData = testStatus;
    }
    else if( formatId == 0x04 )
    {
        TestTrace *testTrace = new TestTrace();
        Result result = testTrace->SetEntryFromString( packetMainDataS );
        if( result.GetErrorType() != Error::None )
        {
            return result;
        }
        mainData = testTrace;
    }
    else
    {
        return Result( Error::Fatal, "Unexpected Format ID." );
    }

    return Result( Error::None, "" );
}
