#include "ir.h"

using namespace TesterCommunication;

Ir::Ir()
{
    isInitialized = false;
}

Ir::~Ir()
{
    Finalize();
}

Result Ir::Initialize()
{
    nn::Result nnResult;

    //
    nnResult = nn::ir::CTR::Low::Initialize();
    if( nnResult.IsFailure())
    {
        return ConvertResult(nnResult);
    }

    isInitialized = true;

    /*K{s*/
    nnResult = nn::ir::CTR::Low::SetAutoPowerControl( true );
    if( nnResult.IsFailure())
    {
        return TesterCommunication::Result( Error::Fatal, "Ir AutoPowerOn Error.");
    }

    /*K{s*/
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        return TesterCommunication::Result( Error::Fatal, "Ir PowerOn Error.");
    }
    
    //baudrateݒ
    nnResult = nn::ir::CTR::Low::SetBaudRate(nn::ir::CTR::BAUD_RATE_115200);
    if( nnResult.IsFailure())
    {
        return ConvertResult(nnResult);
    }
    
    //CxgĎ
    m_SendEvent.Initialize(true);
    m_RecvEvent.Initialize(true);
    nnResult = nn::ir::CTR::Low::GetFinishedSendingEvent( &m_SendEvent );
    if( nnResult.IsFailure())
    {
        return ConvertResult(nnResult);
    }
    nnResult = nn::ir::CTR::Low::GetFinishedReceivingEvent( &m_RecvEvent );
    if( nnResult.IsFailure())
    {
        return ConvertResult(nnResult);
    }
    
    return TesterCommunication::Result( Error::None, "" );
}


Result Ir::Finalize()
{
    if(isInitialized)//Ăꍇ
    {
        nn::Result nnResult;

        /*CuI*/
        nnResult = nn::ir::CTR::Low::Finalize();
        if ( nnResult.IsFailure() )
        {
            return ConvertResult( nnResult );
        }

        m_SendEvent.Finalize();
        m_RecvEvent.Finalize();
        
        isInitialized = false;
    }

    return TesterCommunication::Result( Error::None, "" );
}


Result Ir::Send(Packet *sendPacket)
{
    nn::fnd::TimeSpan sendTimeout = nn::fnd::TimeSpan::FromMilliSeconds(500);

    const string sendString = sendPacket->ToString();
    if( sendString.empty())
    {
        return TesterCommunication::Result( Error::Uninitialized, "Uninitialized Packet.\n" );
    }

    /*KTRɂāApPbg𑗐MƍmŎs邽߁AM*/
    for(unsigned int head = 0; head < sendString.length(); head += 64)
    {
        /*pPbg*/
        unsigned int tail = nn::math::Min<unsigned int>(head + 64, sendString.length());
        string partString = sendString.substr(head, tail - head);
        
        /*MOɃVOiNA*/
        m_SendEvent.ClearSignal();
        
        /*M*/
        nn::Result nnResult = nn::ir::CTR::Low::Send((u8 *)partString.c_str(), partString.length());
        if ( nnResult.IsFailure() )
        {
            nn::ir::CTR::Low::CancelSend();
            return ConvertResult( nnResult );
        }
        
        /*M҂*/
        if ( !m_SendEvent.Wait(sendTimeout) )
        {
            nn::ir::CTR::Low::CancelSend();
            return TesterCommunication::Result( Error::Timeout, "Send Packet Timeout.\n" );
        }
        
        /*G[`FbN*/
        nn::ir::CTR::Low::ErrorStatus errorStatus = nn::ir::CTR::Low::GetErrorStatus();
        if (errorStatus != nn::ir::CTR::Low::STATUS_NO_ERROR)
        {
            nn::ir::CTR::Low::CancelSend();
            stringstream ss;
            ss << errorStatus;
            return TesterCommunication::Result( Error::Fatal, "Send Packet Error(ErrorStatus:" +  ss.str() + ").\n");
        }
    }
    
    return TesterCommunication::Result( Error::None, "" );
}


Result Ir::SendAndRecvReply(Packet *sendPacket, nn::fnd::TimeSpan replyTimeout, int retryCount)
{
    int retry;

    for(retry = 0; retry <= retryCount; retry++)
    {
        /*M*/
        Result result;
        result = Send(sendPacket);
        if ( result.GetErrorType() != Error::None )
        {
            return result;
        }

        /*ԓM*/
        Packet replyPacket;
        result = Recv(&replyPacket, replyTimeout);
        if(result.GetErrorType() == Error::Timeout)
        {
            if(retry >= retryCount)
            {
                return TesterCommunication::Result( Error::Timeout, "Recv Reply Timeout.\n" );
            }
            else
            {
                /*gC*/
                continue;
            }
        }
        else if(result.GetErrorType() != Error::None)
        {
            return result;
        }

        /*ԓ*/
        if(replyPacket.formatId == 0x00)
        {
            //TODO.ΏpacketId,ΏretryCount`FbN
            Reply *replyData = (Reply *)replyPacket.mainData;
            if(replyData->replyStatus == Reply::Ok)
            {
                /*ReplyM*/
                break;
            }
        }

        //TODO.̕ԓXe[^XāAY
        
        /*ُԓM*/
        if(retry >= retryCount)
        {
            /*Ms*/
            return TesterCommunication::Result( Error::Fatal, "Recv Ng Reply.\nRecv : " + replyPacket.ToString() + "\n" );
        }
        else
        {
            continue;
        }
    }

    NN_ASSERT(retry <= retryCount);

    return TesterCommunication::Result( Error::None, "" );
}


Result Ir::Recv( Packet *retPacket, nn::fnd::TimeSpan recvTimeout)
{
    nn::Result nnResult;
    TesterCommunication::Result result;
    size_t recvSize;

    if ( retPacket == NULL )
    {
        return TesterCommunication::Result( Error::Uninitialized, "" );
    }

    /*IRMobt@NA*/
    memset(s_IrRecvBuffer, 0x0, sizeof(s_IrRecvBuffer));

    /*MOɃVOiNA*/
    m_RecvEvent.ClearSignal();
    
    /*wb_MJn*/
    nnResult = nn::ir::CTR::Low::StartReceive( s_IrRecvBuffer, RECV_BUFFER_SIZE, RECV_BUFFER_SIZE, false );
    if( nnResult.IsFailure())
    {
        nn::ir::CTR::Low::EndReceive( &recvSize );
        return ConvertResult( nnResult );
    }    
    
    /*pPbgM҂*/
    if ( !m_RecvEvent.Wait(recvTimeout) )
    {
        nn::ir::CTR::Low::EndReceive( &recvSize );
        return TesterCommunication::Result( Error::Timeout, "Receive Packet Timeout.\n" );
    }
    //LRɂG[
    //ςȃf[^MĂꍇ́A㑱̏ŃG[ƂȂ(͂)
    
    //MĂASTATUS_RECEIVE_TIMEOUT(0x03)ԂĂ邽(oO?)AG[
    /*
    nn::ir::CTR::Low::ErrorStatus errorStatus = nn::ir::CTR::Low::GetErrorStatus();
    if (errorStatus != nn::ir::CTR::Low::STATUS_NO_ERROR)
    {
        nn::ir::CTR::Low::EndReceive( &recvSize );
        stringstream ss;
        ss << errorStatus;
        return TesterCommunication::Result( Error::Fatal, "Receive Packet Error(ErrorStatus:" + ss.str() + ").\n");
    }*/

    /*MI*/
    nnResult = nn::ir::CTR::Low::EndReceive( &recvSize );
    if ( nnResult.IsFailure() )
    {
        return ConvertResult( nnResult );
    }
    
    /*retPacketɒlZbg*/
    string recvString = (char *)s_IrRecvBuffer;
    TesterCommunication::Result recvResult = retPacket->Recv( recvString ) ;
    if ( recvResult.GetErrorType() != Error::None )
    {
        return recvResult;
    }
    
    return TesterCommunication::Result( Error::None, "" );
}


Result Ir::ConvertResult( nn::Result result )
{
    if ( result == nn::ir::CTR::ResultAlreadyInitialized() ) 
    {
        return TesterCommunication::Result( Error::Fatal, "Ir Already Initialized.\n" );
    }
    else if ( result == nn::ir::CTR::ResultNotInitialized() )
    {
        return TesterCommunication::Result( Error::Uninitialized, "Ir Not Uninitialized.\n" );
    }
    else if ( result == nn::ir::CTR::ResultReceiveAlreadyCompleted() )
    {
        return TesterCommunication::Result( Error::Fatal, "Ir Already Received.\n" );
    }
    else if ( result == nn::ir::CTR::ResultMachineSleep() )
    {
        return TesterCommunication::Result( Error::Fatal, "Machine Sleeping.\n" );
    }
    else if ( result == nn::ir::CTR::ResultModuleIsBusy() )
    {
        return TesterCommunication::Result( Error::Fatal, "Ir Module is Busy.\n" );
    }
    else if ( result == nn::ir::CTR::ResultFatalError() )
    {
        return TesterCommunication::Result( Error::Fatal, "Ir Module may be Broken.\n" );
    }
    else
    {
        return TesterCommunication::Result( Error::Undefined, "Ir Undefined Error.\n" );
    }
}
