#include "../../seq/Config.h"
#include "../../seq/TesterLog/ProductionLog.h"
#include "sys_GetPlatform.h"
#include "Convert.h"

namespace TesterCommunication
{
    int GetTargetId()
    {
        uji::sys::PlatformType platform = uji::sys::GetPlatformType();

        switch(platform)
        {
        case uji::sys::PLATFORM_CTR:
            return 0x01;
        case uji::sys::PLATFORM_SPR:
            return 0x02;
        case uji::sys::PLATFORM_FTR:
            return 0x03;
        case uji::sys::PLATFORM_KTR:
            return 0x04;
        case uji::sys::PLATFORM_RED:
            return 0x05;
        default:
            return 0x00;//G[͕ԂȂ
        }
    }

    /*ConfigTestListāAIDԂ
      TestListgpȂ́E`̂̂́A0x00Ԃ
      
      ̎dlł́ATestId͋@ԋʂɂĂ
      @했ɕύXꍇ́AvΉ*/
    int GetTestId()
    {
        uji::seq::Config config;
        u32 testList = config.GetAlternative().TestList;
    
        if(testList == TESTLIST_ID_LCDANDKEY)
        {
            return 0x03;
        }
        else if(testList == TESTLIST_ID_ICAM)
        {
            return 0x0D;
        }
        else if(testList == TESTLIST_ID_AGING)
        {
            return 0x06;
        }
        else if(testList == TESTLIST_ID_TP)
        {
            return 0x04;
        }
        else if(testList == TESTLIST_ID_ACC)
        {
            return 0x08;
        }
        else if(testList == TESTLIST_ID_MIC)
        {
            return 0x09;
        }
        else if(testList == TESTLIST_ID_SLIDEPAD)
        {
            return 0x02;
        }
        else if(testList == TESTLIST_ID_PROCCHK)
        {
            return 0x0F;
        }
        else if(testList == TESTLIST_ID_IMPORT)
        {
            return 0x0E;
        }
        else if(testList == TESTLIST_ID_OCAM_WB)
        {
            return 0x0B;
        }
        else if(testList == TESTLIST_ID_SP_AND_TP)
        {
            return 0x11;
        }
        else if(testList == TESTLIST_ID_CAM_CAPTURE)
        {
            return 0x13;
        }
        /*
        else if(testList == TESTLIST_ID_QTM_CAL)
        {
            return 0x21;
        }
        */
        else
        {
            return 0x00;//G[͕ԂȂ        
        }
    }

    /*LINE,QC,REPAIR̂ݕԂ*/
    int GetTestKindId()
    {
        uji::seq::Config config;
        u32 testMode = config.Get().TestMode;
    
        if(testMode == uji::seq::pl::LINE)
        {
            return 0x01;
        }
        else if(testMode == uji::seq::pl::QC)
        {
            return 0x02;
        }
        else if(testMode == uji::seq::pl::REPAIR)
        {
            return 0x03;
        }
        else
        {
            return 0x00;//G[͕ԂȂ        
        }
    }

    /*tH[}bgID0x04̌ʂԂ*/
    int GetTestResult(bool testResult)
    {
        if(testResult == true)
            return TestTrace::TestOk;
        else if(testResult == false)
            return TestTrace::TestNg;
        else
            return 0x0;//G[͕ԂȂ
    }
}//namespace TesterCommunicationxo
