/*---------------------------------------------------------------------------*
  Project:  CTRTrial
  File:     TesterLog.h

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef _UJI_TESTERLOG_H_
#define _UJI_TESTERLOG_H_

#include "LogResultCode.h"
#include <nn/fs.h>
#include <stdio.h>


//#define __LOG_DEBUG 1

#ifdef __LOG_DEBUG
#define DEBUG_WRITE( ... )  (void)nn::dbg::detail::Printf(__VA_ARGS__)
#else
#define DEBUG_WRITE( ... )
#endif


namespace uji {
namespace seq {

    // fBNg
    const std::wstring LOGDIR           = L"/sys/log"; //CTR{̌Oێp

    // Ot@C̃pX
    const std::wstring NAND_LOGDIR      = L"twln:"    + LOGDIR;

    // GNX|[g̃pX
    const std::wstring EXPORT_DIR       = L"/uji/log";
    const std::wstring SD_EXPORT_DIR    = L"sdmc:"    + EXPORT_DIR;

    // obNAbṽpX
    const std::wstring BACKUP_DIR       = L"/uji/backup";
    const std::wstring SD_BACKUP_DIR    = L"sdmc:"    + BACKUP_DIR;

    // nbV
    const int LOG_HASH_STR_LEN          = 40; //nbVvZ̕
    const std::string HASH_NO_DATA      = "DA39A3EE5E6B4B0D3255BFEF95601890AFD80709"; //f[^ȂSHA-1l(20oCg)
    const std::string BLANK_DATA_HEADER = HASH_NO_DATA +"\n\n";                       //sQ

    // pX̐ݒ
    const std::wstring PATH_LOGDIR      = NAND_LOGDIR;

    typedef enum
    {
        MAC_ADDR=0,     //MACAhX
        SERIAL_NUMBER=1 //VANO
    }ExportFileName;



//============================================================================
//
//  TesterLog  ONX
//
//============================================================================
class TesterLog
{

public:
// oϐ
    char       m_HashEntryValue [LOG_HASH_STR_LEN +1];  //t@C̃nbVs̒l
    char       m_FileHash       [LOG_HASH_STR_LEN +1];  //t@CnbVl
    char       m_DataHash       [LOG_HASH_STR_LEN +1];  //f[^nbVl
    char       padding1[1];

    s64        m_fileSize;          //Õt@CTCY
    s64        m_fileSizeMax;       // Õt@CTCY̍ől

    bool       m_isSpecialMountCalled;
    bool       padding2[7];

    // Et@C
    std::wstring m_fileNameMaster ; // = L"product.log";
    std::wstring m_fileNameSub    ; // = L"product.log~";
    std::wstring m_nandPathMaster ; // = NAND_LOGDIR +L"/"+ m_fileNameMaster;
    std::wstring m_nandPathSub    ; // = NAND_LOGDIR +L"/"+ m_fileNameSub;
    std::wstring m_pathMaster     ; //= PATH_NAND_MASTER;
    std::wstring m_pathSub        ; //= PATH_NAND_SUB;

// o֐
public:
    // RXgN^
    TesterLog() : m_fileSize(-1), m_fileSizeMax(16384),m_isSpecialMountCalled(false)
    {
        sprintf(m_DataHash,       "%s","00000000000000000000FFFFFFFFFFFFFFFFFFFF");
        sprintf(m_FileHash,       "%s","FFFFFFFFFFFFFFFFFFFF00000000000000000000");
        sprintf(m_HashEntryValue, "%s","0123456789ABCDEF0123456789ABCDEF01234567");
    };

    // fXgN^
    ~TesterLog()
    {
        Finalize();
    }


    // ANZbT
            s64        Get_FileSize(void) const;  //t@CTCY擾

    // 
            LogResult  primaryInit(void);
            LogResult  Initialize();       //InitializeRXgN^Ɋ܂܂Ȃ̂́A߂lĂяoŎ擾
            LogResult  Finalize();
    virtual LogResult  InitFile(const std::wstring& path) = 0;

    // [h
            LogResult  LoadFile(const std::wstring & path);
            LogResult  LoadFile_Master(void);
            LogResult  LoadFile_Sub(void);
    virtual LogResult  LoadData(void * buf)=0; //f[^̓o^

    // Cg
            LogResult  WriteProc (void);                   //t@Cۑ(1,2,3,4,5)
            LogResult  WriteProc_WithNoMasterBackup(void); //t@Cۑ(    3,4,5) t@CobNAbvȂ
            LogResult  WriteFile_Master(const std::string & message);
    virtual LogResult  WriteFile(const std::wstring& path, const std::string & message) = 0;

    // Rs[
            LogResult  CopyFile (std::wstring writePath, std::wstring readPath);//Rs[֐̎
            LogResult  CopyFile_MasterAsSub(const std::string & message);
            LogResult  CopyFile_SubAsMaster(const std::string & message);

    // 
            LogResult  DeleteFile(const std::wstring & path, const std::string & message); //Ot@C̏
            LogResult  DeleteFile_Master(const std::string & message); //t@C̍폜
            LogResult  DeleteFile_Sub   (const std::string & message); //t@C̍폜

    // nbV
            LogResult    Calc_FileHash(nn::fs::FileReader &fr); //Ot@CɃnbVlvZ
    virtual LogResult    Calc_DataHash(void) =0;                //Of[^ɃnbVlvZ

            std::string  Get_HashEntryValue(void) const;        //t@C̃nbVs̒l
            std::string  Get_FileHash(void) const;              //t@Ĉ̃nbVlԂ
            std::string  Get_DataHash(void) const;              //̃f[^̃nbVlԂB

    // f[^óiSDj
            LogResult ExportSD(u8 type);
            LogResult ExportSD_MacAddress(void);
            LogResult ExportSD_SerialNumber(void);

    // ޔE (SD)
            LogResult Backup(void);
            LogResult Restore(void);
    virtual LogResult Identify_RestoreTarget()=0;

};// class TesterLog

} // namespace seq
} // namespace uji

#endif // _UJI_TESTERLOG_H_
/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
