/*---------------------------------------------------------------------------*
  Project:  CTRTrial
  File:     TesterLog.cpp

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include "TesterLog.h"
#include "sys_Memory.h"
#include "sys_GetMacAddress.h"

#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>  // EVA_SDK_0_14_1
#include <nn/fs/fs_APILoader.h>
#include <nn/srv.h>
#include <nn/crypto/crypto_Sha1.h>


#include <stdio.h>
#include <string.h>
#include <string>
#include <iostream>

using namespace uji::seq;
using namespace std;

//
//  ŏɕKĂԊ֐
//
LogResult TesterLog::primaryInit(void)
{
    LogResult     lr;
    LogResultCode lrc;
    nn::Result    nnr;

    DEBUG_WRITE("%s called.\n",NN_FUNCTION);

//    InternalCheck();

    nn::Result result = nn::srv::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);

    // fs 
    nn::fs::InitializeForLoader();
    DEBUG_WRITE("InitializeForLoader done.\n");

    // sfoCX򉻂ۂ̓[IɍČȂ悤(fobOpj
    nn::fs::ForceDisableLatencyEmulation();

    // twlnA[JCu}Eg
    if ( false == m_isSpecialMountCalled)
    {
        // twln
        nnr = nn::fs::MountSpecialArchive("twln:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND);
        if (nnr.IsFailure())
        {
            NN_LOG("MountSpecialArchive twln failed.\n");
            nn::dbg::PrintResult(nnr);
            return LogResultCode::ARC_MOUNT_ERROR;
        }

/*        // nand
        nnr = nn::fs::MountSpecialArchive("nand:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND);
        if (nnr.IsFailure())
        {
            NN_LOG("MountSpecialArchive nand failed.\n");
            nn::dbg::PrintResult(nnr);
            return LogResultCode::ARC_MOUNT_ERROR;
        }
*/
        m_isSpecialMountCalled = true;
        DEBUG_WRITE("MountSpecialArchive succeded.\n");
    }

    return LogResultCode::SUCCESS;
}

//
// Ot@C̃nbVlvZB(File Hash)
// nbV̌vZΏہF3sڈȍ~
//  (","s(0x0A)nbVvZ̑Ώۂłj
//

// () fr.Read͌ĂяoRXgɂB
//       AǂݏoTCY1024oCgłA1oCgłĂԂ͂܂肩Ȃ݂B
int  TesterLog::Calc_FileHash(nn::fs::FileReader &fr)
{
#if 0
    Dump_LogTableAll();
#endif

#ifdef __LOG_DEBUG
    s64 offsetStart ; //t@Cł̃nbVΏۊJnԒn
#endif

    //
    // Ot@C̓ǂݍ
    //
    fr.Seek(0, nn::fs::POSITION_BASE_BEGIN);

    // 1sځA2sڂ𖳎鏈i\n\no鏈j
    u8 buf[2];
    std::memset(buf, 0x00, 2);
    while(1)
    {
        s32 result;
        result = fr.Read(&buf[1], 1);

        if (0 == result )
        {
            NN_LOG("%s ERROR.\n", NN_FUNCTION);
            return LogResultCode::NO_MAGIC_CODE ; //t@C̏I[܂ł\n\nȂ
        }

        // s؂qƂ
        if ((0x0A == buf[0]) && (0x0A == buf[1]))
        {
#ifdef __LOG_DEBUG
         offsetStart = fr.GetPosition();
#endif
            break;
        }

        buf[0] = buf[1]; //Read̂Qڈȍ~AAf[^悤
    }


    //mہit@C[hpj
    void * fileDataBuf = uji::sys::Alloc(m_fileSizeMax);
    if ( NULL == fileDataBuf)
    {
        NN_LOG("%s fileDataBuf is NULL\n",NN_FUNCTION);
        return LogResultCode::ALLOCATE_ERROR;
    }
    std::memset(fileDataBuf, 0x00, m_fileSizeMax);

    // NANĎOt@CTCY擾 (16K = 16384)
    s64 fileSize = -1;
    fileSize = fr.GetSize();

    //nbVvZΏۂ̃t@Cf[^Ƀ[h
    s32 readBytes = 0;
    readBytes = fr.Read(fileDataBuf, fileSize);
    if ( readBytes > m_fileSizeMax)
    {
        NN_LOG("%s readBytes greater LOG_FILESIZE_MAX.\n",NN_FUNCTION);
        uji::sys::Free(fileDataBuf);
        return LogResultCode::FS_READ_ERROR; //t@C[hG[
    }

    // 0x0AT[`
    int targetLength =0;
    {
        u8 * ptr;
        ptr = static_cast<u8 *>(fileDataBuf);
        for(u32 length=0 ; length < readBytes ; length++, ptr++)
        {
            if ( 0x0A == *ptr ) {targetLength = length;}
        }
    }
    targetLength = targetLength + 1; //f[^̍ŏIs̉s܂߂邽 +1

    //
    // nbVvZ
    //
    nn::crypto::Sha1Context sha1;
    sha1.Initialize();

    int hashLength = 0;
    hashLength = sha1.GetHashLength();

    //mہinbVvZpj
    void* hashBuf = uji::sys::Alloc(hashLength);
    if ( NULL == hashBuf )
    {
        NN_LOG("%s hashBuf is NULL\n",NN_FUNCTION);
        uji::sys::Free(fileDataBuf);
        return LogResultCode::ALLOCATE_ERROR;
    }
    std::memset(hashBuf, 0x00, sizeof(hashBuf));

    //nbVl\
    u8 * ptr; //`p|C^
    sha1.Update (fileDataBuf, targetLength);//nbVvZ
    DEBUG_WRITE("%s StartOffset:0x%llx Length:%d\n", NN_FUNCTION, offsetStart, targetLength);
    sha1.GetHash(hashBuf);

    std::memset(m_FileHash, 0x00, sizeof(m_FileHash));
    ptr = static_cast<u8 *>(hashBuf);
    DEBUG_WRITE(" sha1 FILE HASH: [");
    for(int i = 0; i < hashLength; i++)
    {
        DEBUG_WRITE("%02X",*ptr);
        sprintf(&m_FileHash[i*2], "%02X",*ptr);
        ptr++;
    }
    DEBUG_WRITE("]\n");
    sha1.Finalize();
    sha1.~Sha1Context();

    // 
    uji::sys::Free(fileDataBuf);
    uji::sys::Free(hashBuf);

    return LogResultCode::SUCCESS;
}

// Ot@C̃TCYԂ
s64 TesterLog::Get_FileSize(void) const
{
    return m_fileSize;
}

// Ot@C̃nbVlԂ
std::string TesterLog::Get_FileHash(void) const
{
    string str;
    str = m_FileHash;
    return str;
}

// f[^̃nbVlԂ
std::string TesterLog::Get_DataHash(void) const
{
    string str;
    str = m_DataHash;
    return str;
}

// t@C̃nbVs̒lԂ
std::string TesterLog::Get_HashEntryValue(void) const
{
    string str;
    str = m_HashEntryValue;
    return str;
}

//
// Oe[ut@Cɏ
//
//  - step1 s̕t@C폜
//  - step2 s̐t@CAt@CɃRs[
//  - step3 t@C
//  - step4 t@C폜
//  - step5 s̐t@CAt@CɃRs[
LogResult TesterLog::WriteProc(void)
{
    LogResult lr;

    //step1ł́At@C݂ȂꍇlB
    //̂߁AFS_OPEN_ERROR͒eȂB
    lr = DeleteFile_Sub        ("1/5 *D1");
    if ((lr != LogResultCode::FS_OPEN_ERROR) &&
        (lr != LogResultCode::FS_DELETE_ERROR) &&
        (lr != LogResultCode::SUCCESS)) goto ERROR;

    lr = CopyFile_MasterAsSub  ("2/5 *C1");
    if ( LogResultCode::SUCCESS != lr ) goto ERROR;

    lr = WriteFile_Master      ("3/5 *W");
    if ( LogResultCode::SUCCESS != lr ) goto ERROR;

    lr = DeleteFile_Sub        ("4/5 *D2");
    if ( LogResultCode::SUCCESS != lr ) goto ERROR;

    lr = CopyFile_MasterAsSub  ("5/5 *C2");
    if ( LogResultCode::SUCCESS != lr ) goto ERROR;

    NN_LOG("%s done.\n", __func__);
    return lr;

ERROR:
    NN_LOG("%s failed(%d).\n",NN_FUNCTION, lr);
    return lr;
}

// Mastert@C̃obNAbvȂꍇ̃Cgt[
LogResult TesterLog::WriteProc_WithNoMasterBackup(void)
{
    LogResult lr;

    NN_LOG("%s ...\n", __func__);

    lr = WriteFile_Master      ("3/5 *W");
    if ( LogResultCode::SUCCESS != lr ) goto ERROR;

    lr = DeleteFile_Sub        ("4/5 *D2");
    if ( LogResultCode::SUCCESS != lr ) goto ERROR;

    lr = CopyFile_MasterAsSub  ("5/5 *C2");
    if ( LogResultCode::SUCCESS != lr ) goto ERROR;

    NN_LOG("%s done.\n", __func__);
    return lr;

ERROR:
    NN_LOG("%s failed(%d).\n",NN_FUNCTION, lr);
    return lr;
}

LogResult TesterLog::WriteFile_Master(const string & message)
{
    LogResult r;
    r = WriteFile(m_pathMaster, message);
    return r;
}

// t@CRs[s   P:Rs[, Q:Rs[
LogResult TesterLog::CopyFile(wstring writePath, wstring readPath)
{
    LogResult lr;

    // fs 
    nn::fs::Initialize();
    nn::fs::FileReader       fr;
    nn::fs::FileOutputStream fos(writePath.c_str(), true);

    // t@CJ
    nn::Result nnr;
    nnr = fr.TryInitialize(readPath.c_str());
    if (nnr.IsFailure()) return LogResultCode::FS_OPEN_ERROR;

    // t@CTCY擾
    m_fileSize = fr.GetSize();
    DEBUG_WRITE( "file=[%ls] Size:%dBytes/", readPath.c_str(), m_fileSize );

    // m
    void* buf = uji::sys::Alloc(m_fileSize);
    if ( NULL == buf )
    {
        lr = LogResultCode::ALLOCATE_ERROR;
        goto FIN;
    }

    // t@C|C^擪
    nnr = fr.TrySeek(0,nn::fs::POSITION_BASE_BEGIN);
    if (nnr.IsFailure())
    {
        NN_LOG(" failed to seek \n");
        nn::dbg::PrintResult(nnr);
        lr = LogResultCode::FS_READ_ERROR;
        goto FIN;
    }

    // mۂɃt@Cf[^[hB
    s32 readBytes;
    readBytes = fr.Read(buf, m_fileSize);
    DEBUG_WRITE("readBytes:%dBytes\n", readBytes);
    if ( readBytes == 0 )
    {
        NN_LOG(" failed to Read [%ls].\n", readPath.c_str());
        lr = LogResultCode::FS_READ_ERROR;
        goto FIN;
    }

    //t@CCgs
    s32 writeBytes;
    writeBytes = fos.Write(buf,m_fileSize);
    DEBUG_WRITE(" wrote [%ls] %dBytes.\n", writePath.c_str(),writeBytes);
    if ( writeBytes == 0 )
    {
        NN_LOG("__CopyFile failed to write [%ls]!\n", writePath.c_str());
        lr = LogResultCode::FS_WRITE_ERROR;
    }
    else
    {
        lr = LogResultCode::SUCCESS;
    }
    fos.Finalize();

FIN:
    uji::sys::Free(buf); // 

    fr.Finalize();       // fs̏I
    fr.~FileInputStream();
    //nn::fs::Finalize();  // finalizeĂԂƃt[YĂ܂B
    return lr;
}


// string͎sɃbZ[Wo߂Ɏgp
LogResult TesterLog::CopyFile_MasterAsSub(const string & message)
{
    NN_LOG("%s %s \n", __func__, message.c_str());
    LogResult lr;

    wstring fromPath  = m_pathMaster;
    wstring toPath    = m_pathSub;

    lr = CopyFile(toPath, fromPath);
    return lr;
}

// string͎sɃbZ[Wo߂Ɏgp
LogResult TesterLog::CopyFile_SubAsMaster(const string & message)
{
    NN_LOG("%s %s \n", __func__, message.c_str());
    LogResult lr;

    wstring fromPath  = m_pathSub;
    wstring toPath    = m_pathMaster;

    lr = CopyFile(toPath, fromPath);
    return lr;
}

// Ot@C t@C
LogResult TesterLog::DeleteFile_Master(const string & message)
{
    LogResult lr;
    lr = DeleteFile(m_pathMaster, message);
    return lr;
}

// Ot@C t@C
LogResult TesterLog::DeleteFile_Sub(const string & message)
{
    LogResult lr;
    lr = DeleteFile(m_pathSub, message);
    return lr;
}

// Ot@C ėp
LogResult TesterLog::DeleteFile(const wstring & path, const string & message)
{
    LogResult lr;
    nn::Result nnr;

    NN_LOG("%s           %s [%ls].\n",__func__, message.c_str(), path.c_str());
    nnr = nn::fs::TryDeleteFile(path.c_str());
    if ( nnr.IsFailure() )
    {
        NN_LOG("%s TryDeleteFile[%ls] is failed(%s).\n", NN_FUNCTION, path.c_str(), message.c_str());
        lr = LogResultCode::FS_DELETE_ERROR;
    }
    else
    {
        lr = LogResultCode::SUCCESS;
    }
    return lr;
}


LogResult TesterLog::ExportSD_MacAddress(void)
{
    return ExportSD(MAC_ADDR);
}

LogResult TesterLog::ExportSD_SerialNumber(void)
{
    return ExportSD(SERIAL_NUMBER);
}

// Of[^SDJ[hɃt@CRs[B
// iEƂɁj
LogResult TesterLog::ExportSD(u8 type)
{
    nn::Result nnr;

    std::string macAddress   =  "001122334455";
    std::wstring wMacAddress = L"001122334455";

    // o̓t@C̑I
    if ( MAC_ADDR == type )
    {

#if 0
        // MACAhXo̓t@Cɂꍇ
        bit8 mac[ nn::uds::MAC_ADDRESS_SIZE ];
        uji::sys::GetMacAddress( mac );

        char         macAddressStr[12+1];
        std::memset(macAddressStr, 0x00, sizeof(macAddressStr));
        std::sprintf(macAddressStr, "%02X%02X%02X%02X%02X%02X", mac[0],
                                                                mac[1],
                                                                mac[2],
                                                                mac[3],
                                                                mac[4],
                                                                mac[5]);
#endif
        char         macAddressStr[12+1];

        uji::sys::GetMacAddressStr(macAddressStr);

        macAddress = macAddressStr;

        wMacAddress[0] = macAddress[0];
        wMacAddress[1] = macAddress[1];
        wMacAddress[2] = macAddress[2];
        wMacAddress[3] = macAddress[3];
        wMacAddress[4] = macAddress[4];
        wMacAddress[5] = macAddress[5];
        wMacAddress[6] = macAddress[6];
        wMacAddress[7] = macAddress[7];
        wMacAddress[8] = macAddress[8];
        wMacAddress[9] = macAddress[9];
        wMacAddress[10] = macAddress[10];
        wMacAddress[11] = macAddress[11];

    }
    else if ( SERIAL_NUMBER == type )
    {
        //TODO VAio[o̓t@Cɂꍇ
    }

    // SDJ[h}Eg
    NN_LOG("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        NN_LOG("failed.\n");
        return LogResultCode::ARC_MOUNT_ERROR;
    }
    NN_LOG("succeeded.\n");


    // SDJ[h/uji/logtH_@
    nn::fs::Directory  d;
    nnr = d.TryInitialize(SD_EXPORT_DIR.c_str());
    if (nnr.IsFailure())
    {
         NN_LOG("directory(%ls) open failed.\n", SD_EXPORT_DIR.c_str());
         nn::dbg::PrintResult(nnr);

         //fBNgȂ̂ŁAfBNg쐬B
         NN_LOG(" try create new directory ...");
         nnr = nn::fs::TryCreateDirectory(SD_EXPORT_DIR.c_str());
         if (nnr.IsFailure())
         {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);

            nnr = nn::fs::Unmount("sdmc:"); //A}Eg
            return LogResultCode::FUNC_CALL_ERROR;
         }
         NN_LOG("succeeded.\n");
    }

    // SDJ[hփt@CRs[s
    LogResult lr;

    /// t@C̃Rs[
    wstring fromPath  = m_pathMaster;
    wstring toPath    = SD_EXPORT_DIR +L"/"+ wMacAddress +L"_" +m_fileNameMaster;
    lr = CopyFile(toPath, fromPath);
    if ( LogResultCode::SUCCESS != lr ) goto FIN;

    /// t@C̃Rs[
    fromPath  = m_pathSub;
    toPath    = SD_EXPORT_DIR +L"/"+ wMacAddress +L"_" +m_fileNameSub;

    CopyFile(toPath, fromPath);

FIN:
    // SDJ[h̃A}Eg
    NN_LOG("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        return LogResultCode::ARC_UMOUNT_ERROR;
    }
    NN_LOG("succeeded.\n");

    return LogResultCode::SUCCESS;
}

//
// f[^̑ޔ(Backupjƕ(Restore) ̓yAŎg܂B
// obNAbv
LogResult TesterLog::Backup(void)
{
    nn::Result nnr;

    std::string macAddress   =  "001122334455";
    std::wstring wMacAddress = L"001122334455";


    // MACAhXo̓t@Cɂꍇ
    bit8 mac[ nn::uds::MAC_ADDRESS_SIZE ];
    uji::sys::GetMacAddress( mac );

    char         macAddressStr[12+1];
    std::memset(macAddressStr, 0x00, sizeof(macAddressStr));
    std::sprintf(macAddressStr, "%02X%02X%02X%02X%02X%02X", mac[0],
                                                            mac[1],
                                                            mac[2],
                                                            mac[3],
                                                            mac[4],
                                                            mac[5]);

    macAddress = macAddressStr;

    wMacAddress[0] = macAddress[0];
    wMacAddress[1] = macAddress[1];
    wMacAddress[2] = macAddress[2];
    wMacAddress[3] = macAddress[3];
    wMacAddress[4] = macAddress[4];
    wMacAddress[5] = macAddress[5];
    wMacAddress[6] = macAddress[6];
    wMacAddress[7] = macAddress[7];
    wMacAddress[8] = macAddress[8];
    wMacAddress[9] = macAddress[9];
    wMacAddress[10] = macAddress[10];
    wMacAddress[11] = macAddress[11];


    // SDJ[h}Eg
    NN_LOG("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        NN_LOG("failed.\n");
        return LogResultCode::ARC_MOUNT_ERROR;
    }
    NN_LOG("succeeded.\n");


    // o͐MACAhXtH_
    std::wstring SD_BACKUP_DEST   = SD_BACKUP_DIR + L"/" +wMacAddress;

    // SDJ[h/uji/backup/(MACAhX) tH_@
    nn::fs::Directory  d;
    nnr = d.TryInitialize(SD_BACKUP_DEST.c_str());
    if (nnr.IsFailure())
    {
         NN_LOG("directory(%ls) open failed.\n", SD_BACKUP_DEST.c_str());
         nn::dbg::PrintResult(nnr);

         //fBNgȂ̂ŁAfBNg쐬B
         NN_LOG(" try create new directory ...");
         nnr = nn::fs::TryCreateDirectory(SD_BACKUP_DEST.c_str());
         if (nnr.IsFailure())
         {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);

            nnr = nn::fs::Unmount("sdmc:"); //A}Eg
            return LogResultCode::FUNC_CALL_ERROR;
         }
         NN_LOG("succeeded.\n");
    }

    // SDJ[hփt@CRs[s
    LogResult lr;

    /// t@Ĉ݃Rs[
    wstring fromPath  = m_pathMaster;
    wstring toPath    = SD_BACKUP_DEST +L"/"+ wMacAddress +L"_" +m_fileNameMaster;
    lr = CopyFile(toPath, fromPath);
    if ( LogResultCode::SUCCESS != lr ) goto FIN;

FIN:
    // SDJ[h̃A}Eg
    NN_LOG("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        return LogResultCode::ARC_UMOUNT_ERROR;
    }
    NN_LOG("succeeded.\n");

    return LogResultCode::SUCCESS;
}


// f[^̕
LogResult TesterLog::Restore(void)
{
    nn::Result nnr;

    std::string macAddress   =  "001122334455";
    std::wstring wMacAddress = L"001122334455";


    // MACAhXo̓t@Cɂꍇ
    bit8 mac[ nn::uds::MAC_ADDRESS_SIZE ];
    uji::sys::GetMacAddress( mac );

    char         macAddressStr[12+1];
    std::memset(macAddressStr, 0x00, sizeof(macAddressStr));
    std::sprintf(macAddressStr, "%02X%02X%02X%02X%02X%02X", mac[0],
                                                            mac[1],
                                                            mac[2],
                                                            mac[3],
                                                            mac[4],
                                                            mac[5]);

    macAddress = macAddressStr;

    wMacAddress[0] = macAddress[0];
    wMacAddress[1] = macAddress[1];
    wMacAddress[2] = macAddress[2];
    wMacAddress[3] = macAddress[3];
    wMacAddress[4] = macAddress[4];
    wMacAddress[5] = macAddress[5];
    wMacAddress[6] = macAddress[6];
    wMacAddress[7] = macAddress[7];
    wMacAddress[8] = macAddress[8];
    wMacAddress[9] = macAddress[9];
    wMacAddress[10] = macAddress[10];
    wMacAddress[11] = macAddress[11];


    // SDJ[h}Eg
    NN_LOG("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        NN_LOG("failed.\n");
        return LogResultCode::ARC_MOUNT_ERROR;
    }
    NN_LOG("succeeded.\n");


    // ͐ SDJ[hMACAhXtH_
    std::wstring SD_BACKUP_DEST;
    SD_BACKUP_DEST   = SD_BACKUP_DIR + L"/" +wMacAddress;


    // SDJ[h/uji/backup/(MACAhX) tH_邩ǂmFB
    nn::fs::Directory  d;
    nnr = d.TryInitialize(SD_BACKUP_DEST.c_str());
    if (nnr.IsFailure())
    {

         NN_LOG("directory(%ls) open failed.\n", SD_BACKUP_DEST.c_str());
         nn::dbg::PrintResult(nnr);

         //fBNgȂ̂ŁAIB
         nnr = nn::fs::Unmount("sdmc:"); //A}Eg
         return LogResultCode::FUNC_CALL_ERROR;
    }

    // XgA̖{̏ƍɐ旧ASD烍[hsB
    LogResult lr;
    lr = LoadFile( SD_BACKUP_DEST +L"/"+ wMacAddress +L"_" +m_fileNameMaster ) ;

    // XgA̖{̏ƍ
    lr = Identify_RestoreTarget();
    if ( LogResultCode::SUCCESS != lr)
    {
        nnr = nn::fs::Unmount("sdmc:"); //A}Eg
        return lr;
    }

    // SDJ[hANANDɃt@CRs[s (t@Ĉ)

    //  wstring fromPath  = m_pathMaster;
    //  wstring toPath    = SD_BACKUP_DEST +L"/"+ wMacAddress +L"_" +m_fileNameMaster;

    wstring fromPath  = SD_BACKUP_DEST +L"/"+ wMacAddress +L"_" +m_fileNameMaster;
    wstring toPath    = m_pathMaster;

    lr = CopyFile(toPath, fromPath);
    if ( LogResultCode::SUCCESS != lr ) goto FIN;

FIN:
    // SDJ[h̃A}Eg
    NN_LOG("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        return LogResultCode::ARC_UMOUNT_ERROR;
    }
    NN_LOG("succeeded.\n");

    return LogResultCode::SUCCESS;
}

// t@C[h
LogResult TesterLog::LoadFile_Master(void)
{
    LogResult r;
    r = LoadFile(m_pathMaster);
    return r;
}

// t@C[h
LogResult TesterLog::LoadFile_Sub(void)
{
    LogResult r;
    r = LoadFile(m_pathSub);
    return r;
}

// pXw肵āA[h
LogResult TesterLog::LoadFile(const wstring & path)
{
    LogResult lr = LogResultCode::UNKNOWN_ERROR ;
    nn::Result nnr;

    // t@CJ
    nn::fs::FileReader fr;
    nnr = fr.TryInitialize(path.c_str());
    if (nnr.IsFailure())
    {
        NN_LOG(" TryInitialize[%ls] is failed\n", path.c_str());
        nn::dbg::PrintResult(nnr);
        return LogResultCode::FS_OPEN_ERROR;
    }

    // t@CTCY擾
    m_fileSize = fr.GetSize();
    NN_LOG("%s [%ls] fileSize:%dBytes", __func__, path.c_str(),m_fileSize);
    if ( 0 ==  m_fileSize )
    {
        fr.Finalize();       // fs̏I
        return LogResultCode::FILESIZE_ZERO;
    }

    // t@Cf[^[hpm
    void* buf = uji::sys::Alloc(m_fileSize);
    if ( NULL == buf )
    {
        lr = LogResultCode::ALLOCATE_ERROR;
        goto FIN;
    }

    // t@C|C^擪
    nnr = fr.TrySeek(0,nn::fs::POSITION_BASE_BEGIN);
    if (nnr.IsFailure())
    {
        NN_LOG(" failed to seek \n");
        lr = LogResultCode::FS_READ_ERROR;
        goto FIN;
    }

    // mۂɃt@Cf[^[hB
    s32 readSize;
    readSize = fr.Read(buf, m_fileSize);
    NN_LOG(" readSize:%dBytes\n", readSize);
    if ( readSize == 0 )
    {
        NN_LOG(" failed to Read [%ls].\n", path.c_str());
        lr = LogResultCode::FS_READ_ERROR;
        goto FIN;
    }

    // ftHgt@Cǂ̃`FbN (擪40oCgS0xFF)
    {
        u8 * ptr = reinterpret_cast<u8 *>(buf);

        int i = 0;
        for(; i < 40 ;i++, ptr++)
        {
            if ( *ptr != 0xFF) { break; }
        }

        if ( 40 == i)
        {
            NN_LOG("HASH AREA ALL 0xFF.\n");
            lr = LogResultCode::HASH_ALL_FF;
            goto FIN;
        }
    }

    // }WbNR[h̊mF(40oCgځA41oCgڂsR[hj
    {
        u8 * ptr = reinterpret_cast<u8 *>(buf);

        ptr = ptr + 40;
        if ( 0x0A != *ptr )
        {
            lr = LogResultCode::NO_MAGIC_CODE;
            goto FIN;
        }

        ptr = ptr + 1;
        if ( 0x0A != *ptr )
        {
            lr = LogResultCode::NO_MAGIC_CODE;
            goto FIN;
        }
    }

    // t@Cf[^[hB
    //  product.log -> \̂̃e[uɓo^B
    //  inspcet.log -> \̂ɓo^
    if ( LogResultCode::SUCCESS != LoadData(buf))
    {
        lr = LogResultCode::FUNC_CALL_ERROR;
        goto FIN;
    }

    // nbVl𐶐î́j
    if ( LogResultCode::SUCCESS != Calc_DataHash())
    {
        lr = LogResultCode::HASH_CALC_ERROR;
        goto FIN;
    }

    // nbVl̏ƍ : f[^()̃nbVlƁAt@C̃nbVl̋Lq
    if ( 0 != strcmp(m_DataHash, m_HashEntryValue))
    {
        NN_LOG("  ---------- hash mismatch !! ---------\n");
        NN_LOG("  DataHash       :[%s]\n", m_DataHash);
        NN_LOG("  HashEntryValue :[%s]\n", m_HashEntryValue);
        lr = LogResultCode::HASH_MISMATCH;
        goto FIN;
    }

    lr = LogResultCode::SUCCESS; //܂ŗ΁A

FIN:
    fr.Finalize();       // fs̏I
    uji::sys::Free(buf); // 
    return lr;
}

//
// 
//
LogResult TesterLog::Initialize(void)
{
    LogResult  lr;
    bool       existMaster = true; // t@C݂邩ǂ

    LogResultCode lrc;
    nn::Result    nnr;
    NN_LOG("%s called.\n",NN_FUNCTION);

    // s
    lr = primaryInit();
    if ( lr != LogResultCode::SUCCESS) return lr;

    // fBNgJƂ݂
    nn::fs::Directory  d;
    nnr = d.TryInitialize(PATH_LOGDIR.c_str());
    if (nnr.IsFailure())
    {
         d.Finalize();
         NN_LOG("directory(%ls) open failed.\n", PATH_LOGDIR.c_str());
         nn::dbg::PrintResult(nnr);

         //fBNgȂ̂ŁAfBNg쐬B
         NN_LOG(" try create new directory ...");
         nnr = nn::fs::TryCreateDirectory(PATH_LOGDIR.c_str());
         if (nnr.IsFailure())
         {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);
            return LogResultCode::FUNC_CALL_ERROR;
         }
         NN_LOG("succeeded.\n");

         existMaster = false;
         //t@CȂ̂ŁAt@C쐬B
//         lr = InitFile(m_pathMaster);
//         return lr;
    }
    else
    {
        //t@C̃[h
        lr = LoadFile_Master();
        switch (lr)
        {
            case LogResultCode::HASH_MISMATCH:
            {
                break;//A
            }
            case LogResultCode::FS_OPEN_ERROR:
            case LogResultCode::FS_READ_ERROR:
            {
                existMaster = false;
                break;//A
            }

            // sȃt@CԂ̏ꍇ́A폜
            case LogResultCode::HASH_ALL_FF:
            case LogResultCode::NO_MAGIC_CODE:
            {
                DeleteFile_Master("Hash Area is All 0xFF or NO magic code, so delete Master file.");
                existMaster = false;
                break;//A
            }
            case LogResultCode::FILESIZE_ZERO:
            {
                DeleteFile_Master("File Size is Zero, so delete Master file.");
                existMaster = false;
                break;//A
            }

            // 
            case LogResultCode::SUCCESS:
            {
                return lr; //I
            }
            default:
            {
                NN_LOG("unexpected error %d\n", lr);
                return lr;
            }
        }// switch

        //A t@C̃[h
        NN_LOG(" MASTER FILE read ERROR(%s), try reading SUB FILE ...\n", lrc.ToString(lr).c_str());
        lr = LoadFile_Sub();
        switch (lr)
        {
            // sȃt@CԂ̏ꍇ́A폜
            case LogResultCode::HASH_ALL_FF:
            case LogResultCode::NO_MAGIC_CODE:
            {
                 DeleteFile_Sub("Hash Area is All 0xFF or NO magic code,  so delete Sub file.");
                 break;
            }
            case LogResultCode::FILESIZE_ZERO:
            {
                 DeleteFile_Sub("File Size is Zero, so delete Sub file.");
                 break;
            }
            case LogResultCode::FS_OPEN_ERROR:
            case LogResultCode::FS_READ_ERROR:
            {
                 break; //Ȃ
            }
            case LogResultCode::HASH_MISMATCH:
            {
                //t@CAt@C̗ƂnbV~X}b`ł邪A
                //nbVȂĂt@Ĉ̂gpB
                if ( existMaster )
                {
                    lr = LoadFile_Master();
                    return lr;
                }
                break;
            }
            case LogResultCode::SUCCESS:
            {
                //t@C̃f[^ɖ肪Ȃ̂ŁÃf[^gp
                NN_LOG("succeeded.\n");
                CopyFile_SubAsMaster("copy SUB FILE to MASTER FILE");
                return lr;
            }
            default:
            {
                NN_LOG("unexpected error %d\n", lr);
                return lr;
            }
        }//switch

    }//if-else

    //t@C݂Ȃ΁At@C쐬
    if (existMaster==false)
    {
        lr = InitFile(m_pathMaster);
    }
    return lr;
}

// I
LogResult TesterLog::Finalize(void)
{
    LogResult  r;
    nn::Result nnr;

    if ( true == m_isSpecialMountCalled)
    {
        // twln
        nnr = nn::fs::Unmount("twln:");
        if (nnr.IsFailure())
        {
            NN_LOG("%s Unmount twln failed.\n",NN_FUNCTION);
            nn::dbg::PrintResult(nnr);
            return LogResultCode::ARC_UMOUNT_ERROR;
        }

/*
        // nand
        nnr = nn::fs::Unmount("nand:");
        if (nnr.IsFailure())
        {
            NN_LOG("%s Unmount nand failed.\n",NN_FUNCTION);
            nn::dbg::PrintResult(nnr);
            return LogResultCode::ARC_UMOUNT_ERROR;
        }
*/
        DEBUG_WRITE("%s Unmount succeeded.\n",NN_FUNCTION);
        m_isSpecialMountCalled = false;
    }

    return LogResultCode::SUCCESS;
}
