/*--------------------------------------------------------------------------*
  Project:
  File: ProductionLogViewer.h

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

*--------------------------------------------------------------------------*/
#ifndef _UJI_SEQ_PRODUCTION_LOGVIEWER_H_
#define _UJI_SEQ_PRODUCTION_LOGVIEWER_H_

#include "sys_GraphicsDrawing.h"
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_MessageLogWindow.h"
#include "sys_TextWindow.h"
#include "sys_Pad.h"
#include "ProductionLog.h"
#include <string>

namespace uji {
namespace seq {


void Run_ProductLog_Viewer();



// ViewerControl  EBhEԁiEBhEƏEBhEj̏pϐ
typedef struct ViewerControl
{
    int         currentPage;   //݂̃y[W
    int         selectedLine;  //Is
    int         drawLines;     //`s
    int         frameCount;    //t[
    std::string message;       //ÕbZ[W
    std::string hashValue;     //t@C̃nbVl
    std::string testerId;      //ID
} ViewerControl;


typedef int LogResult;

//==============================================================================
//
//  LowerWindowNX (WindowNXpVvȃNX)
//
//==============================================================================
class LowerWindow : public sys::Window
{
public:
    //RXgN^ (mgr : j[}l[W̃CX^X̃AhX)
    LowerWindow(sys::WindowManager& mgr, s32 width, s32 height)
    : Window("detail information", width, height),
      m_MesgCount(0),
      m_WindowManager(mgr),
      m_MessageLogWindow(0),
      m_TextWindow(0)
    {}

    virtual ~LowerWindow(){}

    // o͐̃eLXgEChEݒ肵܂
    void SetTextWindow(sys::TextWindow& wnd)
    {
      m_TextWindow = &wnd;
    }

    // o͐̃bZ[WOEChEݒ肵܂
    void SetMessageLogWindow(sys::MessageLogWindow& wnd)
    {
      m_MessageLogWindow = &wnd;
    }

    // ANZbT (EBhEƂ̏񋤗Lp)
    void SetViewerControl(ViewerControl* vc)
    {
        m_vcPtr = vc;
    }

protected:
    // eI[o[ChƎ̏܂
//   virtual void OnDraw(sys::GraphicsDrawing* gfx);
    virtual void OnUpdatePad(const sys::Pad& pad);
    virtual void OnUpdate();

private:
    int m_MesgCount;

    ViewerControl * m_vcPtr;

    sys::WindowManager&     m_WindowManager;
    sys::MessageLogWindow*  m_MessageLogWindow;
    sys::TextWindow*        m_TextWindow;

};// class LowerWindow

//==============================================================================
//
//  LogViewerNX
//
//==============================================================================
class LogViewer
{
private:

    seq::ProductionLog      m_ProductionLog;    // O CX^X

    sys::WindowManager      m_WindowManager;
    sys::TextWindow         m_UpperWindow;      // EBhE
    LowerWindow             m_LowerWindow;      // EBhE
    ViewerControl           m_vc;               // EBhEϐ


public:
    static const int m_DISPLAY_LINE_MAX =14;
    static const int m_FONT_SIZE        =14;

    // ftHgRXgN^ (ϐ̐錾Ə̏vȂƌxłj
    LogViewer():
       m_UpperWindow(400, 240, m_FONT_SIZE),    //EChE (1 400~c240BtHgTCY14)
       m_LowerWindow(m_WindowManager, 320, 239) //EBhE
    {}

    virtual ~LogViewer(){}

    void Initialize(); //

    void Run();        //s


private:

    int  Calc_TotalPages(void); //Õf[^ALogViewerł̃y[WvZB

    // J[\
    void CursorUp();   //J[\
    void CursorDown(); //J[\
    void CursorLeft(); //J[\
    void CursorRight();//J[\E

    // O`悷
    void DrawLog(int row, char * process_name, char * test_result, int testmode,
                 char * program_version, char * date, char * time, char * msg) ;

    // OXg`悷
    int DrawLogList(int start_index);

    // LCD`悷
    int  DrawUpperLCD(sys::GraphicsDrawing* gfx, int display_log_entry_num); //LCD̕`
    void DrawLowerLCD(sys::GraphicsDrawing* gfx);                            //LCD̕`

    // G[bZ[W`悷
    void RunErrorMessage(sys::GraphicsDrawing* gfx,LogResult lr);  //G[\sAL[͂܂Ŏ~߂鏈
    void DrawErrorMessage(sys::GraphicsDrawing* gfx,LogResult lr); //`揈


};//class LogViewer

} //namespace eva
} //namespace uji

#endif // _UJI_SEQ_PRODUCTION_LOGVIEWER_H_
/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
