/*--------------------------------------------------------------------------*
  Project:
  File: ProductionLogViewer.cpp

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

*--------------------------------------------------------------------------*/
#include "ProductionLogViewer.h"
#include "sys_App.h"

#include <nn.h>
#include <nn/fnd.h>
#include <nn/gx.h>
#include <stdlib.h>
#include <nw/types.h>
#include <stdio.h>
#include <string>

using namespace uji::seq;
using namespace std;

namespace uji {
namespace seq {

void Run_ProductLog_Viewer()
{
    LogViewer * lv = new LogViewer;
    lv->Initialize();
    lv->Run();
    delete lv;
}

//============================================================================
//
// LowerWindow
//
//============================================================================

// ͏
void LowerWindow::OnUpdatePad(const sys::Pad& pad)
{
    if (pad.IsButtonRepeatFast(sys::Pad::BUTTON_A))
    {
        sys::Point cursorPos;

        if (m_MessageLogWindow)
        {
            // bZ[WOEChEɏo
            m_MessageLogWindow->Printf("%03d: Thanks!\n", ++m_MesgCount);
        }
    }

    //TODO L,R̋@\𖳌
    if (pad.IsButtonRepeatFast(sys::Pad::BUTTON_R))
    {

    }

    if (pad.IsButtonRepeatFast(sys::Pad::BUTTON_L))
    {

    }
}

// t[XV
void LowerWindow::OnUpdate()
{
    m_vcPtr->frameCount++;
}

//============================================================================
//
// LogViewer
//
//============================================================================

// ṽy[WԂB(ŏ0y[Wj
//
int LogViewer::Calc_TotalPages(void)
{
    int pages = 0;
    int entryNums = 0;
    int mod;

    entryNums = m_ProductionLog.Get_LogEntryNums();
    mod   = entryNums % m_DISPLAY_LINE_MAX;//]
    pages = entryNums / m_DISPLAY_LINE_MAX;

    if ( mod != 0 )
    {
        pages = pages +1;
    }

    return pages;
}

/*---------------------------------------------------------------------------
 
---------------------------------------------------------------------------*/
void LogViewer::Initialize()
{
    //
    // EChE
    //
    // LCDp
    (void)m_WindowManager.CreateWindow(&m_UpperWindow,       NN_GX_DISPLAY0, 0, 0);
    m_UpperWindow.SetTitle("LOG VIEWER ");

    // LCDp
    (void)m_WindowManager.CreateWindow(&m_LowerWindow,       NN_GX_DISPLAY1, 0, 0);
    m_LowerWindow.SetTitle("LOG VIEWER INFO");

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(255);

    // EBhEϐ̏
    m_vc.frameCount = 0;
    m_vc.currentPage = 0;
    m_vc.selectedLine = 0;
    m_vc.drawLines = 0;
    m_vc.message = "This is default message string";// 񏉊ϐwȂ悤ɁA_~[Ă

    m_LowerWindow.SetViewerControl(&m_vc);
}

/*---------------------------------------------------------------------------
O`
---------------------------------------------------------------------------*/
void LogViewer::DrawLog(int row, char * process_name, char * test_result, int testmode,
                        char * program_version, char * date, char * time, char * msg)
{
    char testername[LOG_TESTERNAME_LEN +1]; //H
    char state     [LOG_STATE_LEN      +1]; //Xe[^X
    char modeStr[] = "LQRSSSV AD ";
    char version   [LOG_VERSION_LEN    +1]; //vOo[W
    char l_date    [LOG_DATE_LEN       +1]; //iN//)
    char l_time    [LOG_TIME_LEN       +1]; // (:)
    char l_msg     [LOG_MSG_LEN        +1]; //bZ[W

    std::string s;

    sprintf(testername, "%s", process_name);
    sprintf(state,      "%s", test_result);
    sprintf(version,    "%s", program_version);
    sprintf(l_date,     "%s", date);
    sprintf(l_time,     "%s", time);
    sprintf(l_msg,      "%s", msg);

    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);

    // `Jnʒu
    m_UpperWindow.Gotoxy(0, row);

    // Is̊ȈՕ\
    if ( (m_vc.selectedLine + 2) == row )
    {
        m_UpperWindow.Printf("*");
    }
    else
    {
        m_UpperWindow.Printf(" ");
    }

    m_UpperWindow.Printf("%-10s",testername);

    // ʂ̐F\
    s = state;
    if ("OK" == s)
    {
        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_GREEN);
    }
    else if ("START" == s)
    {
        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
    }
    else if (("SIGN" == s) || ("CALIBRATOR" == s))
    {
        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_BLUE);
    }
    else if (("USRAPP" == s) || ("USRAPP2" == s))
    {
        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_YELLOW);
    }
    else
    {
        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_RED);
    }
    m_UpperWindow.Printf("  %-10s ",state);

    // vOo[WArhAbZ[WL/̕\
    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
    s = testername;
    if (s.size() >= 1)
    {
        s = l_msg;
        if ( s.size() <= 1)
        {
            m_UpperWindow.Printf("%c%-5s %-10s %5s   \n",modeStr[testmode],version,l_date,l_time); //bZ[WȂ
        }
        else
        {
            m_UpperWindow.Printf("%c%-5s %-10s %5s  M\n",modeStr[testmode],version,l_date,l_time);//bZ[W
        }
    }
    else
    {
            m_UpperWindow.Printf("  %-5s %-10s %5s   \n",version,l_date,l_time); //sŏ㏑iOy[W̕\NAj
    }

    // `s̃JEg
    m_vc.drawLines++;
}

/*---------------------------------------------------------------------------
OXg`
---------------------------------------------------------------------------*/
int LogViewer::DrawLogList(int start_index)
{
    int entryNum = 0;
    entryNum = m_ProductionLog.Get_LogEntryNums();
    int currEntry = 0;
    currEntry = (m_vc.selectedLine+1) + m_vc.currentPage * m_DISPLAY_LINE_MAX;

    //Ŝ16s`\(Awb_2s)
    // wb_
    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
    m_UpperWindow.Gotoxy(0, 0);
    m_UpperWindow.Printf( " Name        State      Ver    Date       Time   %03d/%03d\n",currEntry,entryNum);
    m_UpperWindow.Gotoxy(0, 1);
    m_UpperWindow.Printf( "-------------------------------------------------------\n");

    // O`(NA)
    int row = 2;
    for (int preDrawLines = 1; preDrawLines <= m_DISPLAY_LINE_MAX;  preDrawLines++)
    {
        DrawLog(row,"", "", 9, "", "","",""); // testerNamẽTCY0ɂĂƁAs`
        row++;
    }

    // {`
    LogEntry le;
    int displayLogEntryNum=0;//`悵OGg̐
    int i = start_index; //i=0͌߂
    row = 2;
    for (int drawLines = 1; drawLines <= m_DISPLAY_LINE_MAX; i++, drawLines++)
    {
        le = m_ProductionLog.Get_LogEntry(i);
        if (le.used != le.ENTRY_UNUSED) { displayLogEntryNum++; }//`悵LogEntry𐔂
        DrawLog(row,le.testerName, le.state, le.testmode,le.version, le.date,le.time,le.message);
        row++;

        if ( (drawLines + start_index) >= m_ProductionLog.Get_LogEntryNumsMax() ) break;
    }

    // `łGgȂꍇ́Awb_ĕ`B
    if (0 == displayLogEntryNum )
    {
        m_UpperWindow.Gotoxy(0, 0);
        m_UpperWindow.Printf( " Name        State      Ver   Date       Time -/-\n");
    }

    return displayLogEntryNum;
}

/*---------------------------------------------------------------------------
G[bZ[W`
---------------------------------------------------------------------------*/
void LogViewer::DrawErrorMessage(sys::GraphicsDrawing* gfx,LogResult lr)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay0();

    LogResultCode lrc;

    if ( lr < 0 )
    {
        // G[̏ꍇ
        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_YELLOW);
        m_UpperWindow.Gotoxy(0, 0);
        m_UpperWindow.Printf( "-------------------------------------------------------\n");
        m_UpperWindow.Gotoxy(0, 1);
        m_UpperWindow.Printf( "   Error occurred (%s)!\n",lrc.ToString(lr).c_str());
        m_UpperWindow.Gotoxy(0, 2);
        m_UpperWindow.Printf( "-------------------------------------------------------\n");
    }
    else
    {
        // G[ł͂Ȃꍇ(NO_LOG_ENTRYƂ)
        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
        m_UpperWindow.Gotoxy(0, 0);
        m_UpperWindow.Printf( "-------------------------------------------------------\n");
        m_UpperWindow.Gotoxy(0, 1);
        m_UpperWindow.Printf( "  %s \n",lrc.ToString(lr).c_str());
        m_UpperWindow.Gotoxy(0, 2);
        m_UpperWindow.Printf( "-------------------------------------------------------\n");
    }

    // t@CAnbṼ_v ( t@CJȂGet_Hash_ByFileƂ͎~܂\j
    if ( (lr == LogResultCode::HASH_MISMATCH ) ||
         (lr == LogResultCode::HASH_ALL_FF )   ||
         (lr == LogResultCode::NO_LOG_ENTRY))
    {

        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);

        m_UpperWindow.Printf( "fileSize:%lld\n\n",    m_ProductionLog.Get_FileSize());

        m_UpperWindow.Printf( "HashEntryValue :%s\n", (m_ProductionLog.Get_HashEntryValue()).c_str());
        m_UpperWindow.Printf( "FileHash       :%s\n", (m_ProductionLog.Get_FileHash()).c_str());
        m_UpperWindow.Printf( "DataHash       :%s\n", (m_ProductionLog.Get_DataHash()).c_str());
    }

    // t@CTCYߎ̏\
    if ( LogResultCode::FILESIZE_OVER == lr )
    {
        m_UpperWindow.Printf( " fileSize:[%lld]\n",m_ProductionLog.Get_FileSize());
    }

    gfx->m_DrawFramework->SwapBuffers();
}


/*---------------------------------------------------------------------------
 G[bZ[W\
---------------------------------------------------------------------------*/
void LogViewer::RunErrorMessage(sys::GraphicsDrawing* gfx,LogResult lr)
{
    DEBUG_WRITE("LogViewer::DrawErrorMessage  logfile read error(%d).\n",lr);

    do
    {
        // pbh͏
        sys::Pad().UpdatePad();

        // EChE
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV

        // LCDɃG[bZ[W`
        DrawErrorMessage(gfx,lr);

        // pbh͂̓ǂݎ
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
        {
            CursorUp();
        }
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
        {
            CursorDown();
        }
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
        {
            CursorLeft();
        }
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
        {
            CursorRight();
        }
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X))
        {
            m_ProductionLog.ExportSD_MacAddress();
        }

        //nbVl
        m_vc.hashValue = m_ProductionLog.Get_DataHash();

        // EBhEւ̏`B
        m_LowerWindow.SetViewerControl(&m_vc);

        // ViewerControlNA
        m_vc.drawLines = 0;

        // Vsync҂
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        // restore gl state RenderSystem̕`s̍ۂ͕K߂
        for (int attrindex = 0; attrindex < 12; attrindex++)
            glDisableVertexAttribArray(attrindex);

    } while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));

    // EChEj
    m_WindowManager.DestroyWindow(&m_UpperWindow);
    m_WindowManager.DestroyWindow(&m_LowerWindow);
}

/*---------------------------------------------------------------------------
 ʕ`揈
---------------------------------------------------------------------------*/
int LogViewer::DrawUpperLCD(sys::GraphicsDrawing* gfx, int display_log_entry_num)
{
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();
        m_WindowManager.DrawDisplay0();

        display_log_entry_num = DrawLogList(m_vc.currentPage * m_DISPLAY_LINE_MAX);
        if ( 0 == display_log_entry_num )
        {
            m_UpperWindow.SetTextColor(sys::ATTR_COLOR_YELLOW);
            m_UpperWindow.Gotoxy(0, 2);
            m_UpperWindow.Printf(" LogEntry is Not Found.\n");
        }

        // `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);

        // DrawFrameworkExgpAIsnCCg(`j
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        gfx->m_DrawFramework->SetColor(0.5f, 0.5f, 1.0f, 0.5f);
        gfx->m_DrawFramework->SetPointSize( 2.0f);
        gfx->m_DrawFramework->DrawLine(6.0f, static_cast<f32>((m_vc.selectedLine+4) * m_FONT_SIZE -1),
                                     390.0f, static_cast<f32>((m_vc.selectedLine+4) * m_FONT_SIZE -1));

        gfx->m_DrawFramework->SwapBuffers();

        return display_log_entry_num;
}

/*---------------------------------------------------------------------------
 ʕ`揈
---------------------------------------------------------------------------*/
void LogViewer::DrawLowerLCD(sys::GraphicsDrawing* gfx)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay1();

    // `̑O
    gfx->BeginDrawingString();
    gfx->SetFixedWidthFont(14);          //tHgTCY̐ݒ
    gfx->m_TextWriter.SetCursor(3, 17);  //\JnXN[Ww

    //ID
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
    (void)gfx->m_TextWriter.Printf("--TesterId--\n");
    (void)gfx->m_TextWriter.Printf("%s\n", m_vc.testerId.c_str());

    // bZ[W
    (void)gfx->m_TextWriter.Printf("--Message--\n");
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::YELLOW);

    // $  \nɒu
    string findStr    = "$"; //uΏە
    string replaceStr = "\n";
    string::size_type pos;
    string displayStr = m_vc.message;
    pos = displayStr.find(findStr);
    for( ; pos != string::npos ; pos = displayStr.find(findStr, replaceStr.length() + pos))
    {
          displayStr.replace(pos, findStr.length(), replaceStr);
    }

    if ( displayStr.length() > 0 )
    {
       (void)gfx->m_TextWriter.Printf("%s\n",displayStr.c_str());
    }
    else
    {
        (void)gfx->m_TextWriter.Printf("\n");
    }

    // Ot@CXe[^X
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
    (void)gfx->m_TextWriter.Printf("--FileInfo--\n");
    (void)gfx->m_TextWriter.Printf("FileStatus(%d)\n",0);
    (void)gfx->m_TextWriter.Printf("Hash:%s\n", m_vc.hashValue.c_str());
    (void)gfx->m_TextWriter.Printf("Entry:%d\n",m_ProductionLog.Get_LogEntryNums());

    // A{^Ə㉺L[́AOnUpdatePadŃI[o[ChłB
    // L/ŔAEChE}l[W̏łB
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE); // Fݒ
    (void)gfx->m_TextWriter.Printf("--KeyBind--\n");
    (void)gfx->m_TextWriter.Printf(" up/down    :Change Line\n");
    (void)gfx->m_TextWriter.Printf(" left/right :Change Page\n");

    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
#ifdef LOGVIEWER_DEBUG
    //  fobO
    (void)gfx->m_TextWriter.Printf("--Debug--\n");
    (void)gfx->m_TextWriter.Printf("Page(%d) SelectedLine(%d)\n",    m_vc.currentPage,
                                                                     m_vc.selectedLine);
    (void)gfx->m_TextWriter.Printf("DrawLines(%d)\n", m_vc.drawLines);
#endif

    // FrameCount
    (void)gfx->m_TextWriter.Printf("\nFrameCount(%d)\n", m_vc.frameCount);

    gfx->EndDrawingString();

    //
    gfx->m_DrawFramework->SwapBuffers();
}


/*---------------------------------------------------------------------------
J[\
---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------
J[\ 
---------------------------------------------------------------------------*/
void LogViewer::CursorUp()
{
    DEBUG_WRITE(" LogViewer::Run [UP]\n");
    m_vc.selectedLine = m_vc.selectedLine - 1;
    if (m_vc.selectedLine < 0 ) m_vc.selectedLine = 0;
}

/*---------------------------------------------------------------------------
J[\ 
---------------------------------------------------------------------------*/
void LogViewer::CursorDown()
{
    DEBUG_WRITE(" LogViewer::Run [DOWN]\n");

    m_vc.selectedLine = m_vc.selectedLine + 1;

    if (m_vc.currentPage < (Calc_TotalPages() -1))
    {
        //ŏIy[WłȂ΁AMAXŝ݂ɒӂ
        if (m_vc.selectedLine > (m_DISPLAY_LINE_MAX-1) ) m_vc.selectedLine = (m_DISPLAY_LINE_MAX -1);
    }
    else
    {
        //ŏIy[W̏ꍇ
        int allowedDrawLines; //`拖C
        // LogTable̗LȃGg擾B-> 16
        // 1pagẽC14 Ȃ̂ŁAŌ̃y[W̃ĆA2
        allowedDrawLines = m_ProductionLog.Get_LogEntryNums() - m_DISPLAY_LINE_MAX * ( Calc_TotalPages() - 1) -1 ;
        if (m_vc.selectedLine > allowedDrawLines ) m_vc.selectedLine = allowedDrawLines;
    }
}

/*---------------------------------------------------------------------------
J[\ 
---------------------------------------------------------------------------*/
void LogViewer::CursorLeft()
{
    DEBUG_WRITE(" LogViewer::Run [LEFT]\n");
    m_vc.currentPage = m_vc.currentPage - 1;
    if (m_vc.currentPage <  0 ) m_vc.currentPage = 0;
}

/*---------------------------------------------------------------------------
J[\ E
---------------------------------------------------------------------------*/
void LogViewer::CursorRight()
{
    DEBUG_WRITE(" LogViewer::Run [RIGHT]\n");

    // y[W𑝂₷
    int totalpages = 0;
    totalpages = Calc_TotalPages();

    DEBUG_WRITE(" totalpages(%d) m_vc.currentPage(%d) ->(%d)\n",totalpages, m_vc.currentPage,m_vc.currentPage+1);
    m_vc.currentPage = m_vc.currentPage + 1;
    if ( m_vc.currentPage > (totalpages-1))
    {
        m_vc.currentPage = totalpages - 1;
        DEBUG_WRITE("modified m_vc.currentPage(%d)\n",m_vc.currentPage);
    }
    // EAŃJ[\̓gbvɎĂ
    m_vc.selectedLine=0;
}

/*---------------------------------------------------------------------------
 s
---------------------------------------------------------------------------*/
void LogViewer::Run()
{
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    LogResult lr;
    lr = m_ProductionLog.Initialize();
    if (( lr != LogResultCode::SUCCESS )  &&
        ( lr != LogResultCode::HASH_MISMATCH ))
    {
        RunErrorMessage(gfx,lr); //G[̏s
        m_ProductionLog.Finalize();
        return;
    }

    //ÕO̗vf擾B
    int i;
    i = m_ProductionLog.Get_LogEntryNums();
    NN_LOG("Get_LogEntryNums:(%d)\n",i);

    uji::sys::Point cursorPos;

    int displayLogEntryNum = 0;
    do
    {
        // pbh͏
        sys::Pad().UpdatePad();

        // EChE
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();        // XV

        //------------------------------------------
        // PAD̏
        //------------------------------------------

        // OGg̕`悪΁A\L[ł̈ړ\
        if ( 0 < displayLogEntryNum )
        {
            // pbh͂̓ǂݎ
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
            {
                CursorUp();
            }
            else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
            {
                CursorDown();
            }
            else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
            {
                CursorLeft();
            }
            else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
            {
                CursorRight();
            }
        }

        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X))
        {

        }
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_Y))
        {

        }
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_SELECT))
        {
            //ZNg{^͋@\ȂH
        }

        //------------------------------------------
        // LCD̕`
        //------------------------------------------
        displayLogEntryNum = DrawUpperLCD(gfx,displayLogEntryNum);

        //bZ[W
        LogEntry le;
        le = m_ProductionLog.Get_LogEntry(m_vc.selectedLine + m_vc.currentPage *m_DISPLAY_LINE_MAX);
        m_vc.message = le.message;

        //nbVl
        m_vc.hashValue = m_ProductionLog.Get_DataHash();

        //ID
        m_vc.testerId  = le.testerId;

        // EBhEւ̏`B
        m_LowerWindow.SetViewerControl(&m_vc);

        //----------------
        // ʕ`
        //----------------
        DrawLowerLCD(gfx);

        // Vsync҂
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        // ViewerControlNA
        m_vc.drawLines = 0;

    } while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));


    m_ProductionLog.Finalize();

    // EChEj
    m_WindowManager.DestroyWindow(&m_UpperWindow);
    m_WindowManager.DestroyWindow(&m_LowerWindow);
}

}   // usingnamespace seq
}   // usingnamespace uji
