/*--------------------------------------------------------------------------*
  Project:CTR-UJI
  File:   ProductionLogTestFunc.h

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

*--------------------------------------------------------------------------*/
#ifndef _PRODUCTION_LOG_TESTFUNC_H_
#define _PRODUCTION_LOG_TESTFUNC_H_

#include "ProductionLog.h"

#include <nn.h>
#include "sys.h"
#include "../TestResult.h"

#include <string>

namespace uji {
namespace seq {

void ProductionLogTestFunc_Menu();

namespace pl {

//==============================================================================
//
//  ProductionLogTestFunc : p֐
//
//==============================================================================
class ProductionLogTestFunc
{
private:
    static const int FONT_SIZE = 12;
    static const int SEND_SIZE = 32;

    uji::sys::WindowManager m_WindowManager;
    uji::sys::TextWindow    m_LowerWindow;
    uji::sys::GraphicsDrawing* gfx;

    void DrawDisplays( s32 display );

    ProductionLog      m_ProductionLog;    // O

public:
    ProductionLogTestFunc() :
       m_LowerWindow( 320/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE ),
       gfx( uji::sys::GraphicsDrawing::GetInstance())
    {}

    ~ProductionLogTestFunc(){}

    // j[
    static void Menu1 (void);
    static void Menu2 (void);
    static void Menu3 (void);
    static void Menu4 (void);
    static void Menu5 (void);
    static void Menu6 (void);
    static void Menu7 (void);
    static void Menu8 (void);
    static void Menu9 (void);
    static void Menu10 (void);
    static void Menu11 (void);
    static void Menu12 (void);
    static void Menu13 (void);

    // C^[tF[XAip
    static void __DummyDpram_WriteStartLog(void); //fobOp
    static void __DummyDpram_WriteOKLog(void);
    static void __SetDummyDataStart(void);
    static void __SetDummyDataOK(void);

    static bool Invoke_WriteStartLog(uji::seq::TestResult &result);
    static bool Invoke_WriteOKLog   (uji::seq::TestResult &result);
    static bool Invoke_WriteEMSLabelLog(uji::seq::TestResult &result);

    // ]p֐
    void SpecialMountTest(const std::wstring & file_path); //}Egƃt@Ce̊ȈՃ`FbN
    void Fill_0xFF(const std::wstring & file_path);        //0xFF߂̃t@C쐬
    void Fill_0x05(const std::wstring & file_path);        //0x05߂̃t@C쐬

    // XgXeXg
    bool StressTest1(int type); //type==0 1MB, type==14MB

    // API`FbN
    bool ApiCheck(void);

    // C^[i`FbN
    void InternalCheck(void);

    /// ]֐
    void __Dump_ObjectAddress(void);


};//class ProductionLogTestFunc

} //namespace pl
} //namespace seq
} //namespace uji

#endif // _PRODUCTION_LOG_TESTFUNC_H_
/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
