/*--------------------------------------------------------------------------*
  Project:CTR-UJI
  File:   ProductionLogTestFunc.cpp

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

*--------------------------------------------------------------------------*/
#include "ProductionLogTestFunc.h"

#include <nn.h>
#include <nn/fs.h>
#include <nn/srv.h>
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>  // EVA_SDK_0_14_1
#include "../seq/Reception_board_interface.h"
#include "sys.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji{
namespace seq{

using namespace uji::seq;


#define LOG_FILESIZE 16384

//RgAEgƁADPRAMɃ_~[f[^쐬B
//#define DPRAM_FAKE

    static u8 dummyDataStart[24];
    static u8 dummyDataOK   [32];

// OeXg֐pj[
void ProductionLogTestFunc_Menu()
{
    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "ProductionLog FS Menu" );

    m->Add("Mount Master File     ", pl::ProductionLogTestFunc::Menu1);
    m->Add("Mount Sub File        ", pl::ProductionLogTestFunc::Menu2);
    m->Add("----------------------", NULL);
    m->Add("Delete Master File    ", pl::ProductionLogTestFunc::Menu3);
    m->Add("Delete Sub File       ", pl::ProductionLogTestFunc::Menu4);
    m->Add("----------------------", NULL);
    m->Add("Fill 0xFF Master File ", pl::ProductionLogTestFunc::Menu5);
    m->Add("Fill 0xFF Sub File    ", pl::ProductionLogTestFunc::Menu7);
#ifdef FILL_DETAIL
    m->Add("Fill 0x05 Master File ", pl::ProductionLogTestFunc::Menu6);
    m->Add("Fill 0x05 Sub File    ", pl::ProductionLogTestFunc::Menu8);
#endif
    m->Add("----------------------", NULL);
    m->Add("StressTest Alloc 1MB  ", pl::ProductionLogTestFunc::Menu11);
    m->Add("StressTest Alloc 4MB  ", pl::ProductionLogTestFunc::Menu12);

#ifdef API_CHECK
    m->Add("API Check",              pl::ProductionLogTestFunc::Menu13);
#endif

#ifdef MANUAL_FAKE
    m->Add("----------------------", NULL);
    m->Add("Invoke WriteStartLog  ", pl::ProductionLogTestFunc::Menu9);
    m->Add("Invoke WriteOKLog     ", pl::ProductionLogTestFunc::Menu10);
#endif

    m->Open();
    delete m;
}

namespace pl
{

void ProductionLogTestFunc::Menu1(void)
{
    uji::seq::pl::ProductionLogTestFunc * pltf = new ProductionLogTestFunc();
    uji::seq::TestResult  tr;
// zantei
//    pltf->SpecialMountTest(PATH_NAND_MASTER);
    delete pltf;
}

void ProductionLogTestFunc::Menu2(void)
{
    uji::seq::pl::ProductionLogTestFunc * pltf = new ProductionLogTestFunc();
    uji::seq::TestResult  tr;

// zantei
//    pltf->SpecialMountTest(PATH_NAND_SUB);
    delete pltf;
}

void ProductionLogTestFunc::Menu3(void)
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->primaryInit();
        pl->DeleteFile_Master("");
    pl->Finalize();
    delete pl;
}

void ProductionLogTestFunc::Menu4(void)
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->primaryInit();
        pl->DeleteFile_Sub("");
    pl->Finalize();
    delete pl;
}

void ProductionLogTestFunc::Menu5(void)
{
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();
    delete pltf;
}

void ProductionLogTestFunc::Menu6(void)
{
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();
    delete pltf;
}

void ProductionLogTestFunc::Menu7(void)
{
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();

// zantei
//    pltf->Fill_0xFF(PATH_NAND_SUB);
    delete pltf;
}

void ProductionLogTestFunc::Menu8(void)
{
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();

// zantei
//    pltf->Fill_0x05(PATH_NAND_SUB);
    delete pltf;
}

void ProductionLogTestFunc::Menu9(void)
{
    uji::seq::TestResult result;
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();
    pltf->Invoke_WriteStartLog(result);
    delete pltf;
}

void ProductionLogTestFunc::Menu10(void)
{
    uji::seq::TestResult result;
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();
    pltf->Invoke_WriteOKLog(result);
    delete pltf;
}

void ProductionLogTestFunc::Menu11(void)
{
    uji::seq::TestResult result;
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();
    pltf->StressTest1(0);//1MB
    delete pltf;
}

void ProductionLogTestFunc::Menu12(void)
{
    uji::seq::TestResult result;
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();
    pltf->StressTest1(1);//4MB
    delete pltf;
}

void ProductionLogTestFunc::Menu13(void)
{
    uji::seq::TestResult result;
    uji::seq::ProductionLogTestFunc * pltf = new uji::seq::ProductionLogTestFunc();
    pltf->ApiCheck();
    delete pltf;
}



//
// AC^[tF[Xp
//
void ProductionLogTestFunc::__DummyDpram_WriteStartLog(void)
{
    u8 commData[24];
    std::memset(commData, 0x00, sizeof(commData));
    u8 * ptr = commData;

    // "01"
    commData[0] = 0x30;
    commData[1] = 0x31;

    // "00"
    commData[2] = 0x30;
    commData[3] = 0x30;

    // "2010"
    commData[4] = 0x32;
    commData[5] = 0x30;
    commData[6] = 0x31;
    commData[7] = 0x30;

    // "10"/"01"
    commData[8]  = 0x31;
    commData[9]  = 0x30;
    commData[10] = 0x30;
    commData[11] = 0x31;
    // "23" "59"
    commData[12] = 0x32;
    commData[13] = 0x33;
    commData[14] = 0x35;
    commData[15] = 0x39;

    // "000001"
    commData[18] = 0x30;
    commData[19] = 0x30;
    commData[20] = 0x30;
    commData[21] = 0x30;
    commData[22] = 0x30;
    commData[23] = 0x31;

    g_CommC2T->WriteDpramBinary( ptr, sizeof(commData)); //24oCg
}

void ProductionLogTestFunc::__SetDummyDataStart(void)
{
    std::memset(dummyDataStart, 0x00, sizeof(dummyDataStart));

    // "01"
    dummyDataStart[0] = 0x30;
    dummyDataStart[1] = 0x31;

    // "00"
    dummyDataStart[2] = 0x30;
    dummyDataStart[3] = 0x30;

    // "2010"
    dummyDataStart[4] = 0x32;
    dummyDataStart[5] = 0x30;
    dummyDataStart[6] = 0x31;
    dummyDataStart[7] = 0x30;

    // "10"/"01"
    dummyDataStart[8]  = 0x31;
    dummyDataStart[9]  = 0x30;
    dummyDataStart[10] = 0x30;
    dummyDataStart[11] = 0x31;
    // "23" "59"
    dummyDataStart[12] = 0x32;
    dummyDataStart[13] = 0x33;
    dummyDataStart[14] = 0x35;
    dummyDataStart[15] = 0x39;

    // "000001"
    dummyDataStart[18] = 0x30;
    dummyDataStart[19] = 0x30;
    dummyDataStart[20] = 0x30;
    dummyDataStart[21] = 0x30;
    dummyDataStart[22] = 0x30;
    dummyDataStart[23] = 0x31;
}

bool ProductionLogTestFunc::Invoke_WriteStartLog(uji::seq::TestResult &result)
{
    result.m_Result = false;
    u8 commData[24];
    u8 * ptr = commData;
    u8 commTextData[LOG_MSG_LEN+1];
    u8 * ptrText = commTextData;

    LogResult lr;
    LogResultCode lrc;

    lr = LogResultCode::SUCCESS;

    std::memset(commData, 0x00, sizeof(commData));
    std::memset(commTextData, 0x00, sizeof(commTextData));

#ifdef DPRAM_FAKE
    __DummyDpram_WriteStartLog();
#endif

#ifdef MANUAL_FAKE
    __SetDummyDataStart();
    std::memcpy(commData, dummyDataStart, 24);
#else
    g_CommC2T->ReadDpramBinary( ptr, sizeof(commData)); //oCï24oCgǂ
#endif

    g_CommC2T->ReadDpram(ptrText, LOG_MSG_LEN);         //eLXg̈80oCgǂ


    char testerKind[2+1]; //"01"C^[tF[XA"00"
    char testMode  [2+1]; //[h
    int  iTestMode      ;
    char date      [LOG_DATE_LEN+1];
    char time      [LOG_TIME_LEN+1];
    char testerId  [LOG_TESTERID_LEN+1];
    char message   [LOG_MSG_LEN+1];

    std::memset( testerKind, 0x00, sizeof(testerKind));
    std::memset( testMode,   0x00, sizeof(testMode));
    std::memset( date,       0x00, sizeof(date));
    std::memset( time,       0x00, sizeof(time));
    std::memset( testerId,   0x00, sizeof(testerId));
    std::memset( message,    0x00, sizeof(message));

    //
    std::memcpy(testerKind, ptr, 2);

    //testmode
    std::memcpy(testMode,   ptr+2, 2);
    if ( testMode[1] >= 0x30 )
    {
        iTestMode = testMode[1] - 0x30;
    }
    else
    {
        iTestMode = 0;
    }

    //date
    std::memcpy(date,       ptr+4, 4);
    date[4] = '/';
    std::memcpy(&date[5],   ptr+8, 2);
    date[7] = '/';
    std::memcpy(&date[8],   ptr+10, 2);

    //time
    std::memcpy(time,       ptr+12, 2);
    time[2] = ':';
    std::memcpy(&time[3],    ptr+14, 2);

    //testerId
    std::memcpy(testerId,   ptr+18, 6);

// 2011/2/18 ƌNƑǩʁAmessage͎gpȂ߁ACTŘOݎɏȂƂ
#if 0
    //message;
    std::memcpy(message, ptrText, LOG_MSG_LEN);

    // message product.log֑ΏCB
    int i;
    for(i = 0; i < LOG_MSG_LEN ;i++)
    {
        if ( 0x0A == message[i] ) { message[i] = 0x24 ; } // s$ɒu
        if ( 0x2C == message[i] ) { message[i] = 0x20 ; } // , 󔒂ɒu
    }
#endif

    //emF
    NN_LOG("testerKind[%s]\n", testerKind);
    NN_LOG("testMode[%s]  \n", testMode);
    NN_LOG("date[%s]      \n", date);
    NN_LOG("time[%s]      \n", time);
    NN_LOG("testerId[%s]  \n", testerId);
    NN_LOG("message[%s]   \n", message);

    //CpuBoarďOk(_TvΉ)
#ifdef EVA_BOARD
    {
        ProductionLog * pl = new ProductionLog;
        pl->Initialize();
        pl->LogTable_Extract_CpuBoard();
        pl->Finalize();
        delete pl;
    }
#endif

    //OLڂB
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    if (0x30 == testerKind[1] )
    {
        lr = pl->Add_1Line(iTestMode, "CpuBoard",  "START", VERSION_STRING, date, time, testerId, message);
    }
    else if (0x31 == testerKind[1] )
    {
        lr = pl->Add_1Line(iTestMode, "Interface", "START", VERSION_STRING, date, time, testerId, message);
    }

    // ݌ʂ̔
    if ( lr  == LogResultCode::SUCCESS )
    {
        result.m_Result = true;
    }
    else
    {
        sprintf(result.m_String, "%s", lrc.ToString(lr).c_str());
    };

    pl->Finalize();
    delete pl;

    return result.m_Result;
}


void ProductionLogTestFunc::__DummyDpram_WriteOKLog(void)
{
    u8 commData[32];
    std::memset(commData, 0x00, sizeof(commData));
    u8 * ptr = commData;

    // "01"
    commData[0] = 0x30;
    commData[1] = 0x31;

    // "00"
    commData[2] = 0x30;
    commData[3] = 0x30;

    // "2010"
    commData[4] = 0x32;
    commData[5] = 0x30;
    commData[6] = 0x31;
    commData[7] = 0x30;

    // "10"/"02"
    commData[8]  = 0x31;
    commData[9]  = 0x30;
    commData[10] = 0x30;
    commData[11] = 0x32;
    // "01" "02"
    commData[12] = 0x30;
    commData[13] = 0x31;
    commData[14] = 0x30;
    commData[15] = 0x32;

    // "000001"
    commData[18] = 0x30;
    commData[19] = 0x30;
    commData[20] = 0x30;
    commData[21] = 0x30;
    commData[22] = 0x30;
    commData[23] = 0x31;

    // "01" PASS
    commData[24] = 0x30;
    commData[25] = 0x31;

    // "31" "02" "50"
    commData[26] = 0x33;
    commData[27] = 0x31;
    commData[28] = 0x30;
    commData[29] = 0x32;
    commData[30] = 0x35;
    commData[31] = 0x30;

    g_CommC2T->WriteDpramBinary( ptr, sizeof(commData)); //32oCg
}

void ProductionLogTestFunc::__SetDummyDataOK(void)
{
    std::memset(dummyDataOK, 0x00, sizeof(dummyDataOK));

    // "00" 
    dummyDataOK[0] = 0x30;
    dummyDataOK[1] = 0x30;

    // "00"
    dummyDataOK[2] = 0x30;
    dummyDataOK[3] = 0x30;

    // "2010"
    dummyDataOK[4] = 0x32;
    dummyDataOK[5] = 0x30;
    dummyDataOK[6] = 0x31;
    dummyDataOK[7] = 0x30;

    // "10"/"02"
    dummyDataOK[8]  = 0x31;
    dummyDataOK[9]  = 0x30;
    dummyDataOK[10] = 0x30;
    dummyDataOK[11] = 0x32;
    // "01" "02"
    dummyDataOK[12] = 0x30;
    dummyDataOK[13] = 0x31;
    dummyDataOK[14] = 0x30;
    dummyDataOK[15] = 0x32;

    // "000001"
    dummyDataOK[18] = 0x30;
    dummyDataOK[19] = 0x30;
    dummyDataOK[20] = 0x30;
    dummyDataOK[21] = 0x30;
    dummyDataOK[22] = 0x30;
    dummyDataOK[23] = 0x31;

    // "00"  FAIL
    dummyDataOK[24] = 0x30;
    dummyDataOK[25] = 0x30;

    // "31" "02" "50"
    dummyDataOK[26] = 0x33;
    dummyDataOK[27] = 0x31;
    dummyDataOK[28] = 0x30;
    dummyDataOK[29] = 0x32;
    dummyDataOK[30] = 0x35;
    dummyDataOK[31] = 0x30;

}

//
// AC^[tF[Xp
//
bool ProductionLogTestFunc::Invoke_WriteOKLog(uji::seq::TestResult &result)
{
    result.m_Result = false;
    u8 commData[32];
    u8 * ptr = commData;
    u8 commTextData[LOG_MSG_LEN+1];
    u8 * ptrText = commTextData;

    LogResult lr;
    LogResultCode lrc;

    std::memset(commData, 0x00, sizeof(commData));
    std::memset(commTextData, 0x00, sizeof(commTextData));

#ifdef DPRAM_FAKE
    __DummyDpram_WriteOKLog();
#endif

#ifdef MANUAL_FAKE
    __SetDummyDataOK();
    std::memcpy(commData, dummyDataOK, 32);
#else
    g_CommC2T->ReadDpramBinary( ptr, sizeof(commData)); //oCï32oCgǂ
#endif

    g_CommC2T->ReadDpram(ptrText, LOG_MSG_LEN);         //eLXg̈80oCgǂ


    char testerKind[2+1]; //"01"C^[tF[XA"00"
    char testMode  [2+1]; //[h
    int  iTestMode      ;
    char date      [LOG_DATE_LEN+1];
    char time      [LOG_TIME_LEN+1];
    char testerId  [LOG_TESTERID_LEN+1];
    char cResult   [2+1];
    char majorCode [2+1];
    char minorCode [3+1];
    char message   [LOG_MSG_LEN+1];

    std::memset( testerKind, 0x00, sizeof(testerKind));
    std::memset( testMode,   0x00, sizeof(testMode));
    std::memset( date,       0x00, sizeof(date));
    std::memset( time,       0x00, sizeof(time));
    std::memset( testerId,   0x00, sizeof(testerId));
    std::memset( cResult,    0x00, sizeof(cResult));
    std::memset( majorCode,  0x00, sizeof(majorCode));
    std::memset( minorCode,  0x00, sizeof(minorCode));
    std::memset( message,    0x00, sizeof(message));

    //
    std::memcpy(testerKind, ptr, 2);

    //testmode
    std::memcpy(testMode,   ptr+2, 2);
    if ( testMode[1] >= 0x30 )
    {
        iTestMode = testMode[1] - 0x30;
    }
    else
    {
        iTestMode = 0;
    }

    //date
    std::memcpy(date,       ptr+4, 4);
    date[4] = '/';
    std::memcpy(&date[5],   ptr+8, 2);
    date[7] = '/';
    std::memcpy(&date[8],   ptr+10, 2);

    //time
    std::memcpy(time,       ptr+12, 2);
    time[2] = ':';
    std::memcpy(&time[3],   ptr+14, 2);

    //testerId
    std::memcpy(testerId,   ptr+18, 6);

    //result
    std::memcpy(cResult,    ptr+24, 2);

    //majorCode
    std::memcpy(majorCode,  ptr+26, 2);

    //minorCode
    std::memcpy(minorCode,  ptr+29, 3);

// 2011/2/18 ƌNƑǩʁAmessage͎gpȂ߁ACTŘOݎɏȂƂ
#if 0
    //message;
    std::memcpy(message, ptrText, LOG_MSG_LEN);

    // message product.log֑ΏCB
    int i;
    for(i = 0; i < LOG_MSG_LEN ;i++)
    {
        if ( 0x0A == message[i] ) { message[i] = 0x24 ; } // s$ɒu
        if ( 0x2C == message[i] ) { message[i] = 0x20 ; } // , 󔒂ɒu
    }
#endif

    //emF
    NN_LOG("testerKind[%s]\n", testerKind);
    NN_LOG("testMode[%s]  \n", testMode);
    NN_LOG("date[%s]      \n", date);
    NN_LOG("time[%s]      \n", time);
    NN_LOG("testerId[%s]  \n", testerId);
    NN_LOG("cResult[%s]   \n", cResult);
    NN_LOG("majorCode[%s] \n", majorCode);
    NN_LOG("minorCode[%s] \n", minorCode);
    NN_LOG("message[%s]   \n", message);

    //OLڂB
    lr = LogResultCode::UNKNOWN_ERROR;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    if (0x30 == testerKind[1] )
    {
        if ( 0x31 == cResult[1] )
        {
            lr = pl->Add_1Line(iTestMode, "CpuBoard",  "OK", VERSION_STRING, date, time, testerId, message);
        }
        else
        {
            char ngCode[5+1];
            std::memset(ngCode, 0x00, sizeof(ngCode));
            sprintf(ngCode, "%s-%s", majorCode, minorCode);
            lr = pl->Add_1Line(iTestMode, "CpuBoard",  ngCode, VERSION_STRING, date, time, testerId, message);
        }
    }
    else if (0x31 == testerKind[1] )
    {
        if ( 0x31 == cResult[1] )
        {
            lr = pl->Add_1Line(iTestMode, "Interface", "OK", VERSION_STRING, date, time, testerId, message);
        }
        else
        {
            char ngCode[5+1];
            std::memset(ngCode, 0x00, sizeof(ngCode));
            sprintf(ngCode, "%s-%s", majorCode, minorCode);
            lr = pl->Add_1Line(iTestMode, "Interface", ngCode, VERSION_STRING, date, time, testerId, message);
        }
    }

    // ݌ʂ̔
    if ( lr  == LogResultCode::SUCCESS )
    {
        result.m_Result = true;
    }
    else
    {
        sprintf(result.m_String, "%s", lrc.ToString(lr).c_str());
    }

    pl->Finalize();
    delete pl;

    return result.m_Result;
}

//
// ɂ EMS LabelOcp
//
bool ProductionLogTestFunc::Invoke_WriteEMSLabelLog(uji::seq::TestResult &result)
{
    result.m_Result = false;
    u8 commData[32];
    u8 * ptr = commData;
    u8 commTextData[LOG_MSG_LEN+1];
    u8 * ptrText = commTextData;

    LogResult lr;
    LogResultCode lrc;

    std::memset(commData, 0x00, sizeof(commData));
    std::memset(commTextData, 0x00, sizeof(commTextData));

    g_CommC2T->ReadDpramBinary( ptr, sizeof(commData)); //oCï32oCgǂ
    g_CommC2T->ReadDpram(ptrText, LOG_MSG_LEN);         //eLXg̈80oCgǂ

    char testerKind[2+1]; //"01"C^[tF[XA"00"
    char testMode  [2+1]; //[h
    int  iTestMode      ;
    char date      [LOG_DATE_LEN+1];
    char time      [LOG_TIME_LEN+1];
    char testerId  [LOG_TESTERID_LEN+1];
    char cResult   [2+1];
    char majorCode [2+1];
    char minorCode [3+1];
    char message   [LOG_MSG_LEN+1];

    std::memset( testerKind, 0x00, sizeof(testerKind));
    std::memset( testMode,   0x00, sizeof(testMode));
    std::memset( date,       0x00, sizeof(date));
    std::memset( time,       0x00, sizeof(time));
    std::memset( testerId,   0x00, sizeof(testerId));
    std::memset( cResult,    0x00, sizeof(cResult));
    std::memset( majorCode,  0x00, sizeof(majorCode));
    std::memset( minorCode,  0x00, sizeof(minorCode));
    std::memset( message,    0x00, sizeof(message));

    //
    std::memcpy(testerKind, ptr, 2);

    //testmode
    std::memcpy(testMode,   ptr+2, 2);
    if ( testMode[1] >= 0x30 )
    {
        iTestMode = testMode[1] - 0x30;
    }
    else
    {
        iTestMode = 0;
    }

    //date
    std::memcpy(date,       ptr+4, 4);
    date[4] = '/';
    std::memcpy(&date[5],   ptr+8, 2);
    date[7] = '/';
    std::memcpy(&date[8],   ptr+10, 2);

    //time
    std::memcpy(time,       ptr+12, 2);
    time[2] = ':';
    std::memcpy(&time[3],   ptr+14, 2);

    //testerId
    std::memcpy(testerId,   ptr+18, 6);

    //result
    std::memcpy(cResult,    ptr+24, 2);

    //majorCode
    std::memcpy(majorCode,  ptr+26, 2);

    //minorCode
    std::memcpy(minorCode,  ptr+29, 3);

// message EMSxlc

    //message;
    std::memcpy(message, ptrText, LOG_MSG_LEN);

    // message product.log֑ΏCB
    int i;
    for(i = 0; i < LOG_MSG_LEN ;i++)
    {
        if ( 0x0A == message[i] ) { message[i] = 0x24 ; } // s$ɒu
        if ( 0x2C == message[i] ) { message[i] = 0x20 ; } // , 󔒂ɒu
    }

    //emF
    NN_LOG("testerKind[%s]\n", testerKind);
    NN_LOG("testMode[%s]  \n", testMode);
    NN_LOG("date[%s]      \n", date);
    NN_LOG("time[%s]      \n", time);
    NN_LOG("testerId[%s]  \n", testerId);
    NN_LOG("cResult[%s]   \n", cResult);
    NN_LOG("majorCode[%s] \n", majorCode);
    NN_LOG("minorCode[%s] \n", minorCode);
    NN_LOG("message[%s]   \n", message);

    //OLڂB
    lr = LogResultCode::UNKNOWN_ERROR;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    lr = pl->Add_1Line( iTestMode, "EMSLabel", "OK", UJI_APPVER, date, time, testerId, message );

    // ݌ʂ̔
    if ( lr  == LogResultCode::SUCCESS )
    {
        result.m_Result = true;
    }
    else
    {
        sprintf(result.m_String, "%s", lrc.ToString(lr).c_str());
    }

    pl->Finalize();
    delete pl;

    return result.m_Result;
}

//
// XyV}Eg̃eXg
//
void ProductionLogTestFunc::SpecialMountTest(const std::wstring & file_path)
{
    nn::Result  nnr;
    uji::sys::TextWindow tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    nn::fs::Directory dir;
    bool mountDone = false;

    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    tw.Printf("twln: Archive Mount Test\n");
    DrawDisplays( NN_GX_DISPLAY0 );
    nn::Result result = nn::srv::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);
    tw.Printf("nn::srv::Initialize() done.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

    nn::fs::InitializeForLoader();
    tw.Printf("nn::fs::InitializeForLoader() done.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));

    nnr = nn::fs::MountSpecialArchive("twln:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND);
    if (nnr.IsFailure())
    {
        tw.Printf("MountSpecialArchive failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));
        goto FIN;
    }
    mountDone = true;

    tw.Printf("MountSpecialArchive succeded.\n");
    DrawDisplays( NN_GX_DISPLAY0 );
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));

     // fBNgJƂ݂
    nnr = dir.TryInitialize(PATH_LOGDIR.c_str());
    if (nnr.IsFailure())
    {
         dir.Finalize();
         tw.Printf("directory(%ls) open failed.\n", PATH_LOGDIR.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nn::dbg::PrintResult(nnr);
         nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );

         //fBNgȂ̂ŁAfBNg쐬B
         tw.Printf(" try create new directory ...");
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = nn::fs::TryCreateDirectory(PATH_LOGDIR.c_str());
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            nn::dbg::PrintResult(nnr);
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(3000) );
            goto FIN;
         }
         tw.Printf("succeeded.\n");
         DrawDisplays( NN_GX_DISPLAY0 );
         nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );

         //t@CȂ̂ŁAt@C쐬B
         nn::fs::FileOutputStream fos;
         tw.Printf(" try create new file ...");
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = fos.TryInitialize(file_path.c_str(), true);
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            nn::dbg::PrintResult(nnr);
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );
            goto FIN;
         }
         tw.Printf("succeeded.\n");

         fos.Write(BLANK_DATA_HEADER.c_str(),40+2);//swb_
         fos.Finalize();//t@C
    }
    else
    {
         //fBNgĴŁAǂݎpɃt@CJ
         nn::fs::FileReader fr;
         tw.Printf(" TryInitialize [%ls] forRead ...",file_path.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = fr.TryInitialize(file_path.c_str());
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            nn::dbg::PrintResult(nnr);
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(3000) );
            goto FIN;
         }
         tw.Printf("succeeded.\n");
         DrawDisplays( NN_GX_DISPLAY0 );

         //t@CTCY擾
         tw.Printf("GetSize ");
         s64 fileSize = -1;
         fileSize = fr.GetSize();
         tw.Printf("fileSize=%lld\n",fileSize);
         DrawDisplays( NN_GX_DISPLAY0 );

         // m
#if 0
         void* buf = uji::sys::Alloc(fileSize);
         if ( NULL == buf)
         {
            tw.Printf("Alloc %d failed.\n",fileSize);
            DrawDisplays( NN_GX_DISPLAY0 );
            goto FIN;
         }
         tw.Printf("Allocate buf Addr:%p\n", buf);
#else
         char charBuf[80];
         void * buf = &charBuf[0];

         // buf
         memset(buf, 0x00, 80);
#endif
         // t@C|C^擪
         tw.Printf(" TrySeek [%ls] forRead ...",file_path.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = fr.TrySeek(0,nn::fs::POSITION_BASE_BEGIN);
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            goto FIN;
         }
         tw.Printf("succeeded.\n");
         DrawDisplays( NN_GX_DISPLAY0 );

         // mۂɃt@Cf[^[hB
         s32 readSize;
#if 0
         nnr = fr.TryRead(&readSize, buf, fileSize);
#else
         nnr = fr.TryRead(&readSize, buf, 80);
#endif
         if ( nnr.IsFailure())
         {
            tw.Printf(" Read [%ls] failed.\n", file_path.c_str());
            DrawDisplays( NN_GX_DISPLAY0 );
#if 0
            uji::sys::Free(buf); // 
#endif
            goto FIN;
         }

         tw.Printf("readSize:%dBytes\n", readSize);
         DrawDisplays( NN_GX_DISPLAY0 );

         char asciiBuf[8];
         bit8 byteBuf[8];
         memset(asciiBuf, 0x20, sizeof(asciiBuf));
         memset(byteBuf,  0x00, sizeof(byteBuf));


         tw.Printf(" 0  1  2  3   4  5  6  7  ASCII\n");
         DrawDisplays( NN_GX_DISPLAY0 );
         // 擪48oCg\
         char * ptr;
         ptr = reinterpret_cast<char *>(buf);
         for(int i =0; i < 80;i++, ptr++)
         {
            if ((0 != i) && (0 == (i%8)))
            {
                //ʕ\
                tw.Printf("%02X %02X %02X %02X  ", byteBuf[0],byteBuf[1],byteBuf[2],byteBuf[3]);
                tw.Printf("%02X %02X %02X %02X  ", byteBuf[4],byteBuf[5],byteBuf[6],byteBuf[7]);
                tw.Printf("%c%c%c%c %c%c%c%c",  asciiBuf[0],asciiBuf[1],asciiBuf[2],asciiBuf[3],asciiBuf[4],asciiBuf[5],asciiBuf[6],asciiBuf[7]);
                tw.Printf("\n");
                DrawDisplays( NN_GX_DISPLAY0 );
                memset(asciiBuf, 0x20, sizeof(asciiBuf));
                memset(byteBuf,  0x00, sizeof(byteBuf));
            }

            // oCgobt@[֊i[
            byteBuf [i%8] = static_cast<bit8 >(*ptr);

            // ASCIIobt@[֊i[
            if ( (*ptr >= 0x21) && ( *ptr <= 0x7e))
            {
                asciiBuf[i%8] = *ptr;
            }
         }

         tw.Printf("%02X %02X %02X %02X  ",  byteBuf[0],byteBuf[1],byteBuf[2],byteBuf[3]);
         tw.Printf("%02X %02X %02X %02X  ",  byteBuf[4],byteBuf[5],byteBuf[6],byteBuf[7]);
         tw.Printf("%c%c%c%c %c%c%c%c",  asciiBuf[0],asciiBuf[1],asciiBuf[2],asciiBuf[3],asciiBuf[4],asciiBuf[5],asciiBuf[6],asciiBuf[7]);
         tw.Printf("\n");
         DrawDisplays( NN_GX_DISPLAY0 );

#if 0
         uji::sys::Free(buf); // 
#else
         //
#endif
         tw.Printf("fr.Finalize called.\n");
         DrawDisplays( NN_GX_DISPLAY0 );

         fr.Finalize();//t@C
         tw.Printf("[%ls] closed.\n", file_path.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );

         dir.Finalize();//fBNgB
    }


FIN:
    // XyVA[JCũA}Eg
    if ( mountDone )
    {
        nnr = nn::fs::Unmount("twln:");
        if (nnr.IsFailure())
        {
                tw.Printf("Unmount failed.\n");
                nn::dbg::PrintResult(nnr);
                goto FIN;
        }
        tw.Printf("Unmount twln: succeeded.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
    }

    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(5000));

    m_WindowManager.DestroyWindow(&tw);

    tw.Destroy();

    return ;
}


// w̃pX̃t@C0xFFŖ߂Be̊mFMountTestŁB
void ProductionLogTestFunc::Fill_0xFF(const std::wstring & file_path)
{
    nn::Result  nnr;
    uji::sys::TextWindow tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    nn::fs::Directory dir;
    bool mountDone = false;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    nn::fs::FileOutputStream fos;
    void * buf;
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    tw.Printf("fill All 0xFF\n");
    DrawDisplays( NN_GX_DISPLAY0 );
    nn::Result result = nn::srv::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);
    tw.Printf("nn::srv::Initialize() done.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

    nn::fs::InitializeForLoader();
    tw.Printf("nn::fs::InitializeForLoader() done.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

    nnr = nn::fs::MountSpecialArchive("twln:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND);
    if (nnr.IsFailure())
    {
        tw.Printf("MountSpecialArchive failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));
        goto FIN;
    }
    mountDone = true;

    tw.Printf("MountSpecialArchive succeded.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

     // fBNgJƂ݂
    nnr = dir.TryInitialize(PATH_LOGDIR.c_str());
    if (nnr.IsFailure())
    {
         dir.Finalize();
         tw.Printf("directory(%ls) open failed.\n", PATH_LOGDIR.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nn::dbg::PrintResult(nnr);
         nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );

         //fBNgȂ̂ŁAfBNg쐬B
         tw.Printf(" try create new directory ...");
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = nn::fs::TryCreateDirectory(PATH_LOGDIR.c_str());
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            nn::dbg::PrintResult(nnr);
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(3000) );
            goto FIN;
         }
         tw.Printf("done.\n");
         DrawDisplays( NN_GX_DISPLAY0 );
    }

    //t@C΁At@CB
    pl->DeleteFile(file_path, "");

    //t@CȂ̂ŁAt@C쐬B
    tw.Printf(" try create new file ...");
    DrawDisplays( NN_GX_DISPLAY0 );
    nnr = fos.TryInitialize(file_path.c_str(), true);
    if (nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );
        goto FIN;
    }
    tw.Printf("succeeded.\n");

    // m
    buf = uji::sys::Alloc(LOG_FILESIZE);
    if ( NULL == buf)
    {
        tw.Printf("Alloc %d failed.\n",LOG_FILESIZE);
        DrawDisplays( NN_GX_DISPLAY0 );
        goto FIN;
    }
    tw.Printf("Allocate buf Addr:%p\n", buf);

        memset(buf, 0xFF, LOG_FILESIZE);

        fos.Write(buf,LOG_FILESIZE);
        fos.Finalize();//t@CB

    // 
    uji::sys::Free(buf);

    //fBNgB
    dir.Finalize();

FIN:
    // XyVA[JCũA}Eg
    if ( mountDone )
    {
        nnr = nn::fs::Unmount("twln:");
        if (nnr.IsFailure())
        {
                tw.Printf("Unmount failed.\n");
                nn::dbg::PrintResult(nnr);
                goto FIN;
        }
        tw.Printf("Unmount twln: succeeded.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
    }

    delete pl;
    m_WindowManager.DestroyWindow(&tw);
    tw.Destroy();
    return ;
}

// w̃pX̃t@C05Ŗ߂Be̊mFMountTestŁB
void ProductionLogTestFunc::Fill_0x05(const std::wstring & file_path)
{
    nn::Result  nnr;
    uji::sys::TextWindow tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    nn::fs::Directory dir;
    bool mountDone = false;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    nn::fs::FileOutputStream fos;
    void * buf;
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    tw.Printf("fill All 0xFF\n");
    DrawDisplays( NN_GX_DISPLAY0 );
    nn::Result result = nn::srv::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);
    tw.Printf("nn::srv::Initialize() done.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

    nn::fs::InitializeForLoader();
    tw.Printf("nn::fs::InitializeForLoader() done.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

    nnr = nn::fs::MountSpecialArchive("twln:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND);
    if (nnr.IsFailure())
    {
        tw.Printf("MountSpecialArchive failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));
        goto FIN;
    }
    mountDone = true;

    tw.Printf("MountSpecialArchive succeded.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

     // fBNgJƂ݂
    nnr = dir.TryInitialize(PATH_LOGDIR.c_str());
    if (nnr.IsFailure())
    {
         dir.Finalize();
         tw.Printf("directory(%ls) open failed.\n", PATH_LOGDIR.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nn::dbg::PrintResult(nnr);
         nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );

         //fBNgȂ̂ŁAfBNg쐬B
         tw.Printf(" try create new directory ...");
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = nn::fs::TryCreateDirectory(PATH_LOGDIR.c_str());
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            nn::dbg::PrintResult(nnr);
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(3000) );
            goto FIN;
         }
         tw.Printf("done.\n");
         DrawDisplays( NN_GX_DISPLAY0 );
    }

    //t@C΁At@CB
    pl->DeleteFile(file_path, "");

    //t@CȂ̂ŁAt@C쐬B
    tw.Printf(" try create new file ...");
    DrawDisplays( NN_GX_DISPLAY0 );
    nnr = fos.TryInitialize(file_path.c_str(), true);
    if (nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000) );
        goto FIN;
    }
    tw.Printf("succeeded.\n");

    // m
    buf = uji::sys::Alloc(LOG_FILESIZE);
    if ( NULL == buf)
    {
        tw.Printf("Alloc %d failed.\n",LOG_FILESIZE);
        DrawDisplays( NN_GX_DISPLAY0 );
        goto FIN;
    }
    tw.Printf("Allocate buf Addr:%p\n", buf);

        memset(buf, 0x05, LOG_FILESIZE);

        fos.Write(buf,LOG_FILESIZE);
        fos.Finalize();//t@CB

    // 
    uji::sys::Free(buf);

    //fBNgB
    dir.Finalize();

FIN:
    // XyVA[JCũA}Eg
    if ( mountDone )
    {
        nnr = nn::fs::Unmount("twln:");
        if (nnr.IsFailure())
        {
                tw.Printf("Unmount failed.\n");
                nn::dbg::PrintResult(nnr);
                goto FIN;
        }
        tw.Printf("Unmount twln: succeeded.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
    }

    delete pl;
    m_WindowManager.DestroyWindow(&tw);
    tw.Destroy();
    return ;
}

//  StressTest1
//
//  傫mۂŁAAO݁AIJԂB
//
bool ProductionLogTestFunc::StressTest1(int type)
{
    static const int TEST_ALLOCATE_SIZE_1MB = 1 * 1024 * 1024;  //1MB
    static const int TEST_ALLOCATE_SIZE_4MB = 4 * 1024 * 1024;  //4MB

    void * largeBuffer = NULL;
    int loopCount = 0;
    char message[LOG_MSG_LEN+1];
    uji::sys::Pad pad;
    LogResult lr;
    LogResultCode lrc;

    uji::sys::TextWindow tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    if ( 0 == type )
    {
        tw.Printf("== STRESS TEST 1MB ==\n");
    }
    else
    {
        tw.Printf("== STRESS TEST 4MB ==\n");
    }

    do
    {
        pad.UpdatePad();        //pbhXV

        //
        tw.Printf("loopCount %d\n",loopCount);

        // m
        tw.Printf("call uji::sys::Alloc ");
        DrawDisplays( NN_GX_DISPLAY0 );

        std::memset(message, 0x00, sizeof(message));
        if ( type == 0)
        {
            largeBuffer = uji::sys::Alloc(TEST_ALLOCATE_SIZE_1MB);
            //MessageMax(80)
            sprintf(message, "1MB Test loop=%08d 01234567890123456789$01234567890123456789012345678901234", loopCount);
        }
        else
        {
            largeBuffer = uji::sys::Alloc(TEST_ALLOCATE_SIZE_4MB);
            sprintf(message, "4MB Test loop=%d", loopCount);
        }


        if ( NULL == largeBuffer)
        {
            tw.Printf("error.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            return false;
        }
        tw.Printf("done.\n");
        DrawDisplays( NN_GX_DISPLAY0 );

        // OCȕ
        uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
        pl->Initialize();
        // ԂƉ񐔂
        lr = pl->Add_1Line(5,"Stress","START",  "9.99", "2010/4/8",  "23:59","012345",message);

        pl->Finalize();
        delete pl;

        // 
        tw.Printf("call uji::sys::Free ");
        DrawDisplays( NN_GX_DISPLAY0 );
        uji::sys::Free(largeBuffer);
        tw.Printf("done.\n");
        DrawDisplays( NN_GX_DISPLAY0 );

        // ݌ʂ𔻒肵ASUCCESSȊOƁAB
        if ( lr  == LogResultCode::SUCCESS )
        {
            loopCount = loopCount + 1;
        }
        else
        {
            tw.Printf("ERROR %s", lrc.ToString(lr).c_str());
            DrawDisplays( NN_GX_DISPLAY0 );
            break;
        };

    }
    while( !pad.IsButtonDown(uji::sys::Pad::BUTTON_B));

    // I
    m_WindowManager.DestroyWindow(&tw);
    tw.Destroy();

    return true;
}

//
//  API`FbN
//
bool ProductionLogTestFunc::ApiCheck(void)
{
    bool flag;
    uji::sys::TextWindow tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    uji::sys::Pad pad;

    // OCȕ
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    //֐`FbN
    flag = pl->LogTable_IsCpuBoard1st();

    pl->Finalize();
    delete pl;

    tw.Printf("LogTable_IsCpuBoard1st result(%d).\n", flag);
    DrawDisplays( NN_GX_DISPLAY0 );
    do
    {
        pad.UpdatePad();        //pbhXV
        DrawDisplays( NN_GX_DISPLAY0 );
    }
    while( !pad.IsButtonDown(uji::sys::Pad::BUTTON_B));

    m_WindowManager.DestroyWindow(&tw);
    tw.Destroy();

    return flag;
}


//
//  ʕ`
//
void ProductionLogTestFunc::DrawDisplays( s32 display )
{
    if( display == NN_GX_DISPLAY0 || display == NN_GX_DISPLAY_BOTH )
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        m_WindowManager.Update();
        m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
    }

    if( display == NN_GX_DISPLAY1 || display == NN_GX_DISPLAY_BOTH )
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        m_WindowManager.Update();
        m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();

    }
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
}

//
// `FbN֐
//
void ProductionLogTestFunc::InternalCheck(void)
{
    DEBUG_WRITE("%s called.\n",NN_FUNCTION);
#pragma diag_suppress 550
    // c̊mF
    {
        /// q[v
        uptr   heapAddr;
        heapAddr = nn::os::GetHeapAddress();
        DEBUG_WRITE(" heapAddr         ,0x%p.\n",heapAddr);
        size_t heapSize;
        heapSize = nn::os::GetHeapSize();
        DEBUG_WRITE(" heapSize         ,0x%zx Bytes.\n",heapSize);

        /// foCX
        uptr   deviceMemoryAddr;
        deviceMemoryAddr = nn::os::GetDeviceMemoryAddress();
        DEBUG_WRITE(" deviceMemoryAddr ,0x%p.\n",deviceMemoryAddr);
        size_t deviceMemorySize;
        deviceMemorySize = nn::os::GetDeviceMemorySize();
        DEBUG_WRITE(" deviceMemorySize ,0x%zx Bytes.\n",deviceMemorySize);

        /// AvP[VŎgpł郁TCY
        size_t appMemorySize;
        appMemorySize = nn::os::GetAppMemorySize();
        DEBUG_WRITE(" appMemorySize    ,%zd Bytes.\n",appMemorySize);

        /// vOɌ݊蓖ĂĂ郁̍v
        size_t usingMemorySize;
        usingMemorySize = nn::os::GetUsingMemorySize();
        DEBUG_WRITE(" usingMemorySize  ,%zd Bytes.\n",usingMemorySize);

        /// AvP[VŎgpł郁
        size_t usableMemory;
        usableMemory = nn::os::GetAppMemorySize() - nn::os::GetUsingMemorySize() ;
        DEBUG_WRITE(" usable memory     ,%zd Bytes.\n",usableMemory);
    }

    // IuWFNgAhXmF
    {
        __Dump_ObjectAddress();
    }

    // pXmF
    {
        DEBUG_WRITE("  PATH_MASTER:[%ls]\n",PATH_MASTER.c_str());
        DEBUG_WRITE("  PATH_SUB:   [%ls]\n",PATH_SUB.c_str());
    }

    // ̃`FbN
#if 0
    {
        LogResultCode lrc;
        lrc.dumpLogResultCodeString();
    }
#endif

#pragma diag_default 550
}

//
// IuWFNg̃AhXdump
//
#define OBJECTADDR_DUMP(name) DEBUG_WRITE(" %s,0x%p\n",#name,&name)
#define TEST_ALLOCATE_SIZE    256
void ProductionLogTestFunc::__Dump_ObjectAddress(void)
{
    // ̈mF
    DEBUG_WRITE("-- object address dump --\n");
    DEBUG_WRITE(" name, address\n");

// uji::seq::pl̊Oϐ
/// wstring
    DEBUG_WRITE("* wstring:\n");
    OBJECTADDR_DUMP(LOGDIR);
    OBJECTADDR_DUMP(LOGFILE_MASTER);
    OBJECTADDR_DUMP(LOGFILE_SUB);

    OBJECTADDR_DUMP(NAND_LOGDIR);
    OBJECTADDR_DUMP(PATH_NAND_MASTER);
    OBJECTADDR_DUMP(PATH_NAND_SUB);

    OBJECTADDR_DUMP(EXPORT_DIR);
    OBJECTADDR_DUMP(SD_EXPORT_DIR);

/// string
    DEBUG_WRITE("* string:\n");
    OBJECTADDR_DUMP(HASH_NO_DATA);
    OBJECTADDR_DUMP(BLANK_DATA_HEADER);

/// static const int
    DEBUG_WRITE("* static const int\n");
    OBJECTADDR_DUMP(LOG_FILESIZE);
    OBJECTADDR_DUMP(LOG_TESTERNAME_LEN);
    OBJECTADDR_DUMP(LOG_VERSION_LEN);
    OBJECTADDR_DUMP(LOG_STATE_LEN);
    OBJECTADDR_DUMP(LOG_DATE_LEN);
    OBJECTADDR_DUMP(LOG_TIME_LEN);
    OBJECTADDR_DUMP(LOG_TESTERID_LEN);
    OBJECTADDR_DUMP(LOG_MSG_LEN);
    OBJECTADDR_DUMP(SALVAGE_CPUBOARD_MAX);

// oϐ
    DEBUG_WRITE("* member variables \n");

//    OBJECTADDR_DUMP(LOG_COMMA_MAX);

    OBJECTADDR_DUMP(m_DataHash);
    OBJECTADDR_DUMP(m_FileHash);
    OBJECTADDR_DUMP(m_HashEntryValue);
    OBJECTADDR_DUMP(m_logTable);

// ֐
    DEBUG_WRITE("* function \n");
    OBJECTADDR_DUMP(ProductionLog::Initialize);
    OBJECTADDR_DUMP(ProductionLog::Add_1Line);
    OBJECTADDR_DUMP(ProductionLog::__Dump_ObjectAddress);
    OBJECTADDR_DUMP(ProductionLog::Finalize);

// ϐ
    DEBUG_WRITE("* auto variables \n");
    int i = 0;
    char c = 0x30;
    int  * iPtr = &i;
    char * cPtr = &c;

    uptr uPtr1;
    uptr uPtr2;
    uptr uPtr3;
    uptr uPtr4;

    OBJECTADDR_DUMP(i);
    OBJECTADDR_DUMP(c);
    OBJECTADDR_DUMP(iPtr);
    OBJECTADDR_DUMP(cPtr);
    OBJECTADDR_DUMP(uPtr1);
    OBJECTADDR_DUMP(uPtr2);
    OBJECTADDR_DUMP(uPtr3);
    OBJECTADDR_DUMP(uPtr4);

    {
        DEBUG_WRITE("* allocate test 1 \n");
//        uPtr1 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr1 value, 0x%p\n",uPtr1);
//        uPtr2 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr2 value, 0x%p\n",uPtr2);
//        uPtr3 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr3 value, 0x%p\n",uPtr3);
//        uPtr4 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr4 value, 0x%p\n",uPtr4);

        uji::sys::Free((void *) (uPtr4));
        uji::sys::Free((void *) (uPtr3));
        uji::sys::Free((void *) (uPtr2));
        uji::sys::Free((void *) (uPtr1));
    }

    {
        DEBUG_WRITE("* allocate test 2 \n");
        uPtr1 = (uptr) uji::sys::Alloc(TEST_ALLOCATE_SIZE);
        DEBUG_WRITE(" uPtr1 value, 0x%p\n",uPtr1);
        uPtr2 = (uptr) uji::sys::Alloc(TEST_ALLOCATE_SIZE);
        DEBUG_WRITE(" uPtr2 value, 0x%p\n",uPtr2);
        uPtr3 = (uptr) uji::sys::Alloc(TEST_ALLOCATE_SIZE);
        DEBUG_WRITE(" uPtr3 value, 0x%p\n",uPtr3);
        uPtr4 = (uptr) uji::sys::Alloc(TEST_ALLOCATE_SIZE);
        DEBUG_WRITE(" uPtr4 value, 0x%p\n",uPtr4);

        uji::sys::Free((void *) (uPtr4));
        uji::sys::Free((void *) (uPtr3));
        uji::sys::Free((void *) (uPtr2));
        uji::sys::Free((void *) (uPtr1));
    }

    {
        DEBUG_WRITE("* allocate test 3 \n");
//        uPtr1 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr1 value, 0x%p\n",uPtr1);
//        uPtr2 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr2 value, 0x%p\n",uPtr2);
//        uPtr3 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr3 value, 0x%p\n",uPtr3);
//        uPtr4 = (uptr) uji::sys::Alloc(m_fileSizeMax);
        DEBUG_WRITE(" uPtr4 value, 0x%p\n",uPtr4);

        uji::sys::Free((void *) (uPtr4));
        uji::sys::Free((void *) (uPtr3));
        uji::sys::Free((void *) (uPtr2));
        uji::sys::Free((void *) (uPtr1));
    }
}


} // namespace pl
} // namespace seq
} // namespace uji
