/*--------------------------------------------------------------------------*
  Project:CTR-UJI
  File:   ProductionLogDummy.cpp

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

*--------------------------------------------------------------------------*/
#include "ProductionLogDummy.h"
#include "../Reception_board_interface.h"


namespace uji {
namespace seq {

using namespace uji::seq;
using namespace uji::sys;
using namespace std;

//
// _~[Op ֐`}N
//
#define FUNC_DEFINE(name)  void LINE ## _ ## name (void) { ProductionLogDummy::DummyBase_Wait ("LINE", #name, "OK") ; } \
                           void QC ## _ ## name (void) { ProductionLogDummy::DummyBase_Wait ("QC", #name, "OK") ; }

FUNC_DEFINE ( CpuBoard )
FUNC_DEFINE ( SlidePad )
FUNC_DEFINE ( LcdAndKey )
FUNC_DEFINE ( TpCal )
FUNC_DEFINE ( Interface )
FUNC_DEFINE ( Aging )
FUNC_DEFINE ( Wireless )
FUNC_DEFINE ( Shock )
FUNC_DEFINE ( Acc )
FUNC_DEFINE ( Mic )
FUNC_DEFINE ( Gyroscope )
FUNC_DEFINE ( Parallax )

FUNC_DEFINE ( Ocam )
FUNC_DEFINE ( Icam )
FUNC_DEFINE ( DataList )
FUNC_DEFINE ( Sign )
FUNC_DEFINE ( Import )
FUNC_DEFINE ( ProcCheck )
FUNC_DEFINE ( SpAndTp )
FUNC_DEFINE ( WlAudio )
FUNC_DEFINE ( CamCapture )
FUNC_DEFINE ( CamAndIf )
FUNC_DEFINE ( Fang )


//
// _~[O j[o^p}N
//
#define FUNC_ENTRY(mode,name)   m->Add("(" #mode ")" #name ":OK", mode ## _ ## name )

void ProductionLogDummy_Menu()
{
    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "ProductionLog DummyLog 1/2" );
    m->SetColumn(2);

//    m->Add ( "(L)CpuBoard:OK",   pl::ProductionLogDummy::Add1Line_CpuBoard1);

    //12*2 = 24o^
    FUNC_ENTRY(LINE,CpuBoard);
    FUNC_ENTRY(QC,  CpuBoard);
    FUNC_ENTRY(LINE,SlidePad);
    FUNC_ENTRY(QC,  SlidePad);
    FUNC_ENTRY(LINE,LcdAndKey);
    FUNC_ENTRY(QC,  LcdAndKey);
    FUNC_ENTRY(LINE,TpCal);
    FUNC_ENTRY(QC,  TpCal);
    FUNC_ENTRY(LINE,Interface);
    FUNC_ENTRY(QC,  Interface);
    FUNC_ENTRY(LINE,Aging);
    FUNC_ENTRY(QC,  Aging);
    FUNC_ENTRY(LINE,Wireless);
    FUNC_ENTRY(QC,  Wireless);
    FUNC_ENTRY(LINE,Shock);
    FUNC_ENTRY(QC,  Shock);
    FUNC_ENTRY(LINE,Acc);
    FUNC_ENTRY(QC,  Acc);
    FUNC_ENTRY(LINE,Mic);
    FUNC_ENTRY(QC,  Mic);
    FUNC_ENTRY(LINE,Gyroscope);
    FUNC_ENTRY(QC,  Gyroscope);
    FUNC_ENTRY(LINE,Parallax);
    FUNC_ENTRY(QC,  Parallax);

    m->Open();
    delete m;
}

// O@_~[O֐pj[
void ProductionLogDummy_Menu2()
{
    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "ProductionLog DummyLog 2/2" );
    m->SetColumn(2);

//    m->Add ( "(L)CpuBoard:OK",   pl::ProductionLogDummy::Add1Line_CpuBoard1);

    //12*2 = 22o^
    FUNC_ENTRY(LINE,Ocam);
    FUNC_ENTRY(QC,  Ocam);
    FUNC_ENTRY(LINE,Icam);
    FUNC_ENTRY(QC,  Icam);
    FUNC_ENTRY(LINE,DataList);
    FUNC_ENTRY(QC,  DataList);
    FUNC_ENTRY(LINE,Sign);
    FUNC_ENTRY(QC,  Sign);
    FUNC_ENTRY(LINE,Import);
    FUNC_ENTRY(QC,  Import);
    FUNC_ENTRY(LINE,ProcCheck);
    FUNC_ENTRY(QC,  ProcCheck);
    FUNC_ENTRY(LINE,SpAndTp);
    FUNC_ENTRY(QC,  SpAndTp);
    FUNC_ENTRY(LINE,WlAudio);
    FUNC_ENTRY(QC,  WlAudio);
    FUNC_ENTRY(LINE,CamCapture);
    FUNC_ENTRY(QC,  CamCapture);
    FUNC_ENTRY(LINE,CamAndIf);
    FUNC_ENTRY(QC,  CamAndIf);
    FUNC_ENTRY(LINE,Fang);
    FUNC_ENTRY(QC,  Fang);

    //c2
    m->Add ( "(LINE)All Process", pl::ProductionLogDummy::AllProcess_LINE);
    m->Add ( "(QC)All Process", pl::ProductionLogDummy::AllProcess_QC);

    m->Open();
    delete m;
}

namespace pl
{


void ProductionLogDummy::DummyBase_Wait(string mode, string name, string status)
{
    DummyBase(mode,name,status);

    // bZ[W\AL[܂ő҂
    {
        uji::sys::Pad pad;
        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    //        gfx->m_DrawFramework->Clear();
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        pad.WaitAnyKey();
    }
}

void ProductionLogDummy::DummyBase_AutoWait(string mode, string name, string status)
{
    DummyBase(mode,name,status);

    // bZ[W\Aw莞ԑ҂
    {
        uji::sys::Pad pad;

        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
}


// _~[ЂȌ`
void ProductionLogDummy::DummyBase(string mode, string name, string status)
{

    LogResult lr = -1;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    if ( "LINE" == mode )
    {
        lr = pl->Add_1Line(0,name, status,  "0.00", "1234/56/78","00:00","000000",MSG_DUMMY.c_str());
    }
    else if ( "QC" == mode)
    {
        lr = pl->Add_1Line(1,name, status,  "0.00", "1234/56/78","00:00","000000",MSG_DUMMY.c_str());
    }
    else
    {
        // ̑̏̕ꍇ͉ȂB
    }

    if (lr != LogResultCode::SUCCESS)
    {
        // O݂ɎsꍇASUCCESSȊOAĂ܂B
        // (Add_1Line𔲂钼O NN_LOGŃG[bZ[W\܂j
        // @ōsꍇ́AΏR[hiOݎs̉ʕ\ȂǁjĂB
        Menu::m_SubWindow->Printf("(%s)%s write failed.\n",mode.c_str(),name.c_str());
    }
    else
    {
        Menu::m_SubWindow->Printf("(%s)%s write succeded.\n",mode.c_str(),name.c_str());
    }

    pl->Finalize();
    delete pl;
}


// LINEp_~[ЂȌ`
void ProductionLogDummy::DummyBase(string name, string status)
{
    LogResult lr;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    lr = pl->Add_1Line(0,name, status,  "0.00", "1234/56/78","00:00","000000",MSG_DUMMY.c_str());
    if (lr != LogResultCode::SUCCESS)
    {
        // O݂ɎsꍇASUCCESSȊOAĂ܂B
        // (Add_1Line𔲂钼O NN_LOGŃG[bZ[W\܂j
        // @ōsꍇ́AΏR[hiOݎs̉ʕ\ȂǁjĂB
    }

    pl->Finalize();
    delete pl;
}

//------------------------------------------------------------------------------
// ǍH̃_~[f[^̍쐬
//------------------------------------------------------------------------------
// SĂ̗ʎYȞO
void ProductionLogDummy::AllProcess_LINE(void)
{
    AllProcessBase("LINE");
}

void ProductionLogDummy::AllProcess_QC(void)
{
    AllProcessBase("QC");
}

void ProductionLogDummy::AllProcessBase(string mode)
{
    DummyBase_AutoWait(mode,"CpuBoard",  "OK");
    DummyBase_AutoWait(mode,"SlidePad",  "OK");
    DummyBase_AutoWait(mode,"LcdAndKey", "OK");
    DummyBase_AutoWait(mode,"TpCal",     "OK");
    DummyBase_AutoWait(mode,"Interface", "OK");
    DummyBase_AutoWait(mode,"Aging",     "OK");
    DummyBase_AutoWait(mode,"Wireless",  "OK");
    DummyBase_AutoWait(mode,"Shock",     "OK");
    DummyBase_AutoWait(mode,"Acc",       "OK");
    DummyBase_AutoWait(mode,"Mic",       "OK");
    DummyBase_AutoWait(mode,"Gyroscope", "OK");
    DummyBase_AutoWait(mode,"Parallax",  "OK");
    DummyBase_AutoWait(mode,"Ocam",      "OK");
    DummyBase_AutoWait(mode,"Icam",      "OK");
    DummyBase_AutoWait(mode,"DataList",  "OK");
    DummyBase_AutoWait(mode,"Sign",      "OK");
    DummyBase_AutoWait(mode,"Import",    "OK");
    DummyBase_AutoWait(mode,"ProcCheck", "OK");
    DummyBase_AutoWait(mode,"SpAndTp",   "OK");
    DummyBase_AutoWait(mode,"WlAudio",   "OK");
    DummyBase_AutoWait(mode,"CamCapture","OK");
    DummyBase_AutoWait(mode,"CamAndIf",  "OK");
    DummyBase_AutoWait(mode,"Fang",      "OK");

   // bZ[W\
    uji::sys::Pad pad;
    do {

        pad.UpdatePad();

        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }

    while(!pad.IsButtonDown(Pad::BUTTON_B));

}

//------------------------------------------------------------------------------
// ϋvpi\j
//------------------------------------------------------------------------------
// 100񕪂̃O
void ProductionLogDummy::Add1Line_100times(void)
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    char message[50];

    int i = 0;
    for( ; i < 100; i++)
    {
        std::memset(message, 0x00, sizeof(message));
        sprintf(message,"trials=%03d",i);

        pl->Add_1Line(0,"DEBUG", "OK", "9.99", "2010/5/19",  "11:00","012345", message);
    };

    pl->Finalize();
    delete pl;
}

// 10񕪂̃O
void ProductionLogDummy::Add1Line_10times(void)
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    char message[50];

    int i = 0;
    for( ; i < 10; i++)
    {
        std::memset(message, 0x00, sizeof(message));
        sprintf(message,"trials=%03d",i);

        pl->Add_1Line(0,"DEBUG", "OK", "9.99", "2010/5/19",  "11:00","012345", message);
    };
    pl->Finalize();
    delete pl;
}

// 1񕪂̃O
void ProductionLogDummy::Add1Line_Once(void)
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    pl->Add_1Line(0,"LCDAndKey","START",  "9.99", "2010/4/8",  "23:59","012345","0123456789$01234567890123456789$01234567890123456789$012345678901234567890123456");
    pl->Finalize();
    delete pl;
}

}   // namespace pl
}   // namespace seq
}   // namespace uji

