/*---------------------------------------------------------------------------*
  Project: CTR_TRIAL
  File:    ProductionLog.h

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef _UJI_SEQ_PRODUCTION_LOG_H_
#define _UJI_SEQ_PRODUCTION_LOG_H_

#include "TesterLog.h"

#include <nn/fs.h>
#include <nn/fs/fs_APILoader.h>
#include <nn/srv.h>
#include <stdio.h>
#include <string>


/*
 p:
     OGg: Oi1񕪂̃Oj
     Oe[u: OGg̑
*/
namespace uji {
namespace seq {
namespace pl  {

    // [h
    typedef enum
    {
        LINE=0,         //ʎYC
        QC=1,           //QCioׁEj
        REPAIR=2,       //C匟
        SC=3,           //T[rXZ^p
        SUBSIDIARY=4,   //q(NOA,NOE,NAL,NOK)p
        SUBMIT=5,       //_Tv
        VOLUNTARY=6,    //匟iŏIGj
        ACCEPT=8,       //CVŏI
        DEBUG=9,        //fobOp
        TESTMODE_MAX=10
    }Testmode;


    static const int LOG_TESTERNAME_LEN   = 11;
    static const int LOG_VERSION_LEN      =  4;
    static const int LOG_STATE_LEN        = 10;// MAJOR(2)-MINOR(3)-MICRO(3) = 2+1+3+1+3
    static const int LOG_DATE_LEN         = 10;// 2010/12/31 =4+1+2+1+2
    static const int LOG_TIME_LEN         =  5;// 12:34      =2+1+2
    static const int LOG_TESTERID_LEN     =  6;// 000001
    static const int LOG_MSG_LEN          = 80;

    static const int SALVAGE_CPUBOARD_MAX = 50; //O̍ő吔

}//namespace pl


using namespace uji::seq::pl;

//============================================================================
//
//  LogEntry OGgNX(\́j
//
//============================================================================
class LogEntry
{
    public:
        static const int  ENTRY_UNUSED    = 0; //gp
        static const int  ENTRY_USED      = 1; //gp
        static const int  ENTRY_BROKEN    = 6; //OGgj󂳂Ă

        int  testmode;                         //[hTESTMODE      (K{)  4
        char used                             ;//gpĂ邩ǂ
        char state     [LOG_STATE_LEN      +1];//Xe[^X(K{ς) 11
        char date      [LOG_DATE_LEN       +1];//N (C)              11
        char time      [LOG_TIME_LEN       +1];//   (C)               6
        char testerId  [LOG_TESTERID_LEN   +1];//ID   (C)               7
        char testerName[LOG_TESTERNAME_LEN +1];//햼             iK{) 12
        char version   [LOG_VERSION_LEN    +1];//vOo[W(K{)  5
        char message   [LOG_MSG_LEN        +1];//bZ[WiC)              81
        char padding   [2];
};//class LogEntry

//============================================================================
//
//  ProductionLog  CTRpO NX
//
//============================================================================
class ProductionLog : public TesterLog
{
    private:
        static const int LOG_COMMA_MAX      = 8;  //Os̐J}̐
        static const int LOG_ENTRY_NUM_MAX  = 256;//OGg̍ő吔
        static const int LOG_LINEBUF_LEN    = 256;//sobt@

        LogEntry   m_logTable[LOG_ENTRY_NUM_MAX];  //Oe[u (OGg̏W)

    public:
        // RXgN^
        ProductionLog()
        {
            m_fileNameMaster = L"product.log";
            m_fileNameSub    = L"product.log~";
            m_nandPathMaster = NAND_LOGDIR +L"/"+ m_fileNameMaster;
            m_nandPathSub    = NAND_LOGDIR +L"/"+ m_fileNameSub;
            m_pathMaster = m_nandPathMaster;
            m_pathSub    = m_nandPathSub;

        };

        // fXgN^
        virtual ~ProductionLog()
        {
        };

    // 
    virtual LogResult InitFile(const std::wstring & path); //t@C̐VK쐬

    // OGg̑
               int  Get_LogEntryNums(void) const;     //OGg̐擾
               int  Get_LogEntryNumsMax(void) const;  //OGg̐̍ől擾
               int  Get_LogEntryByteSize(LogEntry & le) const; //OGg̃TCYioCgj擾
               int  Get_LogEntryByteSizeMax(void) const;       //OGg̍őTCYioCgj擾
    const LogEntry  Get_LogEntry(const int id) const;   //w肵ID̃OGg擾B

    // OGg̑(w̃OGg̍ŐVCfbNX擾)
               int  Get_LatestLogEntryIndex(const std::string testerName) const;
               int  Get_LatestLogEntryIndex(const std::string testerName, const int testmode) const;
               int  Get_LatestLogEntryIndex(const std::string testerName, const int testmode, const std::string state) const ;
               int  Get_LatestLogEntryIndex(const int testmode, const std::string state) const;
               int  Get_LatestLogEntryIndex(const int testmode) const;
               int  Add_1Line(int testmode, std::string testerName, std::string state, std::string version,
                              std::string date, std::string time, std::string testerId, std::string msg);

               //SCpG[WOł̂ݎgpĂAHvOł̎gp֎~
               int  Overwrite_1Line(int testmode, std::string testerName, std::string state, std::string version,
                              std::string date, std::string time, std::string testerId, std::string msg);

    // Oe[ȗ
    bool       LogTable_IsCpuBoard1st(void);    //Oe[u̍ŏ̗vf(CpuBoard)ł邩ǂ
    LogResult  LogTable_Extract_CpuBoard(void); //OOe[u甲oAOe[uč\z
    LogResult  LogTable_ReconstructForReentry(void); //ēpɊOAEMSxA\tg݂𔲂oăOe[uč\z
    bool       LogTable_LatestLogEntryIsOK(const std::string testerName, const int testmode); //ƂŐV̎wtesterName,wtestmodeOKł邩

    LogResult  LogTable_Shrink(int id_end);     //Oe[uk
    int        LogTable_GetWriteFileSize(void); //Oe[ut@Cɏꍇ̃TCY擾


    // [h
    virtual LogResult LoadData(void * buf);

    // Z[u
    virtual LogResult WriteFile(const std::wstring & path, const std::string & message);

    // nbV
    virtual LogResult Calc_DataHash(void);

    // ޔE
    virtual LogResult Identify_RestoreTarget(void);


private:
    // Rs[RXgN^EZq̎gp֎~
    ProductionLog(const ProductionLog& pl);
    const ProductionLog& operator=(const ProductionLog& pl);

    // OGg̑
    void      LogTable_Clear(void); //Oe[ȕ
    LogResult Create_LogEntry(LogEntry & le,
                              int             testmode,
                              std::string     testerName,
                              std::string     state,
                              std::string     version,
                              std::string     date,
                              std::string     time,
                              std::string     testerId,
                              std::string     msg) const;
    int       LogTable_Rotate(int id_end); //OGgMAXɒBꍇAvfP炵AŌ󂯂B
    int       Add_1Line( LogEntry &le );    //OGg璼ڃOǋLB

    int       Get_NextId(void) const;                       //Ɋi[ID擾
    int       LogTable_Entry(int id, LogEntry & le);        //OGgOe[uɓo^B
    bool      Check_ProhibitedString(std::string str) const;//֎~̃`FbN

    void      Analyze_LogLine(u8 * line, int lineLength);//Oe[uւ̓o^


    // fobOp
    void      LogTable_Dump(void) const;   // gpĂGĝ dump
    void      LogTable_DumpAll(void) const;// SẴGgdump

};

} // namespace seq
} // namespace uji

#endif // _UJI_SEQ_PRODUCTION_LOG_H_
/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
