/*---------------------------------------------------------------------------*
  Project:  CTRTrial
  File:     LogResultCode.h

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef _UJI_LOG_RESULT_CODE_H_
#define _UJI_LOG_RESULT_CODE_H_

#include <nn/types.h>
#include <string>


namespace uji {
namespace seq {

//-------------------------------------------------
// typedef
//-------------------------------------------------
    typedef int LogResult;

//============================================================================
//
//  LogResultCode OUgR[h   // rint^ɂȂĂ܂ƂɒӁB
//
//============================================================================

class LogResultCode
{
 public:
    static const LogResult FILE_NOT_EXIST    =-1; //Ot@C݂Ȃ
    static const LogResult FS_OPEN_ERROR     =-2; //t@CI[vG[
    static const LogResult FS_READ_ERROR     =-3; //t@C[hG[
    static const LogResult FS_WRITE_ERROR    =-4; //t@CCgG[
    static const LogResult FS_DELETE_ERROR   =-5; //t@CG[

    static const LogResult FILE_BROKEN         =-6;//Ot@CjĂ
    static const LogResult ENTRY_BROKEN        =-7;//OGgĂ
    static const LogResult ENTRY_FULL          =-8;//OGgt
    static const LogResult ENTRY_FULL_BOARD1ST =-9;//OGgtŁAO擪iΉ@́A蓮ō폜sj

    static const LogResult ARGUMENT_ERROR    =-10;//O֐G[
    static const LogResult HASH_CALC_ERROR   =-11;//ÕnbVvZɎs
    static const LogResult HASH_MISMATCH     =-12;//ÕnbVl~X}b`
    static const LogResult HASH_ALL_FF       =-13;//ÕnbVlI[FF (systemUpdate1stɂtH[}bgō쐬j

    static const LogResult FILESIZE_OVER       =-14;//Ot@C̃TCYɂG[
    static const LogResult ALLOCATE_ERROR      =-15;//mۂɎs
    static const LogResult COMMA_COUNT_ERROR   =-16;//R}̐
    static const LogResult SDCARD_NO_DETECT    =-17;//SDJ[h}ĂȂ
    static const LogResult NO_MAGIC_CODE       =-18;//Õ}WbNR[h(40,41oCg)݂Ȃ
    static const LogResult FILESIZE_ZERO       =-19;//Õt@CTCY[(systemUpdater1stɂAs{ӂɍ쐬j

    static const LogResult ARC_MOUNT_ERROR   =-20;//A[JCu}EgG[
    static const LogResult ARC_UMOUNT_ERROR  =-21;//A[JCuA}EgG[
    static const LogResult IDENTIFY_FAILURE  =-25;//{̕svG[
    static const LogResult FUNC_CALL_ERROR   =-28;//֐ĂяoɎs
    static const LogResult UNKNOWN_ERROR     =-29;//s
    static const LogResult LOGRESULT_DEF_MIN =-30;//b

    static const LogResult SUCCESS           =0; //
    static const LogResult NO_LOG_ENTRY      =1; //ł邪AOGgȂ
    static const LogResult LOGRESULT_DEF_MAX =2; //b

// LogResultCode stringɕϊ
    #define LogResultCodeToStr(name) LogResultCode::name: { str = #name ; break ; }
    static std::string ToString(LogResult lr)
    {
        std::string str;
        switch( lr )
        {
            case LogResultCodeToStr(FILE_NOT_EXIST)
            case LogResultCodeToStr(FS_OPEN_ERROR)
            case LogResultCodeToStr(FS_READ_ERROR)
            case LogResultCodeToStr(FS_WRITE_ERROR)
            case LogResultCodeToStr(FS_DELETE_ERROR)

            case LogResultCodeToStr(FILE_BROKEN)
            case LogResultCodeToStr(ENTRY_BROKEN)
            case LogResultCodeToStr(ENTRY_FULL)
            case LogResultCodeToStr(ENTRY_FULL_BOARD1ST)

            case LogResultCodeToStr(ARGUMENT_ERROR)
            case LogResultCodeToStr(HASH_CALC_ERROR)
            case LogResultCodeToStr(HASH_MISMATCH)
            case LogResultCodeToStr(HASH_ALL_FF)

            case LogResultCodeToStr(FILESIZE_OVER)
            case LogResultCodeToStr(ALLOCATE_ERROR)
            case LogResultCodeToStr(COMMA_COUNT_ERROR)
            case LogResultCodeToStr(SDCARD_NO_DETECT)
            case LogResultCodeToStr(NO_MAGIC_CODE)
            case LogResultCodeToStr(FILESIZE_ZERO)

            case LogResultCodeToStr(ARC_MOUNT_ERROR)
            case LogResultCodeToStr(ARC_UMOUNT_ERROR)
            case LogResultCodeToStr(IDENTIFY_FAILURE)
            case LogResultCodeToStr(FUNC_CALL_ERROR)
            case LogResultCodeToStr(UNKNOWN_ERROR)
            case LogResultCodeToStr(LOGRESULT_DEF_MIN)

            //
            case LogResultCodeToStr(SUCCESS)
            case LogResultCodeToStr(NO_LOG_ENTRY)
            case LogResultCodeToStr(LOGRESULT_DEF_MAX)

        }
        return str;
    }

#if 0
    // eXg֐
    void dumpLogResultCodeString(void)
    {
        int i = 0;
        std::string str;
        for(i=LOGRESULT_DEF_MIN; i< LOGRESULT_DEF_MAX; i++)
        {
            str=ToString(i);
            NN_LOG("(%d) str =%s\n", i,str.c_str());
        }
    }
#endif
};

} // namespace seq
} // namespace uji

#endif // _UJI_LOG_RESULT_CODE_H
