/*--------------------------------------------------------------------------*
  Project:
  File: InspectLog_Viewer.h

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

*--------------------------------------------------------------------------*/
#ifndef _UJI_SEQ_INSPECT_LOGVIEWER_H_
#define _UJI_SEQ_INSPECT_LOGVIEWER_H_

#include "sys_GraphicsDrawing.h"
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_MessageLogWindow.h"
#include "sys_TextWindow.h"
#include "sys_Pad.h"
#include "InspectLog.h"
#include <string>

namespace uji {
namespace seq {


void Run_InspectLog_Viewer();

typedef int LogResult;

//==============================================================================
//
//  InspectLog_ViewerNX
//
//==============================================================================
class InspectLog_Viewer
{
private:

    seq::InspectLog         m_InspectLog;       // O CX^X

    sys::WindowManager      m_WindowManager;
    sys::TextWindow         m_UpperWindow;      // EBhE

public:
    static const int m_DISPLAY_LINE_MAX =14;
    static const int m_FONT_SIZE        =14;

    // RXgN^
    InspectLog_Viewer():
       m_UpperWindow(400, 240, m_FONT_SIZE)    //EChE (1 400~c240BtHgTCY14)
    {}

    // fXgN^
    virtual ~InspectLog_Viewer(){}

    // 
    void Initialize();

    // s
    void Run();

private:

    // O`悷
    void DrawLog(int row, char * key, char * value );

    // OXg`悷
    int  DrawLogList(int start_index);

    // LCD`悷
    int  DrawUpperLCD(sys::GraphicsDrawing* gfx, int display_log_entry_num); //LCD̕`

    // G[bZ[W`悷
    void RunErrorMessage(sys::GraphicsDrawing* gfx,LogResult lr);  //G[\sAL[͂܂Ŏ~߂鏈
    void DrawErrorMessage(sys::GraphicsDrawing* gfx,LogResult lr); //`揈


};//class InspectLog_Viewer

} //namespace eva
} //namespace uji

#endif // _UJI_SEQ_INSPECT_LOGVIEWER_H_
/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
