/*--------------------------------------------------------------------------*
  Project: CTR_TRIAL
  File:    InspectLog_TestFunc.cpp

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

*--------------------------------------------------------------------------*/
#include "InspectLog_TestFunc.h"
#include "sys.h"

namespace uji{
namespace seq{

using namespace uji::seq;


// OeXg֐pj[
void InspectLog_TestFunc_Menu()
{
    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "InspectLog FS Menu" );

    m->Add("NoComment Write",        InspectLog_TestFunc::Proc1);
    m->Add("DummyComment1 Write",    InspectLog_TestFunc::Proc2);
    m->Add("DummyComment2 Write",    InspectLog_TestFunc::Proc3);
    m->Add("----------------------", NULL);
    m->Add("DeleteFile Master",      InspectLog_TestFunc::Proc4);
    m->Add("DeleteFile Sub",         InspectLog_TestFunc::Proc5);
    m->Open();
    delete m;
}


void InspectLog_TestFunc::Proc1(void)
{
    LogResult lr;

    InspectLog * il = new InspectLog();
    lr = il->Initialize();
    lr = il->Create_DataStructure();
    lr = il->Calc_DataHash();
    lr = il->WriteProc();
    NN_LOG("%d\n",lr);
    delete il;
}

void InspectLog_TestFunc::Proc2(void)
{
    LogResult lr;
    InspectLog * il = new InspectLog();
    lr = il->Initialize();
    lr = il->Set_Comment("DUMMYLOG!","2010/12/04");
    lr = il->Create_DataStructure();
    lr = il->Calc_DataHash();
    lr = il->WriteProc();
    NN_LOG("%d\n",lr);
    delete il;
}

void InspectLog_TestFunc::Proc3(void)
{
    LogResult lr;
    InspectLog * il = new InspectLog();
    lr = il->Initialize();
    lr = il->Set_Comment("ZZ-9.9.9","9999/99/99");
    lr = il->Create_DataStructure();
    lr = il->Calc_DataHash();
    lr = il->WriteProc();
    NN_LOG("%d\n",lr);
    delete il;
}


void InspectLog_TestFunc::Proc4(void)
{
    LogResult lr;
    InspectLog * il = new InspectLog();
    lr = il->primaryInit();
        lr = il->DeleteFile_Master("");
    lr = il->Finalize();
    NN_LOG("%d\n",lr);
    delete il;
}

void InspectLog_TestFunc::Proc5(void)
{
    LogResult lr;
    InspectLog * il = new InspectLog();
    lr = il->primaryInit();
        lr = il->DeleteFile_Sub("");
    lr = il->Finalize();
    NN_LOG("%d\n",lr);
    delete il;
}

} // namespace seq
} // namespace uji
