/*---------------------------------------------------------------------------*
  Project: CTR_TRIAL
  File:    InspectLog.h

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef _UJI_SEQ_INSPECT_LOG_H_
#define _UJI_SEQ_INSPECT_LOG_H_

#include "TesterLog.h"

namespace uji {
namespace seq {

//============================================================================
//
//  InspectLog
//
//============================================================================
class InspectLog : public TesterLog
{
    private:
        static const int LOG_LINEBUF_LEN    = 256;//sobt@

// oϐ
        std::string m_DeviceIdHash   ;
        std::string m_RfuMacAddress  ;
        std::string m_SerialNumber   ;
        std::string m_RegionCode     ;
        std::string m_BondingOption  ;
        std::string m_Comment        ;//Rgő10̕ipƋLj
        std::string m_CommentUpdated ;//RgXV
        std::string padding;

// o֐
    public:
        // RXgN^
        InspectLog():m_DeviceIdHash(""),m_RfuMacAddress(""),m_SerialNumber(""),m_RegionCode(""),m_BondingOption(""),m_Comment(""),m_CommentUpdated("")
        {
            m_fileNameMaster = L"inspect.log";
            m_fileNameSub    = L"inspect.log~";
            m_nandPathMaster = NAND_LOGDIR +L"/"+ m_fileNameMaster;
            m_nandPathSub    = NAND_LOGDIR +L"/"+ m_fileNameSub;
            m_pathMaster = m_nandPathMaster;
            m_pathSub    = m_nandPathSub;

        };

        // fXgN^
        virtual ~InspectLog()
        {};


            void       Clear_DataStructure(void);         //f[^\̂̃[NA
            LogResult  Create_DataStructure(void);        //f[^\̂̍쐬

            void       Dump(void);

    virtual LogResult  InitFile(const std::wstring& path);//f[^t@C̏

            void       Analyze_LogLine(u8 * line, int line_len);

    virtual LogResult  LoadData(void * buf);              //f[^̃[h

    virtual LogResult  WriteFile(const std::wstring& path, const std::string & message);
    virtual LogResult  Calc_DataHash(void);                //Of[^ɃnbVlvZ


         // f[^\̂ւ̃ANZbT

            std::string  Get_DeviceIdHash   (void);
            std::string  Get_RfuMacAddress  (void);
            std::string  Get_SerialNumber   (void);
            std::string  Get_RegionCode     (void);
            std::string  Get_BondingOption  (void);

            LogResult    Set_Comment        (std::string comment_str, std::string date_str);
            std::string  Get_Comment        (void);
            std::string  Get_CommentUpdated (void);


        // AmF
    virtual LogResult    Identify_RestoreTarget(void);

};

} // namespace seq
} // namespace uji

#endif // _UJI_SEQ_INSPECT_LOG_H_
/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
