/*---------------------------------------------------------------------------*
  Project: CTR_TRIAL
  File:    InspectLog.cpp

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include <nn/fs.h>
#include <nn/crypto/crypto_Sha1.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/ps/CTR/ps_API.h>
#include <nn/ps/CTR/ps_Parameters.h>
#include <nn/socket.h>
#include <nn/Result.h>
#include <string.h>

#include "InspectLog.h"
#include "sys_Memory.h"
#include "sys_GetSerialNumber.h"
#include "sys_GetMacAddress.h"
#include "sys_GetRegionCode.h"


using namespace uji::seq;
using namespace std;


void InspectLog::Dump(void)
{
//oϐ
    NN_LOG("m_fileNameMaster (%ls)\n", m_fileNameMaster.c_str());
    NN_LOG("m_fileNameSub    (%ls)\n", m_fileNameSub.c_str());
    NN_LOG("m_pathMaster     (%ls)\n", m_pathMaster.c_str());
    NN_LOG("m_pathSub        (%ls)\n", m_pathSub.c_str());

//
    NN_LOG("m_DeviceIdHash   (%s)\n",  m_DeviceIdHash.c_str());
    NN_LOG("m_RfuMacAddress  (%s)\n",  m_RfuMacAddress.c_str());
    NN_LOG("m_SerialNumber   (%s)\n",  m_SerialNumber.c_str());
    NN_LOG("m_RegionCode     (%s)\n",  m_RegionCode.c_str());
    NN_LOG("m_BondingOption  (%s)\n",  m_BondingOption.c_str());
    NN_LOG("m_Comment        (%s)\n",  m_Comment.c_str());
    NN_LOG("m_CommentUpdated (%s)\n",  m_CommentUpdated.c_str());

}


// f[^
void InspectLog::Clear_DataStructure(void)
{
    m_DeviceIdHash   = "";
    m_RfuMacAddress  = "";
    m_SerialNumber   = "";
    m_RegionCode     = "";
    m_BondingOption  = "";
    m_Comment        = "";
    m_CommentUpdated = "";
}

// f[^쐬
LogResult InspectLog::Create_DataStructure(void)
{
    //[JthR[hV[h擾
    nn::Result nnr;
    nnr = nn::ps::CTR::Initialize();
    if ( nnr.IsFailure())
    {
        NN_LOG("nn::ps::Initialize failed.\n");
        nn::dbg::PrintResult(nnr);
        return LogResultCode::FUNC_CALL_ERROR;
    }
    bit32 deviceId = 0;
    nnr = nn::ps::CTR::GetDeviceId(&deviceId);
    if ( nnr.IsFailure())
    {
        NN_LOG("nn::ps::GetDeviceId failed.\n");
        nn::dbg::PrintResult(nnr);
        return LogResultCode::FUNC_CALL_ERROR;
    }
    char deviceIdStr[10];
    memset(deviceIdStr, 0x00, sizeof(deviceIdStr));
    sprintf(deviceIdStr, "%08X", deviceId);


    bit32 deviceIdHash = 0;
    deviceIdHash = 0xDECABEEF ^ deviceId; //DECA BEEF
    NN_LOG("%08X\n",deviceIdHash);

    deviceIdHash = nn::socket::NtoHl(deviceIdHash);
    NN_LOG("%08X\n",deviceIdHash);

    char deviceIdHashStr[10];
    memset(deviceIdHashStr, 0x00, sizeof(deviceIdHashStr));
    sprintf(deviceIdHashStr, "%08X", deviceIdHash);

    m_DeviceIdHash = deviceIdHashStr;


    //MACAhX擾
    bit8 mac[ nn::uds::MAC_ADDRESS_SIZE ];
    uji::sys::GetMacAddress( mac );
    char macStr[12+5+1];
    memset(macStr, 0x00, sizeof(macStr));
    sprintf(macStr, "%02X-%02X-%02X-%02X-%02X-%02X", mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);
    m_RfuMacAddress = macStr;

    //VAio[擾
    char serial[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN+1];
    uji::sys::GetSerialNumber(serial);
    m_SerialNumber   = serial;

    //[WR[h
    nn::cfg::CTR::CfgRegionCode   crc;
    crc = uji::sys::GetRegionCode();
    char crcStr[10];
    memset(crcStr, 0x00, sizeof(crcStr));
    sprintf(crcStr, "%02d", crc);
    m_RegionCode     = crcStr;

    //{fBOIvV
    nn::cfg::CTR::detail::LocalFriendCodeSeedBody lfcsb;
    nn::cfg::CTR::detail::LocalFriendCodeSeedBody * p;
    p = &lfcsb;
    nn::cfg::CTR::init::GetLocalFriendCodeSeedBody(p, true);

    char bondingOptionStr[10];
    memset(bondingOptionStr, 0x00, sizeof(bondingOptionStr));
    sprintf(bondingOptionStr, "%02d", lfcsb.bondingOption);
    m_BondingOption = bondingOptionStr;

//(ӁIjm_Comment, m_CommentUpdated 
//         Set_Commentɂݒ肳B

    // DataHashvZ
    Calc_DataHash();

    return LogResultCode::SUCCESS;
}


//
// Ot@C
//
// ̊֐̓Ot@C݂ȂԂłAgpłȂB
// ɃOt@Cꍇ́AFS_WRITE_ERRORIɕԂB
LogResult InspectLog::InitFile(const wstring& path)
{
    LogResult lr = LogResultCode::SUCCESS;

    char line[LOG_LINEBUF_LEN];
    s32 writeBytes=0;     //݃TCY
    s32 writeBytesTotal=0;//݃TCYv

    NN_LOG("%s (%s) called.\n", NN_FUNCTION, path.c_str());
    nn::fs::FileOutputStream fos(path.c_str(), true);

    if ( fos.GetSize() != 0 )
    {
        //OԈĂ邽߁A
        //ɂAFS_WRITE_ERRORIɕԂ
        lr = LogResultCode::FS_WRITE_ERROR;
        NN_LOG(" fileSize(%d)\n", path.c_str(),fos.GetSize());
        return lr;
    }
    fos.Finalize();

    // f[^쐬AnbVlvZ
    Clear_DataStructure();
    Create_DataStructure();
    Calc_DataHash();

    // CommentȊÕf[^
    lr = WriteFile(path,"");
    return lr;
}

// siOf[^)͂Af[^\̂ɓo^
void InspectLog::Analyze_LogLine(u8 * line, int line_len)
{
    u8 * ptr = NULL;
    u8 * ptr2 = NULL;
    int charCount =0;
    int equalCount = 0;

    char key    [LOG_LINEBUF_LEN];
    char value  [LOG_LINEBUF_LEN];

    memset(key,   0x00, sizeof(key));
    memset(value, 0x00, sizeof(value));

    // = āA͂Ă
    ptr = line;
    ptr2 = ptr;
    bool  equalFound = false;
    for(int i = 0; i < line_len; i++)
    {
        charCount++;
        if ( '=' == *ptr )
        {
            equalCount++;
            if (equalCount == 1)
            {
                // = ̑O key Ƃ݂Ȃ
                memcpy(key,ptr2,(charCount-1));
                equalFound = true;
                break;
            }
            ptr2 = ptr;
            ptr2++;
            charCount = 0;
        }
        ptr++;
    }

    // = ̌㔼 value Ƃ݂Ȃ
    if (( equalFound ) && ((line_len - charCount) > 0))
    {
        memcpy(value,ptr+1,(line_len - charCount));
    }


    // equal̐𒲂ׂB
    if (( 0 == equalCount ) && ( 40 == line_len )) // commaCount =0 ŁAlineLength0łȂꍇ
    {
        // 1sڂ̃nbVl m_HashEntryValueɃRs[
        memset(m_HashEntryValue, 0x00, sizeof(m_HashEntryValue));
        memcpy(m_HashEntryValue, line, line_len);
        return;
    }
    else if ( 0 == equalCount)
    {
        // s
        //NN_LOG(" commaCount(%d) skip brank line.\n",commaCount);
        return;
    }
    else
    {
        //TODO f[^Ȃ̂ŁA switchŃL[ƔrAoϐɓo^
        NN_LOG("key(%s) value(%s)\n",key,value);

        if ( 0 == strcmp(key, "DeviceIdHash"))  { m_DeviceIdHash   = value ;}
        if ( 0 == strcmp(key, "RfuMacAddress")) { m_RfuMacAddress  = value ;}
        if ( 0 == strcmp(key, "SerialNumber"))  { m_SerialNumber   = value ;}
        if ( 0 == strcmp(key, "RegionCode"))    { m_RegionCode     = value ;}
        if ( 0 == strcmp(key, "BondingOption")) { m_BondingOption  = value ;}
        if ( 0 == strcmp(key, "Comment"))       { m_Comment        = value ;}
        if ( 0 == strcmp(key, "CommentUpdated")){ m_CommentUpdated = value ;}
    }
}



// f[^[h
LogResult InspectLog::LoadData(void * buf)
{
    u8 * ptr = reinterpret_cast<u8 *>(buf);
    u8 * ptr2 = ptr;
    int i = 0;
    int line = 0;
    int charCount = 0;
    u8  lineBuf[LOG_LINEBUF_LEN];

    // f[^\̂NA
    Clear_DataStructure();

    // obt@f[^ǂ݁Af[^\̂ɓo^
    for(i =0; i < m_fileSize; i++)
    {
        charCount++;
        if ( 0x0a == *ptr ) //sR[h
        {
            memset(lineBuf,0x00,sizeof(lineBuf));
            memcpy(lineBuf,ptr2, (charCount-1));
            NN_LOG("(%d)[%s]\n",line,lineBuf);

            Analyze_LogLine(lineBuf, (charCount-1)); //œo^

            line++; //s̃JEg
            ptr2 = ptr;
            ptr2++;
            charCount = 0;
        }
//        NN_LOG("%c",*ptr);
        ptr++;
    }//for

    return LogResultCode::SUCCESS;
}

// f[^t@Cɏ
LogResult InspectLog::WriteFile(const wstring& path, const string & message)
{
    int  i;
    char line[LOG_LINEBUF_LEN];
    s32 writeBytes=0;     //݃TCY
    s32 writeBytesTotal=0;//݃TCYv
    nn::Result nnr;

    nn::fs::FileOutputStream fos(path.c_str(), true);
    DEBUG_WRITE("%s [%ls] fileSize(%d)\n", NN_FUNCTION, path.c_str(),fos.GetSize());

    //t@CTCY[ɂ
    nnr = fos.TrySetSize(0);
    if ( nnr.IsFailure() ) goto ERROR;

#if 0
    //VAio[ݒOɎ擾
    char serial[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN+1];
    uji::sys::GetSerialNumber(serial);
    m_SerialNumber   = serial;
#endif

    //wb_̏o
    //(⑫)nbVľvŹAe[uɃGgo^ƂƁA[ĥݍŝŁA
    //      ł͌vZȂB
    memset(line, 0x00,sizeof(line));
    sprintf(line,"%s\n\n",m_DataHash);
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),false);
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes;
    i = 2;

    //f[^̏o
    memset(line, 0x00,sizeof(line));
    sprintf(line,"DeviceIdHash=%s\n",m_DeviceIdHash.c_str());
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),false);
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes + writeBytesTotal;
    i++;

    memset(line, 0x00,sizeof(line));
    sprintf(line,"RfuMacAddress=%s\n",m_RfuMacAddress.c_str());
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),false);
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes + writeBytesTotal;
    i++;

    memset(line, 0x00,sizeof(line));
    sprintf(line,"SerialNumber=%s\n",m_SerialNumber.c_str());
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),false);
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes + writeBytesTotal;
    i++;

    memset(line, 0x00,sizeof(line));
    sprintf(line,"RegionCode=%s\n",m_RegionCode.c_str());
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),false);
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes + writeBytesTotal;
    i++;

    memset(line, 0x00,sizeof(line));
    sprintf(line,"BondingOption=%s\n",m_BondingOption.c_str());
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),false);
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes + writeBytesTotal;
    i++;

    memset(line, 0x00,sizeof(line));
    sprintf(line,"Comment=%s\n",m_Comment.c_str());
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),false);
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes + writeBytesTotal;
    i++;

    memset(line, 0x00,sizeof(line));
    sprintf(line,"CommentUpdated=%s\n",m_CommentUpdated.c_str());
    nnr = fos.TryWrite(&writeBytes,line,strlen(line),true); //Ńf[^߂Lɂ
    if ( nnr.IsFailure() ) goto ERROR;
    writeBytesTotal = writeBytes + writeBytesTotal;
    i++;

    fos.Finalize();
    NN_LOG("%s            %s lines(%d) writeBytes(%d) \n",__func__, message.c_str(), i,writeBytesTotal);
    return LogResultCode::SUCCESS;

ERROR:
    fos.Finalize();
    return LogResultCode::FS_WRITE_ERROR;
}

// f[^̃nbVlvZAm_DataHash̒lXVB
LogResult InspectLog::Calc_DataHash(void)
{

    // f[^Rs[pobt@m
    void * dataBuf = uji::sys::Alloc(m_fileSizeMax);
    if ( NULL == dataBuf)
    {
        DEBUG_WRITE("%s dataBuf is NULL\n", NN_FUNCTION);
        return LogResultCode::ALLOCATE_ERROR;
    }
    memset(dataBuf, 0x00, m_fileSizeMax);

    char * dataPtr = NULL;       //f[^obt@ւ̃|C^
    dataPtr = static_cast<char *>(dataBuf);

    int  outputTotal = 0;       //o̓f[^TCY(oCg)

    //TODO K̂ŏB
    sprintf(dataPtr, "DeviceIdHash=%s\nRfuMacAddress=%s\nSerialNumber=%s\nRegionCode=%s\nBondingOption=%s\nComment=%s\nCommentUpdated=%s\n"
                     ,m_DeviceIdHash.c_str()
                     ,m_RfuMacAddress.c_str()
                     ,m_SerialNumber.c_str()
                     ,m_RegionCode.c_str()
                     ,m_BondingOption.c_str()
                     ,m_Comment.c_str()
                     ,m_CommentUpdated.c_str()
    );

    outputTotal = strlen(dataPtr);


    // nbVvZ
    nn::crypto::Sha1Context sha1;
    sha1.Initialize();

    // nbVvZpm
    int hashLength = 0;
    hashLength = sha1.GetHashLength();
    void* hashBuf = uji::sys::Alloc(hashLength);
    if ( NULL == hashBuf )
    {
        uji::sys::Free(dataBuf);
        return LogResultCode::ALLOCATE_ERROR;
    }
    memset(hashBuf, 0x00, sizeof(hashBuf));

    // nbVvZ
    NN_LOG("outputTotal:%d\n",outputTotal);
    sha1.Update(dataBuf, outputTotal);
    NN_LOG("%s outputTotal=%d\n",NN_FUNCTION,outputTotal);
    sha1.GetHash(hashBuf);

    // nbVl̕\
    u8 * hashPtr;
    hashPtr = static_cast<u8 *>(hashBuf);
    memset(m_DataHash, 0x00, sizeof(m_DataHash));
    NN_LOG(" sha1 DataHash:[");
    for(int i = 0; i < hashLength; i++)
    {
        NN_LOG("%02X",*hashPtr);
        sprintf(&m_DataHash[i*2], "%02X",*hashPtr);
        hashPtr++;
    }
    NN_LOG("]\n");

    NN_LOG(" check m_DataHash[%s]\n",&m_DataHash[0]);

    // I
    sha1.Finalize();
    sha1.~Sha1Context();

    uji::sys::Free(dataBuf);
    uji::sys::Free(hashBuf);

    return LogResultCode::SUCCESS;
}


// foCXIDnbV擾
// \̓foCXIDnbV(g͎̎菇ŁAlocalFriendCodeSeedȈՕϊj
string    InspectLog::Get_DeviceIdHash (void)
{
    //1. [JthR[hV[hGfBAς
    //2. ɑ΂XORŔ]
    return m_DeviceIdHash;
}

// RfuMacAhX擾
string    InspectLog::Get_RfuMacAddress (void)
{
    return m_RfuMacAddress;
}

// VAio[擾
string    InspectLog::Get_SerialNumber (void)
{
    return m_SerialNumber;
}

// [WR[h擾
string    InspectLog::Get_RegionCode (void)
{
    return m_RegionCode;
}

// {fBOIvV擾
string    InspectLog::Get_BondingOption (void)
{
    return m_BondingOption;
}

// RgZbg
LogResult InspectLog::Set_Comment(string comment_str,  string date_str)
{
    m_Comment        = comment_str;
    m_CommentUpdated = date_str;

    return LogResultCode::SUCCESS;
}

// Rg擾
string    InspectLog::Get_Comment (void)
{
    return m_Comment;
}

// RgXV擾
string    InspectLog::Get_CommentUpdated (void)
{
    return m_CommentUpdated;
}

// XgA̖{̂ƍ
// () m_DeviceIdHash ̒l͂炩ߍXVĂ
LogResult InspectLog::Identify_RestoreTarget(void)
{

    //[JthR[hV[h擾
    nn::Result nnr;
    nnr = nn::ps::CTR::Initialize();
    if ( nnr.IsFailure())
    {
        NN_LOG("nn::ps::Initialize failed.\n");
        nn::dbg::PrintResult(nnr);
        return LogResultCode::FUNC_CALL_ERROR;
    }
    bit32 deviceId = 0;
    nnr = nn::ps::CTR::GetDeviceId(&deviceId);
    if ( nnr.IsFailure())
    {
        NN_LOG("nn::ps::GetDeviceId failed.\n");
        nn::dbg::PrintResult(nnr);
        return LogResultCode::FUNC_CALL_ERROR;
    }
    char deviceIdStr[10];
    memset(deviceIdStr, 0x00, sizeof(deviceIdStr));
    sprintf(deviceIdStr, "%08X", deviceId);

    bit32 deviceIdHash = 0;
    deviceIdHash = 0xDECABEEF ^ deviceId; //DECA BEEF
    NN_LOG("%08X\n",deviceIdHash);

    deviceIdHash = nn::socket::NtoHl(deviceIdHash);
    NN_LOG("%08X\n",deviceIdHash);

    char deviceIdHashStr[10];
    memset(deviceIdHashStr, 0x00, sizeof(deviceIdHashStr));
    sprintf(deviceIdHashStr, "%08X", deviceIdHash);

    // 炩SD烍[hlƁAۂɎ擾lr
    if ( 0 != strncmp(m_DeviceIdHash.c_str(), deviceIdHashStr, 8))
    {
        return LogResultCode::IDENTIFY_FAILURE;
    }

    return LogResultCode::SUCCESS;
}



