/************************************************************************

FLOWERȍ~̂ݒǉ錟̔胉bp[

 *************************************************************************/
#ifndef __TEST_WRAPPING_H_INCLUDED__
#define __TEST_WRAPPING_H_INCLUDED__

#include "sys.h"
#include "../eva/mcu/TestMcu.h"
#include "../eva/mcu/TestRtc.h"
#include "../eva/camera/seqCamera.h"
#include "../eva/camera/seqInCamera.h"
#include "../eva/sound/TestSound.h"
#include "../eva/gyro/gyro_EvaSampling_forF.h"
#include "../eva/TouchPanel/TestTouchPanel.h"
#include "../eva/gyro/gyro_ClientTestFunction.h"
#include "../eva/gyro/gyro_AgingTester.h"
#include "../eva/accelerator/TestAcc.h"
#include "TestResult.h"
#include "../eva/gyro/gyro_UdsClient.h"

namespace uji{
namespace eva{
namespace wrap{

    inline bool CheckTPAccuracy_LcdKey( uji::seq::TestResult &result )
    {
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType() ||
            uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType() ||
            uji::sys::PLATFORM_RED == uji::sys::GetPlatformType())
        {
            return uji::eva::TouchPanel::CheckTPAccuracy( result );
        }
        result.m_Result = true;
        return result.m_Result;
    }

    inline bool CheckTPAccuracy_ProcCheck( uji::seq::TestResult &result )
    {
        if( uji::sys::PLATFORM_CTR == uji::sys::GetPlatformType() ||
            uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
        {
            return uji::eva::TouchPanel::CheckTPAccuracy( result );
        }
        result.m_Result = true;
        return result.m_Result;
    }

    inline bool StickTest( uji::seq::TestResult &result )
    {
        return uji::eva::forF::StickTest( result );
    }

    inline bool GyroInit( uji::seq::TestResult &result )
    {
        uji::seq::Config config;
        if( config.Get().TestMode == uji::seq::pl::LINE )
        {
            return uji::eva::gyroC::Initialize( result );
        }
        return result.m_Result = true;
    }

    inline bool GyroCalibMotionLess( uji::seq::TestResult &result )
    {
        uji::seq::Config config;
        if( config.Get().TestMode == uji::seq::pl::LINE )
        {
            bool testRet;

            uji::eva::GyroUdsClient* gc = new GyroUdsClient;
            gc->Initialize();

            uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();
            uji::sys::JpegDrawer* jpegDrawer = new uji::sys::JpegDrawer;
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            jpegDrawer->OpenPicture(L"rom:/jpeg/Put.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->SwapBuffers();

            testRet = uji::eva::gyroC::Calibrate_TTRotMotionless( result );

            jpegDrawer->ClosePicture();
            delete jpegDrawer;

            gc->Finalize();
            delete gc;

            return testRet;

        }
        return result.m_Result = true;
    }

    inline bool GyroSetCal( uji::seq::TestResult &result )
    {
        uji::seq::Config config;
        if( config.Get().TestMode == uji::seq::pl::LINE )
        {
            return uji::eva::gyroC::SetCal( result );
        }
        return result.m_Result = true;

    }

    inline bool GyroAgingTest( uji::seq::TestResult &result )
    {
        uji::seq::Config config;
        if( config.Get().TestMode == uji::seq::pl::LINE )
        {
            return uji::eva::acc::GyroAgingTest( result );
        }
        return result.m_Result = true;
    }


    inline bool GyroWriteSDLog( uji::seq::TestResult &result )
    {
        uji::seq::Config config;
        if( config.Get().TestMode == uji::seq::pl::LINE )
        {
            return uji::eva::gyroC::WriteSDLog( result );
        }
        return result.m_Result = true;
    }


    inline bool GyroWriteOkLog( uji::seq::TestResult &result )
    {
        return uji::eva::gyroC::WriteProductionLogOK( result );
    }

    inline bool SetSPConfig( uji::seq::TestResult &result )
    {
        uji::seq::Config config;

#if EVA_SLIDEPAD_AUTO
        // LtOtruełCTȐꍇ͎@Ȃ̂ŋIɎ蓮p[^ɂ
        if( uji::sys::GetPlatformType() == uji::sys::PLATFORM_CTR ) {
        config.SetAlternative().SamplingLapTime = 3000;
        config.SetAlternative().SamplingRound = 3;
        }else{
        config.SetAlternative().SamplingLapTime = 1005;
        config.SetAlternative().SamplingRound = 2;
        }
#else
        config.SetAlternative().SamplingLapTime = 3000;
        config.SetAlternative().SamplingRound = 3;
#endif

        result.m_Result = true;
        return result.m_Result;
    }

    inline bool SetSPAndTPAutoConfig( uji::seq::TestResult &result )
    {
        uji::seq::Config config;

        config.SetAlternative().SamplingLapTime = 995;
        config.SetAlternative().SamplingRound = 2;
        config.SetAlternative().TpCalRetry = 0;
        config.SetAlternative().TpCalCheckRetry = 0;
        config.SetAlternative().TpCalAutoMode = true;

        result.m_Result = true;
        return result.m_Result;
    }

    inline bool SetSPAndTPManualConfig( uji::seq::TestResult &result )
    {
        uji::seq::Config config;

        config.SetAlternative().SamplingLapTime = 3000;
        config.SetAlternative().SamplingRound = 3;
        config.SetAlternative().TpCalRetry = 3;
        config.SetAlternative().TpCalCheckRetry = 2;
        config.SetAlternative().TpCalAutoMode = false;

        result.m_Result = true;
        return result.m_Result;
    }


}
}
}

#endif
