/************************************************************************
V[PT
 *************************************************************************/

/* dCN[h̉ */
#ifndef TESTSEQUENCER_H_INCLUDED
#define TESTSEQUENCER_H_INCLUDED

#include <nn.h>
#include "Config.h"
#include "TestListManager.h"
#include "TesterLog/ProductionLogViewer.h"
#include "CompositeApplicationList.h"

namespace uji{
namespace seq{

namespace drawer{
    void DrawOK();
    void DrawNG();
}

/************************************************************************
 ************************************************************************/
class TestSequencer{
  public:
      TestSequencer():m_IsNgLogEnable(false)
    {
        m_TestListManager = new TestListManager;
        m_Config = new Config;

        //ʐpCX^X쐬iƃCX^X܂j
        if( m_TestResultManager==0 )
        {
            m_TestResultManager= new TestResultManager;
        }
    }

    ~TestSequencer()
    {
        delete m_Config;
        delete m_TestListManager;
    }
    
    void  SetCurrentTest(int id) //eXgIDݒ
    {
        m_CurrentTest = id; 
    }

    void Initialize();
    void OpenMenu();
    void Execute();
    void EnableNgLog(){ m_IsNgLogEnable=true; }
    void DesableNgLog(){ m_IsNgLogEnable=false;}

    void OpenLogMenu();       // product.log
    void OpenInspectLogMenu();// inspect.log

    static uji::seq::TestResultManager  *m_TestResultManager;   //eXgʃ}l[W

    // JBe摜ۑHeapp
    u8 *CAM_BUF;

  private:
    bool Execute1Sequence();
    bool SpecialHandlingFlagOnReboot();
    void ShowTesterStatus();
    void ShowInformation();
    void ShowErrorMessage();
    u32  ShowCompositeApplicationList(CompositeApplicationList* list, const s32 listNum);
    int  CalcActiveSequenceLength();
    void Draw(void);
    void AddNgLog(void);
    bool OutputTestResult(bool judge, uji::sys::TextWindow *textWindow);//IŘʏo
    
    // ShowCompositeApplicationList֐p
    void SCAL_GetProductionLogInformation(CompositeApplicationList* list, const s32 listNum);
    void SCAL_DrawDisplay0(uji::sys::GraphicsDrawing *gfx, CompositeApplicationList* list, const s32 listNum);
    void SCAL_DrawDisplay1(uji::sys::GraphicsDrawing *gfx);
    void SCAL_SetCursor1stPos(CompositeApplicationList* list, const s32 listNum);
    void SCAL_GetRemainingBatteryLv();
    void SCAL_InputKey(uji::sys::Pad& pad, const s32 listNum);

    int                 m_SequenceLength;           //V[PX̒
    int                 m_AgingCount;               //G[WO
    int                 m_Progress;                 //V[PX̐is
    int                 m_CurrentTest;              //݂̃eXgێ
    nn::os::Tick::Tick  m_StartTick;                //Jn̂shbj

    uji::seq::TestListManager           *m_TestListManager;     //eXgXg}l[W
    uji::seq::Config                    *m_Config;              //RtBO
    uji::sys::TextWindow                *m_Window;              //\pEChE
    uji::sys::TextWindow                *m_CamWindow;              //\pEChE

    bool m_IsNgLogEnable;
    char m_SpecialNgMessage[0x80];

    //InspectLog
    void Export_InspectLog();

    //ProductLog
    void Open_LogFSMenu();
    void Export_ProductLog();
    void ExtractCpuBoard(void);

    //PortChecker
    void RunPortChecker(void);

    //ʐMj[
    void OpenCommMenu(void);
};

} // namespace seq
} // namespace uji
/* dCN[h̉ */
#endif
