/**************************************************************************
ʍ\`ƕtNX
 *************************************************************************/
#include <nn.h>
#include "sys.h"
#include "../sys/sys_ShowMessage.h"
#include "Coordinate.h"
#include "TestList.h"
#include "TestResult.h"

using namespace uji::sys;
using namespace uji::seq;

const Coordinate<int> MORE_LOCATE(30,13);
const int NUM_INITIAL_INDICATE = 6;

/************************************************************************
 ************************************************************************/
void TestResultManager::ClearAllRecords(void)
{
    m_TestResultVector.clear();    
}

TestResult& TestResultManager::AllocateOneRecord(void)
{
    TestResult initial;
    m_TestResultVector.push_back(initial);
    return m_TestResultVector.back();
}

void TestResultManager::ShowRecords(void)
{
    //L^Ȃꍇ̏
    if( m_TestResultVector.size()==0 )
    {
		ShowMessage::Open( &Menu::m_WindowManager, "No record" );
		return;
    }

	uji::sys::Pad pad;

	const int FONT_SIZE = 14;
	TextWindow *window = new TextWindow( GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2), GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE, FONT_SIZE );
	window->SetTitle( "ERROR LOG" );
	uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
	Menu::m_WindowManager.CreateWindow(window, NN_GX_DISPLAY0,0,0 );    


	TestResultString *str = new TestResultString;
   	std::vector<TestResult>::iterator it;
    bool isDraw = true;

    it=m_TestResultVector.begin();
    str->Initialize( window, it->m_String );
    do{
		//pbhXV
		pad.UpdatePad();

		//{^ɂ郌R[hړ
        if( pad.IsButtonRepeat( Pad::BUTTON_RIGHT ) )
        {
            it++;
            if( it >= m_TestResultVector.end() ) it=m_TestResultVector.begin();
            str->Initialize( window, it->m_String );
            isDraw=true;
        }

        if( pad.IsButtonRepeat( Pad::BUTTON_LEFT ) )
        {
            it--;
            if( it < m_TestResultVector.begin() ) it=m_TestResultVector.end()-1;
            str->Initialize( window, it->m_String );
            isDraw=true;
        }

        if( isDraw )
        {
            //hcƌ̕\
            window->Printf( "\f[%02d-%03d] %-24s\n",
                it->m_TestList->m_Id.m_Major, it->m_TestList->m_Id.m_Minor, it->m_TestList->m_Name );

            //
            window->Printf( "Result:%s", (it->m_Result)?"PASS":"FAIL" );
            window->Printf( " %02d-%03d-%03d\n",
                it->m_TestList->m_Id.m_Major, it->m_TestList->m_Id.m_Minor, it->m_Micro ); 

            //bZ[W
            window->Printf( "MESSAGE:\n" );
            str->ShowInitialLines();

            isDraw=false;
        }
        if( pad.IsButtonRepeat( Pad::BUTTON_A ) ) str->ShowAndForwardOneLine();
        str->ShowMore();


		// `揈
        //EChE
		Menu::m_WindowManager.Update();
        Menu::m_WindowManager.UpdatePad(pad);        

        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
        // ʕ`        
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);        
    }
    while( !pad.IsButtonRepeat(Pad::BUTTON_B) );

	pad.ClearTriggerFlag();

    delete str;
	Menu::m_WindowManager.DestroyWindow(window);
	window->Destroy();
	delete window;

}

TestResult& TestResultManager::GetLastRecord(void)
{
    return m_TestResultVector.back();
}

/************************************************************************
 ************************************************************************/


void TestResultString::Initialize( TextWindow *Window, const char *String)
{
    m_Window = Window;
    m_String = String;
    m_Caret = String;
}

void TestResultString::ShowInitialLines(void)
{
    for( int i=0 ; i<NUM_INITIAL_INDICATE ; i++ )
    {
        ShowAndForwardOneLine();
    }
}

void TestResultString::ShowAndForwardOneLine(void)
{
    while( *m_Caret!='\n' && *m_Caret!='\0' )
    {
        m_Window->Printf( "%c",  *m_Caret );
        m_Caret++;
    }
    if( *m_Caret=='\n' )
    {
        m_Window->Printf( "\n" );
        m_Caret++;
    }
}


bool TestResultString::HasReachLast(void) const
{
    return ( *m_Caret == '\0' )?true:false;
}


void TestResultString::ShowMore(void) const
{
    ATTR_TEXT_COLOR attr = m_Window->GetTextColor();
	Point xy = m_Window->Getxy();


	m_Window->SetTextColor( ATTR_COLOR_GREEN );
	m_Window->Gotoxy( MORE_LOCATE.x, MORE_LOCATE.y );
	m_Window->Printf(  HasReachLast()?"      ":"<MORE>" );

	m_Window->Gotoxy( xy.x, xy.y );
	m_Window->SetTextColor( attr );
}

void TestResultString::ShowArrow(void) const
{
    ATTR_TEXT_COLOR attr = m_Window->GetTextColor();
	Point xy = m_Window->Getxy();

	m_Window->SetTextColor( ATTR_COLOR_GREEN );
    m_Window->Printf( HasReachLast()?"  ":">>");

	m_Window->Gotoxy( xy.x, xy.y );
	m_Window->SetTextColor( attr );
}
