/************************************************************************

eXgXgǗ

 *************************************************************************/


/* dCN[h̉ */
#ifndef TESTLISTMANAGER_H_INCLUDED
#define TESTLISTMANAGER_H_INCLUDED

#include <vector>
#include "../sys/sys.h"
#include "TestList.h"

namespace uji{
namespace seq{

/************************************************************************
 ************************************************************************/
class TestListManager : public uji::sys::Window
{

public:
    TestListManager() : uji::sys::Window("TEST LIST",0,0)
    {
        m_CurrentTestList = g_TestListSet[0].m_List;
    }
	virtual ~TestListManager(){}
    void Change(void);							//fthɂAnm^neeݒł܂B
    bool Save(void);							//obNAbvɌnm/neeۑ܂B
	bool Load(void);							//obNAbv猟nm/nee擾܂B
	void Initialize(void);						//nm/neeftHglɖ߂܂B

	void SetCurrentTestList(int Id);			//JgeXgXgݒ肵܂B
	int  GetCheckCode(void);					//nm/nee񎯕ʗp`FbNR[h擾܂B
	int  CalcCurrentTestListLength(void);		//ݑIĂeXgXg̒擾܂B
	const char*  GetCurrentTestListName(void);	//JgeXgXg̖O擾܂B
	TestList*  GetCurrentTestList(int Offset);	//JgeXgXg擾܂B

private:
    virtual void OnDraw(uji::sys::GraphicsDrawing* gfx);
    virtual void OnUpdatePad(const uji::sys::Pad& pad);
    virtual void OnUpdate(void);

    void MakeMenuInformation(void);
	void ShowExplanation(void);
	void OpenSubMenu(void);
	int  CalcTestListQuantity(void);

	void SaveFromSubMenu(void);
	void LoadFromSubMenu(void);
	void InitializeFromSubMenu(void);

	bool	LoadFromSd(void);
	bool	SaveToSd(void);
	bool	LoadFromCard(void);
	bool	SaveToCard(void);
	bool	SaveCommon( nn::fs::FileStream *file );
	bool	LoadCommon( nn::fs::FileInputStream *ifile );

	//j[\pf[^`Ǝ
	struct MenuInformation{
	  MenuInformation( int Number, int Index ):m_Number(Number),m_Index(Index){}
	  int m_Number;
	  int m_Index;	
	};
	std::vector<MenuInformation> m_MenuInformation;

	uji::seq::TestList*   m_CurrentTestList;
	char*		m_CurrentTestListName;

    int m_Cursor;
    int m_Page;
};

} // namespace seq
} // namespace uji

/* dCN[h̉ */
#endif
