/************************************************************************

eXgXgǗ

 *************************************************************************/
#include <string.h>
#include <nn.h>
#include <nn/fs.h>
#include "TestList.h"
#include "config.h"
#include "../sys/sys.h"
#include "../sys/sys_ShowMessage.h"
#include "../seq/CalcCrc.h"
#include "SaveDataConst.h"
#include "TestListManager.h"
using namespace uji::sys;
using namespace uji::seq;

const int FONT_SIZE = 14;

const char PATH_NAME[]= UJI_SAVEARCHIVE "/uji";
const char FILE_NAME[]= UJI_SAVEARCHIVE "/uji/testlist.sav";

const char SIGNATURE[0x40]="SEQ TESTLIST" __DATE__ " " __TIME__ ;


/**************************************************************************
fthɂAnm^neeݒł܂B
 *************************************************************************/
void TestListManager::Change(void)
{
	int		id;
	int		i;
	int		pageTotal;

    m_Cursor = 0;
	m_Page   = 0;

    Config *config= new Config;

    //{^͂Ɖʂ̏
    uji::sys::Pad pad;
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    SetClientSize( Size(400,240) );
	Menu::m_WindowManager.CreateWindow(this, NN_GX_DISPLAY0,0,0 );    

	//RtBOΉ̃eXgXgK肵āA
	SetCurrentTestList( config->GetAlternative().TestList );
	MakeMenuInformation();
	pageTotal=m_MenuInformation.size();

    //j[[v
    do
    {
        //pbhXV
        pad.UpdatePad();

        // IJ[\̈ړ
		if( pad.IsButtonRepeat( Pad::BUTTON_LEFT ) || pad.IsButtonRepeat( Pad::BUTTON_L ) )
        {
			m_Page--;
			if( m_Page  < 0 ) m_Page   += pageTotal;
			m_Cursor=0;
		}
	 	if( pad.IsButtonRepeat( Pad::BUTTON_RIGHT )|| pad.IsButtonRepeat( Pad::BUTTON_R ) )
        {
	 		m_Page++;
	 		m_Page%= pageTotal;
	 		m_Cursor=0;
	 	}
		if( pad.IsButtonRepeat( Pad::BUTTON_UP ) )
        {
			m_Cursor--;
			if( m_Cursor<0 ) m_Cursor += m_MenuInformation[m_Page].m_Number;
		}
		if( pad.IsButtonRepeat( Pad::BUTTON_DOWN ) )
        {
			m_Cursor++;
			m_Cursor %= m_MenuInformation[m_Page].m_Number;
		}
		//s
        //HSMOmF͕ύXs(OFFɏoȂ悤ɂ邽)
        id = m_MenuInformation[m_Page].m_Index + m_Cursor;
        if( pad.IsButtonDown( Pad::BUTTON_A )
            && strcmp(m_CurrentTestList[id].m_Name, "CHECK HSM LOG") != 0 ) 
        {
        	id = m_MenuInformation[m_Page].m_Index + m_Cursor;
			m_CurrentTestList[id].m_Enable = !m_CurrentTestList[id].m_Enable;
		}

		//ftHglɖ߂
		if( pad.IsButtonDown( Pad::BUTTON_X ) )
        {
	    	id = m_MenuInformation[m_Page].m_Index + m_Cursor;
   			m_CurrentTestList[id].m_Enable = m_CurrentTestList[id].m_Default;
		}

		//̃y[W̗vf𔽓]
		if( pad.IsButtonDown( Pad::BUTTON_Y ) )
        {
			for( i=m_MenuInformation[m_Page].m_Index ; i<m_MenuInformation[m_Page].m_Index+m_MenuInformation[m_Page].m_Number ; i++ )
            {
				m_CurrentTestList[i].m_Enable = !m_CurrentTestList[i].m_Enable;
			}
		}
		//Tuj[\
		if( pad.IsButtonDown( Pad::BUTTON_START ) )
		{
			OpenSubMenu();
            //gKNA            
            pad.ClearTriggerFlag();            

		}
		// `揈

		//EChE
		Menu::m_WindowManager.Update();
        Menu::m_WindowManager.UpdatePad(pad);        

        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
		//\
		ShowExplanation();

        // ʕ`        
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

	Menu::m_WindowManager.DestroyWindow(this);
}

/************************************************************************
Xg烁j[ɕKvȏ쐬
 ************************************************************************/
void TestListManager::MakeMenuInformation(void)
{
    int page = 0;
	int id   = 0;
	
	int currentMajor=-1;			//΂ɂȂW[ԍĂ
	m_MenuInformation.clear();		//j[\pf[^̏

	while( m_CurrentTestList[id].m_Name != NULL ){
		
		if( m_CurrentTestList[id].m_Id.m_Major  != currentMajor ){
			//y[W擪̏
			m_MenuInformation.push_back( MenuInformation(1, id) );
			page++;
		}else{				
			//y[W擪ȊȌ
			m_MenuInformation[page-1].m_Number++;
		}		
		currentMajor = m_CurrentTestList[id].m_Id.m_Major;	
		id++;
	}
}

/************************************************************************
\
 ************************************************************************/

void TestListManager::ShowExplanation(void){
	Menu::m_SubWindow->Printf("\f");
	Menu::m_SubWindow->Printf("[USAGE]\n\n");
	Menu::m_SubWindow->Printf( " +    :Move\n" );
	Menu::m_SubWindow->Printf( " A    :Set\n" );
	Menu::m_SubWindow->Printf( " X    :Set default\n" );
	Menu::m_SubWindow->Printf( " Y    :Toggle value on this page\n" );
	Menu::m_SubWindow->Printf( " Start:Sub menu\n" );
	Menu::m_SubWindow->Printf( " B    :Exit\n");
}

/************************************************************************
  Z[uiA[JCuʂɐU蕪j
  ************************************************************************/
bool TestListManager::Save( void )
{
	if( strcmp( "sdmc:", UJI_SAVEARCHIVE )==0 )
	{
		return SaveToSd();
	}
	else if( strcmp( "data:", UJI_SAVEARCHIVE )==0 )
	{
		return SaveToCard();
	}
	else
	{
		SYS_PANIC("ILLEGAL ARCHIVE NAME" );
		return false;
	}
}

/************************************************************************
  Z[uiʕj
  ************************************************************************/
bool TestListManager::SaveCommon( nn::fs::FileStream *file )
{

	u16 readSum;
	u16 calcSum;
	nn::Result result;
	bool retValue;

	//SeXgXg̑傫
	int TestListQuantity = CalcTestListQuantity();
	int length =0;
	for( int i=0 ; i<TestListQuantity ; i++ )
	{
		for( int j=0 ; g_TestListSet[i].m_List[j].m_Name!=NULL ; j++ )
		{
			length++;
		}
	}

	//Ɨ̈m
	bool *buffer = new bool[length];
	char *readSignature = new char[sizeof(SIGNATURE)];

	//Z[uf[^쐬
	bool *ptr = buffer;
	for( int i=0 ; i<TestListQuantity ; i++ ){
		for( int j=0 ;  g_TestListSet[i].m_List[j].m_Name != NULL ; j++ ){
			*ptr++ = g_TestListSet[i].m_List[j].m_Enable;
		}
	}

	//`FbNTZ
	calcSum = CalcCheckSum( reinterpret_cast<u8 *>(buffer), length*sizeof(bool) );

	//Z[u
	file->Seek( 0, nn::fs::POSITION_BASE_BEGIN );
	if( file->Write(  SIGNATURE, sizeof(SIGNATURE) ) != sizeof(SIGNATURE) )		goto ERROR;
	if( file->Write(  buffer, length*sizeof(bool) ) != length*sizeof(bool) )	goto ERROR;
	if( file->Write(  &calcSum, sizeof(calcSum) ) != sizeof(calcSum) )			goto ERROR;

	//xt@C
	file->Seek( 0, nn::fs::POSITION_BASE_BEGIN );
	if( file->Read( readSignature, sizeof(SIGNATURE) ) != sizeof(SIGNATURE) )	goto ERROR;
	if( strcmp( SIGNATURE, readSignature ) != 0 )								goto ERROR;
	if( file->Read( buffer, length*sizeof(bool) ) != length*sizeof(bool) )		goto ERROR;

	//`FbNTZ
	if( file->Read( &readSum, sizeof(readSum) )!= sizeof(readSum) )				goto ERROR;
	if( readSum !=calcSum )														goto ERROR;
	calcSum = CalcCheckSum( reinterpret_cast<u8 *>(buffer), length*sizeof(bool) );
	if( readSum !=calcSum )														goto ERROR;

	//܂ł琬
PASS:
	delete[] buffer;
	delete[] readSignature;
	return true;
	
ERROR:
	delete[] buffer;
	delete[] readSignature;
	return false;
}


/************************************************************************
  rcJ[hփZ[u
  ************************************************************************/
bool TestListManager::SaveToSd( void )
{
	nn::fs::FileStream file;
	nn::Result result;
	bool retValue;

	//I[v
	if( !nn::fs::IsSdmcInserted() ) return false;
	if( nn::fs::MountSdmc().IsFailure() ) return false;

	nn::fs::TryCreateDirectory( PATH_NAME );	//sĂ
	result = file.TryInitialize( FILE_NAME,		nn::fs::OPEN_MODE_READ   | 
                                                nn::fs::OPEN_MODE_WRITE  | 
                                                nn::fs::OPEN_MODE_CREATE );
	if( result.IsSuccess()  ){
		retValue = SaveCommon( &file );
		file.Finalize();
	}else{
		retValue = false;
	}

	nn::fs::Unmount("sdmc:");
	return retValue;
}

/************************************************************************
  bsqJ[hփZ[u
  ************************************************************************/
bool TestListManager::SaveToCard( void )
{
	nn::fs::FileStream file;
	nn::Result result;
	bool retValue;

	//}Eg
	result = nn::fs::MountSaveData();
    if (result.IsFailure())
    {
	    if( result <= nn::fs::ResultNotFormatted()  ||
            result <= nn::fs::ResultBadFormat()     ||
            result <= nn::fs::ResultVerificationFailed() )
	    {
		    result = nn::fs::FormatSaveData( SAVE_DATA_MAX_FILES, SAVE_DATA_MAX_DIRECTORIES );
		    if( result.IsFailure()  ) return false;
		    result = nn::fs::MountSaveData();
		    if( result.IsFailure()  ) return false;
	    }
        else
        {
            return false;
        }        
    }

	//I[v
	nn::fs::TryCreateDirectory( PATH_NAME );	//sĂ
	result = file.TryInitialize( FILE_NAME,		nn::fs::OPEN_MODE_READ   | 
                                                nn::fs::OPEN_MODE_WRITE  | 
                                                nn::fs::OPEN_MODE_CREATE );
	if( result.IsSuccess() )
	{
		retValue = SaveCommon( &file );
		file.Finalize();
	}else{
		retValue = false;
	}

	nn::fs::CommitSaveData();
	nn::fs::Unmount( "data:" );
	return retValue;
}

/************************************************************************
  [hiA[JCuʂɐU蕪j
  ************************************************************************/
bool TestListManager::Load( void )
{
	if( strcmp( "sdmc:", UJI_SAVEARCHIVE )==0 )
	{
		return LoadFromSd();
	}
	else if( strcmp( "data:", UJI_SAVEARCHIVE )==0 )
	{
		return LoadFromCard();
	}
	else
	{
		SYS_PANIC("ILLEGAL ARCHIVE NAME" );
		return false;
	}
}

/************************************************************************
  [hiʕj
  ************************************************************************/
bool TestListManager::LoadCommon( nn::fs::FileInputStream *ifile )
{
	u16 readSum;
	u16 calcSum;
	nn::Result result;
	bool retValue;
	bool *bufferPointer;

	//SeXgXg̑傫
	int TestListQuantity = CalcTestListQuantity();
	int length =0;
	for( int i=0 ; i<TestListQuantity ; i++ )
	{
		for( int j=0 ; g_TestListSet[i].m_List[j].m_Name!=NULL ; j++ )
		{
			length++;
		}
	}

	//Ɨ̈m
	bool *buffer = new bool[length];
	char *readSignature = new char[sizeof(SIGNATURE)];


	//xt@C
	if( ifile->Read( readSignature, sizeof(SIGNATURE) ) != sizeof(SIGNATURE) )	goto ERROR;
	if( strcmp( SIGNATURE, readSignature ) != 0 )								goto ERROR;
	if( ifile->Read( buffer, length*sizeof(bool) ) != length*sizeof(bool) )		goto ERROR;

	//`FbNTZ
	if( ifile->Read( &readSum, sizeof(readSum) )!= sizeof(readSum) )			goto ERROR;
	calcSum = CalcCheckSum( reinterpret_cast<u8 *>(buffer), length*sizeof(bool) );
	if( readSum !=calcSum )														goto ERROR;

	//܂ł琬

	//f[^WJ
	bufferPointer = buffer;
	for( int i=0 ; i<TestListQuantity ; i++ ){
		for( int j=0 ;  g_TestListSet[i].m_List[j].m_Name != NULL ; j++ ){
			g_TestListSet[i].m_List[j].m_Enable = *bufferPointer++;
		}
	}

PASS:
	delete[] buffer;
	delete[] readSignature;
	return true;

ERROR:
	delete[] buffer;
	delete[] readSignature;
	return false;

}

/************************************************************************
  rcJ[h烍[h
  ************************************************************************/
bool TestListManager::LoadFromSd( void )
{
	nn::fs::FileInputStream ifile;
	bool retValue;

	if( !nn::fs::IsSdmcInserted() ) return false;
	if( nn::fs::MountSdmc().IsFailure() ) return false;

	if( ifile.TryInitialize( FILE_NAME ).IsSuccess() )
	{
		retValue = LoadCommon( &ifile );
		ifile.Finalize();
	}else{
		retValue = false;
	}
	nn::fs::Unmount("sdmc:");
	return retValue;
}

/************************************************************************
  bsqJ[h烍[h
  ************************************************************************/
bool TestListManager::LoadFromCard( void )
{
    nn::Result nnResult;
	nn::fs::FileInputStream ifile;
	bool retValue;

	//}Egis̓Z[uf[^͂Ȃ̂őmfƂj
	nnResult = nn::fs::MountSaveData();
	if( nnResult.IsFailure() )
    {
        //fBAłivIG[jj
        if( nnResult <= nn::fs::ResultNotFound() )
        {
            uji::sys::Panic( "FAIL TO FIND BACKUP MEDIA!!" );
        }
        return false;
    }

	//[hI[v
	if( ifile.TryInitialize( FILE_NAME ).IsSuccess() )
	{
		retValue = LoadCommon( &ifile );
		ifile.Finalize();
	}else{
		retValue = false;
	}
	nn::fs::Unmount( "data:" );
	return retValue;
}


/************************************************************************
V[PT̃p[^
 ************************************************************************/
void TestListManager::Initialize(void)
{
    //eXgXg̐ʂvZ
	int quantity = CalcTestListQuantity();

	//Sp[^ftHglɐݒ
	for( int i=0 ; i<quantity ; i++ )
    {
		for( int j=0 ; g_TestListSet[i].m_List[j].m_Name ; j++ )
        {
			g_TestListSet[i].m_List[j].m_Enable = g_TestListSet[i].m_List[j].m_Default;
		}
	}
}

/************************************************************************
Tuj[
 ************************************************************************/
void TestListManager::OpenSubMenu(void)
{
    Window *parentWin = Menu::m_WindowManager.GetActiveWindow();

	ClassMenu *m = new ClassMenu( "SubMenu", 150, 100 );

	m->Add<TestListManager>( "Save",  		this, &TestListManager::SaveFromSubMenu );
	m->Add<TestListManager>( "Load",  		this, &TestListManager::LoadFromSubMenu );
	m->Add<TestListManager>( "Initialize",	this, &TestListManager::InitializeFromSubMenu );
	m->Open();

    delete m;

	Menu::m_WindowManager.SetActiveWindow( parentWin );    

}

/************************************************************************
Tuj[Ă΂Z[u
 ************************************************************************/
void TestListManager::SaveFromSubMenu(void)
{
	if( Save() )
	{
		ShowMessage::Open( &Menu::m_WindowManager, "Success to save" );
	}else{
		ShowMessage::Open( &Menu::m_WindowManager, "Fail to save" );
	}
}

/************************************************************************
Tuj[Ă΂郍[h
 ************************************************************************/
void TestListManager::LoadFromSubMenu(void)
{
	if( Load() )
	{
		ShowMessage::Open( &Menu::m_WindowManager, "Success to load" );
	}else{
		ShowMessage::Open( &Menu::m_WindowManager, "Fail to load" );
	}
}

/************************************************************************
Tuj[Ă΂鏉
 ************************************************************************/
void TestListManager::InitializeFromSubMenu(void)
{
	Initialize();
	ShowMessage::Open( &Menu::m_WindowManager, "INITIALIZED" );
}

/************************************************************************
Xg̐vZ
 ************************************************************************/
int TestListManager::CalcTestListQuantity(void)
{
    int i=0;
	while( g_TestListSet[i].m_Name ) i++;
	return i;
}

/************************************************************************
ݑIĂeXgXg̒擾܂B
 ************************************************************************/
int TestListManager::CalcCurrentTestListLength(void)
{
	int counter = 0;
	while( m_CurrentTestList[counter].m_Name != NULL ) counter++;
	return counter;
}

/************************************************************************
`FbNR[h擾

`FbNR[h͈́FO`XXXX
 ************************************************************************/
int TestListManager::GetCheckCode(void)
{
	int length = CalcCurrentTestListLength();
	u8 *buffer = new u8[length];

	for( int i=0 ; i<length ; i++ )
	{
		buffer[i]= m_CurrentTestList[i].m_Enable;
	}	
	u32 checkCode = CalcCrc( 0, buffer, length ) ;

	delete[] buffer;
	return (int)( checkCode%10000 );

}

/**************************************************************************
JgeXgXgݒ肵܂B
 *************************************************************************/
void TestListManager::SetCurrentTestList( int Id )
{
	//hc͈͊Oł΁AbZ[W\AOݒ肵܂B
	if( Id >= CalcTestListQuantity() )
    {
        ShowMessage::Open( &Menu::m_WindowManager, "Illegal Test List\nSet List 0" );
        Id = 0;
	}
	m_CurrentTestList 		= g_TestListSet[Id].m_List;
	m_CurrentTestListName	= g_TestListSet[Id].m_Name;
}

/**************************************************************************
JgeXgXg̖O擾܂B
 *************************************************************************/
const char *TestListManager::GetCurrentTestListName(void)
{
    return m_CurrentTestListName;
}

/**************************************************************************
JgeXgXg擾܂B

OffsetF	O@		eXgXg̐擪擾
 			ȊO	擪OffsetꂽeXgXg擾
 						Cӂ̃eXg擾邽߂Ɏgp܂B

 *************************************************************************/
TestList *TestListManager::GetCurrentTestList(int Offset=0 )
{
    return &m_CurrentTestList[Offset];
}


/************************************************************************
`揈iR[obNj
 ************************************************************************/
void TestListManager::OnDraw(uji::sys::GraphicsDrawing* gfx)
{
	int i;
	int id;

	gfx->m_TextWriter.SetFont(&gfx->m_Font);
    gfx->m_TextWriter.SetFontSize((f32)FONT_SIZE);
    gfx->m_TextWriter.EnableFixedWidth(true);
    gfx->m_TextWriter.SetFixedWidth(FONT_SIZE/2);

    //j[\ioʗṕ̓XLbvj
    gfx->m_TextWriter.SetCursor( GetClientPosition().x, GetClientPosition().y );
    gfx->m_TextWriter.SetTextColor( nn::util::Color8::WHITE );

    gfx->BeginDrawingString();

// 	gfx->m_TextWriter.Printf( "\f[%-20s]Page%d/%d\n", g_TestListSet[0].m_Name, m_Page+1, m_MenuInformation.size() );    
 	gfx->m_TextWriter.Printf( "\f[%-20s]Page%d/%d\n", g_TestListSet[uji::sys::AppTypeToTestListId(UJI_APPTYPE)].m_Name, m_Page+1, m_MenuInformation.size() );    

	//j[{̂`悷
    for( i=0 ; i<m_MenuInformation[m_Page].m_Number ; i++ )
    {
        gfx->m_TextWriter.SetCursor( GetClientPosition().x, GetClientPosition().y + (i+1)*FONT_SIZE );

		id = m_MenuInformation[m_Page].m_Index+i;				//Ώۂ̔zYZo

		//lftH[gƈႦΐFFɂ
		if( i==m_Cursor )
        {
			gfx->m_TextWriter.SetTextColor( nw::ut::Color8::RED );
		}
        else if( m_CurrentTestList[id].m_Enable != m_CurrentTestList[id].m_Default )
        {
		    gfx->m_TextWriter.SetTextColor( nw::ut::Color8::BLUE );
		}
        else
        {
		    gfx->m_TextWriter.SetTextColor( nw::ut::Color8::WHITE );
		}
        gfx->m_TextWriter.Printf( "%02d-%03d ", m_CurrentTestList[id].m_Id.m_Major, m_CurrentTestList[id].m_Id.m_Minor );	//W[}Ci[ԍ\
        gfx->m_TextWriter.Printf( "%-25s", m_CurrentTestList[id].m_Name);							//eXg\ϐ̑O̕\
		gfx->m_TextWriter.Printf( "%c\n", m_CurrentTestList[id].m_Enable?'O':'X' );
    }

    gfx->EndDrawingString();
}    


/************************************************************************
͏iR[obNj
 ************************************************************************/
void TestListManager::OnUpdatePad(const uji::sys::Pad& pad)
{
	NN_UNUSED_VAR(pad);
}

/************************************************************************
t[XViR[obNj
 ************************************************************************/
void TestListManager::OnUpdate(void)
{
}
