/*************************************************************************

 ̃Xg

TEST_LIST_DEFINE`ꂽԂł́A̒`ɂȂ܂B


 ************************************************************************/

/* dCN[h̉ */
#ifndef TESTLIST_H_INCLUDED
#define TESTLIST_H_INCLUDED

#include <nn.h>
#include "TestResult.h"
#include "TestIdDefine.h"
#include "TestSample.h"
#include "TestWrapping.h"
#include "../eva/misc/TestAttest.h"
#include "../eva/misc/TestResetSetting.h"
#include "../eva/camera/seqCamera.h"
#include "../eva/camera/seqInCamera.h"
#include "../eva/camera/TestCameraCapture.h"
#include "../eva/lcd/TestLcd.h"
#include "../eva/lcd/TestLcdTraining.h"
#include "../eva/key/TestKey.h"
#include "../eva/analogkey/TestExecuteAnalogStick.h"
#include "../eva/sound/TestSound.h"
#include "../eva/sound/NWSound.h"
#include "../eva/nand/TestNand.h"
#include "../eva/codec/TestCodec.h"
#include "../eva/gyro/gyro_MasterFunction.h"
#include "../eva/gyro/gyro_ClientTestFunction.h"
#include "../eva/gyro/gyro_AgingTester.h"
#include "../eva/gyro/gyro_EvaSampling_forF.h"
#include "../eva/mic/mic_BoardInterface.h"
#include "../eva/mic/mic_Tester.h"
#include "../eva/mcu/TestMcu.h"
#include "../eva/mcu/TestRtc.h"
#include "../eva/mcu/TestPowerOff.h"
#include "../eva/mcu/TestMcuNotification.h"
#include "../eva/misc/TestHWInfo.h"
#include "../eva/misc/TestExtractCpuBoard.h"
#include "../eva/misc/TestReentry.h"
#include "../eva/ir/TestIr.h"
#include "../eva/gpu/gpu_Eva.h"
#include "../eva/TouchPanel/TestTouchPanel.h"
#include "../eva/backlight/BackLightTest.h"
#include "../eva/sd/TestSd.h"
#include "../eva/accelerator/TestAcc.h"
#include "../eva/volume/EvaVolume.h"
#include "../eva/misc/TestWriteProductionLogSolo.h"
#include "../sec/cal/TestCal.h"
#include "../eva/procchk/ProcessCheck.h"
#include "../eva/procchk/ProcessCheck_Define.h"
#include "../eva/import/Import.h"
#include "../eva/import/TestExecuteImport.h"
#include "../eva/backup/TestBackup.h"
#include "../eva/wireless/TestMp.h"
#include "TesterLog/ProductionLogDummy.h"
#include "TesterLog/ProductionLogTestFunc.h"

#include "../eva/aging/AgingSequencer.h"
#include "../eva/aging/AgingImporter.h"
#include "../eva/ai/ApplicationImporter.h"
#include "../eva/accelerator/WaitButtonR.h"
#include "../eva/wifi/TestEepRom.h"
#include "../eva/wifi/TestWifi.h"
#include "../eva/wifi/TestMitsumiWifi.h"


namespace uji{
namespace seq{


//̔ԍi[\
struct TestId{
    int m_Major;    //W[ԍ
    int m_Minor;    //}Ci[ԍ
};

//e̐isɕKvȏi[\
struct TestList{
    //[Uݒ蕔
    char*   m_Name;                 //̖
    TestId  m_Id;                   //̂hc
    bool    (*m_Function)( uji::seq::TestResult &testResult );  //s錟֐
    bool    m_Default;              //ftH[gŌ邩Ȃ

    //vOݒ蕔iڐGȂŁIIj
    bool    m_Enable;               //邩Ȃ
    bool    Padding[2];
};

//eXg̏i[\
struct TestListInformation{
    char*       m_Name; //̂OȂ烊XgIłB
    TestList*   m_List; //eڃXg

};

} // namespace seq
} // namespace uji

extern uji::seq::TestListInformation g_TestListSet[];

#ifdef TEST_LIST_DEFINE
//^C^[tF[XƂ̒ʐMŎgp錟R[hƃ^CgE֐̑Ή\ƂĎgp
extern uji::seq::TestList CheckerList[] = {
    { "ATTEST",                 {G_ATTEST, TID_ATTEST},                     uji::eva::TestAttest                    },
    { "ATTEST NG",              {G_ATTEST, TID_ATTEST_NG},                  uji::eva::TestAttestNg                  },
    { "GET PROGRAM VERSION",    {G_ATTEST, TID_GET_PROGRAM_VERSION},        uji::eva::TestGetProgramVersion         },
    { "GET UID",                {G_HWINFO, TID_GET_UID},                    uji::eva::TestGetUid                    },
    { "GET MAC ADDRESS",        {G_HWINFO, TID_GET_MAC_ADDRESS},            uji::eva::TestGetMacAddress             },

    { "PLAY SOUND I2S2",        {G_SOUND,  TID_SOUND_PLAY_I2S2},            uji::eva::sound::TestPlaySoundI2S2      },
    { "PLAY SOUND I2S2 NEC",    {G_SOUND,  TID_SOUND_PLAY_I2S2_NEC},        uji::eva::sound::TestPlaySoundI2S2_NEC  },
    { "STOP SOUND I2S2",        {G_SOUND,  TID_SOUND_FINALIZE_CDC_HWCHK2},  uji::eva::sound::TestStopSoundI2S2      },
    { "PLAY SOUND I2S1",        {G_SOUND,  TID_SOUND_PLAY_I2S1},            uji::eva::sound::TestPlaySoundI2S1      },
    { "PLAY SOUND I2S1 NEC",    {G_SOUND,  TID_SOUND_PLAY_I2S1_NEC},        uji::eva::sound::TestPlaySoundI2S1_NEC  },
    { "STOP SOUND I2S1",        {G_SOUND,  TID_SOUND_FINALIZE_CDC_HWCHK1},  uji::eva::sound::TestStopSoundI2S1      },
    { "OUTPUT SPEAKER R",       {G_SOUND,  TID_SOUND_SPEAKER_R},            uji::eva::sound::TestOutputSpeakerR     },
    { "OUTPUT SPEAKER R VOLUP", {G_SOUND,  TID_SOUND_SPEAKER_R_VOLUP},      uji::eva::sound::TestOutputSpeakerRVolUp },
    { "DELETE INSTANCE2",       {G_SOUND,  TID_SOUND_DELETE_INSTANCE2},     uji::eva::sound::TestDeleteInstance2    },
    { "OUTPUT SPEAKER L",       {G_SOUND,  TID_SOUND_SPEAKER_L},            uji::eva::sound::TestOutputSpeakerL     },
    { "OUTPUT SPEAKER L VOLUP", {G_SOUND,  TID_SOUND_SPEAKER_L_VOLUP},      uji::eva::sound::TestOutputSpeakerLVolUp },
    { "DELETE INSTANCE1",       {G_SOUND,  TID_SOUND_DELETE_INSTANCE1},     uji::eva::sound::TestDeleteInstance1    },
    { "WAIT JACK INSERT",  {G_SOUND_TEMP,  TID_SOUND_WAIT_JACK_INSERT},     uji::eva::sound::TestWaitJackInsert     },
    { "WAIT JACK PULLOUT", {G_SOUND_TEMP,  TID_SOUND_WAIT_JACK_PULLOUT},    uji::eva::sound::TestWaitJackPullout    },

    { "REMOTE KEY",                         {G_KEY,    TID_REMOTE_KEY},                     uji::eva::key::TestRemoteKey            },
    { "DIGITAL KEY TEST",                   {G_KEY,    TID_KEY_DIGITAL },                   uji::eva::TestDigitalKey                },
    { "DIGITAL KEY TEST NEC",               {G_KEY,    TID_KEY_DIGITAL_NEC },               uji::eva::TestDigitalKey_NEC                },
    { "DIGITAL KEY PUSH TEST UP",           {G_KEY,    TID_KEY_DIGITAL_PUSH_UP },           uji::eva::TestDigitalKey_Push_Up            },
    { "DIGITAL KEY RELEASE TEST UP",        {G_KEY,    TID_KEY_DIGITAL_RELEASE_UP },        uji::eva::TestDigitalKey_Release_Up         },
    { "DIGITAL KEY PUSH TEST LEFT UP",      {G_KEY,    TID_KEY_DIGITAL_PUSH_LEFT_UP },      uji::eva::TestDigitalKey_Push_Left_Up       },
    { "DIGITAL KEY RELEASE TEST LEFT UP",   {G_KEY,    TID_KEY_DIGITAL_RELEASE_LEFT_UP },   uji::eva::TestDigitalKey_Release_Left_up    },
    { "DIGITAL KEY PUSH TEST LEFT",         {G_KEY,    TID_KEY_DIGITAL_PUSH_LEFT },         uji::eva::TestDigitalKey_Push_Left          },
    { "DIGITAL KEY RELEASE TEST LEFT",      {G_KEY,    TID_KEY_DIGITAL_RELEASE_LEFT },      uji::eva::TestDigitalKey_Release_Left       },
    { "DIGITAL KEY PUSH TEST LEFT DOWN",    {G_KEY,    TID_KEY_DIGITAL_PUSH_LEFT_DOWN },    uji::eva::TestDigitalKey_Push_Left_Down     },
    { "DIGITAL KEY RELEASE TEST LEFT DOWN", {G_KEY,    TID_KEY_DIGITAL_RELEASE_LEFT_DOWN }, uji::eva::TestDigitalKey_Release_Left_Down  },
    { "DIGITAL KEY PUSH TEST DOWN",         {G_KEY,    TID_KEY_DIGITAL_PUSH_DOWN },         uji::eva::TestDigitalKey_Push_Down          },
    { "DIGITAL KEY RELEASE TEST DOWN",      {G_KEY,    TID_KEY_DIGITAL_RELEASE_DOWN },      uji::eva::TestDigitalKey_Release_Down       },
    { "DIGITAL KEY PUSH TEST DOWN RIGHT",   {G_KEY,    TID_KEY_DIGITAL_PUSH_DOWN_RIGHT },   uji::eva::TestDigitalKey_Push_Down_Right    },
    { "DIGITAL KEY RELEASE TEST DOWN RIGHT",{G_KEY,    TID_KEY_DIGITAL_RELEASE_DOWN_RIGHT },uji::eva::TestDigitalKey_Release_Down_Right },
    { "DIGITAL KEY PUSH TEST RIGHT",        {G_KEY,    TID_KEY_DIGITAL_PUSH_RIGHT },        uji::eva::TestDigitalKey_Push_Right         },
    { "DIGITAL KEY RELEASE TEST RIGHT",     {G_KEY,    TID_KEY_DIGITAL_RELEASE_RIGHT },     uji::eva::TestDigitalKey_Release_Right      },
    { "DIGITAL KEY PUSH TEST RIGHT UP",     {G_KEY,    TID_KEY_DIGITAL_PUSH_RIGHT_UP },     uji::eva::TestDigitalKey_Push_Right_Up      },
    { "DIGITAL KEY RELEASE TEST RIGHT",     {G_KEY,    TID_KEY_DIGITAL_RELEASE_RIGHT_UP },  uji::eva::TestDigitalKey_Release_Right_Up   },
    { "DIGITAL KEY PUSH TEST SELECT",       {G_KEY,    TID_KEY_DIGITAL_PUSH_SELECT },       uji::eva::TestDigitalKey_Push_Select        },
    { "DIGITAL KEY RELEASE TEST SELECT",    {G_KEY,    TID_KEY_DIGITAL_RELEASE_SELECT },    uji::eva::TestDigitalKey_Release_Select     },
    { "DIGITAL KEY PUSH TEST START",        {G_KEY,    TID_KEY_DIGITAL_PUSH_START },        uji::eva::TestDigitalKey_Push_Start         },
    { "DIGITAL KEY RELEASE TEST START",     {G_KEY,    TID_KEY_DIGITAL_RELEASE_START },     uji::eva::TestDigitalKey_Release_Start      },
    { "DIGITAL KEY PUSH TEST X",            {G_KEY,    TID_KEY_DIGITAL_PUSH_X },            uji::eva::TestDigitalKey_Push_X             },
    { "DIGITAL KEY RELEASE TEST X",         {G_KEY,    TID_KEY_DIGITAL_RELEASE_X },         uji::eva::TestDigitalKey_Release_X          },
    { "DIGITAL KEY PUSH TEST Y",            {G_KEY,    TID_KEY_DIGITAL_PUSH_Y },            uji::eva::TestDigitalKey_Push_Y             },
    { "DIGITAL KEY RELEASE TEST Y",         {G_KEY,    TID_KEY_DIGITAL_RELEASE_Y },         uji::eva::TestDigitalKey_Release_Y          },
    { "DIGITAL KEY PUSH TEST B",            {G_KEY,    TID_KEY_DIGITAL_PUSH_B },            uji::eva::TestDigitalKey_Push_B             },
    { "DIGITAL KEY RELEASE TEST B",         {G_KEY,    TID_KEY_DIGITAL_RELEASE_B },         uji::eva::TestDigitalKey_Release_B          },
    { "DIGITAL KEY PUSH TEST A",            {G_KEY,    TID_KEY_DIGITAL_PUSH_A },            uji::eva::TestDigitalKey_Push_A             },
    { "DIGITAL KEY RELEASE TEST A",         {G_KEY,    TID_KEY_DIGITAL_RELEASE_A },         uji::eva::TestDigitalKey_Release_A          },
    { "DIGITAL KEY PUSH TEST R",            {G_KEY,    TID_KEY_DIGITAL_PUSH_R },            uji::eva::TestDigitalKey_Push_R             },
    { "DIGITAL KEY RELEASE TEST R",         {G_KEY,    TID_KEY_DIGITAL_RELEASE_R },         uji::eva::TestDigitalKey_Release_R          },
    { "DIGITAL KEY PUSH TEST L",            {G_KEY,    TID_KEY_DIGITAL_PUSH_L },            uji::eva::TestDigitalKey_Push_L             },
    { "DIGITAL KEY RELEASE TEST L",         {G_KEY,    TID_KEY_DIGITAL_RELEASE_L },         uji::eva::TestDigitalKey_Release_L          },
    { "HOME BUTTON TEST",                   {G_KEY,    TID_KEY_HOME },                      uji::eva::mcu::HomeButtonTest           },
    { "WIFI BUTTON TEST",                   {G_KEY,    TID_KEY_WIFI_SIMPLE },               uji::eva::mcu::WifiButtonSimpleTest     },
    { "MIC POWER ON",                       {G_MIC, TID_MIC_POWER_OM},                      uji::eva::mic::TestPowerOn              },
    { "MIC POWER OFF",                      {G_MIC, TID_MIC_POWER_OFF},                     uji::eva::mic::TestPowerOff             },
    { "MIC SAMPLING SILENT",                {G_MIC, TID_MIC_SAMPLING_SILENT},               uji::eva::mic::TestSamplingSilent       },
    { "MIC SAMPLING FALSE SIGNAL",          {G_MIC, TID_MIC_SAMPLING_FALSE_SIGNAL},         uji::eva::mic::TestSamplingFalseSignal  },

    { "CAMERA OPENCHECK ICAM",  {G_CAMERA, TID_CAMERA_OPENCHECK_ICAM},      uji::eva::camera::TestOpencheckICAM     },
    { "CAMERA OPENCHECK OCAM1", {G_CAMERA, TID_CAMERA_OPENCHECK_OCAM1},     uji::eva::camera::TestOpencheckOCAM1    },
    { "CAMERA OPENCHECK OCAM2", {G_CAMERA, TID_CAMERA_OPENCHECK_OCAM2},     uji::eva::camera::TestOpencheckOCAM2    },
    { "CAMERA GET ALL ID",      {G_CAMERA, TID_CAMERA_GET_ALL_ID},          uji::eva::camera::TestCameraGetAllId    },

    { "CAMERA ATTEST",          {G_CAMERA, TID_CAMERA_ATTEST},              uji::eva::TestAttest                    },
    { "CAMERA LOG START",       {G_CAMERA, TID_CAMERA_LOG_START},           uji::eva::camera::TestCameraLogStart    },
    { "CAMERA LOG PASS",        {G_CAMERA, TID_CAMERA_LOG_PASS},            uji::eva::camera::TestCameraLogPass     },
    { "CAMERA GET ID",          {G_CAMERA, TID_CAMERA_GET_ID},              uji::eva::camera::TestCameraGetId       },
    { "CAMERA GET VERSION",     {G_CAMERA, TID_CAMERA_GET_VERSION},         uji::eva::camera::GetProgramVersion     },
    { "CAMERA INITIALIZE",      {G_CAMERA, TID_CAMERA_INITIALIZE},          uji::eva::camera::TestInitialize        },
    { "CAMERA GET MAC",         {G_CAMERA, TID_CAMERA_GET_MAC},             uji::eva::camera::TestGetMacAddress     },

    { "CAMERA WB CAL",          {G_CAMERA, TID_CAMERA_WB_CAL},              uji::eva::camera::TestWbCal             },
    { "CAMERA SELECT",          {G_CAMERA, TID_CAMERA_SELECT},              uji::eva::camera::TestSelect            },
    { "CAMERA CAPTURE",         {G_CAMERA, TID_CAMERA_CAPTURE},             uji::eva::camera::TestCapture           },
    { "CAMERA CAPTURE AVERAGE", {G_CAMERA, TID_CAMERA_CAPTURE_AVERAGE},     uji::eva::camera::TestCaptureAverage    },
    { "CAMERA SEND",            {G_CAMERA, TID_CAMERA_SEND},                uji::eva::camera::TestSend              },
    { "CAMERA SEND EXTRA",      {G_CAMERA, TID_CAMERA_SEND_EXTRA},          uji::eva::camera::TestSendExtra         },
    { "CAMERA SEND BMP",        {G_CAMERA, TID_CAMERA_SEND_BMP},            uji::eva::camera::TestSendBmp           },
    { "CAMERA SAVE",            {G_CAMERA, TID_CAMERA_SAVE},                uji::eva::camera::TestSave              },
    { "CAMERA SET CAPTURE CNT", {G_CAMERA, TID_CAMERA_SET_CAPTURE_COUNT},   uji::eva::camera::TestSetCaptureCount   },

    { "CAMERA EXTRA FUNC 0",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC0},         uji::eva::camera::TestCameraExtraFunc0  },
    { "CAMERA EXTRA FUNC 1",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC1},         uji::eva::camera::TestCameraExtraFunc1  },
    { "CAMERA EXTRA FUNC 2",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC2},         uji::eva::camera::TestCameraExtraFunc2  },
    { "CAMERA EXTRA FUNC 3",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC3},         uji::eva::camera::TestCameraExtraFunc3  },
    { "CAMERA EXTRA FUNC 4",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC4},         uji::eva::camera::TestCameraExtraFunc4  },
    { "CAMERA EXTRA FUNC 5",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC5},         uji::eva::camera::TestCameraExtraFunc5  },
    { "CAMERA EXTRA FUNC 6",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC6},         uji::eva::camera::TestCameraExtraFunc6  },
    { "CAMERA EXTRA FUNC 7",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC7},         uji::eva::camera::TestCameraExtraFunc7  },
    { "CAMERA EXTRA FUNC 8",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC8},         uji::eva::camera::TestCameraExtraFunc8  },
    { "CAMERA EXTRA FUNC 9",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC9},         uji::eva::camera::TestCameraExtraFunc9  },

    { "CAMERA SET CAL",         {G_CAMERA, TID_CAMERA_SET_CAL},             uji::eva::camera::TestCameraSetCal      },

    { "SD CARD WP",             {G_SD,     TID_SD_WRITE_PROTECT},           uji::eva::sd::TestSd::WriteProtect      },
    { "NO SD CARD",             {G_SD,     TID_SD_NO_SDCARD},               uji::eva::sd::TestSd::IsNotInsertedCard },
    { "SD READWRITE",           {G_SD,     TID_SD_READWRITE},               uji::eva::sd::TestSd::ReadWriteTest     },

    { "GET NAND CID PRV",    {G_NAND_TEST, TID_NAND_GET_CID_PRV},           uji::eva::nand::TestGetNandCidPrv       },

    { "GET CODEC VER",          {G_CODEC,  TID_CODEC_GET_VERSION},          uji::eva::codec::TestGetCodecVer        },
    { "TEST ANALOG KEY",        {G_CODEC,  TID_CODEC_TEST_ANALOG_KEY},      uji::eva::codec::TestAnalogKey          },
    { "TEST TOUCH PANEL",       {G_CODEC,  TID_CODEC_TEST_TOUCH_PANEL},     uji::eva::codec::TestTouchPanel         },

    { "WRITE START LOG",        {G_LOG,    TID_LOG_WRITE_START_LOG },       uji::seq::pl::ProductionLogTestFunc::Invoke_WriteStartLog }, //31-001
    { "WRITE OK LOG",           {G_LOG,    TID_LOG_WRITE_OK_LOG },          uji::seq::pl::ProductionLogTestFunc::Invoke_WriteOKLog },    //31-002
    { "WRITE EMS LABEL LOG",    {G_LOG,    TID_LOG_WRITE_EMS_LABEL_LOG },   uji::seq::pl::ProductionLogTestFunc::Invoke_WriteEMSLabelLog }, //31-014

    { "GYRO GET PRY",           {G_GYRO,   TID_GYRO_C_GET_PRY},             uji::eva::gyroC::GetPry,                },

    { "GET MGIC VER",           {G_MCU,   TID_MGIC_GET_VERSION},            uji::eva::mcu::GetMgicVersion,          },    // 35-001
    { "GET PMIC VER",           {G_MCU,   TID_PMIC_GET_VERSION},            uji::eva::mcu::GetPmicVersion,          },    // 35-002
    { "GET MCU VER",            {G_MCU,   TID_MCU_GET_VERSION},             uji::eva::mcu::GetMcuVersion,           },    // 35-003
    { "GET CONSOLE TYPE",       {G_MCU,   TID_MCU_GET_CONSOLE_TYPE},        uji::eva::mcu::GetConsoleType,          },    // 35-004
    { "GET BATTERY TYPE",       {G_MCU,   TID_MCU_GET_BATTERY_TYPE},        uji::eva::mcu::GetBatteryType,          },    // 35-005
    { "GET BATTERY TEMP",       {G_MCU,   TID_MCU_GET_BATTERY_TEMP},        uji::eva::mcu::GetBatteryTemp,          },    // 35-006
    { "GET VCELL BOARD",        {G_MCU,   TID_MCU_GET_VCELL_BOARD},         uji::eva::mcu::GetVcellBoard,           },    // 35-007
    { "GET BATTERY REMAIN",     {G_MCU,   TID_MCU_BATTERY_REMAIN_BOARD},    uji::eva::mcu::GetBatteryRemainBoard,   },    // 35-008
    { "RESET VIA MCU",          {G_MCU,   TID_MCU_RESET_VIA},               uji::eva::mcu::ResetViaMcu,             },    // 35-009
    { "SET MASTER_LED MAX",     {G_MCU,   TID_MCU_SET_MASTER_LED},          uji::eva::mcu::SetMasterLedMax,         },    // 35-010
    { "LED RED ON",             {G_MCU,   TID_MCU_LED_RED_ON},              uji::eva::mcu::PowerLedRedOn,           },    // 35-011
    { "LED RED OFF",            {G_MCU,   TID_MCU_LED_RED_OFF},             uji::eva::mcu::PowerLedRedOff,          },    // 35-012
    { "LED BLUE ON",            {G_MCU,   TID_MCU_LED_BLUE_ON},             uji::eva::mcu::PowerLedBlueOn,          },    // 35-013
    { "LED BLUE OFF",           {G_MCU,   TID_MCU_LED_BLUE_OFF},            uji::eva::mcu::PowerLedBlueOff,         },    // 35-014
    { "LED YELLOW ON",          {G_MCU,   TID_MCU_LED_YELLOW_ON},           uji::eva::mcu::WiFiLedYellowOn,         },    // 35-015
    { "LED YELLOW OFF",         {G_MCU,   TID_MCU_LED_YELLOW_OFF},          uji::eva::mcu::WiFiLedYellowOff,        },    // 35-016
    { "LED GREEN ON",           {G_MCU,   TID_MCU_LED_GREEN_ON},            uji::eva::mcu::TuneLedGreenOn,          },    // 35-017
    { "LED GREEN OFF",          {G_MCU,   TID_MCU_LED_GREEN_OFF},           uji::eva::mcu::TuneLedGreenOff,         },    // 35-018
    { "LED PINK ON",            {G_MCU,   TID_MCU_LED_PINK_ON},             uji::eva::mcu::CameraLedPinkOn,         },    // 35-019
    { "LED PINK OFF",           {G_MCU,   TID_MCU_LED_PINK_OFF},            uji::eva::mcu::CameraLedPinkOff,        },    // 35-020
    { "LED INCOM R ON",         {G_MCU,   TID_MCU_LED_INCOMING_R_ON},       uji::eva::mcu::NotifyLedRedOn,          },    // 35-021
    { "LED INCOM R OFF",        {G_MCU,   TID_MCU_LED_INCOMING_R_OFF},      uji::eva::mcu::NotifyLedRedOff,         },    // 35-022
    { "LED INCOM G ON",         {G_MCU,   TID_MCU_LED_INCOMING_G_ON},       uji::eva::mcu::NotifyLedGreenOn,        },    // 35-023
    { "LED INCOM G OFF",        {G_MCU,   TID_MCU_LED_INCOMING_G_OFF},      uji::eva::mcu::NotifyLedGreenOff,       },    // 35-024
    { "LED INCOM B ON",         {G_MCU,   TID_MCU_LED_INCOMING_B_ON},       uji::eva::mcu::NotifyLedBlueOn,         },    // 35-025
    { "LED INCOM B OFF",        {G_MCU,   TID_MCU_LED_INCOMING_B_OFF},      uji::eva::mcu::NotifyLedBlueOff,        },    // 35-026
    { "FLICKER ADJUST MAX",     {G_MCU,   TID_MCU_LED_FLICKER_ADJUST_MAX},  uji::eva::mcu::FlickerAdjustMax,        },    // 35-027
    { "FLICKER ADJUST MIN",     {G_MCU,   TID_MCU_LED_FLICKER_ADJUST_MIN},  uji::eva::mcu::FlickerAdjustMin,        },    // 35-028
    { "GET TUNE VOLUME",        {G_MCU,   TID_MCU_GET_TUNE_VOL},            uji::eva::mcu::GetTuneVol,              },    // 35-029
    { "GET SOUND VOLUME",       {G_MCU,   TID_MCU_GET_SOUND_VOL},           uji::eva::mcu::GetSoundVol,             },    // 35-030
    { "SOUND VOL MAX",          {G_MCU,   TID_MCU_WAIT_SOUND_VOL_MAX},      uji::eva::mcu::WaitSoundVolMax,         },    // 35-031
    { "DETECT OPEN",            {G_MCU,   TID_MCU_DETECT_OPEN},             uji::eva::mcu::DetectOpen,              },    // 35-032
    { "DETECT CLOSE",           {G_MCU,   TID_MCU_DETECT_FOLD},             uji::eva::mcu::DetectFold,              },    // 35-033
    { "LED ON TEST NEC",        {G_MCU,   TID_MCU_LED_ON_NEC},              uji::eva::mcu::LedOnTest_NEC,           },    // 35-034
    { "LED OFF TEST NEC",       {G_MCU,   TID_MCU_LED_OFF_NEC},             uji::eva::mcu::LedOffTest_NEC           },    // 35-035
    { "FLICKER ADJUST MAX NEC", {G_MCU,   TID_MCU_LED_FLICKER_ADJUST_MAX_NEC},  uji::eva::mcu::FlickerAdjustMax_NEC,},    // 35-036
    { "FLICKER ADJUST MIN NEC", {G_MCU,   TID_MCU_LED_FLICKER_ADJUST_MIN_NEC},  uji::eva::mcu::FlickerAdjustMin_NEC,},    // 35-037

    { "GET ACCEL XYZ",          {G_CTR_ACCEL,   TID_GET_ACCEL_XYZ},         uji::eva::mcu::GetAccelXYZ,             },    // 39-001


    { "RTC 1SEC COUNTUP",       {G_RTC,   TID_RTC_1SEC_COUNTUP},            uji::eva::mcu::RTCCountupTest           },
    { "RTC REVICE(SET CAL)",    {G_RTC,   TID_RTC_REVISE},                  uji::eva::mcu:: RTCSetCalTest           },

    { "IR ACCESS TEST",         {G_IR,  TID_IR_ACCESS_TEST},                uji::eva::ir::TestIrAccess              },
    { "IR COMMUNICATION",       {G_IR,  TID_IR_COMMUNICATION},              uji::eva::ir::TestIrCommunication       },
    { "IR TX-RC TEST",          {G_IR,  TID_IR_TX_RC_TEST},                 uji::eva::ir::TestIrTxRc                },
    { "IR RXD RECEIVE TEST",    {G_IR,  TID_IR_RXD_RECEIVE_TEST},           uji::eva::ir::TestIrRxdReceive          },
    { "IR POWERDOWN TEST",      {G_IR,  TID_IR_POWERDOWN_TEST},             uji::eva::ir::TestIrPowerDown           },
    { "IR COMMUNICATION NEC 1", {G_IR,  TID_IR_COMMUNICATION_NEC_1},        uji::eva::ir::TestIrCommunication_NEC_1 },
    { "IR COMMUNICATION NEC 2", {G_IR,  TID_IR_COMMUNICATION_NEC_2},        uji::eva::ir::TestIrCommunication_NEC_2 },
    { "IR COMMUNICATION NEC 3", {G_IR,  TID_IR_COMMUNICATION_NEC_3},        uji::eva::ir::TestIrCommunication_NEC_3 },

    { "LCD TEST 3D",            {G_LCD,  TID_LCD_3D},                       uji::eva::TestLcd::TestEnable3D         },
    { "LCD TEST 3D OFF",        {G_LCD,  TID_LCD_3D_OFF},                   uji::eva::TestLcd::TestDisable3D        },
    { "LCD TEST WHITE",         {G_LCD,  TID_LCD_TEST_WHITE},               uji::eva::TestLcd::TestWhite            },
    { "LCD TEST BLACK",         {G_LCD,  TID_LCD_TEST_BLACK},               uji::eva::TestLcd::TestBlack            },
    { "LCD TEST RED",           {G_LCD,  TID_LCD_TEST_RED},                 uji::eva::TestLcd::TestRed              },
    { "LCD TEST GREEN",         {G_LCD,  TID_LCD_TEST_GREEN},               uji::eva::TestLcd::TestGreen            },
    { "LCD TEST BLUE",          {G_LCD,  TID_LCD_TEST_BLUE},                uji::eva::TestLcd::TestBlue             },
    { "LCD TEST BEGIN",         {G_LCD,  TID_LCD_TEST_BEGIN},               uji::eva::TestLcd::TestBegin            },
    { "LCD TEST END",           {G_LCD,  TID_LCD_TEST_END},                 uji::eva::TestLcd::TestEnd              },


    { "BL MAXBRIGHTNESS",       {G_BL,   TID_BL_MAXBRIGHTNESS},             uji::eva::backlight::SetMaxBrightness   },    // 49-001
    { "BL MINBRIGHTNESS",       {G_BL,   TID_BL_MINBRIGHTNESS},             uji::eva::backlight::SetMinBrightness   },    // 49-002
    { "BL ACTIVE ON",           {G_BL,   TID_BL_ACTIVE_ON    },             uji::eva::backlight::SetActiveBackLightOn},   // 49-003
    { "BL ACTIVE OFF",          {G_BL,   TID_BL_ACTIVE_OFF   },             uji::eva::backlight::SetActiveBackLightOff},  // 49-004
    { "BL LCD SET OFF",         {G_BL,   TID_LCD_SET_OFF},                  uji::eva::backlight::SetLcdOff          },    // 49-006
    { "BL LCD SET ON",          {G_BL,   TID_LCD_SET_ON},                   uji::eva::backlight::SetLcdOn           },    // 49-007
    { "BL LCD SET OFF NEC",     {G_BL,   TID_LCD_SET_OFF_NEC},              uji::eva::backlight::SetLcdOff_NEC      },    // 49-008
    { "BL LCD SET ON NEC",      {G_BL,   TID_LCD_SET_ON_NEC},               uji::eva::backlight::SetLcdOn_NEC       },    // 49-009

    { "WIFI 32K EEPROM WRITE",  {G_OTHER,TID_OTHER_WIFI_32K_EEPROM_WRITE},  uji::eva::eeprom::TestWifi32kEepromWrite  },  // 82-003
    { "WIFI SEND START",        {G_OTHER,TID_OTHER_WIFI_SEND_START},        uji::eva::wifi::TestWifiSendStart       },    // 82-004
    { "WIFI SEND STOP",         {G_OTHER,TID_OTHER_WIFI_SEND_STOP} ,        uji::eva::wifi::TestWifiSendStop        },    // 82-005
    { "WIFI RECEIVE START",     {G_OTHER,TID_OTHER_WIFI_RECEIVE_START},     uji::eva::wifi::TestWifiReceiveStart    },    // 82-006
    { "WIFI RECEIVE STOP",      {G_OTHER,TID_OTHER_WIFI_RECEIVE_STOP},      uji::eva::wifi::TestWifiReceiveStop     },    // 82-007
    { "MITSUMI WIFI RECEIVE START", {G_OTHER,TID_OTHER_MITSUMI_WIFI_RECEIVE_START},     uji::eva::MitsumiWifi::TestMitsumiWifiReceiveStart    },    // 82-008
    { "MITSUMI WIFI RECEIVE STOP",  {G_OTHER,TID_OTHER_MITSUMI_WIFI_RECEIVE_STOP},      uji::eva::MitsumiWifi::TestMitsumiWifiReceiveStop     },    // 82-009

    { "FORCE TURN OFF POWER",   {G_IF,   TID_MCU_FORCE_TURN_OFF_POWER},     uji::eva::mcu::McuPowerOffTest,         },    // 71-072

    // ŒCALlݗpǉ
    { "BOARD REENTRY",          {G_MISC, TID_BOARD_REENTRY},                uji::sec::cal::TestBoardReentry,        },    // 03-020

    {NULL}                              //^[~l[V

};


//`
static uji::seq::TestList HinaList[] = {
    { "ATTEST NG",              {G_ATTEST, TID_ATTEST_NG},                  uji::eva::TestAttestNg,                 false},
    { "ATTEST",                 {G_ATTEST, TID_ATTEST},                     uji::eva::TestAttest,                   true },

    { "LCD SHOW TEST PATTERN",  {G_LCD,    TID_LCD_TEST_PATTERN_SET },      uji::eva::TestLcd::ShowTestPattern,     true },

    { "CAMERA OPENCHECK ICAM",  {G_CAMERA, TID_CAMERA_OPENCHECK_ICAM},      uji::eva::camera::TestOpencheckICAM,    true },
    { "CAMERA OPENCHECK OCAM1", {G_CAMERA, TID_CAMERA_OPENCHECK_OCAM1},     uji::eva::camera::TestOpencheckOCAM1,   true },
    { "CAMERA OPENCHECK OCAM2", {G_CAMERA, TID_CAMERA_OPENCHECK_OCAM2},     uji::eva::camera::TestOpencheckOCAM2,   true },
    {NULL}                              //^[~l[V
};

//kbcL[
static uji::seq::TestList LcdAndKeyList[] = {
    { "SET MANUAL MODE",        {G_MISC,        TID_CHANGE_CONFIG},             uji::eva::wrap::SetSPAndTPManualConfig,         true },
    { "GET MAC ADDRESS",        {G_HWINFO,      TID_GET_MAC_ADDRESS},            uji::eva::TestGetMacAddress,                   true },
    { "SD READWRITE EZ",        {G_SD,          TID_SD_READWRITE_EZ},           uji::eva::sd::TestSd::ReadWriteTestEz,          true },
    { "SET CONSTANT CAL",       {G_MISC,        TID_SET_CONSTANT_CAL},          uji::sec::cal::TestSetConstantCal,              true },
    { "LCD AND BACK LIGHT",     {G_LCD,         TID_LCD_TEST_PATTERN_SET },     uji::eva::TestLcd::ShowTestPattern,             true },
    { "SLIDEPAD INITIALIZE",    {G_KEY,         TID_SLIDEPAD_INITIALIZE},       uji::eva::TestExecuteInitialize,                true },
    { "ON YOUR MARK",           {G_KEY,         TID_SLIDEPAD_ON_YOUR_MARK},     uji::eva::TestExecuteOnYourMark,                true },
    { "SAMPLING",               {G_KEY,         TID_SLIDEPAD_SAMPLING},         uji::eva::TestExecuteSampling,                  false },
    { "CALIBRATION",            {G_KEY,         TID_SLIDEPAD_CALIBRATION},      uji::eva::TestExecuteCalibrate,                 false },
    { "CHECK MAX OUTPUT WIDTH", {G_KEY,         TID_SLIDEPAD_CHECK_MOW},        uji::eva::TestExecuteCheckMaxOutputWidth,       true },
    { "CHECK AUTO RESTORATION", {G_KEY,         TID_SLIDEPAD_CHECK_AR},         uji::eva::TestExecuteCheckAutoRestoration,      true },
    { "SLIDEPAD WRITE DATA2SD", {G_KEY,         TID_SLIDEPAD_DATA_TO_SD},       uji::eva::TestExecuteWriteData2SD,              true },
    { "SLIDEPAD SET CAL",       {G_KEY,         TID_SLIDEPAD_SET_CAL},          uji::eva::TestExecuteSetCalAnalogStick,         false },
    { "SLIDEPAD FINALIZE",      {G_KEY,         TID_SLIDEPAD_FINALIZE},         uji::eva::TestExecuteFinalize,                  true },
    { "DIGITAL KEY TEST",       {G_KEY,         TID_KEY_DIGITAL },              uji::eva::TestDigitalKey,                       true },
    { "HOME BUTTON TEST",       {G_KEY,         TID_KEY_HOME },                 uji::eva::mcu::HomeButtonTest,                  true },
    { "WIFI BUTTON TEST",       {G_KEY,         TID_KEY_WIFI },                 uji::eva::mcu::WifiButtonTest,                  true },
    { "SLIDE VOLUME CAL",       {G_KEY,         TID_SLIDEVOLUME_CAL },          uji::eva::TestClampVolume,                      true },
    { "TOUCH PANEL TEST",       {G_TP,          TID_TP_ACCURACY },              uji::eva::wrap::CheckTPAccuracy_LcdKey,         true },
    { "LED CHECK",              {G_KEY,         TID_LED_CHECK },                uji::eva::mcu::CheckLedOnOff,                   true },
    { "SOUND CHECK",            {G_SOUND,       TID_L_R_SPEAKER_CHECK },        uji::eva::sound::TestBibiriSound,               false },
    { "L/R SPEAKER CHECK",      {G_SOUND,       TID_L_R_SPEAKER_CHECK },        uji::eva::sound::TestLeftAndRightSpeakerSin,    true },
    { "DETECT CLOSE",           {G_MCU,         TID_MCU_DETECT_FOLD_WITH_PIC},  uji::eva::mcu::DetectFoldWithPicture,           true },
    { "DETECT OPEN",            {G_MCU,         TID_MCU_DETECT_OPEN},           uji::eva::mcu::DetectOpen,                      true },
    { "STICK TEST",             {G_MISC,        TID_GYRO_AND_ACC_STICK_CHK },   uji::eva::wrap::StickTest,                      true },
    { "GYRO INIT",              {G_GYRO,        TID_GYRO_C_INITIALIZE},         uji::eva::wrap::GyroInit,                       true },
    { "GYRO CAL MOTIONLESS",    {G_GYRO,        TID_GYRO_C_CALIB_MOTIONLESS},   uji::eva::wrap::GyroCalibMotionLess,            true },
    { "GYRO WRITE LOG TO SD",   {G_GYRO,        TID_GYRO_C_WRITE_SDLOG},        uji::eva::wrap::GyroWriteSDLog,                 true },
    { "GYRO SET CAL",           {G_GYRO,        TID_GYRO_C_SET_CAL},            uji::eva::wrap::GyroSetCal,                     true },
    { "GYRO AGING TEST",        {G_CTR_ACCEL,   TID_GYRO_AGING_TEST},           uji::eva::wrap::GyroAgingTest,                  true },
    { "GYRO WRITE OK LOG",      {G_GYRO,        TID_GYRO_C_PRODUCTION_LOG_OK},  uji::eva::wrap::GyroWriteOkLog,                 true },
    { "CAMERA OPENCHECK ICAM",  {G_CAMERA,      TID_CAMERA_OPENCHECK_ICAM},     uji::eva::camera::TestOpencheckICAM,            true },
    { "CAMERA OPENCHECK OCAM1", {G_CAMERA,      TID_CAMERA_OPENCHECK_OCAM1},    uji::eva::camera::TestOpencheckOCAM1,           true },
    { "CAMERA OPENCHECK OCAM2", {G_CAMERA,      TID_CAMERA_OPENCHECK_OCAM2},    uji::eva::camera::TestOpencheckOCAM2,           true },
    { "MP INIT TEST",           {G_WIRELESS,    TID_WIRELESS_MP},               uji::eva::mp::TestMpInit,                       true },
#ifndef EVA_REPAIR
    { "CLEAR RFU NOR",          {G_NCHECK,      TID_NCHECK_CLEAR_RFU_NOR},      uji::eva::procchk::Invoke_ClearRfuNor,          true },
    { "CHECK RFU NOR",          {G_NCHECK,      TID_NCHECK_RFU_NOR},            uji::eva::procchk::Invoke_CheckRfuNor,          true },
    { "RESET SETTING",          {G_MISC,        TID_RESET_SETTING},             uji::eva::TestResetSetting,                     true },
#endif
    { "WRITE OK LOG SOLO",      {G_LOG,         TID_LOG_WRITE_OK_LOG_SOLO },    uji::eva::TestWriteOkLogSolo,                   true },
    {NULL}                              //^[~l[V
};

//hmJ
static uji::seq::TestList InCameraTestList[] = {
    { "FLICKER",                {G_LCD,    TID_LCD_FLICKER},                uji::eva::TestLcd::ShowFlickerPattern,  false },
    { "IN CAMERA CHART",        {G_CAMERA, TID_INCAMERA_CHART},             uji::eva::camera::TestInCameraChart,    true },
    { "IN CAMERA DUST",         {G_CAMERA, TID_INCAMERA_DUST},              uji::eva::camera::TestInCameraDust,     true },
    { "OUT CAMERA RIGHT DUST",  {G_CAMERA, TID_OUTCAMERA_RIGHT_DUST},       uji::eva::camera::TestOutRightCameraDust, true },
    { "OUT CAMERA LEFT DUST",   {G_CAMERA, TID_OUTCAMERA_LEFT_DUST},        uji::eva::camera::TestOutLeftCameraDust,  true },
    { "WRITE OK LOG SOLO",      {G_LOG,    TID_LOG_WRITE_OK_LOG_SOLO },     uji::eva::TestWriteOkLogSolo,           true },
    {NULL}                              //^[~l[V
};

//OUTJWBP̕␳
static uji::seq::TestList OutCameraWBTestList[] = {
    { "WRITE WB TO SD",         {G_CAMERA, TID_CAMERA_WB_TO_SD},            uji::eva::camera::TestCameraWBtoSD    , true },
    { "CAMERA INITIALIZE",      {G_CAMERA, TID_CAMERA_INITIALIZE},          uji::eva::camera::TestInitialize      , true },
    { "OUT CAMERA LEFT POS",    {G_CAMERA, TID_OUTCAMERA_LEFT_DUST},        uji::eva::camera::CheckOutLeftCameraCapture,  true },
    { "LEFT CAMERA CAL WB",     {G_CAMERA, TID_CAMERA_CAL_WB_CAM2},         uji::eva::camera::TestCameraCalWB_CAM2, true },
    { "CAMERA INITIALIZE2",     {G_CAMERA, TID_CAMERA_INITIALIZE},          uji::eva::camera::TestInitialize      , true },
    { "OUT CAMERA RIGHT POS",   {G_CAMERA, TID_OUTCAMERA_RIGHT_DUST},       uji::eva::camera::CheckOutRightCameraCapture, true },
    { "RIGHT CAMERA CAL WB",    {G_CAMERA, TID_CAMERA_CAL_WB_CAM1},         uji::eva::camera::TestCameraCalWB_CAM1, true },
    { "CAMERA EXTRA FUNC 9",    {G_CAMERA, TID_CAMERA_EXTRA_FUNC9},         uji::eva::camera::TestCameraExtraFunc9, true },
    { "WRITE WB TO SD2",        {G_CAMERA, TID_CAMERA_WB_TO_SD2},           uji::eva::camera::TestCameraWBtoSD2   , true },
    { "WRITE OK LOG SOLO",      {G_LOG,    TID_LOG_WRITE_OK_LOG_SOLO },     uji::eva::TestWriteOkLogSolo          , true },
    {NULL}                              //^[~l[V
};

//JBHpvO
static uji::seq::TestList CameraCaptureTestList[] = {
    { "CAPTURE 3 PICTURES CHART",{G_CAMERA, TID_CAMERA_CAPTURE},            uji::eva::camera::Capture3PicturesChart , true  },
    { "CAPTURE 3 PICTURES WHITE",{G_CAMERA, TID_CAMERA_CAPTURE},            uji::eva::camera::Capture3PicturesWhite , true  },
    { "IN CAMERA DUST",          {G_CAMERA, TID_INCAMERA_DUST},             uji::eva::camera::TestInCameraMio       , false },
    { "OUT CAMERA RIGHT DUST",   {G_CAMERA, TID_OUTCAMERA_RIGHT_DUST},      uji::eva::camera::TestOutRightCameraMio , false },
    { "OUT CAMERA LEFT DUST",    {G_CAMERA, TID_OUTCAMERA_LEFT_DUST},       uji::eva::camera::TestOutLeftCameraMio  , false },
    { "WRITE OK LOG SOLO",       {G_LOG,    TID_LOG_WRITE_OK_LOG_SOLO },    uji::eva::TestWriteOkLogSolo            , true  },
    {NULL}                              //^[~l[V
};

// WCiNCAgj
extern uji::seq::TestList GyroTestList[] = {
    { "ATTEST",                 {G_ATTEST,  TID_ATTEST},                    uji::eva::TestAttest,                        },
    { "ATTEST NG",              {G_ATTEST,  TID_ATTEST_NG},                 uji::eva::TestAttestNg,                      },
    { "GET PRY",                {G_GYRO,    TID_GYRO_C_GET_PRY},            uji::eva::gyroC::GetPry,                     },
    { "INITIALIZE",             {G_GYRO,    TID_GYRO_C_INITIALIZE},         uji::eva::gyroC::Initialize,                 },
    { "GYRO ATTEST",            {G_GYRO,    TID_GYRO_C_ATTEST},             uji::eva::gyroC::ATTEST_C,                   },
    { "GET PROGRAM VER",        {G_GYRO,    TID_GYRO_C_PROGRAM_VERSION},    uji::eva::gyroC::GetProgramVersion,          },
    { "CALIBRATE MOTIONLESS",   {G_GYRO,    TID_GYRO_C_CALIB_MOTIONLESS},   uji::eva::gyroC::Calibrate_TTRotMotionless,  },
    { "GYRO CALIB Z R78",       {G_GYRO,    TID_GYRO_C_CALIB_Z_R78},        uji::eva::gyroC::CalibrateZ_TTRotR78rpm,     },
    { "GYRO CALIB Z L78",       {G_GYRO,    TID_GYRO_C_CALIB_Z_L78},        uji::eva::gyroC::CalibrateZ_TTRotL78rpm,     },
    { "GYRO CALIB Y R78",       {G_GYRO,    TID_GYRO_C_CALIB_Y_R78},        uji::eva::gyroC::CalibrateY_TTRotR78rpm,     },
    { "GYRO CALIB Y L78",       {G_GYRO,    TID_GYRO_C_CALIB_Y_L78},        uji::eva::gyroC::CalibrateY_TTRotL78rpm,     },
    { "GYRO CALIB X R78",       {G_GYRO,    TID_GYRO_C_CALIB_X_R78},        uji::eva::gyroC::CalibrateX_TTRotR78rpm,     },
    { "GYRO CALIB X L78",       {G_GYRO,    TID_GYRO_C_CALIB_X_L78},        uji::eva::gyroC::CalibrateX_TTRotL78rpm,     },
    { "WRITE LOG TO SD",        {G_GYRO,    TID_GYRO_C_WRITE_SDLOG},        uji::eva::gyroC::WriteSDLog,                 },
    { "SEND TEST DATA",         {G_GYRO,    TID_GYRO_C_SEND_TEST_DATA},     uji::eva::gyroC::SendTestData,               },
    { "SET CAL",                {G_GYRO,    TID_GYRO_C_SET_CAL},            uji::eva::gyroC::SetCal,                     },
    { "CHECK CAL SENSITIVITY",  {G_GYRO,    TID_GYRO_C_CHECK_CAL_SENS},     uji::eva::gyroC::CheckCal_Sensitivity,       },
    { "CHECK CAL ZERO OUTPUT",  {G_GYRO,    TID_GYRO_C_CHECK_CAL_ZERO},     uji::eva::gyroC::CheckCal_ZeroRateOutput,    },
    { "WRITE PRODUCTION LOG OK",{G_GYRO,    TID_GYRO_C_PRODUCTION_LOG_OK},  uji::eva::gyroC::WriteProductionLogOK,       },
    {NULL}                              //^[~l[V
};

// WC
static uji::seq::TestList GyroMasterTestList[] = {
    { "CREATE NETWORK",         {G_GYRO_MASTER, TID_GYRO_M_CREATE_NETWORK},         uji::eva::gyroM::CreateNetwork,                 true },
    { "PREPARE FOR TEST",       {G_GYRO_MASTER, TID_GYRO_M_PREPARE_FOR_TEST},       uji::eva::gyroM::PrepareForTest,                true },
    { "INITIALIZE",             {G_GYRO_MASTER, TID_GYRO_M_INITIALIZE},             uji::eva::gyroM::CallInitialize,                true },
    { "CALL GYRO ATTEST",       {G_GYRO_MASTER, TID_GYRO_M_ATTEST},                 uji::eva::gyroM::CallATTEST,                    true },
    { "CALL GET PROGRAM VER",   {G_GYRO_MASTER, TID_GYRO_M_PROGRAM_VERSION},        uji::eva::gyroM::CallGetProgramVersion,         true },
    { "CALIBRATE MOTIONLESS",   {G_GYRO_MASTER, TID_GYRO_M_CALIB_MOTIONLESS},       uji::eva::gyroM::CallCalibrate_TTRotMotionless, true },
    {"@"},
// Z
    { "SET TT SPEED 78RPM",     {G_GYRO_MASTER, TID_GYRO_M_SET_TT_SPEED_78RPM},     uji::eva::gyroM::SetTTRotationSpeed78rpm,       true },
    { "SET TT DIR POSITIVE",    {G_GYRO_MASTER, TID_GYRO_M_SET_TT_DIR_POSITIVE},    uji::eva::gyroM::SetTTRotationDirPositive,      true },
    { "TT ROTATION Z START"   , {G_GYRO_MASTER, TID_GYRO_M_START_TT_ROTATION},      uji::eva::gyroM::RotateTurntableForZAxisTest,   true },
    { "WAIT TT SPEED 78RPM",    {G_GYRO_MASTER, TID_GYRO_M_WAIT_TT_SPEED_78RPM},    uji::eva::gyroM::WaitTTRotationSpeed78rpm,      true },
    { "CALIBRATE Z R78",        {G_GYRO_MASTER, TID_GYRO_M_CALIB_Z_R78},            uji::eva::gyroM::CallCalibrateZ_TTRotR78rpm,    true },
    { "SET TT DIR NEGATIVE",    {G_GYRO_MASTER, TID_GYRO_M_SET_TT_DIR_NEGATIVE},    uji::eva::gyroM::SetTTRotationDirNegative,      true },
    { "WAIT TT SPEED 78RPM",    {G_GYRO_MASTER, TID_GYRO_M_WAIT_TT_SPEED_78RPM},    uji::eva::gyroM::WaitTTRotationSpeed78rpm,      true },
    { "CALIBRATE Z L78",        {G_GYRO_MASTER, TID_GYRO_M_CALIB_Z_L78},            uji::eva::gyroM::CallCalibrateZ_TTRotL78rpm,    true },
    { "STOP TURNTABLE",         {G_GYRO_MASTER, TID_GYRO_M_STOP_TT_ROTATION},       uji::eva::gyroM::StopTurnTable,                 true },
    {"@"},
// Y
    { "SET TT SPEED 78RPM",     {G_GYRO_MASTER, TID_GYRO_M_SET_TT_SPEED_78RPM},     uji::eva::gyroM::SetTTRotationSpeed78rpm,       true },
    { "SET TT DIR POSITIVE" ,   {G_GYRO_MASTER, TID_GYRO_M_SET_TT_DIR_POSITIVE},    uji::eva::gyroM::SetTTRotationDirPositive,      true },
    { "TT ROTATION Y START",    {G_GYRO_MASTER, TID_GYRO_M_START_TT_ROTATION},      uji::eva::gyroM::RotateTurntableForYAxisTest,   true },
    { "WAIT TT SPEED 78RPM",    {G_GYRO_MASTER, TID_GYRO_M_WAIT_TT_SPEED_78RPM},    uji::eva::gyroM::WaitTTRotationSpeed78rpm,      true },
    { "CALIBRATE Y R78",        {G_GYRO_MASTER, TID_GYRO_M_CALIB_Y_R78},            uji::eva::gyroM::CallCalibrateY_TTRotR78rpm,    true },
    { "SET TT DIR NEGATIVE",    {G_GYRO_MASTER, TID_GYRO_M_SET_TT_DIR_NEGATIVE},    uji::eva::gyroM::SetTTRotationDirNegative,      true },
    { "WAIT TT SPEED 78RPM",    {G_GYRO_MASTER, TID_GYRO_M_WAIT_TT_SPEED_78RPM},    uji::eva::gyroM::WaitTTRotationSpeed78rpm,      true },
    { "CALIBRATE Y L78",        {G_GYRO_MASTER, TID_GYRO_M_CALIB_Y_L78},            uji::eva::gyroM::CallCalibrateY_TTRotL78rpm,    true },
    { "STOP TURNTABLE",         {G_GYRO_MASTER, TID_GYRO_M_STOP_TT_ROTATION},       uji::eva::gyroM::StopTurnTable,                 true },
    {"@"},
// X
    { "SET TT SPEED 78RPM",     {G_GYRO_MASTER, TID_GYRO_M_SET_TT_SPEED_78RPM},     uji::eva::gyroM::SetTTRotationSpeed78rpm,       true },
    { "SET TT DIR POSITIVE" ,   {G_GYRO_MASTER, TID_GYRO_M_SET_TT_DIR_POSITIVE},    uji::eva::gyroM::SetTTRotationDirPositive,      true },
    { "TT ROTATION X START",    {G_GYRO_MASTER, TID_GYRO_M_START_TT_ROTATION},      uji::eva::gyroM::RotateTurntableForXAxisTest,   true },
    { "WAIT TT SPEED 78RPM",    {G_GYRO_MASTER, TID_GYRO_M_WAIT_TT_SPEED_78RPM},    uji::eva::gyroM::WaitTTRotationSpeed78rpm,      true },
    { "CALIBRATE X R78",        {G_GYRO_MASTER, TID_GYRO_M_CALIB_X_R78},            uji::eva::gyroM::CallCalibrateX_TTRotR78rpm,    true },
    { "SET TT DIR NEGATIVE",    {G_GYRO_MASTER, TID_GYRO_M_SET_TT_DIR_NEGATIVE},    uji::eva::gyroM::SetTTRotationDirNegative,      true },
    { "WAIT TT SPEED 78RPM",    {G_GYRO_MASTER, TID_GYRO_M_WAIT_TT_SPEED_78RPM},    uji::eva::gyroM::WaitTTRotationSpeed78rpm,      true },
    { "CALIBRATE X L78",        {G_GYRO_MASTER, TID_GYRO_M_CALIB_X_L78},            uji::eva::gyroM::CallCalibrateX_TTRotL78rpm,    true },
    { "STOP TURNTABLE",         {G_GYRO_MASTER, TID_GYRO_M_STOP_TT_ROTATION},       uji::eva::gyroM::StopTurnTable,                 true },
    {"@"},

    { "SET CAL",                {G_GYRO_MASTER, TID_GYRO_M_SET_CAL},                uji::eva::gyroM::CallSetCal,                    true },
    { "CHECK CAL SENSITIVITY",  {G_GYRO_MASTER, TID_GYRO_M_CHECK_CAL_SENS},         uji::eva::gyroM::CallCheckCal_Sensitivity,      false },
    { "CHECK CAL ZERO OUTPUT",  {G_GYRO_MASTER, TID_GYRO_M_CHECK_CAL_ZERO},         uji::eva::gyroM::CallCheckCal_ZeroRateOutput,   false },

    { "WRITE PRODUCTION LOG OK",{G_GYRO_MASTER, TID_GYRO_M_PRODUCTION_LOG_OK},      uji::eva::gyroM::CallWriteProductionLogOK,      true },
    { "WRITE LOG TO SD(MASTER)",{G_GYRO_MASTER, TID_GYRO_M_WRITE_SDLOG_MASTER},     uji::eva::gyroM::CallWriteSDLogByMaster,        true },
    { "WRITE LOG TO SD",        {G_GYRO_MASTER, TID_GYRO_M_WRITE_SDLOG},            uji::eva::gyroM::CallWriteSDLog,                false },
    {NULL}                              //^[~l[V
};

// G[WO
static uji::seq::TestList AgingList[] = {
    { "LOG CHECK",              {G_MISC,    TID_LOG_CHECK_PREV_AGING},              uji::eva::AgingImporter::LogCheckPrevAging, true },
    { "FLICKER",                {G_LCD,     TID_LCD_FLICKER},                       uji::eva::TestLcd::ShowFlickerPattern,      true },
    { "AGING TEST",             {G_MISC,    TID_AGING_TEST },                       uji::eva::AgingSequencer::RunAging,         true },
    /*RunAgingŌʏo͂s߁Aȍ~TestList͎sȂ*/
    /*ToDo:G[WOIvVON̏ꍇA_[obt@TCYقȂ邽߁AɃtbJmF\oȂ*/
    /*t@C̖A2013/07/19_łTestListgpĂȂ(tbJmF)*/
    {NULL}                              //^[~l[V
};

// G[WOC|[g
static uji::seq::TestList AgingImportList[] = {
    { "LOG CHECK",              {G_MISC,    TID_LOG_CHECK_PREV_AGING},              uji::eva::AgingImporter::LogCheckPrevAging, true },
    { "FLICKER",                {G_LCD,     TID_LCD_FLICKER},                       uji::eva::TestLcd::ShowFlickerPattern,      true },
    { "AGING IMPORT",           {G_MISC,    TID_AGING_IMPORT},                      uji::eva::AgingImporter::ImportAndRunAging, true },
    /*ImportAndRunAgingŌʏo͂s߁Aȍ~TestList͎sȂ*/
    {NULL}                              //^[~l[V
};

// ^b`plLu[V
static uji::seq::TestList TouchPanelTestList[] = {
#ifndef EVA_TP_MODULE
    { "FLICKER",                {G_LCD,     TID_LCD_FLICKER},       uji::eva::TestLcd::ShowFlickerPattern,      true },
#endif
    { "TP CALIBRATION",         {G_TP,      TID_TP_CALIBRATION },   uji::eva::TouchPanel::TestTouchPanel,       true },
    { "WRITE OK LOG",           {G_TP,      TID_TP_WRITE_OK_LOG },  uji::eva::TouchPanel::WriteTouchPanelLog,   true },
    {NULL}
};

//x
static uji::seq::TestList AccelList[] = {
    { "WAIT R BUTTON",          {G_CTR_ACCEL,   TID_WAIT_R_BUTTON},                 uji::eva::acc::WaitButtonR,                     true },
    { "ACCELEROMETER",          {G_CTR_ACCEL,   TID_ACC_TEST},                      uji::eva::acc::AccelerometerTest,               true },
    {NULL}                              //^[~l[V
};

// i}CN
using namespace uji::eva::mic_t;
static uji::seq::TestList MicTesterList[] = {
    { "CALIBRATE MIC TESTER",   {G_MIC_TESTER,  TID_MIC_T_CALIBRATE_TESTER},        TestExecuteCalibrateTester,         true },
    { "INITIALIZE",             {G_MIC_TESTER,  TID_MIC_T_INITIALIZE},              TestExecuteInitialize,              true },
    { "CTR DC OFFSET",          {G_MIC_TESTER,  TID_MIC_T_CTR_DCOFFSET},            TestExecuteCtrModeDcOffset,         true },
    { "CTR INPUT TEST",         {G_MIC_TESTER,  TID_MIC_T_CTR_INPUT},               TestExecuteCtrModeInput,            true },
    { "PGA GAIN CALIBRATION",   {G_MIC_TESTER,  TID_MIC_T_CALIBRATE_PGA_GAIN},      TestExecuteCalibratePgaGain,        true },
    { "SENSITIVITY",            {G_MIC_TESTER,  TID_MIC_T_SENSITIVITY},             TestExecuteSensitivity,             true },
    { "WRITE DATA TO SD",       {G_MIC_TESTER,  TID_MIC_T_WRITE_DATA_TO_SD},        TestExecuteWriteData2SD,            true },
    { "SET CAL",                {G_MIC_TESTER,  TID_MIC_T_SET_CAL},                 TestExecuteSetCalPgaGain,           true },
    { "FINALIZE",               {G_MIC_TESTER,  TID_MIC_T_FINALIZE},                TestExecuteFinalize,                true },
    { "WRITE PRODUCTION LOG OK",{G_MIC_TESTER,  TID_MIC_T_PRODUCTION_LOG_OK},       TestExecuteWriteProductionLogOk,    true },
    { "SHOW MAJOR VARIABLE",    {G_MIC_TESTER,  TID_MIC_T_SHOW_MAJOR_VARIABLE},     TestExecuteShowMajorVariable,       true },
    {NULL}                              //^[~l[V
};

// XChpbh
static uji::seq::TestList SlidePadList[] = {
    { "SET CONFIG"   ,             {G_MISC,   TID_CHANGE_CONFIG},           uji::eva::wrap::SetSPConfig,                true },
#ifndef EVA_REPAIR
    { "CHECK PRODUCT LOG",         {G_NCHECK, TID_NCHECK_PRODUCT_LOG},      uji::eva::procchk::Invoke_CheckProductLog,  true },
#endif
    { "INITIALIZE",                {G_KEY,    TID_SLIDEPAD_INITIALIZE},     uji::eva::TestExecuteInitialize,            true },
    { "ON YOUR MARK",              {G_KEY,    TID_SLIDEPAD_ON_YOUR_MARK},   uji::eva::TestExecuteOnYourMark,            true },
    { "SAMPLING",                  {G_KEY,    TID_SLIDEPAD_SAMPLING},       uji::eva::TestExecuteSampling,              true },
    { "CALIBRATION",               {G_KEY,    TID_SLIDEPAD_CALIBRATION},    uji::eva::TestExecuteCalibrate,             true },
    { "CHECK MAX OUTPUT WIDTH",    {G_KEY,    TID_SLIDEPAD_CHECK_MOW},      uji::eva::TestExecuteCheckMaxOutputWidth,   false },
    { "CHECK AUTO RESTORATION",    {G_KEY,    TID_SLIDEPAD_CHECK_AR},       uji::eva::TestExecuteCheckAutoRestoration,  false },
    { "WRITE DATA TO SD",          {G_KEY,    TID_MIC_T_WRITE_DATA_TO_SD},  uji::eva::TestExecuteWriteData2SD,          true },
    { "SET CAL",                   {G_KEY,    TID_SLIDEPAD_SET_CAL},        uji::eva::TestExecuteSetCalAnalogStick,     true },
    { "FINALIZE",                  {G_KEY,    TID_SLIDEPAD_FINALIZE},       uji::eva::TestExecuteFinalize,              true },
    { "WRITE OK LOG SOLO",         {G_LOG,    TID_LOG_WRITE_OK_LOG_SOLO },  uji::eva::TestWriteOkLogSolo,               true },
    {NULL}                              //^[~l[V
};

// XChpbh^b`plLu[V
static uji::seq::TestList SpAndTpTestList[] = {
#ifndef EVA_REPAIR
    { "REENTRY",                    {G_MISC,    TID_REENTRY},               uji::eva::TestReentry,                       true },
    { "SET AUTO MODE",              {G_MISC,    TID_CHANGE_CONFIG},         uji::eva::wrap::SetSPAndTPAutoConfig,        true },
    { "SET MANUAL MODE",            {G_MISC,    TID_CHANGE_CONFIG},         uji::eva::wrap::SetSPAndTPManualConfig,      false },
    { "CHECK PRODUCT LOG",          {G_NCHECK, TID_NCHECK_PRODUCT_LOG},      uji::eva::procchk::Invoke_CheckProductLog,  true },
#endif
    { "FLICKER",                    {G_LCD,    TID_LCD_FLICKER},             uji::eva::TestLcd::ShowFlickerPattern,      false },
    { "INITIALIZE",                 {G_KEY,    TID_SLIDEPAD_INITIALIZE},     uji::eva::TestExecuteInitialize,            true },
    { "ON YOUR MARK",               {G_KEY,    TID_SLIDEPAD_ON_YOUR_MARK},   uji::eva::TestExecuteOnYourMark,            true },
    { "SAMPLING",                   {G_KEY,    TID_SLIDEPAD_SAMPLING},       uji::eva::TestExecuteSampling,              true },
    { "CALIBRATION",                {G_KEY,    TID_SLIDEPAD_CALIBRATION},    uji::eva::TestExecuteCalibrate,             true },
    { "CHECK MAX OUTPUT WIDTH",     {G_KEY,    TID_SLIDEPAD_CHECK_MOW},      uji::eva::TestExecuteCheckMaxOutputWidth,   false },
    { "CHECK AUTO RESTORATION",     {G_KEY,    TID_SLIDEPAD_CHECK_AR},       uji::eva::TestExecuteCheckAutoRestoration,  false },
    { "WRITE DATA TO SD",           {G_KEY,    TID_MIC_T_WRITE_DATA_TO_SD},  uji::eva::TestExecuteWriteData2SD,          true },
    { "SET CAL",                    {G_KEY,    TID_SLIDEPAD_SET_CAL},        uji::eva::TestExecuteSetCalAnalogStick,     true },
    { "FINALIZE",                   {G_KEY,    TID_SLIDEPAD_FINALIZE},       uji::eva::TestExecuteFinalize,              true },
    { "TP CALIBRATION",             {G_TP,     TID_TP_CALIBRATION },         uji::eva::TouchPanel::TestTouchPanel,       true },
    { "WRITE OK LOG",               {G_TP,     TID_TP_WRITE_OK_LOG },        uji::eva::TouchPanel::WriteTouchPanelLog,   true },
    {NULL}
};

// vvZX`FbN
static uji::seq::TestList PreProcCheckList[] = {
    { "STARTUP",              {G_NCHECK,    TID_NCHECK_STARTUP},          uji::eva::procchk::Invoke_Startup,                    true  },
    { "CHECK SEQUENCE",       {G_NCHECK,    TID_NCHECK_SEQUENCE},         uji::eva::procchk::Invoke_CheckSequence,              true  },
    { "CHECK SER NO",         {G_NCHECK,    TID_NCHECK_SER_NO},           uji::eva::procchk::Invoke_CheckSerialNo,              true  },
    { "CHECK REGION",         {G_NCHECK,    TID_NCHECK_REGION},           uji::eva::procchk::Invoke_CheckRegion,                true  },
    { "CHECK PRODUCT LOG",    {G_NCHECK,    TID_NCHECK_PRODUCT_LOG},      uji::eva::procchk::Invoke_CheckProductLog,            true  },
    { "CHECK LAST PROCESS",   {G_NCHECK,    TID_NCHECK_LAST_PROCESS},     uji::eva::procchk::Invoke_CheckProductLogLastProcess, true  },
    { "CHECK CAL FLAG",       {G_NCHECK,    TID_NCHECK_CAL_FLAG},         uji::sec::cal::TestConfirmCalAdjusted,                true  },
    { "CLEAR RFU NOR",        {G_NCHECK,    TID_NCHECK_CLEAR_RFU_NOR},    uji::eva::procchk::Invoke_ClearRfuNor,                true  },
    { "CHECK RFU NOR",        {G_NCHECK,    TID_NCHECK_RFU_NOR},          uji::eva::procchk::Invoke_CheckRfuNor,                true  },
    { "VALIDATE SIGN",        {G_NCHECK,    TID_NCHECK_VALIDATE_SIGN},    uji::eva::procchk::Invoke_ValidateSign,    FLAG_CHECK_VALIDATE_SIGN  },
    { "CHECK BLANK SD",       {G_NCHECK,    TID_NCHECK_BLANK_SD},         uji::eva::procchk::Invoke_CheckBlankSdCard,FLAG_CHECK_BLANK_SD       },
    { "WRITE OK LOG",         {G_NCHECK,    TID_NCHECK_WRITE_LOG},        uji::eva::procchk::Invoke_WriteProductLog,            true  },
    { "DISPLAY QR",           {G_NCHECK,    TID_NCHECK_DISPLAY_QR},       uji::eva::procchk::Invoke_TestFunc,                   false },
    {NULL}                              //^[~l[V
};

// vZX`FbN
static uji::seq::TestList ProcCheckList[] = {
    { "STARTUP",               {G_NCHECK,    TID_NCHECK_STARTUP},          uji::eva::procchk::Invoke_Startup,                    true },
//    { "CHECK SEQUENCE",        {G_NCHECK,    TID_NCHECK_SEQUENCE},         uji::eva::procchk::Invoke_CheckSequence,              true },
    { "CHECK SER NO",          {G_NCHECK,    TID_NCHECK_SER_NO},           uji::eva::procchk::Invoke_CheckSerialNo,              true },
    { "CHECK REGION",          {G_NCHECK,    TID_NCHECK_REGION},           uji::eva::procchk::Invoke_CheckRegion,                true },
    { "CHECK PRODUCT LOG",     {G_NCHECK,    TID_NCHECK_PRODUCT_LOG},      uji::eva::procchk::Invoke_CheckProductLog,            true },
    { "CHECK LAST PROCESS",    {G_NCHECK,    TID_NCHECK_LAST_PROCESS},     uji::eva::procchk::Invoke_CheckProductLogLastProcess, true },
    { "CHECK IMPORT VERSION",  {G_NCHECK,    TID_NCHECK_IMPORT_VERSION},   uji::eva::procchk::Invoke_CheckProductLogImportVersion, true },
    { "CHECK PREINSTALL VERSION", {G_NCHECK,    TID_NCHECK_PREINSTALL_VERSION},   uji::eva::procchk::Invoke_CheckProductLogPreInstallVersion, FLAG_CHECK_PRE_INSTALL},
    { "CHECK NOT PREINSTALLED",   {G_NCHECK,    TID_NCHECK_NOT_PREINSTALLED},     uji::eva::procchk::Invoke_CheckProductLogNotPreInstalled,   !FLAG_CHECK_PRE_INSTALL},
    { "CHECK NOT EXIST AGING", {G_NCHECK,    TID_NCHECK_NOT_EXIST_AGING},  uji::eva::procchk::Invoke_CheckNotExsistAgingProgram, true },
    { "CHECK CAL FLAG",        {G_NCHECK,    TID_NCHECK_CAL_FLAG},         uji::sec::cal::TestConfirmCalAdjusted,                true },
    { "CHECK 3D VOLUME",       {G_NCHECK,    TID_NCHECK_3D_VOLUME},        uji::eva::Test3DVolumeForProcessCheck,                true },
    { "CLEAR RFU NOR",         {G_NCHECK,    TID_NCHECK_CLEAR_RFU_NOR},    uji::eva::procchk::Invoke_ClearRfuNor,                true },
    { "CHECK RFU NOR",         {G_NCHECK,    TID_NCHECK_RFU_NOR},          uji::eva::procchk::Invoke_CheckRfuNor,                true },
    { "VALIDATE SIGN",         {G_NCHECK,    TID_NCHECK_VALIDATE_SIGN},    uji::eva::procchk::Invoke_ValidateSign,               true },
    { "CHECK BLANK SD",        {G_CTR_NCHECK1, TID_NCHECK_BLANK_SD},       uji::eva::procchk::Invoke_CheckBlankSdCard,      FLAG_CHECK_BLANK_SD},
    { "CHECK PREINSTALL SD",   {G_CTR_NCHECK1, TID_NCHECK_SD},             uji::eva::procchk::Invoke_CheckPreInstallSdCard, FLAG_CHECK_PRE_INSTALL_SD},
    { "CHECK NOT INSERT SD",   {G_CTR_NCHECK1, TID_NCHECK_NOT_INSERT_SD},  uji::eva::procchk::Invoke_CheckNoSdCard,              false},
    { "CHECK SD SIZE",         {G_CTR_NCHECK1, TID_NCHECK_SD_SIZE},        uji::eva::procchk::Invoke_CheckSdCardSize,            true },
    { "CHECK TP ACCURACY",     {G_TP,        TID_TP_ACCURACY },            uji::eva::wrap::CheckTPAccuracy_ProcCheck,            true },
    { "CHECK FIRSTLAUNCH FLAG",{G_NCHECK,    TID_NCHECK_FIRSTLAUNCH_FLAG}, uji::eva::procchk::Invoke_CheckFirstLaunchFlag,       true },
    { "WRITE OK LOG",          {G_NCHECK,    TID_NCHECK_WRITE_LOG},        uji::eva::procchk::Invoke_WriteProductLog,            true },
    { "DISPLAY QRCODE",        {G_NCHECK,    TID_NCHECK_DISPLAY_QR},       uji::eva::procchk::Invoke_DisplayQRCode,              true },
    {NULL}                              //^[~l[V
};

//ēiJ[hj
static uji::seq::TestList ReentryList[] = {
    { "LOG EXTRACT CPU BOARD",     {G_LOG,     TID_LOG_EXTRACT_CPU_BOARD},  uji::eva::TestExtractCpuBoard,              true },
    { "BACK UP RTC CAL",           {G_MISC,    TID_BACK_UP_RTC_CAL},        uji::sec::cal::TestBackUpRtcCalAndWriteStartLog, true },
    { "ERASE CAL",                 {G_MISC,    TID_ERASE_CAL},              uji::sec::cal::TestEraseCal,                true },
    { "RESTORE RTC CAL",           {G_MISC,    TID_RESTORE_RTC_CAL},        uji::sec::cal::TestRestoreRtcCal,           true },
    { "CONFIRM INITIALIZE",        {G_MISC,    TID_CONFIRM_CAL_INITIALIZED},uji::sec::cal::TestConfirmCalInitialized,   true },
    { "RESET SETTING",             {G_NAPP_IMPORT,  TID_NAPP_IMPORT_RESET_SETTING},  uji::eva::import::TestExecuteResetSetting,  true },
    { "WRITE OK LOG",              {G_LOG,     TID_LOG_WRITE_OK_LOG_SOLO},  uji::sec::cal::TestWriteOkLog,              true },
    {NULL}                              //^[~l[V
};

// C_ VXej[XVp
static uji::seq::TestList UpdateList[] = {
    { "INITIALIZE",         {G_NAPP_IMPORT,  TID_NAPP_IMPORT_INITIALIZE},          uji::eva::import::TestExecuteInitialize,        true  },
    { "COMPARE DEFAULT LIST",{G_NAPP_IMPORT, TID_NAPP_CHECK_DEFAULT_LIST},         uji::eva::import::TestExecuteCompareDefaultTitleList,   true  },
    { "DELETE TEST PROGRAM",{G_NAPP_IMPORT,  TID_NAPP_IMPORT_DELETE_TEST_PROGRAM}, uji::eva::import::TestExecuteDeleteTestProgram, true  },
    { "IMPORT CIA",         {G_NAPP_IMPORT,  TID_NAPP_IMPORT_CIA},                 uji::eva::import::TestExecuteImportCia,         true  },
    { "UPDATE FIRMWARE",    {G_NAPP_IMPORT,  TID_NAPP_UPDATE_FIRMWARE},            uji::eva::import::TestExecuteUpdateFirmware,    true  },
    { "GET APPLICATION INFO", {G_NAPP_IMPORT,TID_NAPP_IMPORT_GET_APPINFO},         uji::eva::import::TestExecuteGetAppInfo,        true  },
    { "COMPARE TICKET DB",  {G_NAPP_IMPORT,  TID_NAPP_COMPARE_TICKET_DB},          uji::eva::import::TestExecuteCompareTicketDatabase,  true  },
    { "COMPARE TITLE LIST", {G_NAPP_IMPORT,  TID_NAPP_COMPARE_TITLE_LIST},         uji::eva::import::TestExecuteCompareTitleList,  true  },
    { "WRITE OK LOG",       {G_NAPP_IMPORT,  TID_NAPP_IMPORT_WRITE_UPDATE_OK_LOG}, uji::eva::import::TestExecuteWriteUpdateOkLog,  true  },
    {NULL}                              //^[~l[V
};

// f[^
// ETCP COMMUNICATE ŁAVAio[Ƃ邽߁ATCP COMMUNICATE  CHECK SER NO OɎ{
// ECLEAR RFU NOR ́ATCP COMMUNICATEɎ{iNORɂlbg[NݒNA邽)
// ESIGN VALIDATE ̌ɁAWRITE SIGN LOG Ă
static uji::seq::TestList ImportList[] = {
    { "CHECK AGING LOG",    {G_NCHECK,       TID_NCHECK_AGING_LOG},                uji::eva::import::Invoke_CheckAgingLog,                  true  },
    { "CHECK BLANK SD",     {G_NCHECK,       TID_NCHECK_BLANK_SD},                 uji::eva::procchk::Invoke_CheckBlankSdCard,              true  },
    { "INITIALIZE",         {G_NAPP_IMPORT,  TID_NAPP_IMPORT_INITIALIZE},          uji::eva::import::TestExecuteInitialize,                 true  },
    { "STARTUP",            {G_NAPP_IMPORT,  TID_NAPP_IMPORT_STARTUP},             uji::eva::import::TestExecuteStartup,                    true  },
    { "WRITE START LOG",    {G_NAPP_IMPORT,  TID_NAPP_IMPORT_WRITE_START_LOG},     uji::eva::import::Invoke_WriteStartLog,                  true  },
    { "CHECK INSTALL STATE",{G_NAPP_IMPORT,  TID_NAPP_IMPORT_CHECK_INSTALL_STATE}, uji::eva::import::Invoke_CheckInstallState,              false },
    { "WRITE REGION",       {G_NAPP_IMPORT,  TID_NAPP_IMPORT_WRITE_REGION},        uji::eva::import::TestExecuteWriteRegionFromSerial,      false },
    { "TCP COMMUNICATE",    {G_NAPP_IMPORT,  TID_NAPP_IMPORT_TCP_COMMUNICATE},     uji::eva::import::Invoke_TcpComm,                        true  },
    { "CHECK HSM LOG",      {G_NAPP_IMPORT,  TID_NAPP_IMPORT_CHECK_HSM_LOG},       uji::eva::import::TestExecuteCheckHsmLog,                HSM_RESTRICT},
    { "CLEAR RFU NOR",      {G_NCHECK,       TID_NCHECK_CLEAR_RFU_NOR},            uji::eva::procchk::Invoke_ClearRfuNor,                   true  },
    { "CHECK SER NO",       {G_NCHECK,       TID_NCHECK_SER_NO},                   uji::eva::procchk::Invoke_CheckSerialNo,                 true  },
    { "CHECK REGION",       {G_NCHECK,       TID_NCHECK_REGION},                   uji::eva::procchk::Invoke_CheckRegion,                   true  },
    { "VALIDATE SIGN",      {G_NCHECK,       TID_NCHECK_VALIDATE_SIGN},            uji::eva::procchk::Invoke_ValidateSign,                  true  },
    { "WRITE SIGN LOG",     {G_NAPP_IMPORT,  TID_NAPP_IMPORT_WRITE_SIGN_LOG},      uji::eva::import::Invoke_WriteSignLog,                   true  },
    { "HARDWARE RESET",     {G_NAPP_IMPORT,  TID_NAPP_IMPORT_HARDWARE_RESET},      uji::eva::import::TestExecuteHardwareReset,              REBOOT     },
    //----------------------------------------------------------------------------------------------------------------------------------------------
    // HARDWARE RESET sƈUċN܂B
    //----------------------------------------------------------------------------------------------------------------------------------------------
    { "REINITIALIZE",       {G_NAPP_IMPORT,  TID_NAPP_IMPORT_REINITIALIZE},        uji::eva::import::TestExecuteReinitializeAfterReboot,    REBOOT     },
    { "EXTRACT AC ADAPTER", {G_NAPP_IMPORT,  TID_NAPP_EXTRACT_AC_ADAPTER},         uji::eva::import::TestExecuteExtractAcAdapter,           false },
    { "CHECK BATTERY LEVEL",{G_NAPP_IMPORT,  TID_NAPP_CHECK_REMAINING_BATTERY_LV}, uji::eva::import::TestExecuteCheckRemainingBatteryLv,    true  },
    { "NEEDS CLEANUP"      ,{G_NAPP_IMPORT,  TID_NAPP_IMPORT_NEEDS_CLEANUP},       uji::eva::import::TestExecuteNeedsCleanup,               true  },
    { "INITIALIZE SDMC",    {G_NAPP_IMPORT,  TID_NAPP_IMPORT_INITIALIZE_SDMC},     uji::eva::import::TestExecuteInitializeSdmc,             PREINSTALL },
    { "DELETE TEST PROGRAM",{G_NAPP_IMPORT,  TID_NAPP_IMPORT_DELETE_TEST_PROGRAM}, uji::eva::import::TestExecuteDeleteTestProgram,          true  },
    { "DELETE PREIN TICKET",{G_NAPP_IMPORT,  TID_NAPP_IMPORT_DELETE_PREIN_TICKET}, uji::eva::import::TestExecuteDeletePreinstallTicket,     HSM_RESTRICT},
    { "RESET SETTING",      {G_NAPP_IMPORT,  TID_NAPP_IMPORT_RESET_SETTING},       uji::eva::import::TestExecuteResetSetting,               true  },
    { "WRITE HOME MENU ID", {G_NAPP_IMPORT,  TID_NAPP_WRITE_HOME_MENU_ID},         uji::eva::import::TestExecuteWriteHomeMenuId,            true  },
    { "CHANGE CFG PARAMETERS",{G_NAPP_IMPORT,TID_NAPP_CHANGE_CFG_PARAMETERS},      uji::eva::import::TestExecuteChangeConfigParameters,     CARM  },
    { "CHANGE OPENING MENU",{G_NAPP_IMPORT,  TID_NAPP_CHANGE_OPENING_MENU},        uji::eva::import::TestExecuteChangeOpeningMenu,          TEST_MENU_BOOT },
    { "SET LCD MIN BRIGHTNESS",{G_NAPP_IMPORT,  TID_NAPP_SET_LCD_MIN_BRIGHTNESS},  uji::eva::import::TestExecuteSetLcdMinBrightness,        true  },
    { "IMPORT CIA",         {G_NAPP_IMPORT,  TID_NAPP_IMPORT_CIA},                 uji::eva::import::TestExecuteImportCia,                  true  },
    {"@"},
    { "RESTORE LCD BRIGHTNESS",{G_NAPP_IMPORT,  TID_NAPP_RESTORE_LCD_BRIGHTNESS},  uji::eva::import::TestExecuteRestoreLcdBrightness,       true  },
    { "UPDATE FIRMWARE",    {G_NAPP_IMPORT,  TID_NAPP_UPDATE_FIRMWARE},            uji::eva::import::TestExecuteUpdateFirmware,             true  },
    { "IMPORT EXT SAVEDATA",{G_NAPP_IMPORT,  TID_NAPP_IMPORT_EXT_SAVEDATA},        uji::eva::import::TestExecuteImportExtSaveData,          PREINSTALL },
    { "WRITE TWL FONT TABLE", {G_NAPP_IMPORT,TID_NAPP_WRITE_TWL_FONT_TABLE},       uji::eva::import::TestExecuteWriteTWLFontTable,          CHN_KOR    },
    { "GET APPLICATION INFO", {G_NAPP_IMPORT,TID_NAPP_IMPORT_GET_APPINFO},         uji::eva::import::TestExecuteGetAppInfo,                 true  },
    { "WAS PROPERLY IMPORTED",{G_NAPP_IMPORT,TID_NAPP_WAS_PROPERLY_IMPORTED},      uji::eva::import::TestExecuteWasProperlyImported,        true  },
    { "COMPARE PROGRAM INFO", {G_NAPP_IMPORT,TID_NAPP_COMPARE_PROGRAM_INFO},       uji::eva::import::TestExecuteCompareProgramInfo,         true  },
    { "COMPARE TICKET DB",  {G_NAPP_IMPORT,  TID_NAPP_COMPARE_TICKET_DB},          uji::eva::import::TestExecuteCompareTicketDatabase,      true  },
    { "COMPARE TITLE LIST", {G_NAPP_IMPORT,  TID_NAPP_COMPARE_TITLE_LIST},         uji::eva::import::TestExecuteCompareTitleList,           false },
    { "COMPARE PREIN LIST", {G_NAPP_IMPORT,  TID_NAPP_COMPARE_PREIN_LIST},         uji::eva::import::TestExecuteComparePreInstallTitleList, false },
    { "WRITE OK LOG",       {G_NAPP_IMPORT,  TID_NAPP_IMPORT_WRITE_OK_LOG},        uji::eva::import::TestExecuteWriteOkLog,                 true  },
    {NULL}                              //^[~l[V
};

//ꎞgp
static uji::seq::TestList ScratchList[] = {
    { "ATTEST",                 {G_ATTEST, TID_ATTEST},                     uji::eva::TestAttest,                   true },

    {NULL}                              //^[~l[V
};

//[Uf[^ޔ
static uji::seq::TestList BackupList[] = {
    { "CHECK SD",                  {G_MISC, TID_BACKUP_CHECK_SD},           uji::eva::backup::TestSdCardWritable,   true },
    { "MAKE DIRECTORY",            {G_MISC, TID_BACKUP_MAKE_DIRECTORY},     uji::eva::backup::MakeDirectory,        true },
    { "BACKUP INSPECT LOG",        {G_MISC, TID_LOG_BACKUP_INSPECTLOG},     uji::eva::backup::BackupInspectLog,     true },
    { "BACKUP CAL",                {G_MISC, TID_BACKUP_BACKUP_CAL},         uji::eva::backup::BackupCal,            true },
    { "BACKUP PRODUCT LOG",        {G_MISC, TID_LOG_BACKUP_PRODUCTLOG},     uji::eva::backup::BackupProductLog,     true },
    {NULL}                              //^[~l[V
};

//[Uf[^
static uji::seq::TestList RestoreList[] = {
    { "CHECK SD",                  {G_MISC, TID_BACKUP_CHECK_SD},           uji::eva::backup::TestSdCardAvailable,  true },
    { "RESTORE INSPECT LOG",       {G_MISC, TID_LOG_RESTORE_INSPECTLOG},    uji::eva::backup::RestoreInspectLog,    true },
    { "RESTORE SER NO",            {G_MISC, TID_BACKUP_RESTORE_SER_NO},     uji::eva::backup::RestoreSerialNumber,  true },
    { "RESTORE CAL",               {G_MISC, TID_BACKUP_RESTORE_CAL},        uji::eva::backup::RestoreCal,           true },
    { "RESTORE PRODUCT LOG",       {G_MISC, TID_LOG_RESTORE_PRODUCTLOG},    uji::eva::backup::RestoreProductLog,    true },
    { "WRITE OK LOG SOLO",         {G_LOG,  TID_LOG_WRITE_OK_LOG_SOLO },    uji::eva::TestWriteOkLogSolo,           true },
    {NULL}                              //^[~l[V
};

// \tg
static uji::seq::TestList AppImportList[] = {
    { "APPLICATION IMPORT",        {G_MISC, TID_APP_IMPORT},        uji::eva::ApplicationImporter::ImportAndRunApplication, true },

    {NULL}                              //^[~l[V
};

//[h̏͂
uji::seq::TestListInformation g_TestListSet[]={
    { "LcdAndKey",          LcdAndKeyList       },
    { "Icam",               InCameraTestList    },
    { "Gyroscope",          GyroMasterTestList  },
    { "Aging",              AgingList           },
    { "TpCal",              TouchPanelTestList  },
    { "Scratch",            ScratchList         },
    { "Acc",                AccelList           },
#ifdef EVA_MIC_TESTER_QC
    { "Mic_QC",             MicTesterList       },
#else  //ʏ
    { "Mic",                MicTesterList       },
#endif
    { "SlidePad",           SlidePadList        },
    { "P-PCheck",           PreProcCheckList    },
    { "ProcCheck",          ProcCheckList       },
    { "Reentry",            ReentryList         },
    { "Import",             ImportList          },
    { "Backup",             BackupList          },
    { "Restore",            RestoreList         },
    { "Update",             UpdateList          },
    { "OcamWB",             OutCameraWBTestList },
    { "SpAndTp",            SpAndTpTestList     },
    { "CamCapture",         CameraCaptureTestList},
    { "AgingImport",        AgingImportList     },
    { "AppImport",          AppImportList       },
    {NULL}                              //^[~l[V
};
#endif

/* dCN[h̉ */
#endif
