/************************************************************************

JƒʐMۂ̑҂

*************************************************************************/
#include <nn.h>
#include "sys.h"
#include "TestList.h"
#include "Config.h"
#include "CommCamera.h"
#include "../eva/camera/TestCamera.h"
#include "Reception_camera.h"

#ifdef EVA_COMPOSITE    //FTR DP2p
#include "TestSequencer.h"
static void ShowPicture( wchar_t *file );
#endif  //DP2p܂


using namespace uji::sys;
using namespace uji::seq;

extern uji::seq::TestList CheckerList[];

uji::seq::CommPacketCamera *uji::seq::g_CommPacketCamera=0;

static void WaitButton(void);
static bool ScanCardSlot(void);

/************************************************************************
fobOo
  ***********************************************************************/
static void DebugOut( const char *str )
{
	Config c;
	if( c.Get().EnableDebugOut ){
		nn::Result nnResult;
		nn::fs::FileOutputStream ofile;
		if( nn::fs::MountSdmc().IsFailure() ) SYS_PANIC( "FAIL TO MOUNT SDMC" );
		nn::fs::TryCreateDirectory(L"sdmc:/uji" );
		nnResult = ofile.TryInitialize( L"sdmc:/uji/debug.txt", true );
		ofile.Seek( ofile.GetSize(), nn::fs::POSITION_BASE_BEGIN );
		ofile.Write( str, strlen(str) );
		ofile.Finalize();
		nn::fs::Unmount("sdmc:");
	}
}

/************************************************************************
hc߂Ή֐s
************************************************************************/
static void Execute( InputTextWindow *win, uji::eva::CommPack *commPack, TestId id )
{
	TestList *list = CheckerList;
	bool isMatched = false;
	bool judge;
	TestResult *result = new TestResult;

	while( list->m_Name!=NULL && isMatched==false )
	{
		if( list->m_Id.m_Major==id.m_Major && list->m_Id.m_Minor==id.m_Minor && list->m_Function!=NULL )
		{

			{
				char str[100];
				sprintf( str, "[%s]\n", list->m_Name );
				DebugOut( str );
			}

			//𖄂ߍ
			win->Printf( "ARG[0]=%02X ARGNUM=%d\n", commPack->Arg[0], commPack->ArgNum );
			memcpy( result->m_String, commPack->Arg, commPack->ArgNum&0xff );
			if( commPack->ArgNum !=0xff ) result->m_String[commPack->ArgNum]='\0';

			win->Printf( "%s ", list->m_Name );
			judge = (list->m_Function)( *result );
			win->Printf( "%s\n", judge?"PASS":"FAIL" );
			win->Printf( "%s,LEN=%d\n", result->m_String, strlen( result->m_String)+1 );

			//߂lRpbNɑ
			strcpy( commPack->Arg, result->m_String );
			commPack->ArgNum= strlen( result->m_String);
			isMatched=true;
			
		}

		list++;
	}

	if( !isMatched )
	{
		win->Printf( "Not Matched!!\n" );
		//ŏIIɂ͂g`ks
	}
	
	delete result;
}

/************************************************************************
fBXvCP̃Abvf[g
  ************************************************************************/
static void UpdateDisplay1(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

	Menu::m_WindowManager.Update();
	Menu::m_WindowManager.UpdatePad(pad);
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
	gfx->m_DrawFramework->Clear();        
	Menu::m_WindowManager.DrawDisplay1();
	gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 
}

/************************************************************************
JƒʐMۂ̑҂
*************************************************************************/
void uji::seq::Reception_Camera(void)
{
	uji::sys::Pad pad;
	u8 *buffer;
	int mode;
#ifdef EVA_COMPOSITE
	// FTRJ␳HpvOItO
    bool m_IsTestFinished = false;
#endif
    bool m_isCardPowerActive;   // J[hhĂĒʓdĂ邩̃tO
    u8 CardState;               // J[hd̏Ԏ擾pϐ

	u16 code;
	TestId id;
	static const int FONT_SIZE=14;
	Config *config = new Config;
	uji::eva::CommPack *commPack = new uji::eva::CommPack;

	InputTextWindow *win = new uji::sys::InputTextWindow(
		uji::sys::GraphicsDrawing::DISPLAY1_WIDTH/(FONT_SIZE/2),
		uji::sys::GraphicsDrawing::DISPLAY1_HEIGHT/FONT_SIZE,
		FONT_SIZE,
        uji::sys::Menu::m_WindowManager);

	win->SetTitle( "RECEPTION for Camera checker" );
	Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY1, 0, 0 );        

	win->Printf("\f");

	uji::eva::TestCamera::PreInitialize();	//WŌꍇp̓ʃo

	WaitButton();

	g_CommPacketCamera = new CommPacketCamera;
	g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
	win->Printf("CSPI MODE=%d\n", config->Get().CspiMode );

	do
	{
		//pbhXV
        pad.UpdatePad();

        // ŃJ[hd̊mF{iuNtbVJ[hł̌ɑΉj
        
        //J[hd̊mF
        nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
        if(!CardState || CardState == 0x0C)
        {
            //J[hdĂȂA͏ԑJڒ̏ꍇ
            m_isCardPowerActive = false;
            
            //J[hď
            while(!m_isCardPowerActive)
            {
                //J[hd̏Ԏ擾
                nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
                
                if(!CardState)  //J[hdOFF
                {
                    //xdĂ݂āAXe[gǂ]Ԃ`FbN
                    if(ScanCardSlot())  m_isCardPowerActive = true;
                    else                m_isCardPowerActive = false;
                }
                else if(CardState == 0x04 || CardState == 0x08)
                {
                    //0x08̏ꍇ͐ɒʓdA0x04ɂȂXe[g͖mFON̖͗l
                    m_isCardPowerActive = true;
                }
                else if(CardState == 0x0C)
                {
                    //JڒȂ̂ōă[v
                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
                }
                else
                {
                    //ɗXe[g͖͂H
                }
            }
        }
        else m_isCardPowerActive = true;    //̍s0x04zȌԂłȂΗvȂ͂
        // ɓB_ŁẢ̎MɂĂ͓dONO

		g_CommPacketCamera->Update();

		if( g_CommPacketCamera->IsFifoHazard() )
		{
			win->Printf( "READ FIFO ERROR, FIFO RESET!!\n" );
			g_CommPacketCamera->ClearFifoHazard();	
		}

		if( g_CommPacketCamera->ReadCommand( commPack ) )
		{
			id.m_Major = commPack->CommID >>8;
			id.m_Minor = commPack->CommID & 0xff;
			win->Printf( "INST=0x%04X[%02d-%03d]\n", commPack->CommID, id.m_Major, id.m_Minor );
			Execute( win, commPack, id );
			g_CommPacketCamera->ReplyCommand( commPack );
#ifdef EVA_COMPOSITE
            // OKOݎɌIƔf
			if( id.m_Major == G_CAMERA && id.m_Minor == TID_CAMERA_LOG_PASS )
			{
        		g_CommPacketCamera->Update();
                m_IsTestFinished = true;
            }
#endif
		}

		UpdateDisplay1();
		
#ifdef EVA_COMPOSITE
		// FTRpɌIPassʕ\ă[v甲鏈
		if( m_IsTestFinished )
		{
            ShowPicture( L"rom:/jpeg/Pass.jpg" );
            break;
        }
#endif

	}
	while( !pad.IsButtonDown(Pad::BUTTON_B) );

	delete commPack;
	delete config;

	Menu::m_WindowManager.DestroyWindow(win);
	delete win;

	g_CommPacketCamera->Finalize();
	delete g_CommPacketCamera;

}
/************************************************************************
{^҂
*************************************************************************/
static void WaitButton(void)
{
	uji::sys::Pad pad;
	uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
	JpegDrawer *jd = new JpegDrawer;

	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
	gfx->m_DrawFramework->Clear();        
	jd->OpenPicture( L"rom:/jpeg/Start.jpg" );
	jd->DrawPicture( NN_GX_DISPLAY0 );


	do
	{
		//pbhXV
        pad.UpdatePad();
		gfx->m_DrawFramework->SwapBuffers();

	}
	while( !pad.IsButtonDown(Pad::BUTTON_A) );

	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
	gfx->m_DrawFramework->Clear();        
	gfx->m_DrawFramework->SwapBuffers();

	jd->ClosePicture();
	delete jd;
}

/************************************************************************
ʂɊG\

************************************************************************/
static void ShowPicture( wchar_t *file )
{
    GLuint s_TextureId;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    JpegTexture jt;

    jt.Open( file );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            GL_RGB_NATIVE_DMP,
                                            jt.GetWidth(),
                                            jt.GetHeight(),
                                            GL_RGB_NATIVE_DMP,
                                            GL_UNSIGNED_SHORT_5_6_5,
                                            jt.GetTextureDataPointer(),
                                            s_TextureId );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle(s_TextureId,
                                                0.0f, 0.0f,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                jt.GetWidth(), jt.GetHeight() );
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->DeleteTexture(s_TextureId);
    jt.Close();

}

//------------------------------------------------------------------------------
// ɓdāAJ[h̑}Ԃ𒲍B
//------------------------------------------------------------------------------
static bool ScanCardSlot(void)
{
    u8 PowerState, CardState;
    
    //dĂ݂
    nn::fs::CardSlotPowerOn(&PowerState);
    
    //Jڒ߂
    do
    {
        nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    }while(CardState == 0x0C);
    
    //Jڌ̏ԂmF
    nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    if(!CardState) return false;
    else if(CardState == 0x04)
    {
        nn::fs::CardSlotPowerOff(&PowerState);
        
        return false;
    }
    else if(CardState == 0x08) return true;
    
    //ɗ̂s
    nn::fs::CardSlotPowerOff(&PowerState);
    return false;
}

