/************************************************************************

^C^tF[XƒʐMۂ̑҂

*************************************************************************/
#include <nn.h>
#include "CommC2T.h"
#include "TestList.h"
#include "Config.h"
#include "Register_board_interface.h"
#include "Reception_board_interface.h"


#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/drivers/cal/cal_default.h>         // CTR  CAL ftHgl
#include <nn/drivers/cal/cal_default_MODEL3.h>  // FTR  CAL ftHgl

// CFGꎞύX̂ɕKv
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/detail/cfg_Default.h>

using namespace uji::sys;
using namespace uji::seq;

extern uji::seq::TestList CheckerList[];

uji::seq::CommC2T *uji::seq::g_CommC2T=0;
bool uji::seq::g_IsGfxUpdate = true;

/************************************************************************
hc߂Ή֐s
************************************************************************/
static void Execute( InputTextWindow *win, TestId id, u8 *buffer )
{
	TestList *list = CheckerList;
	bool isMatched = false;
	bool judge;
	TestResult result;

	while( list->m_Name!=NULL && isMatched==false )
	{
		if( list->m_Id.m_Major==id.m_Major && list->m_Id.m_Minor==id.m_Minor )
		{
			win->Printf( "%s ", list->m_Name );

			if( strlen( (char*)buffer )!=0 )
			{
				strncpy( result.m_String, (char*)buffer, uji::seq::MAX_STRING_LEN );
			}

			judge = (list->m_Function)( result );
			win->Printf( "%s\n", judge?"PASS":"FAIL" );
			g_CommC2T->Send( (u16)judge, (u8*)(&result.m_String[0]), strlen( result.m_String )+1 );
			win->Printf( "%s,LEN=%d\n", result.m_String, strlen( result.m_String)+1 );

			isMatched=true;
		}

		list++;
	}

	if( !isMatched )
	{
		win->Printf( "Not Matched!!\n" );
		g_CommC2T->Send( (u16)false, NULL, 0 );

		//ŏIIɂ͂g`ks
	}
}
/************************************************************************
fBXvCÕAbvf[g
  ************************************************************************/
static void UpdateDisplay0(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

	Menu::m_WindowManager.Update();
	Menu::m_WindowManager.UpdatePad(pad);
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
	gfx->m_DrawFramework->Clear();        
	Menu::m_WindowManager.DrawDisplay0();
	gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 
}

/************************************************************************
^C^tF[XƒʐMۂ̑҂
*************************************************************************/
void uji::seq::Reception_BoardInterface(void)
{
	uji::sys::Pad pad;
	u8 *buffer;
	int mode;

	u16 code;
	TestId id;
	static const int FONT_SIZE=14;
	buffer = new u8[DPRAM_SIZE];
	Config *config = new Config;

	InputTextWindow *win = new uji::sys::InputTextWindow(
		uji::sys::GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2),
		uji::sys::GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE,
		FONT_SIZE,
        uji::sys::Menu::m_WindowManager);

	win->SetTitle( "RECEPTION for Board/Interface checker " );
	Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY0, 0, 0 );        

	win->Printf("\f");
	
	g_CommC2T = new CommC2T;
	g_CommC2T->Initialize( static_cast<CommC2T::SpiType>(config->Get().CspiMode_Board) );
	win->Printf("CSPI MODE=%d\n", config->Get().CspiMode_Board );
	g_IsGfxUpdate = true;
	bool flag_BLTest = false;   // CFGlꎞIɕύX邽߂̃obNCgtO
	do
	{
		//pbhXV
        pad.UpdatePad();

		if( g_CommC2T->CanReceive() )
		{
			if( !g_CommC2T->Receive( &code, buffer, DPRAM_SIZE ) )
			{
				win->Printf( "inhibit bit is illegal!!\n" );
			}
			else
			{
				id.m_Major = code >>8;
				id.m_Minor = code & 0xff;
				win->Printf( "INST=0x%04X[%02d-%03d]\n", code, id.m_Major, id.m_Minor );

                // FTR̏ꍇAꎞIɃobNCgdCFGlύX
                // ŏPxd̎V[PX̏ꍇ
                if( flag_BLTest == true && uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType() )
                {
                    // tOĂtO܂āACFGlɖ߂B
                    nn::cfg::CTR::detail::BacklightPwmTableCfgData backlightPwmTableCfgData;
                    bit32 cfgKey = GET_CFG_KEY( nn::cfg::CTR::detail::NN_CFG_LCD, nn::cfg::CTR::detail::NN_CFG_LCD_BACKLIGHT_PWM_TABLE);
                    size_t size  = sizeof(backlightPwmTableCfgData);

                    // ݂ CFGl擾
                    nn::cfg::CTR::init::GetConfig( &backlightPwmTableCfgData, size, cfgKey );

                    // CAL l擾
                    nn::drivers::cal::MODEL3::Calibration cal;
                    cal.Initialize();
                    nn::drivers::cal::MODEL3::BacklightCalDataCore  backlightCalDataCore;
                    cal.Get(&backlightCalDataCore, nn::drivers::cal::MODEL3::CAL_DATA_BL_PWM);

                    // CALQƂČ̒lɖ߂
                    // W
                    for(int i=0; i<3; i++){
                        for(int j=0; j<3; j++){
                            backlightPwmTableCfgData.coef[i][j] = backlightCalDataCore.coef[i][j];
                        }
                    }
                    // PxiKe[u
                    for(int i=0; i<7; i++){
                        backlightPwmTableCfgData.luminanceLevel[i] = backlightCalDataCore.luminanceLevel[i];
                    }

                    // {̂Ɍ̒l߂(OɈӐ} FlushĂ̂߁AFlush)
                    if( nn::cfg::CTR::init::SetConfig( cfgKey, &backlightPwmTableCfgData, size ).IsFailure() )
                    {
                        SYS_PANIC( "CFG SET FAIL" );
                    } 
                    if( nn::cfg::CTR::init::FlushConfig().IsFailure() )
                    {
                        SYS_PANIC( "CFG FLUSH FAIL" );
                    }
                    flag_BLTest = false;
                }
                // R}hőPxd̏ꍇ
                else if( id.m_Major==49 && id.m_Minor==1 && uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType() )
                {
                    // obNCgdOCFGύX
                    // PWMl CTRftHg̒lɒu
                    nn::cfg::CTR::detail::BacklightPwmTableCfgData backlightPwmTableCfgData;
                    bit32 cfgKey = GET_CFG_KEY( nn::cfg::CTR::detail::NN_CFG_LCD, nn::cfg::CTR::detail::NN_CFG_LCD_BACKLIGHT_PWM_TABLE);
                    size_t size  = sizeof(backlightPwmTableCfgData);

                    // ݂ CFGl擾
                    nn::cfg::CTR::init::GetConfig( &backlightPwmTableCfgData, size, cfgKey );

                    // CFG  CTRftHglݒ({NANDɊi[Ăl͎gȂ)
                    // W
                    for(int i=0; i<3; i++){
                        for(int j=0; j<3; j++){
                            backlightPwmTableCfgData.coef[i][j] = nn::drivers::cal::CTR::DEFAULT_BACKLIGHT_CAL_DATA.coef[i][j];
                        }
                    }
                    // PxiKe[u
                    for(int i=0; i<7; i++){
                        backlightPwmTableCfgData.luminanceLevel[i] = nn::drivers::cal::CTR::DEFAULT_BACKLIGHT_CAL_DATA.luminanceLevel[i];
                    }

                    // {̂gplƂăZbg({̏ԂςȂ߂ Flush͂Ȃ)
                    if( nn::cfg::CTR::init::SetConfig( cfgKey, &backlightPwmTableCfgData, size ).IsFailure() )
                    {
                        SYS_PANIC( "CFG SET FAIL" );
                    }
                    // CFGl̕ύX𑦎f邽߂ NN_CFG_LCD_BACKLIGHT SetConfig GSPɒʒmB
                    nn::cfg::CTR::detail::BackLightCfgData backLightCfgData;
                    bit32 cfgKey2 = GET_CFG_KEY( nn::cfg::CTR::detail::NN_CFG_LCD, nn::cfg::CTR::detail::NN_CFG_LCD_BACKLIGHT);
                    size_t size2  = sizeof(backLightCfgData);
                    nn::cfg::CTR::init::GetConfig( &backLightCfgData, size2, cfgKey2 );
                    if( nn::cfg::CTR::init::SetConfig( cfgKey2, &backLightCfgData, size2 ).IsFailure() )
                    {
                        SYS_PANIC( "CFG SET FAIL" );
                    } 
                }
                // R}hŏPxd̏ꍇ
                else if( id.m_Major==49 && id.m_Minor==2 && uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType() )
                {
                    // obNCgdȂAtO𗧂Ă
                    flag_BLTest = true;
                }
				Execute( win, id, buffer );
			}
		}

		if( g_IsGfxUpdate )	UpdateDisplay0();
	}
	while( !pad.IsButtonDown(Pad::BUTTON_B) );

	g_IsGfxUpdate = true;
	g_CommC2T->Finalize();

	Menu::m_WindowManager.DestroyWindow(win);
	delete win;
	delete[] buffer;
	delete g_CommC2T;
	delete config;
}
