/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     PortChecker.h

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef _UJI_SEQ_PORT_CHECKER_H_
#define _UJI_SEQ_PORT_CHECKER_H_

#include <nn/types.h>
#include <nn/fs.h>
#include <nn/crypto/crypto_Hash.h>
#include <stdio.h>
#include <string>
#include <math.h>

#include "sys_GraphicsDrawing.h"
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_MessageLogWindow.h"
#include "sys_TextWindow.h"    
#include "sys_Pad.h"

using namespace std;

namespace uji{
namespace seq{


// CursorControl  EBhE
typedef struct CursorControl
{
	int  row    ; // s = CommandEntryIndex
	int  column ; // 
	bool active ; // A{^ŉĂ邩
             
} CursorControl;

//============================================================================
//
//  CommandEntry R}hGgNX(\́j
//
//============================================================================
class CommandEntry
{	
    public: 
    
		//Xe[^X
		static const int STATUS_READY = 0;
		static const int STATUS_GO    = 1;
		static const int STATUS_MAX   = 2;

		//AhX
		static const int ADDRESS_MAX  = 0xFFFFFF;

		//R}h
		static const int COMMAND_READ_WORD        = 0;
		static const int COMMAND_READ_WORD_1TIME  = 1;
		static const int COMMAND_WRITE_WORD       = 2;
		static const int COMMAND_WRITE_WORD_1TIME = 3;	
		static const int COMMAND_MAX              = 4;       

		//f[^
		static const unsigned int DATA_MAX = 0xFFFFFFFF;

		//NbN
		static const int CLOCK_512K_HZ = 0;
		static const int CLOCK_1M_HZ   = 1;
		static const int CLOCK_2M_HZ   = 2;
		static const int CLOCK_4M_HZ   = 3;
		static const int CLOCK_8M_HZ   = 4;
		static const int CLOCK_16M_HZ  = 5;
		static const int CLOCK_MAX     = 6;
     
        //ANZXP
        static const int ACCESS_UNIT_1BYTE = 0;
        static const int ACCESS_UNIT_2BYTE = 1;//Big Endian
        static const int ACCESS_UNIT_4BYTE = 2;//Big Endian
        static const int ACCESS_UNIT_2BYTE_LITTLE= 3;
        static const int ACCESS_UNIT_4BYTE_LITTLE= 4;
        static const int ACCESS_UNIT_MAX   = 5;
     
        //[h 1bit/4bit
        static const int MODE_1BIT = 0;
        static const int MODE_4BIT = 1;//gpĂȂB`̂
        static const int MODE_MAX  = 2;
     
	    int  status          ;//Xe[^X
	    int  addr            ;//AhX
	    int  cmd             ;//R}h
	    unsigned int  data   ;//f[^
	    int  clock           ;//NbN
	    int  bitmode         ;//1bit/4bit
        int  accessunit      ;//1oCgAQoCgASoCg
//
   string AddressToString(int addr) const
   {	  	
	  char msg[6 + 1];
	  
	  memset(msg, 0x00, sizeof(msg));	  
	  sprintf(msg, "%06x", addr);
	  
	  string str;	  
	  str = msg;
	  
	  return str;
   }
   
   string DataToString(int data) const
   {
	  char msg[8 + 1];
	  memset(msg, 0x00, sizeof(msg));
	  
	  sprintf(msg, "%08x", data);
	  
	  string str;
	  str = msg;
	  
	  return str;
   }
   
   string ClipboardToString(int clipboard) const
   {
	  char msg[8 + 1];
	  memset(msg, 0x00, sizeof(msg));
	  
	  sprintf(msg, "%08x", clipboard);
	  
	  string str;
	  str = msg;
	  
	  return str;
   }   
      
// 
   string StatusToString(int s) const
    {
        string str;
        switch( s )
        {
            case STATUS_READY:  { str="READY";      break; }
            case STATUS_GO:     { str="GO   ";      break; }
            case STATUS_MAX:    { str="STATUS_MAX"; break; }            
        }
        return str;
    }
 
    string CommandToString(int s) const
    {
        string str;
        switch( s )
        {
            case COMMAND_READ_WORD:        { str="Rw  ";        break; }
            case COMMAND_READ_WORD_1TIME:  { str="Rw1t";        break; }
            case COMMAND_WRITE_WORD:       { str="Ww  ";        break; }
            case COMMAND_WRITE_WORD_1TIME: { str="Ww1t";        break; }
            case COMMAND_MAX:              { str="COMMAND_MAX"; break; }            
        }
        return str;
    }
    
   string ClockToString(int s) const
    {
        string str;
        switch( s )
        {
            case CLOCK_512K_HZ:            { str="512KHz";      break; }
            case CLOCK_1M_HZ:              { str="1MHz  ";      break; }
            case CLOCK_2M_HZ:              { str="2MHz  ";      break; }
            case CLOCK_4M_HZ:              { str="4MHz  ";      break; }
            case CLOCK_8M_HZ:              { str="8MHz  ";      break; }
            case CLOCK_16M_HZ:             { str="16MHz ";      break; }
            case CLOCK_MAX:                { str="CLOCK_MAX"; break; }
        }
        return str;
    }    
 
    string AccessUnitToString(int s) const
    {
        string str;
        switch( s )
        {
            case ACCESS_UNIT_1BYTE:         { str="1Byte";           break; }
            case ACCESS_UNIT_2BYTE:         { str="2Byte";           break; }
            case ACCESS_UNIT_4BYTE:         { str="4Byte";           break; }
            case ACCESS_UNIT_2BYTE_LITTLE:  { str="2ByteL";          break; }
            case ACCESS_UNIT_4BYTE_LITTLE:  { str="4ByteL";          break; }
            case ACCESS_UNIT_MAX:           { str="ACCESS_UNIT_MAX"; break; }
        }
        return str;
    }    

};//class CommandEntry

//============================================================================
//
//  PortChecker |[g`FbJ[NX
//
//============================================================================
class PortChecker
{
    	static const int COMMAND_ENTRY_MAX = 8;//Ŝ̍siR}hsj̍ő
    	static const int COLUMN_MAX        = 6;//Ŝ̗񐔂̍ő
	    static const int FONT_SIZE         =14;//tHgTCY
	    
private:
		CommandEntry       m_CommandEntryTable[COMMAND_ENTRY_MAX]; //R}hGg̃e[u
		
	    sys::WindowManager m_WindowManager; //EBhE}l[W
    	sys::TextWindow    m_UpperWindow;   //EBhE
        unsigned int       m_clipboard;     //Nbv{[h ( XŃRs[AYŃy[Xgj
	    CursorControl      m_cc;            //J[\ϐ

public:
	PortChecker():	m_UpperWindow(400, 240, FONT_SIZE) //EChE (1 400~c240BtHgTCY14) 
	{
		m_addr_digit = 0;
		m_data_digit = 0;
	}
	
	virtual ~PortChecker(){}
		
	void Initialize(void);

	void Run(void);                      //AvP[ṼC[v
	
	void Execute(CommandEntry *ce, sys::GraphicsDrawing* gfx,CursorControl &cc);//CARDSPI-API̎s֐
	
	// ʕ`
	void DrawUpperLCD(sys::GraphicsDrawing* gfx, CursorControl & cc);
	void Draw_CommandEntry(void);	
	void DrawUnderLine_Data(sys::GraphicsDrawing* gfx, CursorControl & cc);
	void DrawUnderLine_Address(sys::GraphicsDrawing* gfx, CursorControl & cc);

	// J[\
	void CursorUp(void);
	void CursorDown(void);
	void CursorLeft(void);
	void CursorRight(void);	
	
	// L[oChɂȈՃAhX
	void CommandEntry_Set_RoundSPIUSB(void);
	void CommandEntry_Set_Interface(void);
	

    // 
	/// Xe[^X
	void StatusInc(int &s) const;
	void StatusDec(int &s) const;	
	
	/// AhX
	void AddressInc(int & a) const;
	void AddressDec(int & a) const;	
	int m_addr_digit; //

	/// R}h
	void CommandInc(int &s) const;
	void CommandDec(int &s) const;

	/// f[^
	void DataInc(unsigned int & d) const;
	void DataDec(unsigned int & d) const;
	int m_data_digit; //	
	
	/// NbN
	void ClockInc(int &s) const;
	void ClockDec(int &s) const;
	
	/// ANZXP
	void AccessUnitInc(int &s) const;
	void AccessUnitDec(int &s) const;	

    // R}hGg̐
	void         CommandEntry_Init(CommandEntry &ce) const;
	CommandEntry Get_CurrentCommandEntry(void) const;
	void         Set_CurrentCommandEntry(CommandEntry ce);

	// J[hSPIANZX
	/// Read
    void TestRead(int access_unit, nn::fs::FileStream &in, unsigned int& data) const;
	void TestRead_1Byte(nn::fs::FileStream *in, unsigned int * data) const;
	void TestRead_2Byte(nn::fs::FileStream *in, unsigned int * data) const;
	void TestRead_4Byte(nn::fs::FileStream *in, unsigned int * data) const;
	void TestRead_2ByteLittle(nn::fs::FileStream *in, unsigned int * data) const;
	void TestRead_4ByteLittle(nn::fs::FileStream *in, unsigned int * data) const;
		
	/// Write
    void TestWrite(int access_unit, nn::fs::FileStream &out, unsigned int & data) const;
	void TestWrite_1Byte(nn::fs::FileStream *out, unsigned int * data) const;
	void TestWrite_2Byte(nn::fs::FileStream *out, unsigned int * data) const;
	void TestWrite_4Byte(nn::fs::FileStream *out, unsigned int * data) const;
	void TestWrite_2ByteLittle(nn::fs::FileStream *out, unsigned int * data) const;
	void TestWrite_4ByteLittle(nn::fs::FileStream *out, unsigned int * data) const;
	
};

} // namespace seq
} // namespace uji

#endif // _UJI_SEQ_PORT_CHECKER_H_
/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
