/*---------------------------------------------------------------------------*
  Project:  CTR-UJI
  File:     PortChecker.cpp

  Copyright 2010 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/

#include "PortChecker.h"
 
using namespace uji::seq;
using namespace std;


//R}hGg̏
void PortChecker::CommandEntry_Init(CommandEntry &ce) const
{
	//Xe[^X
	ce.status     = CommandEntry::STATUS_READY;
	
	//AhX
	ce.addr       = 0;

    //R}h
	ce.cmd        = CommandEntry::COMMAND_READ_WORD_1TIME;
	
	//f[^
	ce.data       = 0;

	//NbN	
	ce.clock      = CommandEntry::CLOCK_4M_HZ;
	
	//ANZXP
	ce.accessunit = CommandEntry::ACCESS_UNIT_2BYTE;
	
	//샂[h
	ce.bitmode    = CommandEntry::MODE_1BIT;
	
}


void PortChecker::CommandEntry_Set_Interface(void)
{
	m_CommandEntryTable[0].addr = 0x0;
	m_CommandEntryTable[0].cmd  = CommandEntry::COMMAND_READ_WORD;
	
	m_CommandEntryTable[1].addr = 0x2;
	m_CommandEntryTable[1].cmd  = CommandEntry::COMMAND_READ_WORD;

	m_CommandEntryTable[2].addr = 0x4;
	m_CommandEntryTable[2].cmd  = CommandEntry::COMMAND_READ_WORD;

	m_CommandEntryTable[3].addr = 0x6;
	m_CommandEntryTable[3].cmd  = CommandEntry::COMMAND_READ_WORD;


	m_CommandEntryTable[4].addr = 0x800;
	m_CommandEntryTable[4].cmd  = CommandEntry::COMMAND_WRITE_WORD_1TIME;
							
	m_CommandEntryTable[5].addr = 0x802;
	m_CommandEntryTable[5].cmd  = CommandEntry::COMMAND_READ_WORD;
	
	m_CommandEntryTable[6].addr = 0x804;
	m_CommandEntryTable[6].cmd  = CommandEntry::COMMAND_READ_WORD;

}

void PortChecker::CommandEntry_Set_RoundSPIUSB(void)
{
	m_CommandEntryTable[0].addr = 0x4;
	m_CommandEntryTable[1].addr = 0x5;
	m_CommandEntryTable[2].addr = 0x6;
	m_CommandEntryTable[3].addr = 0x1000;

	m_CommandEntryTable[4].addr = 0x8;					
	m_CommandEntryTable[5].addr = 0x9;
	m_CommandEntryTable[6].addr = 0xa;
	m_CommandEntryTable[7].addr = 0x2000;		
	m_CommandEntryTable[7].cmd  = CommandEntry::COMMAND_WRITE_WORD_1TIME;
}


//e[ȕ
void PortChecker::Initialize(void)
{

    //    
    // EChE
    //
    // LCDp
    (void)m_WindowManager.CreateWindow(&m_UpperWindow,       NN_GX_DISPLAY0, 0, 0);
    m_UpperWindow.SetTitle("PORT CHECKER");

    // LCDp
    //(void)m_WindowManager.CreateWindow(&m_LowerWindow,       NN_GX_DISPLAY1, 0, 0);
    //m_LowerWindow.SetTitle("information");

	// e[ȕ
	//
	for(int i = 0; i < COMMAND_ENTRY_MAX; i++)
	{
		CommandEntry_Init(m_CommandEntryTable[i]);
	}
	
	// FSCȕ
	nn::fs::Initialize();
	
}

//Xe[^X
void PortChecker::StatusInc(int & s) const
{
	s = s + 1;
	if ( s == CommandEntry::STATUS_MAX){ s = 0;}
}

void PortChecker::StatusDec(int & s) const
{
	s = s - 1;
	if ( s < 0){ s = CommandEntry::STATUS_MAX-1;}
}

//AhX
void PortChecker::AddressInc(int & a) const
{
	int offset ;
	double base = 16;	
	offset =  static_cast<int>(pow(base, m_addr_digit));
	
	a = a + offset;
	if ( a > CommandEntry::ADDRESS_MAX){ a = 0;}
}

void PortChecker::AddressDec(int & a) const
{
	int offset;
	double base = 16;
	offset =  static_cast<int>(pow(base, m_addr_digit));
	
	a = a - offset;
	if ( a < 0){ a = CommandEntry::ADDRESS_MAX;}
}

// R}h
void PortChecker::CommandInc(int & c) const
{
	c = c + 1;
	if ( c == CommandEntry::COMMAND_MAX){ c = 0;}
}

void PortChecker::CommandDec(int & c) const
{
	c = c - 1;
	if ( c < 0){ c = CommandEntry::COMMAND_MAX-1;}
}

//f[^
void PortChecker::DataInc(unsigned int & d) const
{
	int offset ;
	double base = 16;	
	offset =  static_cast<int>(pow(base, m_data_digit));
	
	d = d + offset;
	if ( d > CommandEntry::DATA_MAX){ d = 0;}
}

void PortChecker::DataDec(unsigned int & d) const
{
	int offset;
	double base = 16;
	offset =  static_cast<int>(pow(base, m_data_digit));
	
	d = d - offset;		
	if ( d < 0){ d = CommandEntry::DATA_MAX;}
}

// NbN
void PortChecker::ClockInc(int & c) const
{
	c = c + 1;
	if ( c == CommandEntry::CLOCK_MAX){ c = 0;}
}

void PortChecker::ClockDec(int & c) const
{
	c = c - 1;
	if ( c < 0){ c = CommandEntry::CLOCK_MAX-1;}
}

// ANZXP
void PortChecker::AccessUnitInc(int & c) const
{
	c = c + 1;
	if ( c == CommandEntry::ACCESS_UNIT_MAX){ c = 0;}
}

void PortChecker::AccessUnitDec(int & c) const
{
	c = c - 1;
	if ( c < 0){ c = CommandEntry::ACCESS_UNIT_MAX-1;}	
}

//------------------------------------------------------------------------------
// R}hGg̃ANZbT
//------------------------------------------------------------------------------
CommandEntry PortChecker::Get_CurrentCommandEntry(void) const
{
	return m_CommandEntryTable[m_cc.row];	
}

void  PortChecker::Set_CurrentCommandEntry(CommandEntry ce)
{
	 m_CommandEntryTable[m_cc.row] = ce;
}

/*---------------------------------------------------------------------------
J[\
---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------
J[\ 
---------------------------------------------------------------------------*/
void PortChecker::CursorUp()
{
	if (false == m_cc.active )
	{
		m_cc.row = m_cc.row - 1;
		if ( m_cc.row < 0) m_cc.row = COMMAND_ENTRY_MAX -1;
	}
	else
	{
		CommandEntry ce;
		ce = Get_CurrentCommandEntry();
		
		switch(m_cc.column)
	    {
			case 0: StatusInc(ce.status);
			        break;
					
			case 1: AddressInc(ce.addr);
        			break;
			 	
			case 2: CommandInc(ce.cmd);
        			break;
 
 			case 3: DataInc(ce.data);
 			        break;
	                        			               
 			case 4: ClockInc(ce.clock);
					break;
						
 			case 5: AccessUnitInc(ce.accessunit);
					break;
		}
		
		Set_CurrentCommandEntry(ce);
	}
}

/*---------------------------------------------------------------------------
J[\ 
---------------------------------------------------------------------------*/
void PortChecker::CursorDown()
{
	if (false == m_cc.active )
	{	
		m_cc.row = m_cc.row + 1;
		if ( m_cc.row >= COMMAND_ENTRY_MAX ) m_cc.row = 0;
	}
	else
	{
		CommandEntry ce;
		ce = Get_CurrentCommandEntry();
		
		switch(m_cc.column)
	    {
			case 0: StatusDec(ce.status);
			        break;
			
			case 1: AddressDec(ce.addr); 
        			break;
			 	
			case 2: CommandDec(ce.cmd);
        			break;
 
 			case 3: DataDec(ce.data);
 			        break;
	                        			               
 			case 4: ClockDec(ce.clock);
					break;	

 			case 5: AccessUnitDec(ce.accessunit);
					break;	
		}
		
		Set_CurrentCommandEntry(ce);
	}
}

/*---------------------------------------------------------------------------
J[\ 
---------------------------------------------------------------------------*/
void PortChecker::CursorLeft()
{
	if (false == m_cc.active )
	{
		m_cc.column = m_cc.column - 1;
		if ( m_cc.column < 0) m_cc.column = COLUMN_MAX -1;
	}
	else
	{
		//ANeBuȏꍇAŌړ
		switch(m_cc.column)
	    {
			case 1: m_addr_digit = m_addr_digit + 1;
					if (m_addr_digit > 5) m_addr_digit = 0; 
 			        break;	
			 	
 			case 3: m_data_digit = m_data_digit + 1;
					if (m_data_digit > 7) m_data_digit = 0; 
 			        break;	                        			               
		}
	}
}

/*---------------------------------------------------------------------------
J[\ E
---------------------------------------------------------------------------*/
void PortChecker::CursorRight()
{
	if (false == m_cc.active )
	{
		m_cc.column = m_cc.column + 1;
		if ( m_cc.column >= COLUMN_MAX ) m_cc.column = 0;	
	}
	else
	{		 		
		//ANeBuȏꍇAEŌړ
		switch(m_cc.column)
	    {
			case 1: m_addr_digit = m_addr_digit - 1;
					if (m_addr_digit < 0) m_addr_digit = 5; 
 			        break;	
			 	
 			case 3: m_data_digit = m_data_digit - 1;
					if (m_data_digit < 0) m_data_digit = 7; 
 			        break;	                        			               
		}
	}
}

/*---------------------------------------------------------------------------
 ʕ`揈
---------------------------------------------------------------------------*/
void PortChecker::DrawUnderLine_Data(sys::GraphicsDrawing* gfx, CursorControl & cc)
{
	switch (m_data_digit)
	{
		case 7: gfx->m_DrawFramework->DrawLine(180.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               187.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
		case 6: gfx->m_DrawFramework->DrawLine(187.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               194.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
		case 5: gfx->m_DrawFramework->DrawLine(194.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               201.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;			
		case 4: gfx->m_DrawFramework->DrawLine(201.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               208.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;		
		case 3: gfx->m_DrawFramework->DrawLine(208.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               215.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
		case 2: gfx->m_DrawFramework->DrawLine(215.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               222.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
		case 1: gfx->m_DrawFramework->DrawLine(222.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               229.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;         						               
		case 0: gfx->m_DrawFramework->DrawLine(229.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         						               236.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
	}
}

void PortChecker::DrawUnderLine_Address(sys::GraphicsDrawing* gfx, CursorControl & cc)
{
 	switch(m_addr_digit)
	{
		case 5:     gfx->m_DrawFramework->DrawLine(76.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         			               				   83.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1)); break;
 		case 4:     gfx->m_DrawFramework->DrawLine(83.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         			               				   90.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1)); break;
 		case 3:     gfx->m_DrawFramework->DrawLine(90.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         			               				   97.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1)); break;
 		case 2:     gfx->m_DrawFramework->DrawLine(97.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         			               				   104.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1)); break;
 		case 1:     gfx->m_DrawFramework->DrawLine(104.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         			               				   111.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1)); break;
 		case 0:     gfx->m_DrawFramework->DrawLine(111.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
         			               				   118.0f, static_cast<f32>((cc.row+4)* FONT_SIZE -1)); break;
    }
}

void PortChecker::DrawUpperLCD(sys::GraphicsDrawing* gfx, CursorControl & cc)
{
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();
        m_WindowManager.DrawDisplay0();
        
    	// R}hGg`
    	Draw_CommandEntry();
    	
		// ΏۃGg̉`
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        
        gfx->m_DrawFramework->SetColor(0.5f, 0.5f, 1.0f, 0.5f);
		gfx->m_DrawFramework->SetPointSize( 2.0f);
				
		double x_start = 0.0f;
		double x_fin   = 0.0f;		
		if ( false == cc.active )
		{		
		    switch(cc.column)
		    {
				case 0: //status 
				        x_start = 12.0f; x_fin = x_start + 5*7;
				        gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;		
				case 1: //address
				        x_start = 75.0f; x_fin = x_start + 6*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
				case 2: //command
		                x_start = 138.0f; x_fin = x_start + 4*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break; 
	 			case 3: //data
	 			        x_start = 180.0f; x_fin = x_start + 8*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
	 			case 4: //clock
	 			        x_start = 249.0f; x_fin = x_start + 6*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
	 			case 5: //accessunit
	 			        x_start = 306.0f; x_fin = x_start + 6*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
			}
		 }
		 else
		 {
		    switch(cc.column)
		    {
				case 0: //status
				        x_start = 12.0f; x_fin = x_start + 5*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;		
				case 1: //address
	        			DrawUnderLine_Address(gfx,cc); break;
	        			
				case 2: //command
   		                x_start = 138.0f; x_fin = x_start + 4*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break; 
	 			case 3: //data
	        			DrawUnderLine_Data(gfx,cc); break;

	 			case 4: //clock
   	 			        x_start = 249.0f; x_fin = x_start + 6*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
	 			case 5: //accessunit
	 			        x_start = 306.0f; x_fin = x_start + 6*7;
	        			gfx->m_DrawFramework->DrawLine(x_start, static_cast<f32>((cc.row+4)* FONT_SIZE -1),
	                         			               x_fin, static_cast<f32>((cc.row+4)* FONT_SIZE -1));break;
			}
		 }

        gfx->m_DrawFramework->SwapBuffers();
        
        return;
}


/*---------------------------------------------------------------------------
R}hGg`
---------------------------------------------------------------------------*/
void PortChecker::Draw_CommandEntry(void)
{
    // wb_
    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);    
    m_UpperWindow.Gotoxy(0, 0);
    m_UpperWindow.Printf( " Status   Address  Cmd   Data      Clock   AccessUnit\n");
    m_UpperWindow.Gotoxy(0, 1);    
    m_UpperWindow.Printf( "-------------------------------------------------------\n");

	// R}hGg
	static char line[80];
	CommandEntry ce;
	for (int i = 0; i < 8; i++)
	{
		// Is̃nCCg
		if (( m_cc.active) &&( i == m_cc.row)) 
		{
			m_UpperWindow.SetTextColor(sys::ATTR_COLOR_GREEN); 	
		}
		else
		{
			m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE); 	
		}
		
		ce = m_CommandEntryTable[i];
		
		m_UpperWindow.Gotoxy(0, 2+i); 
  
	    memset(line, 0x00, sizeof(line));
	    sprintf(line, " %s    %s   %s  %s  %s  %s\n", ce.StatusToString(ce.status).c_str(),
	    								              ce.AddressToString(ce.addr).c_str(),
	    									          ce.CommandToString(ce.cmd).c_str(),
	    									          ce.DataToString(ce.data).c_str(),
	    									          ce.ClockToString(ce.clock).c_str(),
	    									          ce.AccessUnitToString(ce.accessunit).c_str()
	    									       );
	    m_UpperWindow.Printf(line);
	}
	
	// Nbv{[h̕`
	m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE); 		
	m_UpperWindow.Gotoxy(0, 12);
	m_UpperWindow.Printf(" Clipboard [%s]", ce.ClipboardToString(m_clipboard).c_str());
	m_UpperWindow.Gotoxy(0, 13);
	m_UpperWindow.Printf("  x:copy   y:paste");	

	return ;
}

/*---------------------------------------------------------------------------
|[g`FbJ̎s
---------------------------------------------------------------------------*/
void PortChecker::Run(void)
{
   sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();
   
   Initialize(); 

    do 
    {
        // pbh͏
        sys::Pad().UpdatePad();
        
        // EChE
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV
  
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
    	{
			CursorUp();
    	}
		else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
    	{
    	  	CursorDown();
    	}
		else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
    	{        
			CursorLeft();
    	}
		else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
    	{        
			CursorRight();
    	}

		// L[
		if ((sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_B)) && (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_X)))
		{
			CommandEntry_Set_Interface();	
		}
		else if ((sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_B)))
		{
			CommandEntry_Set_RoundSPIUSB();	
		}		
		

		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X))
    	{
            //R}hGg̃f[^Nbv{[hɐݒ
            CommandEntry ce = Get_CurrentCommandEntry();
            if ( 1 == m_cc.column  )
            {
                m_clipboard = ce.addr;
            }
            else if ( 3 == m_cc.column)
            {
                m_clipboard = ce.data;
            }
    	}
		else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_Y))
    	{
            //Nbv{[h̃f[^R}hGgɐݒ
            CommandEntry ce = Get_CurrentCommandEntry();
            if ( 1 == m_cc.column  )
            {
                ce.addr = m_clipboard & 0x00FFFFFF;
            }
            else if ( 3 == m_cc.column)
            {
                ce.data = m_clipboard;
            }
            Set_CurrentCommandEntry(ce);
    	}	


		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_B))
    	{
            m_cc.active = false;
    	}
		else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
    	{
            m_cc.active = !m_cc.active;
    	}	

        //------------------------------------------
    	// LCD̕`
        //------------------------------------------
        DrawUpperLCD(gfx,m_cc);
        
        //----------------	    
	    // ʕ`
	    //----------------
        //DrawLowerLCD(gfx);
        
        //------------------------------------------
        // CARDSPI-API̎s
        //------------------------------------------
        if ( (0 == m_cc.column ) && ( false == m_cc.active ))
        {
			// status  GO sB
			CommandEntry ce = Get_CurrentCommandEntry();
			if ( ce.STATUS_GO == ce.status ) 
			{
				Execute(&ce, gfx, m_cc);
				ce.status = ce.STATUS_READY;
				Set_CurrentCommandEntry(ce);
			}
	    	gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);			
		}
		else
		{
        	// Vsync҂
	    	gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
	    }
	    
    } while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));


    // EChEj
    m_WindowManager.DestroyWindow(&m_UpperWindow);
//    m_WindowManager.DestroyWindow(&m_LowerWindow);
}

/*---------------------------------------------------------------------------
R}hGg̎s
---------------------------------------------------------------------------*/
void PortChecker::Execute(CommandEntry * ce, sys::GraphicsDrawing* gfx, CursorControl & cc) 
{
	wchar_t* clock ;

	NN_LOG("stat=%d addr=%d cmd=%d data=%d clock=%d\n",ce->status, ce->addr,ce->cmd,ce->data, ce->clock);

    //NbN̐ݒ
	switch (ce->clock)
	{
		case CommandEntry::CLOCK_512K_HZ : clock = L"cardspi:/512KHz_1xIO.bin"; break;	
		case CommandEntry::CLOCK_1M_HZ   : clock = L"cardspi:/1MHz_1xIO.bin"; break;	
		case CommandEntry::CLOCK_2M_HZ   : clock = L"cardspi:/2MHz_1xIO.bin"; break;
		case CommandEntry::CLOCK_4M_HZ   : clock = L"cardspi:/4MHz_1xIO.bin"; break;
		case CommandEntry::CLOCK_8M_HZ   : clock = L"cardspi:/8MHz_1xIO.bin"; break;
		case CommandEntry::CLOCK_16M_HZ  : clock = L"cardspi:/16MHz_1xIO.bin"; break;
	}

    // s
	nn::fs::FileStream in;
   	nn::fs::FileStream out;

	switch (ce->cmd)
	{
		case CommandEntry::COMMAND_READ_WORD:        //A[h
			 {
				in.Initialize(clock, NULL);
			 	for(int i=0;;i++) 
			    {
					in.SetPosition(ce->addr);
			 		TestRead(ce->accessunit,in, ce->data);
				    Set_CurrentCommandEntry(*ce);  			 		
//                    if ( 0 == (i % 10))
//                    {
			 		    sys::Pad().UpdatePad();
					    if ( sys::Pad().IsButtonDown(sys::Pad::BUTTON_B) ) break;

					    DrawUpperLCD(gfx,cc);

					    gfx->m_DrawFramework->SwapBuffers();
					   	gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH); 
				        m_WindowManager.Update();               	
//					}
			 	}
			 	in.Finalize();
			 }
			 break;

		case CommandEntry::COMMAND_READ_WORD_1TIME:  //1񃊁[h
			 {
				in.Initialize(clock, NULL);
			 	in.SetPosition(ce->addr);	
			 	    TestRead(ce->accessunit,in, ce->data);
			 	in.Finalize();
			 }
			 break;

		case CommandEntry::COMMAND_WRITE_WORD:      //ACg
			 {
        	 	out.Initialize(clock, NULL);
			 	for(int i = 0;;i++) 
			 	{
				 	out.SetPosition(ce->addr);				
				 	TestWrite(ce->accessunit,out, ce->data);
				    Set_CurrentCommandEntry(*ce);				 	
//				 	if ( 0 == (i % 10))
//				 	{
                        sys::Pad().UpdatePad();
				 	    if ( sys::Pad().IsButtonDown(sys::Pad::BUTTON_B) ) break;
				 	    
				 	    DrawUpperLCD(gfx,cc);
				 	    
				 	    gfx->m_DrawFramework->SwapBuffers();
					   	gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH); 
				        m_WindowManager.Update();              
				 	    
//				 	}
			 	}
			 	out.Finalize();
			 }
			 break;

		case CommandEntry::COMMAND_WRITE_WORD_1TIME:  //1񃉃Cg
			 {
			 	out.Initialize(clock, NULL);
			 	out.SetPosition(ce->addr);
			 	    TestWrite(ce->accessunit, out, ce->data); 
			 	out.Finalize();
			 }
			 break;
	}
}

//------------------------------------------------------------------
// ANZXP(access unit)ς֐
//------------------------------------------------------------------
void PortChecker::TestRead(int access_unit, nn::fs::FileStream &in, unsigned int & data) const
{
    switch (access_unit)
    {
        case CommandEntry::ACCESS_UNIT_1BYTE:        {TestRead_1Byte(&in, &data); } break;
        case CommandEntry::ACCESS_UNIT_2BYTE:        {TestRead_2Byte(&in, &data); } break;
        case CommandEntry::ACCESS_UNIT_2BYTE_LITTLE: {TestRead_2ByteLittle(&in, &data); } break;
        case CommandEntry::ACCESS_UNIT_4BYTE:        {TestRead_4Byte(&in, &data); } break;
        case CommandEntry::ACCESS_UNIT_4BYTE_LITTLE: {TestRead_4ByteLittle(&in, &data); } break;
    }
}

void PortChecker::TestWrite(int access_unit, nn::fs::FileStream &out, unsigned int & data) const
{
   switch (access_unit)
    {
        case CommandEntry::ACCESS_UNIT_1BYTE:        {TestWrite_1Byte(&out, &data); } break;
        case CommandEntry::ACCESS_UNIT_2BYTE:        {TestWrite_2Byte(&out, &data); } break;
        case CommandEntry::ACCESS_UNIT_2BYTE_LITTLE: {TestWrite_2ByteLittle(&out, &data); } break;        
        case CommandEntry::ACCESS_UNIT_4BYTE:        {TestWrite_4Byte(&out, &data); } break;
        case CommandEntry::ACCESS_UNIT_4BYTE_LITTLE: {TestWrite_4ByteLittle(&out, &data); } break;
    }
}

//------------------------------------------------------------------
// Read
//       4byte/2byte/1byte
//------------------------------------------------------------------
void PortChecker::TestRead_4Byte(nn::fs::FileStream *in, unsigned int * data) const
{
    s32 readByte = 0;
    u8  readBuffer[4];
	{
    	memset(readBuffer, 0x00, sizeof(readBuffer));
    	readByte = in->Read(readBuffer, 4);

    	NN_LOG("readByte:%d bytes\n", readByte);
    	NN_LOG("readData:%02X%02X%02X%02X\n", readBuffer[0],
    	                                      readBuffer[1],
    	                                      readBuffer[2],
    	                                      readBuffer[3]);
    	
		*data =  (readBuffer[0]) * 256 * 256 * 256
		        +(readBuffer[1]) * 256 * 256
		        +(readBuffer[2]) * 256
    	        +(readBuffer[3]); 
   
     	NN_LOG("data:%08X\n", *data);
    }
}
void PortChecker::TestRead_4ByteLittle(nn::fs::FileStream *in, unsigned int * data) const
{
    s32 readByte = 0;
    u8  readBuffer[4];
	{
    	memset(readBuffer, 0x00, sizeof(readBuffer));
    	readByte = in->Read(readBuffer, 4);

    	NN_LOG("readByte:%d bytes\n", readByte);
    	NN_LOG("readData:%02X%02X%02X%02X\n", readBuffer[0],
    	                                      readBuffer[1],
    	                                      readBuffer[2],
    	                                      readBuffer[3]);
    	
		*data =  (readBuffer[3]) * 256 * 256 * 256
		        +(readBuffer[2]) * 256 * 256
		        +(readBuffer[1]) * 256
    	        +(readBuffer[0]); 
   
     	NN_LOG("data:%08X\n", *data);
    }
}

void PortChecker::TestRead_2Byte(nn::fs::FileStream *in, unsigned int * data) const
{
    s32 readByte = 0;
    u8 readBuffer[2];
	{
    	memset(readBuffer, 0x00, sizeof(readBuffer));
    	readByte = in->Read(readBuffer, 2);

    	NN_LOG("readByte:%d bytes\n", readByte);
    	NN_LOG("readData:%02X%02X\n", readBuffer[0],readBuffer[1]);
    	
		*data =  (readBuffer[0]) * 256
    	        +(readBuffer[1]); 
   
     	NN_LOG("data:%04X\n", *data);
    }
}

void PortChecker::TestRead_2ByteLittle(nn::fs::FileStream *in, unsigned int * data) const
{
    s32 readByte = 0;
    u8 readBuffer[2];
	{
    	memset(readBuffer, 0x00, sizeof(readBuffer));
    	readByte = in->Read(readBuffer, 2);

    	NN_LOG("readByte:%d bytes\n", readByte);
    	NN_LOG("readData:%02X%02X\n", readBuffer[0],readBuffer[1]);
    	
		*data =  (readBuffer[1]) * 256
    	        +(readBuffer[0]); 
   
     	NN_LOG("data:%04X\n", *data);
    }
}

void PortChecker::TestRead_1Byte(nn::fs::FileStream *in, unsigned int * data) const
{
    s32 readByte = 0;
    u8 readBuffer;
	{
		readBuffer = 0;
    	readByte = in->Read(&readBuffer, 1);

    	NN_LOG("readByte:%d bytes\n", readByte);
    	NN_LOG("readData:%02X\n", readBuffer);
    	
		*data = readBuffer; 
   
     	NN_LOG("data:%02X\n", *data);
    }
}
//------------------------------------------------------------------
// WRITE
//       4byte/2byte/1byte
//------------------------------------------------------------------
void PortChecker::TestWrite_4Byte(nn::fs::FileStream *out, unsigned int * data) const
{
    s32 writtenByte;
	char writeBuffer[4];
	{		
    	memset(writeBuffer, 0x00, sizeof(writeBuffer));
   		writeBuffer[0] = (*data) / (256 * 256 * 256) ;
   		writeBuffer[1] = (*data) / (256 * 256) ;
   		writeBuffer[2] = (*data) / (256) ;
   		writeBuffer[3] = (*data) % (256) ;
   	   		
    	writtenByte = out->Write(writeBuffer, 4);
   		NN_LOG("writtenByte:%d\n", writtenByte);
   		NN_LOG("writtenData:%02X%02X%02X%02X\n", writeBuffer[0],
   		                                         writeBuffer[1],
   		                                         writeBuffer[2],
   		                                         writeBuffer[3]);
   	}
}

void PortChecker::TestWrite_4ByteLittle(nn::fs::FileStream *out, unsigned int * data) const
{
    s32 writtenByte;
	char writeBuffer[4];
	{		
    	memset(writeBuffer, 0x00, sizeof(writeBuffer));
   		writeBuffer[3] = (*data) / (256 * 256 * 256) ;
   		writeBuffer[2] = (*data) / (256 * 256) ;
   		writeBuffer[1] = (*data) / (256) ;
   		writeBuffer[0] = (*data) % (256) ;
   	   		
    	writtenByte = out->Write(writeBuffer, 4);
   		NN_LOG("writtenByte:%d\n", writtenByte);
   		NN_LOG("writtenData:%02X%02X%02X%02X\n", writeBuffer[0],
   		                                         writeBuffer[1],
   		                                         writeBuffer[2],
   		                                         writeBuffer[3]);
   	}
}
void PortChecker::TestWrite_2Byte(nn::fs::FileStream *out, unsigned int * data) const
{
    s32 writtenByte;
	char writeBuffer[2];
	{
    	memset(writeBuffer, 0x00, sizeof(writeBuffer));
   		writeBuffer[0] = (*data) / (256) ;
   		writeBuffer[1] = (*data) % (256) ;
   		
    	writtenByte = out->Write(writeBuffer, 2);
   		NN_LOG("writtenByte:%d\n", writtenByte);
   		NN_LOG("writtenData:%02X%02X\n", writeBuffer[0],writeBuffer[1]);
   	}
}

void PortChecker::TestWrite_2ByteLittle(nn::fs::FileStream *out, unsigned int * data) const
{
    s32 writtenByte;
	char writeBuffer[2];
	{
    	memset(writeBuffer, 0x00, sizeof(writeBuffer));
   		writeBuffer[1] = (*data) / (256) ;
   		writeBuffer[0] = (*data) % (256) ;
   		
    	writtenByte = out->Write(writeBuffer, 2);
   		NN_LOG("writtenByte:%d\n", writtenByte);
   		NN_LOG("writtenData:%02X%02X\n", writeBuffer[0],writeBuffer[1]);
   	}
}

void PortChecker::TestWrite_1Byte(nn::fs::FileStream *out, unsigned int * data) const
{
    s32 writtenByte;
	char writeBuffer;
	{
		writeBuffer = 0x00;
   		writeBuffer = *data ;
   		
    	writtenByte = out->Write(&writeBuffer, 1);
   		NN_LOG("writtenByte:%d\n", writtenByte);
   		NN_LOG("writtenData:%02X\n", writeBuffer);
   	}
}

/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
