/************************************************************************
RtBO[Vݒ
 ************************************************************************/

/* dCN[h̉ */
#ifndef CONFIG_H_INCLUDED
#define CONFIG_H_INCLUDED

/************************************************************************
 ************************************************************************/

#include <vector>
#include <nn.h>
#include "../sys/sys.h"
#include "../sys/sys_Menu.h"
#include "../sys/sys_InputTextWindow.h"

namespace uji{
namespace seq{

/************************************************************************
 ************************************************************************/

/************************************************************************
RtBȌ^ύX^ۑȂǂpNX
 ************************************************************************/
class Config{

public:

	Config(){}
	~Config(){}

   	#define CONFIG_TYPE_DEF			//ŃRtBǑ^錾sĂ܂B
	#include "./ConfigDefine.h"
	#undef  CONFIG_TYPE_DEF


	const Member&	Get(void) const //p[^擾
    {
        return m_StaticConfig; 
    }
	const MemberAlt	GetAlternative(void) const //p[^擾
    {
        return m_StaticConfigAlt; 
    }

	Member&	Set(void) //p[^ݒ
    {
        return m_StaticConfig; 
    }
    
	MemberAlt&	SetAlternative(void) //p[^ݒ
    {
        return m_StaticConfigAlt; 
    }

	bool	Load(void);				//[h
	bool	Save(void);				//[h
	void	Initialize(void);		//p[^̏
	int		GetCheckCode(void);		//RtBOʗp`FbNR[h擾܂B

    struct Information;          
   	static const Information m_ConfigInformation[];

    //f[^̓̓^Cv
    enum Input{
	    Input_DECIMAL = 0,
	    Input_DECIMAL5,
	    Input_DATA,
	    Input_DATA16,
	    Input_BOOL,
		Input_LIST,
        Input_ASCII3
    };

private:
	static Member m_StaticConfig;
  	static MemberAlt m_StaticConfigAlt;

	bool	LoadFromSd(void);
	bool	SaveToSd(void);
	bool	LoadFromCard(void);
	bool	SaveToCard(void);
	bool	SaveCommon( nn::fs::FileStream *file );
	bool	LoadCommon( nn::fs::FileInputStream *ifile );
};

//ݒύXƂɎgp\̂ƃf[^
struct Config::Information{
	const 	char *Prefix;			//p[^̑Oɕ\镶
	u32   	*Data;					//p[^i[
	const 	char *Suffix;			//p[^̌ɕ\镶
	u32  	DefaultData;			//ftH[gl
	Input   InputType;				//͌`
	u32 :24;						//pfBOQSahs
	const   char **List;			//Xg`̕\Xgǐ`ł͕svj
};



class ConfigWindow : public uji::sys::InputTextWindow
{

public:
	static const int FONT_SIZE = 14;

	ConfigWindow( Config *config ):
	uji::sys::InputTextWindow(
		uji::sys::GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2),
		uji::sys::GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE,
		FONT_SIZE,
        uji::sys::Menu::m_WindowManager), m_Config(config){}
    virtual ~ConfigWindow(){}
    void Open(void);    //RtBOEChEI[v܂
private:
    struct ConfigMenu;

	void MakeMenuInformation(void);
	void ShowMenu( int cursor, int page );
	void ExecuteMenu( int page, int cursor );
	void ShowExplanation(void);
	void SubMenu( void );
	void SubMenuSave(void);
	void SubMenuLoad(void);
	void SubMenuInitialize(void);

    Config *m_Config;
  	int m_TotalPage;

	std::vector<ConfigMenu> m_MenuInformation;

};

//RtBOύXj[p̃f[^Ɗ֐
struct ConfigWindow::ConfigMenu{
	int Number;
	int Index;
};

} // namespace seq
} // namespace uji


/* dCN[h̉ */
#endif
