/**************************************************************************

RtBO[Vݒ

 *************************************************************************/
#include <string.h>
#include <nn.h>
#include <nn/fs.h>
#include "../sys/sys.h"
#include "../sys/sys_ClassMenu.h"
#include "../sys/sys_ShowMessage.h"
#include "../seq/CalcCrc.h"
#include "SaveDataConst.h"
#include "Config.h"

using namespace uji::sys;
using namespace uji::seq;

static int  GetListSize( const char **List );

Config::Member Config::m_StaticConfig;
Config::MemberAlt Config::m_StaticConfigAlt;


//RtBOj[̃CN[h
#define CONFIG_MENU_DEF
#include "./ConfigDefine.h"
#undef  CONFIG_MENU_DEF

const char ID_STRING[]="%02d-%02d ";
const char PREFIX_STRING[]="%-30s";
const char SUFFIX_STRING[]="%-10s\n";


const char PATH_NAME[]= UJI_SAVEARCHIVE "/uji";
const char FILE_NAME[]= UJI_SAVEARCHIVE "/uji/config.sav";



const char SIGNATURE[]="SEQ CONFIG" __DATE__ " " __TIME__ ;

struct SaveFormat
{
	char Signature[0x40];			//VOl`̈
	Config::Member Member;			//ۑf[^
	Config::MemberAlt MemberAlt;	//ۑf[^
	u16 CheckSum;					//`FbNT
};


/************************************************************************

Config

************************************************************************/

/************************************************************************
  p[^̏
  ************************************************************************/
void Config::Initialize( void )
{
    int id = 0;
	while( m_ConfigInformation[id].Prefix[0] != '@' | m_ConfigInformation[id].Prefix[1] != '@'  )
    { 
		if( m_ConfigInformation[id].Prefix[0] != '@' )
        {
			//y[W擪ȊOȂf[^ftH[gɕύX
			*(m_ConfigInformation[id].Data) = m_ConfigInformation[id].DefaultData;
		}
		id++;
	}
}

/************************************************************************
  Z[uiA[JCuʂɐU蕪j
  ************************************************************************/
bool Config::Save( void )
{
	if( strcmp( "sdmc:", UJI_SAVEARCHIVE )==0 )
	{
		return SaveToSd();
	}
	else if( strcmp( "data:", UJI_SAVEARCHIVE )==0 )
	{
		return SaveToCard();
	}
	else
	{
		SYS_PANIC("ILLEGAL ARCHIVE NAME" );
		return false;
	}
}

/************************************************************************
  Z[uiʕj
  ************************************************************************/
bool Config::SaveCommon( nn::fs::FileStream *file )
{

	SaveFormat *format = new SaveFormat;
	u16 readSum;
	u16 calcSum;
	nn::Result result;
	bool retValue;

	//Z[upf[^\쐬
	strcpy( format->Signature, SIGNATURE );
	format->Member		= m_StaticConfig;
	format->MemberAlt	= m_StaticConfigAlt;
	format->CheckSum	= 0;
	format->CheckSum	= CalcCheckSum( reinterpret_cast<u8 *>(format), sizeof(SaveFormat) );



	//Z[u
	file->Seek( 0, nn::fs::POSITION_BASE_BEGIN );
	if( file->Write( format, sizeof(SaveFormat) ) != sizeof( SaveFormat ) )
	{
		retValue=false;
		goto FINALLY;
	}

	//xt@C
	file->Seek( 0, nn::fs::POSITION_BASE_BEGIN );
	if( file->Read( format, sizeof(SaveFormat) ) != sizeof( SaveFormat ) )
	{
		retValue=false;
		goto FINALLY;
	}

	//`FbNTZ
	readSum = format->CheckSum;
	format->CheckSum=0;
	calcSum = CalcCheckSum( reinterpret_cast<u8 *>(format), sizeof(SaveFormat) );
	if( readSum != calcSum )
	{
		retValue=false;
		goto FINALLY;

	}

	//܂ł琬
	retValue=true;

FINALLY:
	delete format;
	return retValue;
}



/************************************************************************
  rcJ[hփZ[u
  ************************************************************************/
bool Config::SaveToSd( void )
{
	nn::fs::FileStream file;
	nn::Result result;
	bool retValue;

	if( !nn::fs::IsSdmcInserted() ) return false;
	if( nn::fs::MountSdmc().IsFailure() ) return false;

	nn::fs::TryCreateDirectory( PATH_NAME );	//sĂ
	result = file.TryInitialize( FILE_NAME,		nn::fs::OPEN_MODE_READ   | 
                                                nn::fs::OPEN_MODE_WRITE  | 
                                                nn::fs::OPEN_MODE_CREATE );
	if( result.IsSuccess()  )
	{
		retValue = SaveCommon( &file );
		file.Finalize();
	}else{
		retValue =  false;
	}

	nn::fs::Unmount("sdmc:");
	return retValue;
}

/************************************************************************
  bsqJ[hփZ[u
  ************************************************************************/
bool Config::SaveToCard( void )
{
	nn::fs::FileStream file;
	nn::Result result;
	bool retValue;

	//}Eg
	result = nn::fs::MountSaveData();    
    if (result.IsFailure())
    {
	    if( result <= nn::fs::ResultNotFormatted()  ||
            result <= nn::fs::ResultBadFormat()     ||
            result <= nn::fs::ResultVerificationFailed() )
	    {
		    result = nn::fs::FormatSaveData( SAVE_DATA_MAX_FILES, SAVE_DATA_MAX_DIRECTORIES );
		    if( result.IsFailure()  ) return false;
		    result = nn::fs::MountSaveData();
		    if( result.IsFailure()  ) return false;
	    }
        else
        {
            return false;
        }
    }

	//I[v
	nn::fs::TryCreateDirectory( PATH_NAME );	//sĂ
	result = file.TryInitialize( FILE_NAME,		nn::fs::OPEN_MODE_READ   | 
                                                nn::fs::OPEN_MODE_WRITE  | 
                                                nn::fs::OPEN_MODE_CREATE );
	if( result.IsSuccess()  )
	{
		retValue = SaveCommon( &file );
		file.Finalize();
	}else{
		retValue = false;
	}

	nn::fs::CommitSaveData();
	nn::fs::Unmount( "data:" );
	return retValue;
}



/************************************************************************
  [hiA[JCuʂɐU蕪j
  ************************************************************************/
bool Config::Load( void )
{
	if( strcmp( "sdmc:", UJI_SAVEARCHIVE )==0 )
	{
		return LoadFromSd();
	}
	else if( strcmp( "data:", UJI_SAVEARCHIVE )==0 )
	{
		return LoadFromCard();
	}
	else
	{
		SYS_PANIC("ILLEGAL ARCHIVE NAME" );
		return false;
	}
}

/************************************************************************
  [hiʕj
  ************************************************************************/
bool Config::LoadCommon( nn::fs::FileInputStream *ifile )
{
	SaveFormat *format = new SaveFormat;
	u16 readSum;
	u16 calcSum;

	//xt@C
	if( ifile->Read( format, sizeof(SaveFormat) ) != sizeof( SaveFormat ) ) goto ERROR;

	//`FbNTZ
	readSum = format->CheckSum;
	format->CheckSum=0;
	calcSum = CalcCheckSum( reinterpret_cast<u8 *>(format), sizeof(SaveFormat) );
	if( readSum != calcSum ) goto ERROR;

	//VOl`ƍ
	if( strcmp( SIGNATURE, format->Signature )!=0 ) goto ERROR;

	//܂ł΃f[^͑ÓƔfĂB
	m_StaticConfig = format->Member;
	m_StaticConfigAlt = format->MemberAlt;

	delete format;
	return true;

ERROR:
	delete format;
	return false;
}

/************************************************************************
  rcJ[h烍[h
  ************************************************************************/
bool Config::LoadFromSd( void )
{
	nn::fs::FileInputStream ifile;
	bool retValue;

	if( !nn::fs::IsSdmcInserted() ) return false;
	if( nn::fs::MountSdmc().IsFailure() ) return false;


	if( ifile.TryInitialize( FILE_NAME ).IsSuccess() )
	{
		retValue = LoadCommon( &ifile );
		ifile.Finalize();
	}else{
		retValue = false;
	}
	nn::fs::Unmount("sdmc:");
	return retValue;
}

/************************************************************************
  bsqJ[h烍[h
  ************************************************************************/
bool Config::LoadFromCard( void )
{
    nn::Result nnResult;
    nn::fs::FileInputStream ifile;
	bool retValue;

	//}Egis̓Z[uf[^͂Ȃ̂őmfƂj
	nnResult = nn::fs::MountSaveData();
	if( nnResult.IsFailure() )
    {
        //fBAłivIG[jj
        if( nnResult <= nn::fs::ResultNotFound() )
        {
            uji::sys::Panic( "FAIL TO FIND BACKUP MEDIA!!" );
        }
        return false;
    }
    

	//[hI[v
	if( ifile.TryInitialize( FILE_NAME ).IsSuccess() )
	{
		retValue = LoadCommon( &ifile );
		ifile.Finalize();
	}else{
		retValue = false;
	}
	nn::fs::Unmount( "data:" );
	return retValue;
}

/************************************************************************
`FbNR[h擾

`FbNR[h͈́FO`XXXX
 ************************************************************************/
int Config::GetCheckCode(void)
{
	u32 checkCode = CalcCrc( 0, reinterpret_cast<u8*>(&m_StaticConfig), sizeof(m_StaticConfig) ) ;
	return (int)( checkCode%10000 );
}

/************************************************************************

ConfigWindow

************************************************************************/


/************************************************************************
  p[^̕ύX
  ************************************************************************/
void ConfigWindow::Open( void )
{
	int cursor = 0;
	int page   = 0;
	int id;

    uji::sys::Pad pad;
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
	SetTitle( "CONFIGURATION" );

	Menu::m_WindowManager.CreateWindow(this, NN_GX_DISPLAY0,0,0 );
	Menu::m_WindowManager.SetManagerPadControlFlag(false);
    MakeMenuInformation();

    //j[[v
	do {
        //pbhXV
        pad.UpdatePad();

        // IJ[\̈ړ
		if( pad.IsButtonRepeat( Pad::BUTTON_LEFT ) ){ page--   ; if( page<0 )	page   += m_TotalPage; cursor=0;			}
	 	if( pad.IsButtonRepeat( Pad::BUTTON_RIGHT) ){ page++   ; 			 	page   %= m_TotalPage; cursor=0;			} 
		if( pad.IsButtonRepeat( Pad::BUTTON_UP   ) ){ cursor-- ; if( cursor<0 ) cursor += m_MenuInformation[page].Number;	}
        if( pad.IsButtonRepeat( Pad::BUTTON_DOWN ) ){ cursor++ ; 				cursor %= m_MenuInformation[page].Number;	} 

        //s
        if( pad.IsButtonDown( Pad::BUTTON_A ) ){
			ExecuteMenu( page, cursor );

			//gKNA            
            pad.ClearTriggerFlag();            
		}
		
		//ftHglɖ߂
		if( pad.IsButtonDown( Pad::BUTTON_X ) ){
			if( ShowMessage::Open( &Menu::m_WindowManager, "Do you initilize\n this parameter?", ShowMessage::SHM_OK_CANCEL ) )
			{ 
				id = m_MenuInformation[page].Index + cursor+1;
				*(m_Config->m_ConfigInformation[id].Data) = m_Config->m_ConfigInformation[id].DefaultData;
			}
		}

		//Tuj[\
		if( pad.IsButtonDown( Pad::BUTTON_START ) )
		{
			SubMenu();
            //gKNA            
            pad.ClearTriggerFlag();            

		}

		ShowMenu( cursor, page );

        //EChE
		Menu::m_WindowManager.Update();
        Menu::m_WindowManager.UpdatePad(pad);        

        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);  
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
		//\
		ShowExplanation();

		// ʕ`        
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

	}
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

	Menu::m_WindowManager.DestroyWindow(this);

}

/************************************************************************
  j[̍쐬
  ************************************************************************/
void ConfigWindow::MakeMenuInformation( void ){

    int page = 0;
	int id   = 0;
	
    const ConfigWindow::ConfigMenu NullInformation = { 0, 0 };

    while( m_Config->m_ConfigInformation[id].Prefix[0] != '@' |
		   m_Config->m_ConfigInformation[id].Prefix[1] != '@'  ){ 

		if( m_Config->m_ConfigInformation[id].Prefix[0] == '@' ){

			//z̊g
			m_MenuInformation.push_back( NullInformation );

			//y[W擪̏
			m_MenuInformation[page].Index  = id;		
			m_MenuInformation[page].Number = 0;
			page++;
		}else{
			//y[W擪ȊȌ
			m_MenuInformation[page-1].Number++;
		}
		id++;
	}
	//y[Wۑ
	m_TotalPage = page;

}

/**************************************************************************
j[̕\


  Cursor	ݎĂJ[\ʒu
  Page		݂̃y[Wiŏ̃y[W͂Oj

 *************************************************************************/
const char CONVERSION_TABLE[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";   //l𕶎ɕϊ邽߂̃e[u

void ConfigWindow::ShowMenu( int Cursor, int Page )
{
    int i;
	int id;
	
	//j[\ioʗṕ̓XLbvj
    SetTextColor( ATTR_COLOR_GREEN );
	Printf( "\f%-42sPage%d/%d\n", m_Config->m_ConfigInformation[m_MenuInformation[Page].Index].Prefix+1, Page+1, m_TotalPage );    

	//j[{̂`悷
    for( i=0 ; i<m_MenuInformation[Page].Number ; i++ ){
		id = m_MenuInformation[Page].Index+1+i;		//Ώۂ̔zYZo

	
		//lftH[gƈႦΐFύXɂ
		if( *(m_Config->m_ConfigInformation[id].Data) != m_Config->m_ConfigInformation[id].DefaultData ){
            if( i!=Cursor ){
                SetTextColor( ATTR_COLOR_MAGENTA );
            }else{
                SetTextColor( ATTR_COLOR_CYAN );
            }
		}else{
            if( i!=Cursor ){
    		    SetTextColor( ATTR_COLOR_WHITE );
            }else{
                SetTextColor( ATTR_COLOR_RED);
            }
        }

        
		Printf( ID_STRING, Page+1, i+1 );							//ʔԍ\

        Printf( PREFIX_STRING, m_Config->m_ConfigInformation[id].Prefix );				//ϐ̑O̕\
		switch( m_Config->m_ConfigInformation[id].InputType ){
		  case Config::Input_DECIMAL:
			Printf( "      %04d", *( m_Config->m_ConfigInformation[id].Data ) );	//ϐ̒l\
			break;
		  case Config::Input_DECIMAL5:
			Printf( "      %05d", *( m_Config->m_ConfigInformation[id].Data ) );
			break;
		  case Config::Input_DATA:
			Printf( "  %08X", 	 *( m_Config->m_ConfigInformation[id].Data ) );	
			break;
		  case Config::Input_DATA16:
			Printf( "      %04X", *( m_Config->m_ConfigInformation[id].Data ) );
			break;
		  case Config::Input_BOOL:
			Printf( "         %s", *( m_Config->m_ConfigInformation[id].Data )?"O":"X" );
			break;
		  case Config::Input_LIST:
			if( *(m_Config->m_ConfigInformation[id].Data) < GetListSize( m_Config->m_ConfigInformation[id].List ) ){
				Printf( "%10.10s", m_Config->m_ConfigInformation[id].List[ *(m_Config->m_ConfigInformation[id].Data) ]  );
			}
            break;
		  case Config::Input_ASCII3:
			Printf( "       %c%c%c", CONVERSION_TABLE[ *(m_Config->m_ConfigInformation[id].Data) / (36*36)      ]
                                   , CONVERSION_TABLE[ *(m_Config->m_ConfigInformation[id].Data) % (36*36) / 36 ]
                                   , CONVERSION_TABLE[ *(m_Config->m_ConfigInformation[id].Data) % (36*36) % 36 ]

            );
            break;
		  default:
			break;
		}
        Printf( SUFFIX_STRING, m_Config->m_ConfigInformation[id].Suffix   );			//ϐ̌̕\
    }
}    



/**************************************************************************
RtBOύX̎s
 *************************************************************************/
void ConfigWindow::ExecuteMenu( int page, int cursor )
{
	int id = m_MenuInformation[page].Index + cursor+1;

	const int VALIABLE_LOCATE_X2 = 27 +18;	//̓p[^XW
	const int VALIABLE_LOCATE_X4 = 24 +18;
	const int VALIABLE_LOCATE_X8 = 20 +18;
	const int VALIABLE_LOCATE_X3 = 25 +18;


	//lftH[gƈႦΐFFɂ
	if( *(m_Config->m_ConfigInformation[id].Data) != m_Config->m_ConfigInformation[id].DefaultData )
    {
 	    SetTextColor( ATTR_COLOR_YELLOW );
    }else{
	    SetTextColor( ATTR_COLOR_WHITE );
	}

	Gotoxy( 0, cursor+1 );
    Printf( ID_STRING,	 	page+1, cursor+1 );							//ʔԍ\
    Printf( PREFIX_STRING,	m_Config->m_ConfigInformation[id].Prefix );	//ϐ̑O̕
    Printf( "          " );											    //ϐ̋
    Printf( SUFFIX_STRING,  m_Config->m_ConfigInformation[id].Suffix );	//ϐ̌̕\
			
	switch( m_Config->m_ConfigInformation[id].InputType){
	  case Config::Input_DECIMAL:
		Gotoxy( VALIABLE_LOCATE_X4, cursor+1 );
		*(m_Config->m_ConfigInformation[id].Data) = InputDecimal( *(m_Config->m_ConfigInformation[id].Data) );
		break; 

	  case Config::Input_DECIMAL5:
		Gotoxy( VALIABLE_LOCATE_X4, cursor+1 );
		*(m_Config->m_ConfigInformation[id].Data) = InputDecimal5( *(m_Config->m_ConfigInformation[id].Data) );
		break; 

	  case Config::Input_DATA:
		Gotoxy( VALIABLE_LOCATE_X8, cursor+1 );
		*(m_Config->m_ConfigInformation[id].Data) = InputData( *(m_Config->m_ConfigInformation[id].Data) );
		break; 

	  case Config::Input_DATA16:
		Gotoxy( VALIABLE_LOCATE_X4, cursor+1 );
		*(m_Config->m_ConfigInformation[id].Data) = (u32)InputData16( (u16)(*(m_Config->m_ConfigInformation[id].Data)) );
		break; 

	  case Config::Input_BOOL:
		Gotoxy( VALIABLE_LOCATE_X2, cursor+1 );
		*(m_Config->m_ConfigInformation[id].Data) = (u32)(*(m_Config->m_ConfigInformation[id].Data)?false:true);
		break; 

	  case Config::Input_LIST:
		(*(m_Config->m_ConfigInformation[id].Data))++;
		if( *(m_Config->m_ConfigInformation[id].Data) >=GetListSize( m_Config->m_ConfigInformation[id].List ) ){
			*(m_Config->m_ConfigInformation[id].Data)= 0;
		}
		break; 

	  case Config::Input_ASCII3:
		Gotoxy( VALIABLE_LOCATE_X3, cursor+1 );
		*(m_Config->m_ConfigInformation[id].Data) = (u32)InputAscii3( (u16)(*(m_Config->m_ConfigInformation[id].Data)) );
		break; 

      default:
        break;
	}

}


/************************************************************************
  p̕\
 ************************************************************************/
void ConfigWindow::ShowExplanation( void ){
	Menu::m_SubWindow->Printf("\f");
	Menu::m_SubWindow->Printf("[USAGE]\n\n");
	Menu::m_SubWindow->Printf( " +    :Move\n" );
	Menu::m_SubWindow->Printf( " A    :Set\n" );
	Menu::m_SubWindow->Printf( " B    :Exit/Cancel\n");
	Menu::m_SubWindow->Printf( " X    :Set default\n" );
	Menu::m_SubWindow->Printf( " Start:Sub menu" );
}

/************************************************************************
  [hZ[ũׂTuj[\
 ************************************************************************/
void ConfigWindow::SubMenu( void )
{
    Window *parentWin = Menu::m_WindowManager.GetActiveWindow();

	ClassMenu *m = new ClassMenu( "SUB MENU", 150, 100 );

    m->Add<ConfigWindow>( "Save",		this,	&ConfigWindow::SubMenuSave 		);
	m->Add<ConfigWindow>( "Load", 		this,	&ConfigWindow::SubMenuLoad 		);
	m->Add<ConfigWindow>( "Initialize",	this,	&ConfigWindow::SubMenuInitialize);
	m->Open();

	delete m;

	Menu::m_WindowManager.SetActiveWindow( parentWin );    

}

/************************************************************************
  Z[uiTuj[pj
  ************************************************************************/
void ConfigWindow::SubMenuSave( void )
{

	if( m_Config->Save() )
	{
		ShowMessage::Open( &Menu::m_WindowManager, "Success to save" );
	}else{
		ShowMessage::Open( &Menu::m_WindowManager, "Fail to save" );
	}
}




/************************************************************************
  [hiTuj[pj
  ************************************************************************/
void ConfigWindow::SubMenuLoad( void )
{
	if( m_Config->Load() )
	{
		ShowMessage::Open( &Menu::m_WindowManager, "Success to load" );
	}else{
		ShowMessage::Open( &Menu::m_WindowManager, "Fail to load" );
	}
}

/************************************************************************
  iTuj[pj
  ************************************************************************/
void ConfigWindow::SubMenuInitialize( void )
{
	m_Config->Initialize();
	ShowMessage::Open( &Menu::m_WindowManager, "Re-Initialized" );
}


/************************************************************************
  Xg^CṽXǧvZ


	\Xg
߂l
	Xg

  ************************************************************************/
static int  GetListSize( const char **List ){
	int Count=0;
	
	while( List[Count]!=NULL ){
		Count++;
	}
	return Count;
}
