/************************************************************************

JpʐMNX

 *************************************************************************/

/* dCN[h̉ */
#ifndef COMMCAMERA_H_INCLUDED
#define COMMCAMERA_H_INCLUDED

#include <queue>
#include <nn.h>
#include "sys.h"
#include "../eva/wireless/CommandUtil.h"
#include "Register_camera.h"

namespace uji{
namespace seq{



class CommCamera{

public:
	static const int FIFO_SIZE = uji::seq::camera::FIFO_SIZE;

	enum SpiType{
		SpiType_512Kx1 = 0,
		SpiType_1Mx1,
		SpiType_2Mx1,
		SpiType_4Mx1,
		SpiType_8Mx1,
		SpiType_16Mx1,
		SpiType_512Kx4,
		SpiType_1Mx4,
		SpiType_2Mx4,
		SpiType_4Mx4,
		SpiType_8Mx4,
		SpiType_16Mx4
	};

	CommCamera(){}
	~CommCamera(){}

	void Initialize( SpiType spiType );
	void Finalize(void);

	u32 GetReadFifoCount(void);
	u32 GetWriteFifoCount(void);
	u32 GetDataFifoCount(void);

	void ReadFifo( u8 *data, u32 size );
	void WriteFifo( const u8 *data, u32 size );
	void WriteDataFifo( const u8 *data, u32 size );

	static void TestFifo(void);		//eheneXg

	//foOp
	void LockFifo(void);
	void UnlockFifo(void);

private:
	nn::fs::FileStream m_FileStream;

	u32 GetFifoCount_Common( u32 ADDRESS );

};


class CommPacketCamera{

public:

	static const u32 MAX_QUEUE_SIZE = 4096*2;
	static const u32 TIME_OUT=20;				//̃Abvf[g񐔈ȓɃpPbgȂꍇAp

	enum StateType{
		StateType_Clean,
		StateType_Dirty
	};

	CommPacketCamera():m_State(StateType_Clean), m_FifoHazard(false){}
	~CommPacketCamera(){}

	void Initialize( CommCamera::SpiType spiType );
	void Finalize(void);
	void Update(void);
	bool ReadCommand( uji::eva::CommPack *commPack );
	void ReplyCommand( uji::eva::CommPack *commPack );

	static void TestPacket(void);		//o`bjdseXg

	//ehenُmFp\bh
	bool IsFifoHazard(void){ return m_FifoHazard; }
	void ClearFifoHazard(void){ m_FifoHazard=false; };

	CommCamera m_CommCamera;

private:
	void AnalysisCommand( uji::eva::CommPack *commPack, char* Str );

	u8 m_Buffer[ MAX_QUEUE_SIZE ];
	std::deque<u8> m_ReadQueue;
	std::deque<u8> m_WriteQueue;
		
	bool m_State;
	u32  m_TimeOutCounter;
	bool m_FifoHazard;

};



}
}
/* dCN[h̉ */
#endif
