/************************************************************************

JpʐMNX

*************************************************************************/
#include <nn.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include "sys.h"
#include "CommCamera.h"
#include "Register_Camera.h"
#include "../eva/wireless/CommandUtil.h"

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
namespace{

//J[hroh̃oX^Cv
const nn::fs::CardSpiBaudRate baudRate[] = {
    nn::fs::CARDSPI_BAUDRATE_512KHZ ,
    nn::fs::CARDSPI_BAUDRATE_1MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_2MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_4MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_8MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_16MHZ  ,
    nn::fs::CARDSPI_BAUDRATE_512KHZ ,
    nn::fs::CARDSPI_BAUDRATE_1MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_2MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_4MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_8MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_16MHZ  
};

    //pPbg
    const u8 CHECK_SUM_LENGTH  = 4;
    const u8 COMMAND_ID_LENGTH = 4;
    const u8 ARG_NUM_LENGTH    = 2;
}
/************************************************************************

broĥehenMNX

************************************************************************/


/************************************************************************
 ************************************************************************/
void CommCamera::Initialize( SpiType spiType )
{
    nn::fs::SetCardSpiBaudRate( baudRate[ spiType ] );
}

/************************************************************************
 ************************************************************************/
void CommCamera::Finalize( void )
{
}


/************************************************************************
eheñJEg擾
************************************************************************/
u32 CommCamera::GetFifoCount_Common( u32 address )
{
    const u32 COUNTER_SIZE = 4;
    u8 buffer[COUNTER_SIZE];
    
    nn::fs::Read( 0x03, address, reinterpret_cast<u32*>( buffer ), COUNTER_SIZE );

    return buffer[0] | buffer[1]<<8 | buffer[2]<<16;
}

/************************************************************************
eeheñJEg擾
************************************************************************/
u32 CommCamera::GetReadFifoCount( void )
{
    return  GetFifoCount_Common( camera::REG_COUNT_R );
}
u32 CommCamera::GetWriteFifoCount( void )
{
    return  GetFifoCount_Common( camera::REG_COUNT_W );
}
u32 CommCamera::GetDataFifoCount( void )
{
    return  GetFifoCount_Common( camera::REG_COUNT_D );
}

/************************************************************************
[hehen̓ǂݏo
************************************************************************/
void CommCamera::ReadFifo( u8 *data, u32 size )
{
    if( size==0 ) return;
#if 0
    LockFifo(); //debug
#endif
    nn::fs::Read( 0x03, camera::REG_FIFO_R, reinterpret_cast<u32*>( data ), size );
    data[size] = 0x00; //boOΉ
#if 0
    UnlockFifo();   //debug
#endif

}

/************************************************************************
Cgehen̏
************************************************************************/
void CommCamera::WriteFifo( const u8 *data, u32 size )
{
    if( size==0 ) return;
    SYS_ASSERT( size<=camera::FIFO_SIZE );
#if 0
    LockFifo(); //debug
#endif
    nn::fs::Write( 0x02, camera::REG_FIFO_W, reinterpret_cast<const u32*>( data ), size );
    
#if 0
    UnlockFifo();   //debug
#endif
}

/************************************************************************
f[^ehen̏
************************************************************************/
void CommCamera::WriteDataFifo( const u8 *data, u32 size )
{
    if( size==0 ) return;
#if 0
    LockFifo();
#endif

#if 0
    SYS_ASSERT( size<=camera::FIFO_SIZE );
#endif  
    nn::fs::Write( 0x02, camera::REG_FIFO_D, reinterpret_cast<const u32*>( data ), size );
    
#if 0
    SYS_ASSERT( writtenByte==size );
#endif
#if 0
    UnlockFifo();   //debug
#endif
}

/************************************************************************
foOpb胋[`
************************************************************************/
/************************************************************************
ehenANZX擾
************************************************************************/
void CommCamera::LockFifo( void )
{
    u32 SIZE = 1;
    s32 readByte;
    u8 buffer[SIZE];

    buffer[0]=1;
nn::fs::Write( 0x02, camera::REG_REQUEST_LOCK, reinterpret_cast<const u32*>( buffer ), SIZE );
    do{
        nn::fs::Read( 0x03, camera::REG_FIFO_R, reinterpret_cast<u32*>( buffer ), SIZE );
    }while( buffer[0]!=0 );
}

/************************************************************************
ehenANZXJ
************************************************************************/
void CommCamera::UnlockFifo( void )
{
    u32 SIZE = 1;
    u8 buffer[SIZE];

    m_FileStream.SetPosition( camera::REG_REQUEST_LOCK );
    
    buffer[0]=0;
    nn::fs::Write( 0x02, camera::REG_REQUEST_LOCK, reinterpret_cast<const u32*>( buffer ), SIZE );
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
}





/************************************************************************

eXg[`

************************************************************************/

/************************************************************************
fBXvCP̃Abvf[g
  ************************************************************************/
static void UpdateDisplay1(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    Menu::m_WindowManager.Update();
    Menu::m_WindowManager.UpdatePad(pad);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();        
    Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 
}

/************************************************************************
eheneXg
  ************************************************************************/
void CommCamera::TestFifo(void)
{
    uji::sys::Pad pad;
    int mode;
    CommCamera *cc = new CommCamera;

    u32 cntReadFifo;
    u32 cntWriteFifo;
    u32 cntDataFifo;

    u8  *buffer = new u8[0x1000];

    static const int FONT_SIZE=14;

    InputTextWindow *win = new uji::sys::InputTextWindow(
        uji::sys::GraphicsDrawing::DISPLAY1_WIDTH/(FONT_SIZE/2),
        uji::sys::GraphicsDrawing::DISPLAY1_HEIGHT/FONT_SIZE,
        FONT_SIZE,
        uji::sys::Menu::m_WindowManager);

    win->SetTitle( "TEST FIFO" );
    Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY1, 0, 0 );        

    win->Printf("0-5: 512k,1M,2M,4M,8M,16M (R/W=1bit/1bit)\n");
    win->Printf("6-10:512k,1M,2M,4M,8M,16M (R/W=4bit/1bit)\n");

    win->Printf("SPI TYPE=");
    mode = win->InputDecimal(0);
    pad.WaitReleaseKey();
    
    cc->Initialize( static_cast<SpiType>(mode) );

    do
    {
        //pbhXV
        pad.UpdatePad();

        cntReadFifo  = cc->GetReadFifoCount();
        cntWriteFifo = cc->GetWriteFifoCount();
        cntDataFifo  = cc->GetDataFifoCount(); 
        win->Gotoxy( 0, 0 );
        win->Printf("\f");
        win->Printf( "X:READ FIFO\n" );
        win->Printf( "Y:WRITE FIFO\n" );
        win->Printf( "L:WRITE DATA FIFO\n\n" );
        win->Printf( "R:CONFIRM DATA FIFO COUNTER \n\n" );
        win->Printf( "FIFO:R=[%04X] W=[%04X] D=[%04X]\n", cntReadFifo, cntWriteFifo, cntDataFifo );

        if( pad.IsButtonPress(Pad::BUTTON_X) ){
            u32 size;
            win->Printf( "READ FIFO \nData SIZE(MAX4096)=" );
            size = win->InputDecimal( 0 );
            cc->ReadFifo( buffer, size );
            for( int i=0 ; i<size ; i++ )
            {
                win->Printf( "\n(%02X)", buffer[i], buffer[i] );
                UpdateDisplay1();
                UpdateDisplay1();
                pad.WaitAnyKey();
                pad.WaitReleaseKey();
            }
        }

        if( pad.IsButtonPress(Pad::BUTTON_Y) ){
            u32 size;
            win->Printf( "WRITE FIFO\nData SIZE(MAX4096)=" );
            size = win->InputDecimal( 0 );
            for( int i=0 ; i<size ; i++ ) buffer[i] = (u8)(i+'A');
            cc->WriteFifo( buffer, size );
            pad.WaitReleaseKey();
        }

        if( pad.IsButtonPress(Pad::BUTTON_L) ){
            u32 size;
            win->Printf( "WRITE DATA FIFO\nData SIZE(MAX4096)=" );
            size = win->InputDecimal( 0 );
            for( int i=0 ; i<size ; i++ ) buffer[i] = (u8)(i+'a');
            cc->WriteDataFifo( buffer, size );
            pad.WaitReleaseKey();
        }

        if( pad.IsButtonPress(Pad::BUTTON_R) ){
            u32 answer;
            win->Printf( "CONFIRM DATA FIFO COUNTER\nANSWER=" );
            answer = win->InputData( 0 );

            for( int i=0 ; i<1000 ; i++ )
            {
                win->Printf( "CNT=%d\n", i );
                UpdateDisplay1();

                cntDataFifo  = cc->GetDataFifoCount(); 
                if( answer != cntDataFifo )
                {
                    win->Printf( "ERROR: %x %x\n", answer, cntDataFifo );
                    UpdateDisplay1();
                    UpdateDisplay1();
                    pad.WaitAnyKey();
                }


            }
            pad.WaitReleaseKey();
        }


        UpdateDisplay1();
    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

    cc->Finalize();


    Menu::m_WindowManager.DestroyWindow(win);
    delete win;
    delete[] buffer;
    delete cc;
}
/************************************************************************

R}h^X|Xp{摜f[^MNX

************************************************************************/


/************************************************************************
 ************************************************************************/
void CommPacketCamera::Initialize( CommCamera::SpiType spiType )
{
    m_CommCamera.Initialize( spiType );
}

/************************************************************************
 ************************************************************************/
void CommPacketCamera::Finalize( void )
{
    m_CommCamera.Finalize();
}

/************************************************************************
NXɕێĂL[ƂbrohL[̓
************************************************************************/
void CommPacketCamera::Update( void )
{
    u32 size;

    //broh\eheñJE^擾
    u32 cntReadFifo  = m_CommCamera.GetReadFifoCount();
    u32 cntWriteFifo = m_CommCamera.GetWriteFifoCount();
    u32 cntDataFifo  = m_CommCamera.GetDataFifoCount();

    //qd`c@ehen
    if( cntReadFifo!=0 )
    {
        if( cntReadFifo + m_ReadQueue.size() <= MAX_QUEUE_SIZE )
        {
            size=cntReadFifo; 
        }else{
            size=MAX_QUEUE_SIZE - m_ReadQueue.size(); 
        }

        m_CommCamera.ReadFifo( m_Buffer, size );
        for( int i=0 ; i<size ; i++ ) m_ReadQueue.push_back( m_Buffer[i] );


        m_State = StateType_Dirty;  //ȂɂMĂ
    }


    //vqhsd@ehen
    if( m_WriteQueue.size()!=0 )
    {
        if(cntWriteFifo + m_WriteQueue.size()<camera::FIFO_SIZE )
        {
            size = m_WriteQueue.size();
        }else{
            size = camera::FIFO_SIZE - cntWriteFifo;
        }

        for( int i=0 ; i<size ; i++ ){
            m_Buffer[i]=m_WriteQueue.front();
            m_WriteQueue.pop_front();
        }
        m_CommCamera.WriteFifo( m_Buffer, size );
    }


    //K莞ԈȏMԂł΁Aُ픭Ƃ݂ȂăL[NA
    if( m_State == StateType_Dirty ) m_TimeOutCounter++;

    if( m_TimeOutCounter > TIME_OUT )
    {
        m_ReadQueue.clear();
        m_State = StateType_Clean;
        m_TimeOutCounter = 0;
        m_FifoHazard = true;
    }

}

/************************************************************************
R}hǂݏo

F  R}hi[

߂lF
true    LȃR}h
false   LȃR}hȂ

************************************************************************/
bool CommPacketCamera::ReadCommand( uji::eva::CommPack *commPack )
{

    u32 queueSize = m_ReadQueue.size();


    //ŏpPbgTCYɒBĂȂƗLR}hȂƂ
    if( queueSize<CHECK_SUM_LENGTH+COMMAND_ID_LENGTH +ARG_NUM_LENGTH ) return false;

    //L[ꎞIɃR}hpbN`
    u8 *buffer = new u8[ queueSize ];
    for( int i=0 ; i<queueSize ; i++ )
    {
        buffer[i] = m_ReadQueue.at(i);
    }
    AnalysisCommand( commPack, (char*)buffer );
    u32 packetSize = CHECK_SUM_LENGTH+COMMAND_ID_LENGTH +ARG_NUM_LENGTH+commPack->ArgNum;

    //pPbgTCYɒBĂȂƗLR}hȂƂ
    if( queueSize< packetSize ) return false;


    bool result = uji::eva::CommandUtil::isCorrectCheckSum( (char*)buffer, packetSize );
    
    //擾pPbgehen폜
    for( int i=0 ; i<packetSize ; i++ )
    m_ReadQueue.pop_front();

    if( m_ReadQueue.size()==0 )
    {
        m_State = StateType_Clean;
        m_TimeOutCounter = 0;
    }


    delete[] buffer;
    return result;
}

/************************************************************************
R}hRpbNɊi[܂B

î
************************************************************************/
void CommPacketCamera::AnalysisCommand( uji::eva::CommPack *commPack, char* Str )
{
    commPack->CheckSum   = eva::CommandUtil::ConvertNumFromString( Str, CHECK_SUM_LENGTH ); // `FbNT
    commPack->CommID     = eva::CommandUtil::ConvertNumFromString( Str+CHECK_SUM_LENGTH, COMMAND_ID_LENGTH ); // R}hID
    commPack->ArgNum     = eva::CommandUtil::ConvertNumFromString( Str+CHECK_SUM_LENGTH + COMMAND_ID_LENGTH, ARG_NUM_LENGTH ); // 
    
    if( commPack->ArgNum < eva::MAX_ARG_NUM )
    {
        std::memcpy( commPack->Arg, Str+CHECK_SUM_LENGTH+COMMAND_ID_LENGTH+ARG_NUM_LENGTH, commPack->ArgNum );
    }
}

/************************************************************************
R}hԐM
Aobt@^̏ꍇ͋󂭂܂ő҂

F  R}hi[

************************************************************************/
void CommPacketCamera::ReplyCommand( uji::eva::CommPack *commPack )
{
    u32 size = CHECK_SUM_LENGTH + COMMAND_ID_LENGTH + ARG_NUM_LENGTH + commPack->ArgNum + 3;    //CRLF\0ǉ


    //L[̋󂫑҂
    while( size + m_WriteQueue.size() > CommPacketCamera::MAX_QUEUE_SIZE )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    }

    char *returnString   = new char[ size ];
    char *checkSumString = new char[ size ];

    //`FbNTȊO𖄂߂
    sprintf( returnString, "%04X%02X%s", ( commPack->CommID )+0xa000, commPack->ArgNum, commPack->Arg );

    //`FbNTvZāASȃX|X`ɂ
    u16 checkSum = eva::CommandUtil::CalcCheckSum( returnString, COMMAND_ID_LENGTH + ARG_NUM_LENGTH + commPack->ArgNum ); 
    sprintf( checkSumString, "%04X%s\r\n", checkSum, returnString );

    //L[ɒǉ
    for( int i=0 ; i<size-1 ; i++ ) //\0͒ǉȂ
    {
        m_WriteQueue.push_back( (u8)checkSumString[i] );
    }


    delete[] checkSumString;
    delete[] returnString;
}

/************************************************************************
pPbgeXg
  ************************************************************************/
void CommPacketCamera::TestPacket(void)
{
    uji::sys::Pad pad;
    int mode;
    CommPacketCamera *cpc = new CommPacketCamera;
    uji::eva::CommPack *cp = new uji::eva::CommPack;


    static const int FONT_SIZE=14;

    InputTextWindow *win = new uji::sys::InputTextWindow(
        uji::sys::GraphicsDrawing::DISPLAY1_WIDTH/(FONT_SIZE/2),
        uji::sys::GraphicsDrawing::DISPLAY1_HEIGHT/FONT_SIZE,
        FONT_SIZE,
        uji::sys::Menu::m_WindowManager);

    win->SetTitle( "TEST PACKET" );
    Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY1, 0, 0 );        

    win->Printf("A:Sample Reply\n\n" );
    win->Printf("0-5: 512k,1M,2M,4M,8M,16M (R/W=1bit/1bit)\n");
    win->Printf("6-10:512k,1M,2M,4M,8M,16M (R/W=4bit/1bit)\n");

    win->Printf("SPI TYPE=");
    mode = win->InputDecimal(0);
    pad.WaitReleaseKey();

    cpc->Initialize( static_cast<CommCamera::SpiType>(mode) );

    do
    {
        //pbhXV
        pad.UpdatePad();

        //eheñAbvf[g@
        cpc->Update();

        //R}hM@
        if( cpc->ReadCommand( cp ) )
        {   
            win->Printf( "\n" );
            win->Printf( "CHECKSUM:%04X\n", cp->CheckSum );
            win->Printf( "COMM ID :%04X\n", cp->CommID   );
            win->Printf( "ARG NUM :%04X\n", cp->ArgNum   );

            win->Printf( "%02X %02X %02X %02X %02X %02X %02X %02X\n",
                            cp->Arg[0],
                            cp->Arg[1],
                            cp->Arg[2],
                            cp->Arg[3],
                            cp->Arg[4],
                            cp->Arg[5],
                            cp->Arg[6],
                            cp->Arg[7] );

            win->Printf( "[%c%c%c%c%c%c%c%c]\n",
                            cp->Arg[0],
                            cp->Arg[1],
                            cp->Arg[2],
                            cp->Arg[3],
                            cp->Arg[4],
                            cp->Arg[5],
                            cp->Arg[6],
                            cp->Arg[7] );

        }
        
        //TvvCM
        if( pad.IsButtonPress(Pad::BUTTON_A) ){
            cp->CommID = 0x0101;
            cp->ArgNum = 5;
            strcpy( cp->Arg, "HELLO" );
            win->Printf( "\n=SAMPLE REPLY=\n" );
            cpc->ReplyCommand( cp );
        }
    

        UpdateDisplay1();
    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

    cpc->Finalize();

    Menu::m_WindowManager.DestroyWindow(win);
    delete win;
    delete cp;
    delete cpc;
}
