/************************************************************************

^C^tF[XpʐMNX

 *************************************************************************/

/* dCN[h̉ */
#ifndef COMMC2T_H_INCLUDED
#define COMMC2T_H_INCLUDED

#include <nn.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include "sys.h"

namespace uji{
namespace seq{

/************************************************************************
 ************************************************************************/
class CommC2T{

public:
    static const int BUFFER_SIZE = 2048;

    enum SpiType{
        SpiType_512Kx1 = 0,
        SpiType_1Mx1,
        SpiType_2Mx1,
        SpiType_4Mx1,
        SpiType_8Mx1,
        SpiType_16Mx1,
        SpiType_512Kx4,
        SpiType_1Mx4,
        SpiType_2Mx4,
        SpiType_4Mx4,
        SpiType_8Mx4,
        SpiType_16Mx4
    };

    CommC2T(){}
    ~CommC2T(){}

    void Initialize( SpiType spiType );
    void Finalize(void);

    bool CanReceive(void);
    bool Receive( u16 *instructionCode, u8 *data, int dataSize );
    void Send( u16 errorCode, const u8 *data, int dataSize );

    //GAɃANZX
    void WriteDpram( const u8 *data, int dataSize );
    void ReadDpram( u8 *data, int dataSize );

    //oCiGAɃANZX
    void WriteDpramBinary( const u8 *data, int dataSize );
    void ReadDpramBinary( u8 *data, int dataSize );

    static void TestDpram(void);    //coq`l̃eXg
    static void TestComm(void);     //ʐMeXg

private:
};

}
}
/* dCN[h̉ */
#endif
