/************************************************************************

^C^tF[XpʐMNX

*************************************************************************/
#include <nn.h>
#include "Register_board_interface.h"
#include "CommC2T.h"

using namespace uji::sys;
using namespace uji::seq;
namespace{

//J[hroh̃oX^Cv
const wchar_t *PATH[]={
    L"cardspi:/512KHz_1xIO.bin",
    L"cardspi:/1MHz_1xIO.bin",
    L"cardspi:/2MHz_1xIO.bin",
    L"cardspi:/4MHz_1xIO.bin",
    L"cardspi:/8MHz_1xIO.bin",
    L"cardspi:/16MHz_1xIO.bin",

    L"cardspi:/512KHz_4xIO.bin",
    L"cardspi:/1MHz_4xIO.bin",
    L"cardspi:/2MHz_4xIO.bin",
    L"cardspi:/4MHz_4xIO.bin",
    L"cardspi:/8MHz_4xIO.bin",
    L"cardspi:/16MHz_4xIO.bin"
};

//J[hroh̃oX^Cv
const nn::fs::CardSpiBaudRate baudRate[] = {
    nn::fs::CARDSPI_BAUDRATE_512KHZ ,
    nn::fs::CARDSPI_BAUDRATE_1MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_2MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_4MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_8MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_16MHZ  ,
    nn::fs::CARDSPI_BAUDRATE_512KHZ ,
    nn::fs::CARDSPI_BAUDRATE_1MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_2MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_4MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_8MHZ   ,
    nn::fs::CARDSPI_BAUDRATE_16MHZ  
};


}


/************************************************************************
 ************************************************************************/
void CommC2T::Initialize( SpiType spiType )
{
    nn::fs::SetCardSpiBaudRate( baudRate[ spiType ] );
}

/************************************************************************
 ************************************************************************/
void CommC2T::Finalize( void )
{
}

/************************************************************************
Mf[^邩ǂ̖₢킹
************************************************************************/
bool CommC2T::CanReceive( void )
{
    u32 result;
    
    nn::fs::Read( 0x03, REG_DPRAM_CTR_ACCESS_INHIBIT, &result, sizeof(u32) );
    
    
    if( result == 0 )   //ǂݒlOȂMf[^
    {
        return true;
    }else{
        return false;
    }
}

/************************************************************************
M
************************************************************************/
bool CommC2T::Receive( u16 *instructionCode, u8 *data, int dataSize )
{

    if( !CanReceive() ) return false;

    //f[^M
    ReadDpram( data, dataSize );
    
    u8  buffer[ nn::math::RoundUp( REG_SIZE, sizeof(u32))];
    //CXgNVR[hM
    nn::fs::Read( 0x03, REG_RECEIVE_DATA_FROM_TWL, reinterpret_cast<u32*>( buffer ), sizeof( buffer ) );
    std::memcpy( instructionCode, buffer, REG_SIZE );

    return true;
}

/************************************************************************
M
************************************************************************/
void CommC2T::Send( u16 errorCode, const u8 *data, int dataSize )
{
    //f[^M
    WriteDpram( data, dataSize );

    //CXgNVR[hM
    nn::fs::Write( 0x02, REG_SEND_DATA_TO_TWL, reinterpret_cast<u32*>(&errorCode), REG_SIZE );

    
}

/************************************************************************
coq`lւ̏
************************************************************************/
void CommC2T::WriteDpram( const u8 *data, int dataSize )
{
    //f[^M
    if( dataSize !=0 ){
        nn::fs::Write( 0x02, REG_COMMUNICATION_DPRAM, reinterpret_cast<const u32*>(data), dataSize );
    }
}

void CommC2T::WriteDpramBinary( const u8 *data, int dataSize )
{
    //f[^M
    if( dataSize !=0 ){
        nn::fs::Write( 0x02, REG_COMMUNICATION_DPRAM_BINARY, reinterpret_cast<const u32*>(data), dataSize );
    }
}
/************************************************************************
coq`l̓ǂݏo
************************************************************************/
void CommC2T::ReadDpram( u8 *data, int dataSize )
{
    //f[^M
    if( dataSize !=0 )
    {
        u8 buffer[ nn::math::RoundUp( dataSize, sizeof(u32))];
        nn::fs::Read( 0x03, REG_COMMUNICATION_DPRAM, reinterpret_cast<u32*>(buffer), sizeof( buffer ) );
        std::memcpy( data, buffer, dataSize );
    }
}

void CommC2T::ReadDpramBinary( u8 *data, int dataSize )
{
    //f[^M
    if( dataSize !=0 )
    {
        u8 buffer[ nn::math::RoundUp( dataSize, sizeof(u32))];
        nn::fs::Read( 0x03, REG_COMMUNICATION_DPRAM_BINARY, reinterpret_cast<u32*>(buffer), sizeof( buffer ) );
        std::memcpy( data, buffer, dataSize );
    }
}

/************************************************************************

eXg[`

************************************************************************/

/************************************************************************
fBXvCÕAbvf[g
  ************************************************************************/
static void UpdateDisplay0(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    Menu::m_WindowManager.Update();
    Menu::m_WindowManager.UpdatePad(pad);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();        
    Menu::m_WindowManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 
}

/************************************************************************
coq`l̃eXg
  ************************************************************************/
void CommC2T::TestDpram(void)
{
    uji::sys::Pad pad;
    u8 *buffer;
    int mode;
    CommC2T *c2t = new CommC2T;
    buffer = new u8[DPRAM_SIZE];
    static const int FONT_SIZE=14;


    InputTextWindow *win = new uji::sys::InputTextWindow(
        uji::sys::GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2),
        uji::sys::GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE,
        FONT_SIZE,
        uji::sys::Menu::m_WindowManager);

    win->SetTitle( "TEST DPRAM" );
    Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY0, 0, 0 );        

    win->Printf("\f");
    win->Printf("0-5: 512k, 1M, 2M, 4M, 8M, 16M (R/W=1bit/1bit)\n");
    win->Printf("6-10:512k, 1M, 2M, 4M, 8M, 16M (R/W=4bit/1bit)\n");

    win->Printf("SPI TYPE=");
    mode = win->InputDecimal(0);
    
    c2t->Initialize( static_cast<SpiType>(mode) );

    u8 seed = 0;
    do
    {
        //pbhXV
        pad.UpdatePad();

        win->Printf( "seed=%d\n", seed );
        
        //
        for( int i=0 ; i< DPRAM_SIZE ; i++ ) buffer[i]=(u8)(seed+i);
        c2t->WriteDpram( buffer, DPRAM_SIZE );

        //NA
        for( int i=0 ; i< DPRAM_SIZE ; i++ ) buffer[i]=0;

        //xt@C
        c2t->ReadDpram( buffer, DPRAM_SIZE );
        for( int i=0 ; i< DPRAM_SIZE ; i++ )
        {
            if( buffer[i]!=(u8)( (seed+i)&0xff ) )
            {
                win->Printf( "ERROR: %04X:%02X->%02X\n", i, (seed+i)&0xff, buffer[i] );
                UpdateDisplay0();
                if( pad.WaitAnyKey() & Pad::BUTTON_B ) break;;
            }
        }
        UpdateDisplay0();
    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

    c2t->Finalize();

    Menu::m_WindowManager.DestroyWindow(win);
    delete win;
    delete[] buffer;
    delete c2t;
}


/************************************************************************
ʐMeXg
  ************************************************************************/
void CommC2T::TestComm(void)
{
    uji::sys::Pad pad;
    u8 *buffer;
    int mode;
    CommC2T *c2t = new CommC2T;
    buffer = new u8[DPRAM_SIZE];
    u16 code;
    static const int FONT_SIZE=14;


    InputTextWindow *win = new uji::sys::InputTextWindow(
        uji::sys::GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2),
        uji::sys::GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE,
        FONT_SIZE,
        uji::sys::Menu::m_WindowManager);

    win->SetTitle( "TEST COMMUNICAITION" );
    Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY0, 0, 0 );        

    win->Printf("\f");
    win->Printf("0-5: 512k, 1M, 2M, 4M, 8M, 16M (R/W=1bit/1bit)\n");
    win->Printf("6-10:512k, 1M, 2M, 4M, 8M, 16M (R/W=4bit/1bit)\n");

    win->Printf("SPI TYPE=");
    mode = win->InputDecimal(0);
    
    c2t->Initialize( static_cast<SpiType>(mode) );

    do
    {
        //pbhXV
        pad.UpdatePad();

        if( c2t->CanReceive() )
        {
            if( !c2t->Receive( &code, buffer, DPRAM_SIZE ) )
            {
                win->Printf( "inhibit bit is illegal!!\n" );
            }else{
                win->Printf( "INST=%04X\n", code );
                win->Printf( "Data %02X %02X %02X %02X %02X %02X %02X %02X\n",
                                buffer[0],
                                buffer[1],
                                buffer[2],
                                buffer[3],
                                buffer[4],
                                buffer[5],
                                buffer[6],
                                buffer[7] );
                //f[^]
                for(int i=0 ; i<DPRAM_SIZE ; i++ )
                {
                    buffer[i]=(u8)~buffer[i];
                }
                
                //M
                c2t->Send( (u16)~code, buffer, DPRAM_SIZE );
            }
        }
        UpdateDisplay0();
    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

    c2t->Finalize();

    Menu::m_WindowManager.DestroyWindow(win);
    delete win;
    delete[] buffer;
    delete c2t;
}
