/************************************************************************
b`k
 ************************************************************************/
#include <nn.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "sys.h"
#include "../seq/Config.h"
#include "../seq/TestList.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "TestCal.h"
#include <nn/drivers/cal/cal_default.h>         // CTR   CAL ftHgl
#include <nn/drivers/cal/cal_default_MODEL1.h>  // SPFL  CAL ftHgl
#include <nn/drivers/cal/cal_default_MODEL3.h>  // FTR  CAL ftHgl

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
using namespace nn::drivers::cal::CTR;

u8 s_RTCCompensationValue = 0;  //ޔEpqsbLl


/************************************************************************
qsbLl̑ޔƃX^[gŐLq
 ************************************************************************/
bool uji::sec::cal::TestBackUpRtcCalAndWriteStartLog(TestResult &result)
{
    RtcCompensation rtcCompensation;

    nn::drivers::cal::CTR::Calibration cal;
    cal.Initialize();

    if( !cal.IsAdjusted( CAL_DATA_RTC ) )
    {
        sprintf( result.m_String, "NOT ADJUSTED" );
        result.m_Result = false;
    }else{
        cal.Get(&rtcCompensation, nn::drivers::cal::CTR::CAL_DATA_RTC);
        s_RTCCompensationValue = rtcCompensation.RTCCompensationValue;
        sprintf( result.m_String, "RTC CAL=%02X", s_RTCCompensationValue );
        result.m_Result = true;
    }

    uji::seq::Config  *c = new uji::seq::Config;
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();

    pdl->Initialize();
    pdl->Add_1Line( c->Get().TestMode,
                    g_TestListSet[c->GetAlternative().TestList].m_Name,
                    "START",
                    VERSION_STRING,
                    "",
                    "",
                    "",
                    result.m_String );
    delete pdl;
    delete c;

    return result.m_Result;
}

/************************************************************************
qsbLl̕
 ************************************************************************/
bool uji::sec::cal::TestRestoreRtcCal(TestResult &result)
{
    RtcCompensation rtcCompensation;

    nn::drivers::cal::CTR::Calibration cal;
    cal.Initialize();

    sprintf( result.m_String, "RTC CAL=%02X", s_RTCCompensationValue );
    rtcCompensation.RTCCompensationValue = s_RTCCompensationValue;

    char errorString[100];
    sprintf( errorString, "CAL FAIL:RTC CAL=%02X", s_RTCCompensationValue );
    if( !cal.Set( &rtcCompensation, nn::drivers::cal::CTR::CAL_DATA_RTC) )  SYS_PANIC( errorString );
    if( !cal.Flush() )                                                      SYS_PANIC( errorString );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
b`kt@C̍폜
 ************************************************************************/
bool uji::sec::cal::TestEraseCal(TestResult &result)
{
    const wchar_t CAL_FILE0[]=L"nandro:/sys/HWCAL0.dat";
    const wchar_t CAL_FILE1[]=L"nandro:/sys/HWCAL1.dat";

    nn::Result nnr;
    
    nnr = nn::fs::TryDeleteFile( CAL_FILE0 );
    if( nnr.IsFailure())
    {
        sprintf( result.m_String, "Delete CAL file0 Fail" );
        return result.m_Result = false;
    }
    nnr = nn::fs::TryDeleteFile( CAL_FILE1 );
    if( nnr.IsFailure())
    {
        sprintf( result.m_String, "Delete CAL file1 Fail" );
        return result.m_Result = false;
    }

    return result.m_Result = true;
}

/************************************************************************
qsbȊÔb`kƂȂĂ邱Ƃ̊mF
 ************************************************************************/
bool uji::sec::cal::TestConfirmCalInitialized(TestResult &result)
{
    const u32 MICRO_CODE_OFFSET = 100;  //mf̃}CNR[hɂOgpłȂ߁AItZbg
    int i;
    Calibration cal;
    cal.Initialize();

    result.m_Result = true;
    for( i=0 ; i<nn::drivers::cal::CTR::CAL_DATA_MAX ; i++ )
    {
        if( i!=(int)nn::drivers::cal::CTR::CAL_DATA_RTC )
        {
            if( cal.IsAdjusted((nn::drivers::cal::CTR::Type)i ) )
            {
                result.m_Result = false;
                break;
            }
        }
    }

    if( !result.m_Result ) result.m_Micro=MICRO_CODE_OFFSET + i;
    return result.m_Result;
}

/************************************************************************
b`kς݂ƂȂĂ邱Ƃ̊mF

ς݂҂ĂTyperbgɂāAConfig->AdjustedCalɊmFĂ܂B

b0 :FCRAM
b1 :LCD_FLICKER
b2 :CAMREA
b3 :TOUCH_PANEL
b4 :ANALOG_STICK
b5 :CODEC
b6 :GYRO SCOPE
b7 :RTC

b8 :ACCEL
b9 :SURROUND
b10:ABL
b11:ULCD
b12:BL_PWM
b13:ANALOG_STICK_APPEND
b14:CAMERA_APPEND
b15:ABL_LGY

b16:MCU
b17:ULCD_DELAY
b18-b3:gp܂AOŖ߂ĂB

************************************************************************/
bool uji::sec::cal::TestConfirmCalAdjusted(TestResult &result)
{
    const u32 MICRO_CODE_OFFSET = 100;  //mf̃}CNR[hɂOgpłȂ߁AItZbg
    int i;
    bool expectedValue;

    Calibration cal;
    cal.Initialize();

    Config config;

#if 0
    u32 adjustedCal = config.Get().AdjustedCal;
#else
    u32 adjustedCal;

    switch(uji::sys::GetPlatformType())
    {
        case PLATFORM_CTR: adjustedCal = config.Get().AdjustedCalCtr; break;
        case PLATFORM_SPR: adjustedCal = config.Get().AdjustedCalSpr; break;
        case PLATFORM_FTR: adjustedCal = config.Get().AdjustedCalFtr; break;
        case PLATFORM_KTR: adjustedCal = config.Get().AdjustedCalKtr; break;
    }
#endif

    result.m_Result = true;
    for( i=0 ; i<nn::drivers::cal::CTR::CAL_DATA_MAX ; i++ )
    {
        expectedValue = (adjustedCal>>i & 1 )?true:false;

        if( cal.IsAdjusted( (nn::drivers::cal::CTR::Type)i )!=expectedValue )
        {
            result.m_Result = false;
            break;
        }
    }

    if( !result.m_Result ) result.m_Micro=MICRO_CODE_OFFSET + i;
    return result.m_Result;
}

/************************************************************************
njŐLq
 ************************************************************************/
bool uji::sec::cal::TestWriteOkLog(TestResult &result)
{

    uji::seq::Config  *c = new uji::seq::Config;
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();

    sprintf( result.m_String, "RTC CAL=%02X", s_RTCCompensationValue );

    pdl->Initialize();
    pdl->Add_1Line( c->Get().TestMode,
                    g_TestListSet[c->GetAlternative().TestList].m_Name,
                    "OK",
                    VERSION_STRING,
                    "",
                    "",
                    "",
                    result.m_String );
    delete pdl;
    delete c;

    result.m_Result=true;
    return result.m_Result;
}

namespace{
    
    enum
    {
        MICRO_SET               = 100,
        MICRO_FLUSH_AND_UPDATE  = 200,
        MICRO_FLUSH             = 210,
        MICRO_SET_MODEL         = 220
    };
}


static void FailMsg( TestResult &result, int micro1, int micro2 )
{
    result.m_Result = false;
    result.m_Micro  = micro1 + micro2;
    if( micro1 == MICRO_SET )
    {
        switch ( micro2 )
        {
            case CAL_DATA_FCRAM               : sprintf( result.m_String, "FAIL SET FCRAM                "); break;
            case CAL_DATA_LCD_FLICKER         : sprintf( result.m_String, "FAIL SET LCD_FLICKER          "); break;
            case CAL_DATA_CAMERA              : sprintf( result.m_String, "FAIL SET CAMERA               "); break;
            case CAL_DATA_TOUCH_PANEL         : sprintf( result.m_String, "FAIL SET TOUCH_PANEL          "); break;
            case CAL_DATA_ANALOG_STICK        : sprintf( result.m_String, "FAIL SET ANALOG_STICK         "); break;
            case CAL_DATA_CODEC               : sprintf( result.m_String, "FAIL SET CODEC                "); break;
            case CAL_DATA_GYRO_SCOPE          : sprintf( result.m_String, "FAIL SET GYRO_SCOPE           "); break;
            case CAL_DATA_RTC                 : sprintf( result.m_String, "FAIL SET RTC                  "); break;
            case CAL_DATA_ACCEL               : sprintf( result.m_String, "FAIL SET ACCEL                "); break;
            case CAL_DATA_SURROUND            : sprintf( result.m_String, "FAIL SET SURROUND             "); break;
            case CAL_DATA_ABL                 : sprintf( result.m_String, "FAIL SET ABL                  "); break;
            case CAL_DATA_ULCD                : sprintf( result.m_String, "FAIL SET ULCD                 "); break;
            case CAL_DATA_BL_PWM              : sprintf( result.m_String, "FAIL SET BL_PWM               "); break;
            case CAL_DATA_ANALOG_STICK_APPEND : sprintf( result.m_String, "FAIL SET ANALOG_STICK_APPEND  "); break;
            case CAL_DATA_CAMERA_APPEND       : sprintf( result.m_String, "FAIL SET CAMERA_APPEND        "); break;
            case CAL_DATA_ABL_LGY             : sprintf( result.m_String, "FAIL SET ABL_LGY              "); break;
            case CAL_DATA_MCU                 : sprintf( result.m_String, "FAIL SET MCU                  "); break;
            case CAL_DATA_ULCD_DELAY          : sprintf( result.m_String, "FAIL SET ULCD_DELAY           "); break;
            case CAL_DATA_ECHO_CANCEL         : sprintf( result.m_String, "FAIL SET ECHO_CANCEL          "); break;
        }
    }else
    {
        switch ( micro1 )
        {
            case MICRO_FLUSH_AND_UPDATE : sprintf( result.m_String, "FAIL FLUSH_AND_UPDATE  "); break;
            case MICRO_FLUSH            : sprintf( result.m_String, "FAIL FLUSH             "); break;
            case MICRO_SET_MODEL        : sprintf( result.m_String, "FAIL SET MODEL         "); break;
        }
        
    }

}


/************************************************************************
Œlb`kf[^ǋL
 ************************************************************************/
bool uji::sec::cal::TestSetConstantCal(TestResult &result)
{
    //khmdݒȊOł͌ɂnjŕԂB
    Config c;
    if( c.Get().TestMode !=uji::seq::pl::LINE )
    {
        strcpy( result.m_String, "SKIPPED" );
        result.m_Result = true;
        return result.m_Result;
    }

    LcdFlickerInfo lcdFlickerInfo;
    CodecCalDataCore codecCalDataCore;
    Surround surround;
    BacklightCalDataCore backlightCalDataCore;
    UlcdDelayCalDataCore ulcdDelayCalDataCore;
    EchoCancelCalDataCore echoCancelCalDataCore;

    u8 isFlicker    = 0x00;
    u8 isCodec      = 0x00;
    u8 isSurround   = 0x00;
    u8 isBL         = 0x00;
    u8 isUlcd       = 0x00;
    u8 isEcho       = 0x00;

    nn::drivers::cal::CTR::Calibration cal;
    cal.Initialize();

    cal.Get( &backlightCalDataCore,     CAL_DATA_BL_PWM );
    cal.Get( &codecCalDataCore,         CAL_DATA_CODEC );
    cal.Get( &lcdFlickerInfo,           CAL_DATA_LCD_FLICKER );
    cal.Get( &surround,                 CAL_DATA_SURROUND );
    cal.Get( &ulcdDelayCalDataCore,     CAL_DATA_ULCD_DELAY );
    cal.Get( &echoCancelCalDataCore,    CAL_DATA_ECHO_CANCEL );

    // }CNQC̓}CNŕ␳ׁA}CNQClޔ
    u8 micGainTemp = codecCalDataCore.micGainCalibrateParam;

    //Œl
    // -----------SPR------------
    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
    {
        if( !cal.IsAdjusted( nn::drivers::cal::CTR::CAL_DATA_LCD_FLICKER ))
        {
            lcdFlickerInfo = nn::drivers::cal::MODEL1::DEFAULT_LCD_FLICKER_INFO;            isFlicker   = 0x01;
        }
        
        codecCalDataCore     = nn::drivers::cal::MODEL1::CODEC_CFG_DEFAULT;                 isCodec     = 0x01;
        surround             = nn::drivers::cal::MODEL1::DEFAULT_SURROUND_CAL_DATA;         isSurround  = 0x01;
        backlightCalDataCore = nn::drivers::cal::MODEL1::DEFAULT_BACKLIGHT_CAL_DATA;        isBL        = 0x01;
        ulcdDelayCalDataCore = nn::drivers::cal::MODEL1::DEFAULT_ULCD_DELAY_CAL_DATA;       isUlcd      = 0x01;
        
    }
    // -----------FTR------------
    else if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        if( !cal.IsAdjusted( nn::drivers::cal::CTR::CAL_DATA_LCD_FLICKER ))
        {
            lcdFlickerInfo = nn::drivers::cal::MODEL3::DEFAULT_LCD_FLICKER_INFO;            isFlicker   = 0x01;
        }
        
        codecCalDataCore      = nn::drivers::cal::MODEL3::CODEC_CFG_DEFAULT;                isCodec     = 0x01;
        surround              = nn::drivers::cal::MODEL3::DEFAULT_SURROUND_CAL_DATA;        isSurround  = 0x01;
        backlightCalDataCore  = nn::drivers::cal::MODEL3::DEFAULT_BACKLIGHT_CAL_DATA;       isBL        = 0x01;
        echoCancelCalDataCore = nn::drivers::cal::MODEL3::DEFAULT_ECHO_CANCEL_CAL_DATA;     isEcho      = 0x01;

    }
    // -----------CTR------------
    else
    {
        backlightCalDataCore = nn::drivers::cal::CTR::DEFAULT_BACKLIGHT_CAL_DATA;           isBL        = 0x01;
    }

    codecCalDataCore.AnalogInterfaceParam.interval=1;
    codecCalDataCore.AnalogInterfaceParam.xpPullUpRegister=6;

    if( !cal.Set( &lcdFlickerInfo,        CAL_DATA_LCD_FLICKER, isFlicker  )) { FailMsg( result, MICRO_SET, CAL_DATA_LCD_FLICKER ); return false; }
    if( !cal.Set( &codecCalDataCore,      CAL_DATA_CODEC,       isCodec    )) { FailMsg( result, MICRO_SET, CAL_DATA_CODEC       ); return false; }
    if( !cal.Set( &surround,              CAL_DATA_SURROUND,    isSurround )) { FailMsg( result, MICRO_SET, CAL_DATA_SURROUND    ); return false; }
    if( !cal.Set( &backlightCalDataCore,  CAL_DATA_BL_PWM,      isBL       )) { FailMsg( result, MICRO_SET, CAL_DATA_BL_PWM      ); return false; }
    if( !cal.Set( &ulcdDelayCalDataCore,  CAL_DATA_ULCD_DELAY,  isUlcd     )) { FailMsg( result, MICRO_SET, CAL_DATA_ULCD_DELAY  ); return false; }
    if( !cal.Set( &echoCancelCalDataCore, CAL_DATA_ECHO_CANCEL, isEcho     )) { FailMsg( result, MICRO_SET, CAL_DATA_ECHO_CANCEL ); return false; }

    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
    {
        if(!cal.SetModel(nn::drivers::cal::CTR::CAL_MODEL_RESERVED_1))
        {
            FailMsg( result, MICRO_SET_MODEL, 0 );
            return result.m_Result;
        }
    }
    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        if(!cal.SetModel(nn::drivers::cal::CTR::CAL_MODEL_RESERVED_3))
        {
            FailMsg( result, MICRO_SET_MODEL, 0 );
            return result.m_Result;
        }
    }

    if( !cal.Flush())
    { 
        FailMsg( result, MICRO_FLUSH, 0 );
        return result.m_Result;
    }

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
p ē̏
 ************************************************************************/
bool uji::sec::cal::TestBoardReentry(TestResult &result)
{
    //LINEݒȊOł͌OKŕԂBLINEȊOł͎{Ȃz肾ǁB
    Config c;
    if( c.Get().TestMode !=uji::seq::pl::LINE )
    {
        strcpy( result.m_String, "SKIPPED" );
        result.m_Result = true;
        return result.m_Result;
    }
    
    // ȊÕO
    uji::eva::TestExtractCpuBoard( result );
    if( result.m_Result == false )
    {
        return result.m_Result;
    }
    
    // RTC␳lޔ
    RtcCompensation rtcCompensation;
    nn::drivers::cal::CTR::Calibration cal;
    cal.Initialize();

    if( !cal.IsAdjusted( CAL_DATA_RTC ) )
    {
        sprintf( result.m_String, "NOT ADJUSTED" );
        result.m_Result = false;
    }else{
        cal.Get(&rtcCompensation, nn::drivers::cal::CTR::CAL_DATA_RTC);
        s_RTCCompensationValue = rtcCompensation.RTCCompensationValue;
        sprintf( result.m_String, "RTC CAL=%02X", s_RTCCompensationValue );
        result.m_Result = true;
    }
    if( result.m_Result == false )
    {
        return result.m_Result;
    }
    
    // e␳l
    uji::sec::cal::TestEraseCal( result );
    if( result.m_Result == false )
    {
        return result.m_Result;
    }
    
    // RTC␳l𕜋A
    uji::sec::cal::TestRestoreRtcCal( result );
    if( result.m_Result == false )
    {
        return result.m_Result;
    }
    
    // ␳lĂ邩̊mF
    uji::sec::cal::TestConfirmCalInitialized( result );
    if( result.m_Result == false )
    {
        return result.m_Result;
    }
    
    // CALlCFGlɔf
    uji::eva::import::TestExecuteResetSetting( result );
    if( result.m_Result == false )
    {
        return result.m_Result;
    }
    
    result.m_Result = true;
    return result.m_Result;
}
