/************************************************************************

 FileViewer̃eXgvO
 
 *************************************************************************/

#ifndef FILE_VIEWER_H_INCLUDED
#define FILE_VIEWER_H_INCLUDED

#include <nn.h>
#include "sys.h"
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBase.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>  // EVA_SDK_0_14_1
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>

namespace uji{
namespace sec{


class FileViewer
{
    public:
    FileViewer() : m_UpperWindow( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE ),
                   m_LowerWindow( 320/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE ),
                   gfx( uji::sys::GraphicsDrawing::GetInstance())
    {
        nn::fs::ForceDisableLatencyEmulation();
    }
    ~FileViewer(){}
    
    struct FileMenuMap
    {
        char FuncName[40];
        void ( FileViewer::*func )( const wchar_t *, const nn::fs::DirectoryEntry * );
        char FuncExplanation[100];
    };
    
    static void FileViewerMenu()
    {
        uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "FileViewerMenu" );
#if (!defined(EVA_LCD_RED))
        m->Add( " Rom           ", FileViewer::OpenROM );
#endif
        m->Add( " SDMC          ", FileViewer::OpenSDMC );
#if (!defined(EVA_LCD_RED))
        m->Add( " NAND          ", FileViewer::OpenNAND );
        m->Add( " Data          ", FileViewer::OpenDATA );
        m->Add( " Twln          ", FileViewer::OpenTWLN );
#endif
        m->Open();
        delete m;
    }
    
    static void OpenSDMC()
    {
        nn::Result result;
        
        result = nn::fs::MountSdmc();
        if( result.IsFailure())
        {
            nn::dbg::PrintResult( result );
            uji::sys::ShowMessage::Open( &uji::sys::Menu::m_WindowManager, " Open Failed! ");
            return;
        }
        FileViewer* fv = new FileViewer;
        fv->FileViewerCommon( L"sdmc:/" );
        nn::fs::Unmount( "sdmc:/" );
        delete fv;
    }
    
    static void OpenNAND()
    {
        FileViewer* fv = new FileViewer;
        fv->FileViewerCommon( L"nand:/" );
        delete fv;
    }
    
    static void OpenTWLN()
    {
        nn::Result result;
        
        result = nn::fs::MountSpecialArchive("twln:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND );
        if( result.IsFailure())
        {
            nn::dbg::PrintResult( result );
            uji::sys::ShowMessage::Open( &uji::sys::Menu::m_WindowManager, " Open Failed! ");
            return;
        }
        FileViewer* fv = new FileViewer;
        fv->FileViewerCommon( L"twln:/" );
        nn::fs::Unmount( "twln:" );
        delete fv;
    }
    
    static void OpenDATA()
    {
        nn::Result result;
        result = nn::fs::MountSaveData();
        if( result <= nn::fs::ResultNotFormatted() )    // EVA_SDK_0_14_1
        {
            result = nn::fs::FormatSaveData( 0x100, 0x100 );
            if( result.IsFailure())
            {
                NN_LOG("Format Error\n");
                uji::sys::ShowMessage::Open( &uji::sys::Menu::m_WindowManager, " Open Failed! ");
                return;
            }
            result = nn::fs::MountSaveData();
            if( result.IsFailure())
            {
                NN_LOG("Mount Error\n");
                uji::sys::ShowMessage::Open( &uji::sys::Menu::m_WindowManager, " Open Failed! ");
                return;
            }
        }

        FileViewer* fv = new FileViewer;
        fv->FileViewerCommon( L"data:/" );
        nn::fs::Unmount( "data:" );
        delete fv;
    }
    
    static void OpenROM()
    {
        const int READ_FILE_NUM = 50;
        
        FileViewer* fv = new FileViewer;
        fv->FileViewerCommon( L"rom:/");

        delete fv;
    }
    
    
    void OpenBinaryViewer( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry );
    void OpenBitmapViewer( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry );
    void NumberBmp( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry );
    void OpenBitmap3D( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry );
    void CopyToSDMC( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry );
    void DeleteFile( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry );
    void DeleteDir( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry );

        

    private:
    static const u32 FONT_SIZE = 14;
    static const u32 MAX_DIR_ENTRY_LENGTH = 255;
    static const u32 MAX_FILE_PATH_LENGTH = 255;
    static const u32 VIEW_MAX_NUM = 15;
    static const u32 HEIGHT_MAX_NUM = 55;
    
    void FileViewerCommon( const wchar_t* rootDirectory );
    bool MakeDirEntry( nn::fs::DirectoryEntry* dirEntry, s32* entryNum, const wchar_t* dirPath );
    void DirTest();
    void ShowDirList( nn::fs::DirectoryEntry* dirEntry, const s32 entryNum, const int nowCursor );
    void DrawScrollBar( const int posX, const int posY, const int width, const int height, 
                        const int allElement, const int nowElement, const int showElementNum );

    void OpenFileMenu( const wchar_t* filePath, const nn::fs::DirectoryEntry* dirEntry );
    void OpenDirMenu( const wchar_t* filePath, const nn::fs::DirectoryEntry* dirEntry );

    
    uji::sys::TextWindow    m_UpperWindow;
    uji::sys::TextWindow    m_LowerWindow;
    //uji::sys::WindowManager m_WindowManager;
    
    uji::sys::GraphicsDrawing* gfx;
    
};


} // namespace sec
} // namespace uji

#endif // FILE_VIEWER_H_INCLUDED
