/************************************************************************

 FileViewer̃eXgvO
 
 *************************************************************************/

#include "FileViewer.h"
#include <nn/fs.h>
#include "sys_ShowMessage.h"
#include <string>
#include <wchar.h>
#include "../eva/lcd/TestLcd_RED.h"
using namespace uji::sys;

namespace uji{
namespace sec{

namespace
{
    FileViewer::FileMenuMap fileMenuMap[] = 
    {
        { "Open Binary"     ,&FileViewer::OpenBinaryViewer, "Open To Binary Mode"       },
        { "Open Text"       ,NULL,                          "Not Implement..."          },
        { "Open Bmp"        ,&FileViewer::OpenBitmapViewer, "Open BMP File\nPlease Select ***.bmp"              },
        { "Open Bmp 3D"     ,&FileViewer::OpenBitmap3D,     "Open BMP File with 3D Mode\nPlease Select ***_left.bmp"},
        { "Open Num Bmp"    ,&FileViewer::NumberBmp,        "Open Numbered BMP Files"   },
#ifdef EVA_START_MENU
        { "Copy to SD"      ,&FileViewer::CopyToSDMC,       "Make Folder And Copy File" },
        { "-----------"     ,NULL,                          " "                         },
        { "Delete File"     ,&FileViewer::DeleteFile,       "Delete File"               },
#endif
    };
    
    FileViewer::FileMenuMap dirMenuMap[] = 
    {
#ifdef EVA_START_MENU
        { "Delete Dir"     ,&FileViewer::DeleteDir, "Delete Directory "       },
#else
        { "-----------"     ,NULL,                          " "                         },
#endif
    };
}

/*---------------------------------------------------------------------------
  name: NumberBmp
  Desc: ԍbmpt@CJ(cN)

  Args: Jt@C̃pX ext:"rom:","sdmc:"
  Rtns: ȂB
---------------------------------------------------------------------------*/  
void FileViewer::NumberBmp( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry );

    uji::eva::TestLcd_RED TLR1;
    TLR1.NumberBmpViewer( openPath );
    
}

/*---------------------------------------------------------------------------
  name: OpenBmp3D
  Desc: bmpt@C3D[hŊJ(cN)

  Args: Jt@C̃pX ext:"rom:","sdmc:"
  Rtns: ȂB
---------------------------------------------------------------------------*/  
void FileViewer::OpenBitmap3D( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry );

    uji::eva::TestLcd_RED TLR1;
    TLR1.OpenBmp3D( openPath );
    
}

/*---------------------------------------------------------------------------
  name: OpenBitmapViewer
  Desc: t@CbmpƂĊJ(cN)

  Args: Jt@C̃pX ext:"rom:","sdmc:"
  Rtns: ȂB
---------------------------------------------------------------------------*/  
void FileViewer::OpenBitmapViewer( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry );
        
    uji::eva::TestLcd_RED TLR1;
    TLR1.OpenBmpViewer( openPath );
    
}

/*---------------------------------------------------------------------------
  name: FileViewerCommon
  Desc: t@Cr[{

  Args: [g̃pX ext:"rom:","sdmc:"
  Rtns: ȂB
---------------------------------------------------------------------------*/  

void FileViewer::FileViewerCommon( const wchar_t* rootDirectory )
{
    nn::fs::DirectoryEntry* dirEntry = new nn::fs::DirectoryEntry[ MAX_DIR_ENTRY_LENGTH ];
    wchar_t* dirPath  = new wchar_t[ MAX_FILE_PATH_LENGTH + 1 ];
    wchar_t* filePath = new wchar_t[ MAX_FILE_PATH_LENGTH + 1 ];
    
    int nowCursor = 0;  // ݂̃J[\ʒu
    s32 entryNum  = 0;  // fBNgGg
    
    Menu::m_WindowManager.CreateWindow( &m_UpperWindow, NN_GX_DISPLAY0, 0, 0 );
    
    std::wcscpy( dirPath, rootDirectory );
    
    MakeDirEntry( dirEntry, &entryNum, dirPath );
    
    while( true )
    {
        Pad().UpdatePad();
        if( Pad().IsButtonRepeat( Pad::BUTTON_UP ))
        {
            if( nowCursor <= 0 )
            {
                nowCursor = entryNum - 1;
            }else
            {
                nowCursor--;
            }
        }
        if( Pad().IsButtonRepeat( Pad::BUTTON_DOWN ))
        {
            if( nowCursor >= entryNum - 1 )
            {
                nowCursor = 0;
            }else
            {
                nowCursor++;
            }
        }
        if( Pad().IsButtonRepeat( Pad::BUTTON_LEFT ))
        {
            if( nowCursor > VIEW_MAX_NUM )
            {
                nowCursor -= VIEW_MAX_NUM;
            }else
            {
                nowCursor = 0;
            }
        }
        if( Pad().IsButtonRepeat( Pad::BUTTON_RIGHT ))
        {
            if( nowCursor < entryNum - VIEW_MAX_NUM )
            {
                nowCursor += VIEW_MAX_NUM;
            }else
            {
                nowCursor = entryNum - 1;
            }
        }
        // B{^AJ[\ԏ(..)A{^
        if( Pad().IsButtonDown( Pad::BUTTON_B ) || ( Pad().IsButtonDown( Pad::BUTTON_A ) && nowCursor == 0 ))
        {
            if( !std::wcscmp( dirPath, rootDirectory ) )
            {
                break; // [gfBNgɂꍇ͔B
            }else
            {
                int pathLength = std::wcslen( dirPath ) - 1;  // pXz̖̓Y
                do{
                    dirPath[ pathLength ] = L'\0';
                    pathLength--;
                }while( dirPath[ pathLength ] != L'/' );  // XbV̎O܂ł\0Ŗ߂
                
                nowCursor = 0;  // J[\0ɖ߂
            }
        }  // L̏ȊO(J[\ԏȊO)A{^
        else if( Pad().IsButtonDown( Pad::BUTTON_A ) )
        {
            // fBNgIꍇA'/'ƃfBNgǉăfBNgGg蒼
            if( dirEntry[ nowCursor ].attributes.isDirectory )
            {
                //std::wcscat( dirPath, L"/" );
                std::wcscat( dirPath, dirEntry[ nowCursor ].entryName );
                std::wcscat( dirPath, L"/" );
                nowCursor = 0;
            }else
            {   // t@CIꍇAt@Cj[N
                std::wcscpy( filePath, dirPath );
                //std::wcscat( filePath, L"/" );
                std::wcscat( filePath, dirEntry[ nowCursor ].entryName );
                //OpenBinaryViewer( filePath );
                OpenFileMenu( filePath, &dirEntry[ nowCursor ] );
            }
        }else if( Pad().IsButtonDown( Pad::BUTTON_X ) && dirEntry[ nowCursor ].attributes.isDirectory )
        {
            std::wcscpy( filePath, dirPath );
            std::wcscat( filePath, dirEntry[ nowCursor ].entryName );
            OpenDirMenu( filePath, &dirEntry[ nowCursor ] );
        }
        
        // fBNgGg쐬A\XV
        MakeDirEntry( dirEntry, &entryNum, dirPath );
        ShowDirList( dirEntry, entryNum, nowCursor );
    }
    
    Menu::m_WindowManager.DestroyWindow( &m_UpperWindow );
    m_UpperWindow.Destroy();
    
    delete[] dirPath;
    delete[] filePath;
    delete[] dirEntry;
    
}

/*---------------------------------------------------------------------------
  name: ShowDirList
  Desc: fBNgGgƌ݂̃J[\ʒut@CXg`

  Args: dirEntry  = fBNgGg
        entryNum  = Gg
        nowCursor = J[\ʒu
        
  Rtns: ȂB
---------------------------------------------------------------------------*/  

void FileViewer::ShowDirList( nn::fs::DirectoryEntry* dirEntry, const s32 entryNum, const int nowCursor )
{
    m_UpperWindow.Printf("\f");
    
    int start = 0;
    int end   = 0;
    
    static int lastStart = 0;
    static int lastEnd   = VIEW_MAX_NUM;
    
    
    if( entryNum <= VIEW_MAX_NUM )
    {
        start = 0;
        end   = entryNum;
    }else if( nowCursor == 0 )
    {
        start = 0;
        end   = VIEW_MAX_NUM;
    }
    else if( nowCursor >= lastStart && lastEnd > nowCursor )
    {
        start = lastStart;
        end   = lastEnd;
    }else if( nowCursor < lastStart )
    {
        start = nowCursor;
        end   = VIEW_MAX_NUM + start;
    }else if( lastEnd <= nowCursor )
    {
        end   = nowCursor + 1;
        start = end - VIEW_MAX_NUM;
    }else
    {
        NN_LOG("ERROR\n");
    }
    
    lastStart = start;
    lastEnd   = end;
    
    for(int i = start; i < end; i++ )
    {
        if( nowCursor == i )
        {
            m_UpperWindow.SetTextColor( ATTR_COLOR_CYAN );
        }else
        {
            m_UpperWindow.SetTextColor( ATTR_COLOR_WHITE );
        }
        
        m_UpperWindow.Printf("%-47ls", dirEntry[i].entryName );
        if( dirEntry[i].attributes.isDirectory )
        {
            m_UpperWindow.Printf("   <DIR>\n");
        }else
        {
            m_UpperWindow.Printf("%8d\n",dirEntry[i].entrySize );
        }
        
    }

    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->Clear();
    Menu::m_WindowManager.Update();
    Menu::m_WindowManager.DrawDisplay0();
    
    DrawScrollBar( 400-8, 12, 7, 227, entryNum, start, VIEW_MAX_NUM );

    gfx->m_DrawFramework->SwapBuffers();
    
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
}

/*---------------------------------------------------------------------------
  name: MakeDirEntry
  Desc: fBNg̃pXGg쐬

  Args: dirEntry  = fBNgGg
        entryNum  = Gg
        dirPath   = fBNg̃pX
        
  Rtns: 쐬ɐtrueAsfalse
---------------------------------------------------------------------------*/  
bool FileViewer::MakeDirEntry( nn::fs::DirectoryEntry* dirEntry, s32* entryNum, const wchar_t* dirPath )
{
    nn::fs::Directory dir;
    nn::Result result;
    result = dir.TryInitialize( dirPath );
    if( result.IsFailure())
    {
        NN_LOG("dirInitialize Failed\n");
        nn::dbg::PrintResult( result );
        return false;
    }
    
    //--------------------------------------------------------------------------
    // ߂閼O".."ǉăGg쐬
    //--------------------------------------------------------------------------
    *entryNum = ( dir.Read( &dirEntry[1], MAX_DIR_ENTRY_LENGTH ) + 1 );
    std::wcscpy( dirEntry[0].entryName, L".." );
    dirEntry[0].attributes.isDirectory = true;
    
    #pragma diag_suppress 181  // RpC̃oOۂŗ}
    char windowTitle[ MAX_FILE_PATH_LENGTH ] = "";
    std::sprintf( windowTitle, "FileViewer - [%ls]", dirPath );
    #pragma diag_default 181
    
    m_UpperWindow.SetTitle( windowTitle );
    
    return true;
}

/*---------------------------------------------------------------------------
  name: DrawScrollBar
  Desc: EBhEp̃XN[o[`悷
        EBhE̕``SwapBufferĂԑOɌĂԁB

  Args: PosX            = XN[o[̍XW
        PosY            = XN[o[̍YW
        width           = XN[o[X̒
        height          = XN[o[Y̒
        allElement      = EBhEɕ\SĂ̗vf̐
        nowElement      = ݂̕\Ăvf̈ʒu
        showElementNum  = xɃEBhEɕ\łvf̐
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
void FileViewer::DrawScrollBar( const int posX, const int posY, const int width, const int height, 
                                const int allElement, const int nowElement, const int showElementNum )
{
    gfx->BeginDrawingShape();
    
    gfx->SetColor( nw::ut::Color8( 0x303030FF ));
    gfx->FillRectangle( posX, posY, width, height );
    
    gfx->SetColor( nw::ut::Color8::GRAY );
    if( allElement > showElementNum )
    {
        gfx->FillRectangle( posX + 1,
                            posY + nowElement*( height - 2 )/ allElement + 1,
                            width - 2,
                            nw::ut::Max( ( height - 2 ) * showElementNum / allElement, 1 ));
    }
}

#if 1
#pragma diag_suppress 546,181


/*---------------------------------------------------------------------------
  name: OpenBinaryViewer
  Desc: oCir[N

  Args: openPath = Jt@C̃pX
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
void FileViewer::OpenBinaryViewer( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry );
    //--------------------------------------------------------------------------
    // 
    //--------------------------------------------------------------------------
    nn::fs::FileInputStream fr;
    nn::Result result;
    
    result = fr.TryInitialize( openPath );
    
    
    if( result.IsFailure())
    {
        NN_LOG("Initialize Failed\n");
        nn::dbg::PrintResult( result );
        return;
    }
    s64 fileSize;
    s32 readSize;
    
    result = fr.TryGetSize( &fileSize );
    if( result.IsFailure())
    {
        NN_LOG("GetSize Failed\n");
        nn::dbg::PrintResult( result );
        return;
    }
    if( fileSize == 0 )
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " File is Empty! ");
        return;
        
    }
    u8* fileOpenBuf = new u8[ nn::math::RoundUp( fileSize, 8 ) ];
    if( fileOpenBuf == NULL )
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " File Too Large! ");
        return;
    }
    std::memset( fileOpenBuf, 0x00, nn::math::RoundUp( fileSize, 8 ));
    
    uji::sys::TextWindow binaryWindow( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    Menu::m_WindowManager.CreateWindow( &binaryWindow, NN_GX_DISPLAY0, 0, 0 );
    
    result = fr.TryRead( &readSize, fileOpenBuf, fileSize );
    if( result.IsFailure())
    {
        NN_LOG("Read Failed\n");
        nn::dbg::PrintResult( result );
        goto BINARY_FINALIZE;
    }
    if( readSize != fileSize )
    {
        NN_LOG("ReadSize != FileSize\n");
    }

    
    char binaryWindowTitle[ MAX_FILE_PATH_LENGTH ] = "";
    std::sprintf( binaryWindowTitle, "Binary Viewer - [%ls]", openPath );
    
    binaryWindow.SetTitle( binaryWindowTitle );
    
    int nowPosition = 0;
    u8* baseAddress = fileOpenBuf;
    char* charPointer = NULL;
    char  putChar[2] = "";
    putChar[1] = '\0';

    
    u8 viewNum;
    
    if( fileSize / 8 + 1 < VIEW_MAX_NUM )
    {
        viewNum = fileSize / 8;
        if( fileSize % 8 )
        {
            viewNum += 1;
        }
    }else
    {
        viewNum = VIEW_MAX_NUM;
    }
    
    while( true )
    {
        //--------------------------------------------------------------------------
        // L[֘A
        //--------------------------------------------------------------------------
        Pad().UpdatePad();
        
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_UP ))
        {
            if( nowPosition > 0 )
            {
                nowPosition--;
            }
        }
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_DOWN ))
        {
            if( nowPosition <= (fileSize-1) / 8 - VIEW_MAX_NUM )
            {
                nowPosition++;
            }
        }
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_LEFT ))
        {
            if( nowPosition <= VIEW_MAX_NUM )
            {
                nowPosition = 0;
            }else
            {
                nowPosition -= VIEW_MAX_NUM;
            }
        }
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_RIGHT ))
        {
            if( nowPosition + VIEW_MAX_NUM < fileSize / 8 - VIEW_MAX_NUM - 1 )
            {
                nowPosition += VIEW_MAX_NUM;
            }else if( 0 <= fileSize / 8 - VIEW_MAX_NUM )
            {
                nowPosition = (fileSize-1)/8 - VIEW_MAX_NUM + 1;
            }
        }
        if( Pad().IsButtonDown( Pad::BUTTON_B ))
        {
            break;
        }
        
        //--------------------------------------------------------------------------
        // \
        //--------------------------------------------------------------------------
        
        binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
        binaryWindow.Printf("\f");
        binaryWindow.Printf("Address   +0 +1 +2 +3 +4 +5 +6 +7  ASCII\n");
        
        baseAddress = fileOpenBuf + ( 8 * nowPosition );
        
        
        for( int i = 0; i < viewNum ; i++ )
        {
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%08X  ", static_cast<u32>( baseAddress - fileOpenBuf ));
            
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );  // J[O
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X  ", *baseAddress++ );
            
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            charPointer = reinterpret_cast<char*>( baseAddress - 8 );
            for( int j = 0; j < 8; j++ )
            {
                putChar[0] = *charPointer;
                if( putChar[0] == '%' )
                {
                    binaryWindow.PutString( putChar );
                    binaryWindow.PutString( putChar );  // %2񏑂ȂƏƂĔF
                }
                else if( 0x20 < putChar[0] && putChar[0] < 0x7F )
                {
                    binaryWindow.PutString( putChar );
                }else
                {
                    binaryWindow.PutString(" ");
                }
                charPointer++;
            }
            binaryWindow.PutString("\n");

        }
        
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.DrawDisplay0();
        
        
        gfx->SetColor( nw::ut::Color8( 0x77777777 ));
        gfx->FillRectangle( 1, 12, 398, FONT_SIZE + 2 );
        
        const int BAR_POS_X  = 400 - 8;
        const int BAR_POS_Y  = 12;
        const int BAR_WIDTH  = 7;
        const int BAR_HEIGHT = 227;
        
        DrawScrollBar( BAR_POS_X, BAR_POS_Y, BAR_WIDTH, BAR_HEIGHT, ( fileSize - 1 ) / 8 + 1, nowPosition, VIEW_MAX_NUM );

        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    }
    
    BINARY_FINALIZE:
    
    Menu::m_WindowManager.DestroyWindow( &binaryWindow );
    binaryWindow.Destroy();
    
    fr.Finalize();
    delete[] fileOpenBuf;
    
}


/*---------------------------------------------------------------------------
  name: OpenTextViewer
  Desc: eLXgr[N

  Args: openPath = Jt@C̃pX
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
/*
void FileViewer::OpenTextViewer( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry );
    //--------------------------------------------------------------------------
    // 
    //--------------------------------------------------------------------------
    nn::fs::FileInputStream fr;
    nn::Result result;
    
    result = fr.TryInitialize( openPath );
    
    
    if( result.IsFailure())
    {
        NN_LOG("Initialize Failed\n");
        nn::dbg::PrintResult( result );
        return;
    }
    s64 fileSize;
    s32 readSize;
    
    result = fr.TryGetSize( &fileSize );
    if( result.IsFailure())
    {
        NN_LOG("GetSize Failed\n");
        nn::dbg::PrintResult( result );
        return;
    }
    if( fileSize == 0 )
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " File is Empty! ");
        return;
        
    }
    u8* fileOpenBuf = new u8[ nn::math::RoundUp( fileSize, 8 ) ];
    if( fileOpenBuf == NULL )
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " File Too Large! ");
        return;
    }
    std::memset( fileOpenBuf, 0x00, nn::math::RoundUp( fileSize, 8 ));
    
    uji::sys::TextWindow binaryWindow( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    Menu::m_WindowManager.CreateWindow( &binaryWindow, NN_GX_DISPLAY0, 0, 0 );
    
    result = fr.TryRead( &readSize, fileOpenBuf, fileSize );
    if( result.IsFailure())
    {
        NN_LOG("Read Failed\n");
        nn::dbg::PrintResult( result );
        goto BINARY_FINALIZE;
    }
    if( readSize != fileSize )
    {
        NN_LOG("ReadSize != FileSize\n");
    }

    
    char binaryWindowTitle[ MAX_FILE_PATH_LENGTH ] = "";
    std::sprintf( binaryWindowTitle, "Text Viewer - [%ls]", openPath );
    
    binaryWindow.SetTitle( binaryWindowTitle );
    
    int nowPosition = 0;
    u8* baseAddress = fileOpenBuf;
    char* charPointer = NULL;
    char  putChar[2] = "";
    putChar[1] = '\0';

    
    u8  viewNum = 0;
    u32 lineNum = 0;
    u32 filePosCount = 0;
    
    for( int i = 0; i < fileSize; i++ )
    {
        if( fileOpenBuf[i] == 0x0d ) // CR
        {
            if( fileOpenBuf[i+1] == 0x0a )
            {
                continue;
            }else
            {
                filePosCount = 0;
                lineNum++;
                continue;
            }
        }
        if( fileOpenBuf[i] == 0x0a )
        {
            filePosCount = 0;
            lineNum++;
            continue;
        }
        
        filePosCount++;
        
        if( filePosCount == 55 )
        {
            filePosCount = 0;
            lineNum++;
        }
        
    }
    
    if( lineNum + 1 < VIEW_MAX_NUM )
    {
        viewNum = lineNum;
        //if( fileSize % 8 )
        //{
        //    viewNum += 1;
        //}
    }else
    {
        viewNum = VIEW_MAX_NUM;
    }
    
    while
    
    while( true )
    {
        //--------------------------------------------------------------------------
        // L[֘A
        //--------------------------------------------------------------------------
        Pad().UpdatePad();
        
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_UP ))
        {
            if( nowPosition > 0 )
            {
                nowPosition--;
            }
        }
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_DOWN ))
        {
            if( nowPosition <= (fileSize-1) / 8 - VIEW_MAX_NUM )
            {
                nowPosition++;
            }
        }
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_LEFT ))
        {
            if( nowPosition <= VIEW_MAX_NUM )
            {
                nowPosition = 0;
            }else
            {
                nowPosition -= VIEW_MAX_NUM;
            }
        }
        if( Pad().IsButtonRepeatFast( Pad::BUTTON_RIGHT ))
        {
            if( nowPosition + VIEW_MAX_NUM < fileSize / 8 - VIEW_MAX_NUM - 1 )
            {
                nowPosition += VIEW_MAX_NUM;
            }else if( 0 <= fileSize / 8 - VIEW_MAX_NUM )
            {
                nowPosition = (fileSize-1)/8 - VIEW_MAX_NUM + 1;
            }
        }
        if( Pad().IsButtonDown( Pad::BUTTON_B ))
        {
            break;
        }
        
        //--------------------------------------------------------------------------
        // \
        //--------------------------------------------------------------------------
        binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
        binaryWindow.Printf("\f");
        binaryWindow.Printf("Address   +0 +1 +2 +3 +4 +5 +6 +7  ASCII\n");
        
        baseAddress = fileOpenBuf + ( 8 * nowPosition );
        
        
        for( int i = 0; i < viewNum - 1 ; i++ )
        {
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%08X  ", static_cast<u32>( baseAddress - fileOpenBuf ));
            
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );  // J[O
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X ", *baseAddress++ );
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            binaryWindow.Printf("%02X  ", *baseAddress++ );
            
            binaryWindow.SetTextColor( ATTR_COLOR_WHITE );
            charPointer = reinterpret_cast<char*>( baseAddress - 8 );
            for( int j = 0; j < 8; j++ )
            {
                putChar[0] = *charPointer;
                if( putChar[0] == '%' )
                {
                    binaryWindow.PutString( putChar );
                    binaryWindow.PutString( putChar );  // %2񏑂ȂƏƂĔF
                }
                else if( 0x20 < putChar[0] && putChar[0] < 0x7F )
                {
                    binaryWindow.PutString( putChar );
                }else
                {
                    binaryWindow.PutString(" ");
                }
                charPointer++;
            }
            binaryWindow.PutString("\n");

        }
        
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.DrawDisplay0();
        
        DrawScrollBar( 400-8, 12, 7, 227, ( fileSize - 1 ) / 8 + 1, nowPosition, VIEW_MAX_NUM );

        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    }
    
    BINARY_FINALIZE:
    
    Menu::m_WindowManager.DestroyWindow( &binaryWindow );
    binaryWindow.Destroy();
    
    fr.Finalize();
    delete[] fileOpenBuf;
    
}
*/

void FileViewer::OpenFileMenu( const wchar_t* filePath, const nn::fs::DirectoryEntry* dirEntry )
{
    uji::sys::TextWindow menuWindow( 100/(FONT_SIZE/2), ( sizeof( fileMenuMap )/sizeof( fileMenuMap[0])) + 1, FONT_SIZE );
    menuWindow.SetTitle("File Menu");
    Menu::m_WindowManager.CreateWindow( &menuWindow, NN_GX_DISPLAY0, 
                                        150, 120 - ( FONT_SIZE*( sizeof( fileMenuMap )/sizeof( fileMenuMap[0])) )/2 );
    
    int nowPosition = 0;
    
    while( true )
    {
        //--------------------------------------------------------------------------
        // L[֘A
        //--------------------------------------------------------------------------
        Pad().UpdatePad();
        
        if( Pad().IsButtonRepeat( Pad::BUTTON_UP ))
        {
            if( nowPosition == 0 )
            {
                nowPosition = ( sizeof( fileMenuMap )/sizeof( fileMenuMap[0])) - 1;
            }else
            {
                nowPosition--;
            }
        }
        if( Pad().IsButtonRepeat( Pad::BUTTON_DOWN ))
        {
            if( nowPosition == (( sizeof( fileMenuMap )/sizeof( fileMenuMap[0])) - 1 ))
            {
                nowPosition = 0;
            }else
            {
                nowPosition++;
            }
        }

        if( Pad().IsButtonDown( Pad::BUTTON_B ))
        {
            break;
        }
        if( Pad().IsButtonDown( Pad::BUTTON_A ))
        {
            if( fileMenuMap[ nowPosition ].func != NULL )
            {
                ( this->*( fileMenuMap[ nowPosition ].func ))( filePath, dirEntry );
                break;
            }
        }
        
        
        
        //--------------------------------------------------------------------------
        // `֘A
        //--------------------------------------------------------------------------
        
        menuWindow.Printf("\f");
        
        for( int i = 0; i < ( sizeof( fileMenuMap )/sizeof( fileMenuMap[0]) ); i++ )
        {
            if( i == nowPosition )
            {
                menuWindow.SetTextColor( ATTR_COLOR_CYAN );
            }else
            {
                menuWindow.SetTextColor( ATTR_COLOR_WHITE );
            }
            menuWindow.Printf("%s\n", fileMenuMap[ i ].FuncName );
        }
        
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.DrawDisplay0();
        
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf("%s\n", fileMenuMap[ nowPosition ].FuncExplanation );     
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();

        
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
        
    }
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->Clear();
    Menu::m_SubWindow->Printf("\f");
    Menu::m_WindowManager.Update();
    Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();

        
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    
    Menu::m_WindowManager.DestroyWindow( &menuWindow );
    menuWindow.Destroy();
}

void FileViewer::OpenDirMenu( const wchar_t* filePath, const nn::fs::DirectoryEntry* dirEntry )
{
    uji::sys::TextWindow menuWindow( 100/(FONT_SIZE/2), ( sizeof( dirMenuMap )/sizeof( dirMenuMap[0])) + 1, FONT_SIZE );
    menuWindow.SetTitle("Dir Menu");
    Menu::m_WindowManager.CreateWindow( &menuWindow, NN_GX_DISPLAY0, 
                                        150, 120 - ( FONT_SIZE*( sizeof( dirMenuMap )/sizeof( dirMenuMap[0])) )/2 );
    
    int nowPosition = 0;
    
    while( true )
    {
        //--------------------------------------------------------------------------
        // L[֘A
        //--------------------------------------------------------------------------
        Pad().UpdatePad();
        
        if( Pad().IsButtonRepeat( Pad::BUTTON_UP ))
        {
            if( nowPosition == 0 )
            {
                nowPosition = ( sizeof( dirMenuMap )/sizeof( dirMenuMap[0])) - 1;
            }else
            {
                nowPosition--;
            }
        }
        if( Pad().IsButtonRepeat( Pad::BUTTON_DOWN ))
        {
            if( nowPosition == (( sizeof( dirMenuMap )/sizeof( dirMenuMap[0])) - 1 ))
            {
                nowPosition = 0;
            }else
            {
                nowPosition++;
            }
        }

        if( Pad().IsButtonDown( Pad::BUTTON_B ))
        {
            break;
        }
        if( Pad().IsButtonDown( Pad::BUTTON_A ))
        {
            if( dirMenuMap[ nowPosition ].func != NULL )
            {
                ( this->*( dirMenuMap[ nowPosition ].func ))( filePath, dirEntry );
                break;
            }
        }
        
        
        
        //--------------------------------------------------------------------------
        // `֘A
        //--------------------------------------------------------------------------
        
        menuWindow.Printf("\f");
        
        for( int i = 0; i < ( sizeof( dirMenuMap )/sizeof( dirMenuMap[0]) ); i++ )
        {
            if( i == nowPosition )
            {
                menuWindow.SetTextColor( ATTR_COLOR_CYAN );
            }else
            {
                menuWindow.SetTextColor( ATTR_COLOR_WHITE );
            }
            menuWindow.Printf("%s\n", dirMenuMap[ i ].FuncName );
        }
        
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.DrawDisplay0();
        
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf("%s\n", dirMenuMap[ nowPosition ].FuncExplanation );     
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();

        
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
        
    }
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->Clear();
    Menu::m_SubWindow->Printf("\f");
    Menu::m_WindowManager.Update();
    Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();

        
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    
    Menu::m_WindowManager.DestroyWindow( &menuWindow );
    menuWindow.Destroy();
}
        
void FileViewer::DeleteDir( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry )
    
    
    if( !uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " DeleteDir OK? ", uji::sys::ShowMessage::SHM_OK_CANCEL ))
    {
        return;
    }
    
    nn::Result result;
    
    result = nn::fs::TryDeleteDirectoryRecursively( openPath );
    
    if( result.IsFailure())
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Delete Fail! ");
        return;
    }
    uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Delete Success! ");
    return;
}
    
    

void FileViewer::CopyToSDMC( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry );
    if( !std::memcmp( openPath, L"sdmc:", 10 ))
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " This File In SDMC! ");
        return;
    }
    
    nn::Result result;
    result = nn::fs::MountSdmc();
    if( result.IsFailure())
    {
        //nn::dbg::PrintResult( result );
        
        if( result <= nn::fs::ResultNotFound())
        {
            uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " SD Not Found! ");
            return;
        }else
        {
            uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Open SD Error! ");
            return;
        }
    }
    if( !nn::fs::IsSdmcWritable())
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " SD Write Protected! ");
        return;
    }
    
    uji::sys::InputTextWindow inputWindow( 30, 2, 12, Menu::m_WindowManager );
    Menu::m_WindowManager.CreateWindow( &inputWindow, NN_GX_DISPLAY0, 10, 10 );
    inputWindow.SetTitle("Set Copy Destination");
    inputWindow.Printf("Copy Folder = Copy2SD_");
    u32 folderNum = inputWindow.InputDecimal( 0 );
    Menu::m_WindowManager.DestroyWindow( &inputWindow );
    inputWindow.Destroy();
    wchar_t sdFileName[100] = L"";
    wchar_t sdFolderName[100] = L"";
    
    swprintf( sdFolderName, 100, L"sdmc:/copy2SD_%04d/", folderNum );
    
    result = nn::fs::TryCreateDirectory( sdFolderName );
    
    if( result.IsFailure())
    {
        //nn::dbg::PrintResult( result );
        if( result <= nn::fs::ResultAlreadyExists() )
        {

        }else
        {
            uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Copy Unknown Error! ");
            nn::fs::Unmount("sdmc:");
            return;
        }
    }
    
    std::wcscpy( sdFileName, sdFolderName );
    std::wcscat( sdFileName, dirEntry->entryName );
    result = nn::fs::TryCreateFile( sdFileName, 0 );
    if( result.IsFailure())
    {
        if( result <= nn::fs::ResultAlreadyExists() )
        {
            if( !uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " OverWrite OK? ", uji::sys::ShowMessage::SHM_OK_CANCEL ))
            {
                nn::fs::Unmount("sdmc:");
                return;
            }
        }else
        {
            uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Copy Unknown Error! ");
            nn::fs::Unmount("sdmc:");
            return;
        }
    }
    
    
    nn::fs::FileStream fsWrite;
    nn::fs::FileStream fsRead;
    result = fsWrite.TryInitialize( sdFileName, nn::fs::OPEN_MODE_WRITE );
    if( result.IsFailure())
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Write File Initialize Error! ");
        nn::fs::TryDeleteFile( sdFileName );
        nn::fs::Unmount("sdmc:");
        return;
    }
    
    result = fsRead.TryInitialize( openPath, nn::fs::OPEN_MODE_READ );
    if( result.IsFailure())
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Read File Initialize Error! ");
        nn::fs::TryDeleteFile( sdFileName );
        nn::fs::Unmount("sdmc:");
        return;
    }
    
    result = fsWrite.TrySetSize( fsRead.GetSize());
    if( result.IsFailure())
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Write File SetSize Error! ");
        nn::fs::TryDeleteFile( sdFileName );
        nn::fs::Unmount("sdmc:");
        return;
    }

    const u32 MAX_BUFFER_SIZE = 1000000;
    u8* copyBuffer = new u8[ MAX_BUFFER_SIZE ];
    if( copyBuffer == NULL )
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Copy Buffer Allocate Error! ");
        
        nn::fs::TryDeleteFile( sdFileName );
        nn::fs::Unmount("sdmc:");
        return;
    }
    while( s32 readSize = fsRead.Read( copyBuffer, MAX_BUFFER_SIZE ))
    {
        s32 writtenSize = 0;
        result = fsWrite.TryWrite( &writtenSize, copyBuffer, readSize );
        if( result.IsFailure() || writtenSize != readSize )
        {
            uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Copy Error! ");
            
            nn::fs::TryDeleteFile( sdFileName );
            
            delete[] copyBuffer;
            nn::fs::Unmount("sdmc:");
            return;
        }

    }
    
    delete[] copyBuffer;
    
    uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Copy Success! ");
    
    nn::fs::Unmount("sdmc:");
    
}

void FileViewer::DeleteFile( const wchar_t* openPath, const nn::fs::DirectoryEntry* dirEntry )
{
    NN_UNUSED_VAR( dirEntry );
    
    if( !uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Delete OK? ", uji::sys::ShowMessage::SHM_OK_CANCEL ))
    {
        return;
    }
    nn::Result result;
    
    result = nn::fs::TryDeleteFile( openPath );
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Delete Fail! ");
    }else
    {
        uji::sys::ShowMessage::Open( &Menu::m_WindowManager, " Delete Success! ");
    }
    
}

#pragma diag_default 546,181
    
    
#endif

} // namespace sec
} // namespace uji
