/************************************************************************
befj[
 ************************************************************************/
#include <nn.h>
#include <nn/cfg/CTR/cfg_ApiSys.h>
#include <nn/cfg/CTR/detail/cfg_DataStructures.h>
#include <nn/cfg/CTR/detail/cfg_Keys.h>
#include "sys.h"
#include "../seq/Config.h"
#include "../eva/procchk/ProcessCheck.h"
#include "sys_WriteSerialNumber.h"
#include "CfgMenu.h"
using namespace uji;
using namespace uji::sys;
using namespace nn::cfg::CTR::system;
using namespace nn::cfg::CTR::detail;

static uji::sys::InputTextWindow				*s_Window;

static void PreProcess(void);
static void PostProcess(void);
static void ShowSystemInformation(void);
static void ShowLcdFlicker(void);
static void ShowCamera(void);
static void ShowRtc(void);
static void ShowGyro(void);
static void ShowSlidePad(void);
static void ShowTouchPanel();
static void ShowAcc(void);
static void ShowCodec(void);
static void ShowMcu(void);
static void ShowUlcdDelay(void);
static void ShowBlPwm(void);
static void Show3DSurround(void);
static void ShowEchoCancel(void);
static void ShowDebugParam(void);
static void EulaSetting(void);
static void OtherSetting(void);
static void ResetSerial(void);

/************************************************************************
befj[
 ************************************************************************/
void uji::sec::cfg::CfgMenu(void)
{
    ClassMenu *m = new ClassMenu( "CFG MENU" );
	m->SetColumn(2);
    m->Add             ( "System Information", ShowSystemInformation );
    m->Add             ( "---", NULL );	//pfBO
    m->Add             ( "LcdFlicker", ShowLcdFlicker );
    m->Add             ( "Camera", ShowCamera );
    m->Add             ( "Rtc", ShowRtc );    
    m->Add             ( "Gyro", ShowGyro );
    m->Add             ( "SlidePad", ShowSlidePad );
    m->Add             ( "TouchPanel",ShowTouchPanel );
    m->Add             ( "Acc", ShowAcc );
    m->Add             ( "Codec", ShowCodec );
    m->Add             ( "MCU", ShowMcu );
    m->Add             ( "ULCD Delay", ShowUlcdDelay );
    m->Add             ( "BL PWM", ShowBlPwm );
    m->Add             ( "---", NULL );	//pfBO
    m->Add             ( "3D Surround", Show3DSurround );
    m->Add             ( "Echo Cancel", ShowEchoCancel );
    m->Add             ( "Debug Param", ShowDebugParam );
    m->Add             ( "EULA SETTING", EulaSetting );
    m->Add             ( "Other Setting", OtherSetting );
#ifdef EVA_START_MENU
    m->Add             ( "!!Reset Serial!!", ResetSerial, nw::ut::Color8::RED );
#endif
    m->Open();
    delete m;
}



/************************************************************************
ʑO
 ************************************************************************/
static void PreProcess(void)
{
	const int FONT_SIZE = 14;
    nn::cfg::CTR::Initialize();
    s_Window = new InputTextWindow( GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2), GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE, FONT_SIZE );
	s_Window->SetTitle( "CFG" );
	Menu::m_WindowManager.CreateWindow(s_Window, NN_GX_DISPLAY0,0,0 );    
}

/************************************************************************
{^҂
 ************************************************************************/
static void WaitAnyKey(void)
{
    uji::sys::Pad pad;

    //[X҂
    do
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        pad.UpdatePad();	
    } while (( pad.GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) != 0);		

    //҂
    do
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        pad.UpdatePad();	
    } while (( pad.GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) == 0);		

    //[X҂
    do
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        pad.UpdatePad();	
    } while (( pad.GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) != 0);		

}
/************************************************************************
ʌ㏈ƃ{^҂
 ************************************************************************/
static void PostProcess(void)
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

	Menu::m_WindowManager.Update();
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
	gfx->m_DrawFramework->Clear();        
	Menu::m_WindowManager.DrawDisplay0();
	gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

	Menu::m_WindowManager.Update();
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
	gfx->m_DrawFramework->Clear();        
	Menu::m_WindowManager.DrawDisplay0();
	gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

	WaitAnyKey();

	Menu::m_WindowManager.DestroyWindow(s_Window );    
	delete s_Window;	

    nn::cfg::CTR::Finalize();

}


/************************************************************************
VXe\
 ************************************************************************/
static void ShowSystemInformation(void)
{
    uji::seq::TestResult testResult;
    u8 serialNumber[CFG_SECURE_INFO_SERIAL_NO_LEN];

    //L`FbN
    uji::eva::procchk::Invoke_ValidateSign( testResult );

	PreProcess();

    //VAio[
    s_Window->Printf("\f<SYSTEM INFORMATION>\n");
    s_Window->Printf( "SerialNumber=" );
    if( GetSerialNo( serialNumber ).IsSuccess() )
    {
        s_Window->Printf( "%.15s\n", serialNumber );
    }else{
    	s_Window->Printf( "FAIL\n" );
    }

    //[W
    nn::cfg::CTR::CfgRegionCode cfgRegionCode;
    s_Window->Printf( "Region=" );
    if( GetRegion( &cfgRegionCode).IsSuccess() )
    {
        s_Window->Printf( "%d\n", (int)cfgRegionCode );
    }else{
    	s_Window->Printf( "FAIL\n" );
    }
    
    //`FbN
    s_Window->Printf( "\nVALIDATE SIGN: [%s]\n", testResult.m_Result?"OK":"NG" );

	PostProcess();
}

/************************************************************************
ekhbjdq\
 ************************************************************************/
static void ShowLcdFlicker(void)
{
	PreProcess();

    LcdFlickerCfgData lcdFlickerCfgData;
    GetConfig( &lcdFlickerCfgData, sizeof(LcdFlickerCfgData), GET_CFG_KEY( NN_CFG_LCD, NN_CFG_LCD_CAL_FLICKER ) );

	s_Window->Printf("\f<FLICKER>\n");
	s_Window->Printf( "vcomTop   =%d\n", lcdFlickerCfgData.vcomTop );
	s_Window->Printf( "vcomBottom=%d\n", lcdFlickerCfgData.vcomBottom );

	PostProcess();
}
/************************************************************************
JLu[Vl\
 ************************************************************************/
static void ShowCamera(void)
{
	PreProcess();

    
    CameraCfgData cameraCfgData;
    GetConfig( &cameraCfgData, sizeof(CameraCfgData), GET_CFG_KEY( NN_CFG_CAMERA, NN_CFG_CAMERA_CAL ) );


	s_Window->Printf("\f<CAMERA POSITON>\n");
    s_Window->Printf( "flags            =%s\n",cameraCfgData.position.flags.isValidRotationXY?"true":"false" );
	s_Window->Printf( "scale            =%f\n",cameraCfgData.position.scale );
	s_Window->Printf( "rotationZ        =%f\n",cameraCfgData.position.rotationZ );
	s_Window->Printf( "translationX	    =%f\n",cameraCfgData.position.translationX );
	s_Window->Printf( "translationY	    =%f\n",cameraCfgData.position.translationY );
	s_Window->Printf( "rotationX        =%f\n",cameraCfgData.position.rotationX );
	s_Window->Printf( "rotationY        =%f\n",cameraCfgData.position.rotationY );
	s_Window->Printf( "angleOfViewRight =%f\n",cameraCfgData.position.angleOfViewRight );
	s_Window->Printf( "angleOfViewLeft  =%f\n",cameraCfgData.position.angleOfViewLeft );
	s_Window->Printf( "distanceToChart  =%f\n",cameraCfgData.position.distanceToChart );
	s_Window->Printf( "distanceCameras  =%f\n",cameraCfgData.position.distanceCameras );
	s_Window->Printf( "imageWidth       =%d\n",cameraCfgData.position.imageWidth );
	s_Window->Printf( "imageHeight      =%d\n",cameraCfgData.position.imageHeight );

    PostProcess();

    PreProcess();

	s_Window->Printf("\f<CAMERA QUALITY>\n");
	s_Window->Printf( "aeBaseTarget     =%d\n",cameraCfgData.quality.aeBaseTarget );
	s_Window->Printf( "kRL              =%d\n",cameraCfgData.quality.kRL );
	s_Window->Printf( "kGL              =%d\n",cameraCfgData.quality.kGL );
	s_Window->Printf( "kBL              =%d\n",cameraCfgData.quality.kBL );
	s_Window->Printf( "ccmPosition      =%d\n",cameraCfgData.quality.ccmPosition );
	s_Window->Printf( "awbCcmL9Right    =%d\n",cameraCfgData.quality.awbCcmL9Right );
	s_Window->Printf( "awbCcmL9Left     =%d\n",cameraCfgData.quality.awbCcmL9Left  );
	s_Window->Printf( "awbCcmL10Right   =%d\n",cameraCfgData.quality.awbCcmL10Right );
	s_Window->Printf( "awbCcmL10Left    =%d\n",cameraCfgData.quality.awbCcmL10Left  );
	s_Window->Printf( "awbX0Right       =%d\n",cameraCfgData.quality.awbX0Right );
	s_Window->Printf( "awbX0Left        =%d\n",cameraCfgData.quality.awbX0Left  );


	PostProcess();
}

/************************************************************************
RTC␳l\
 ************************************************************************/
static void ShowRtc(void)
{
	PreProcess();

    RtcCfgData rtcCfgData;
    GetConfig( &rtcCfgData, sizeof(RtcCfgData), GET_CFG_KEY( NN_CFG_RTC, NN_CFG_RTC_CAL_COMPENSATION ) );

	s_Window->Printf("\f<RTC>\n");
	s_Window->Printf( "RTCCompensationValue =%02Xh\n", rtcCfgData.RTCCompensationValue );

	PostProcess();
}

/************************************************************************
WCLu[Vl\
 ************************************************************************/
static void ShowGyro(void)
{
	PreProcess();

    GyroscopeCfgData gyroscopeCfgData;
    GetConfig( &gyroscopeCfgData, sizeof(GyroscopeCfgData), GET_CFG_KEY( NN_CFG_HID, NN_CFG_HID_CAL_GYROSCOPE ) );

	s_Window->Printf("\f<GYRO>\n");
	s_Window->Printf( "X_RPM_0        =%+-d\n",   gyroscopeCfgData.x.raw_rpm_0);
	s_Window->Printf( "X_RPM_POSITIVE =%+-d\n",   gyroscopeCfgData.x.raw_rpm_positive_78);
	s_Window->Printf( "X_RPM_NEGATIVE =%+-d\n",   gyroscopeCfgData.x.raw_rpm_negative_78);
	s_Window->Printf( "Y_RPM_0        =%+-d\n",   gyroscopeCfgData.y.raw_rpm_0);
	s_Window->Printf( "Y_RPM_POSITIVE =%+-d\n",   gyroscopeCfgData.y.raw_rpm_positive_78);
	s_Window->Printf( "Y_RPM_NEGATIVE =%+-d\n",   gyroscopeCfgData.y.raw_rpm_negative_78);
	s_Window->Printf( "Z_RPM_0        =%+-d\n",   gyroscopeCfgData.z.raw_rpm_0);
	s_Window->Printf( "Z_RPM_POSITIVE =%+-d\n",   gyroscopeCfgData.z.raw_rpm_positive_78);
	s_Window->Printf( "Z_RPM_NEGATIVE =%+-d\n",   gyroscopeCfgData.z.raw_rpm_negative_78);

	PostProcess();
}

/************************************************************************
XChpbh Lu[Vl\
 ************************************************************************/
static void ShowSlidePad(void)
{
	PreProcess();

    AnalogStickCfgData analogStickCfgData;
    GetConfig( &analogStickCfgData, sizeof(AnalogStickCfgData), GET_CFG_KEY( NN_CFG_HID, NN_CFG_HID_CAL_ANALOGSTICK ) );

	s_Window->Printf("\f<SLIDE PAD>\n");
	s_Window->Printf( "center_x = %d\n", analogStickCfgData.center_x );
	s_Window->Printf( "center_y = %d\n", analogStickCfgData.center_y );
	s_Window->Printf( "\n" );
	s_Window->Printf( "scale_x  = %f\n", analogStickCfgData.scale_x );
	s_Window->Printf( "scale_y  = %f\n", analogStickCfgData.scale_y );
	s_Window->Printf( "max_x    = %d\n", analogStickCfgData.max_x );
	s_Window->Printf( "min_x    = %d\n", analogStickCfgData.min_x );
	s_Window->Printf( "max_y    = %d\n", analogStickCfgData.max_y );
	s_Window->Printf( "min_y    = %d\n", analogStickCfgData.min_y );
	s_Window->Printf( "type     = %d\n", analogStickCfgData.type );
    
	PostProcess();
}

/************************************************************************
^b`pl Lu[Vl\
 ************************************************************************/
static void ShowTouchPanel()
{
    PreProcess();

    TouchPanelCfgData touchPanelCfgData;
    GetConfig( &touchPanelCfgData, sizeof(TouchPanelCfgData), GET_CFG_KEY( NN_CFG_HID, NN_CFG_HID_CAL_TOUCHPANEL ) );
    
    s_Window->Printf("\f<TOUCH PANEL>\n");
    s_Window->Printf( "Point0 raw_x = %d\n", touchPanelCfgData.point0.raw_x );
    s_Window->Printf( "Point0 raw_y = %d\n", touchPanelCfgData.point0.raw_y );
    s_Window->Printf( "Point0 dx    = %d\n", touchPanelCfgData.point0.dx    );
    s_Window->Printf( "Point0 dy    = %d\n", touchPanelCfgData.point0.dy    );
    s_Window->Printf( "\n" );
    s_Window->Printf( "Point1 raw_x = %d\n", touchPanelCfgData.point1.raw_x );
    s_Window->Printf( "Point1 raw_y = %d\n", touchPanelCfgData.point1.raw_y );
    s_Window->Printf( "Point1 dx    = %d\n", touchPanelCfgData.point1.dx    );
    s_Window->Printf( "Point1 dy    = %d\n", touchPanelCfgData.point1.dy    );

    PostProcess();
}

/************************************************************************
xv␳l\
 ************************************************************************/
static void ShowAcc(void)
{
	PreProcess();

    AccelCfgData accelCfgData;
    GetConfig( &accelCfgData, sizeof(AccelCfgData), GET_CFG_KEY( NN_CFG_HID, NN_CFG_HID_CAL_ACCELEROMETER ) );

	s_Window->Printf("\f<ACC>\n");
	s_Window->Printf( "X_OFFSET =%d\n", accelCfgData.x.offset);
	s_Window->Printf( "X_SCALE  =%d\n", accelCfgData.x.scale);
	s_Window->Printf( "Y_OFFSET =%d\n", accelCfgData.y.offset);
	s_Window->Printf( "Y_SCALE  =%d\n", accelCfgData.y.scale);
	s_Window->Printf( "Z_OFFSET =%d\n", accelCfgData.z.offset);
	s_Window->Printf( "Z_SCALE  =%d\n", accelCfgData.z.scale);

	PostProcess();
}

/************************************************************************
R[fbN␳l\
 ************************************************************************/
static void ShowCodec(void)
{
	PreProcess();

    CodecCfgData codecCfgData;
    GetConfig( &codecCfgData, sizeof(CodecCfgData), GET_CFG_KEY( NN_CFG_CODEC, NN_CFG_CODEC_CAL ) );

	s_Window->Printf("\f<CODEC>\n");
	s_Window->Printf( "PGA_GAIN =%d\n", codecCfgData.micGainCalibrateParam);
	s_Window->Printf( "interval =%d\n", codecCfgData.AnalogInterfaceParam.interval);
	s_Window->Printf( "xpPullUpRegister=%d\n", codecCfgData.AnalogInterfaceParam.xpPullUpRegister);


	PostProcess();
}

/************************************************************************
lbtiXCh{[j\
 ************************************************************************/
static void ShowMcu(void)
{
	PreProcess();

    McuSlideVolumeRangeCfgData mcuSlideVolumeRangeCfgData;
    GetConfig( &mcuSlideVolumeRangeCfgData, sizeof(mcuSlideVolumeRangeCfgData), GET_CFG_KEY( NN_CFG_MCU, NN_CFG_MCU_SLIDE_VOLUME ) );

	s_Window->Printf("\f<MCU>\n");
	s_Window->Printf( "SVR2 MIN  =%d\n", mcuSlideVolumeRangeCfgData.svr2.min );
	s_Window->Printf( "SVR2 MAX  =%d\n", mcuSlideVolumeRangeCfgData.svr2.max );
	s_Window->Printf( "SOUND MIN =%d\n", mcuSlideVolumeRangeCfgData.sound.min );
	s_Window->Printf( "SOUND MAX =%d\n", mcuSlideVolumeRangeCfgData.sound.max );

	PostProcess();
}

/************************************************************************
tkbc@cdk`x\
 ************************************************************************/
static void ShowUlcdDelay(void)
{
	PreProcess();

    UlcdDelayCfgData ulcdDelayCfgData;
    GetConfig( &ulcdDelayCfgData, sizeof(UlcdDelayCfgData), GET_CFG_KEY( NN_CFG_LCD, NN_CFG_LCD_ULCD_DELAY ) );

    s_Window->Printf("\f<ULCD DELAY>\n");
	s_Window->Printf( "to2D =%d\n", (int)ulcdDelayCfgData.to2D );
	s_Window->Printf( "to3D =%d\n", (int)ulcdDelayCfgData.to3D );

	PostProcess();
}

/************************************************************************
akQovl\
 ************************************************************************/
static void ShowBlPwm(void)
{
	PreProcess();

    BacklightPwmTableCfgData backlightPwmTableCfgData;
    GetConfig( &backlightPwmTableCfgData, sizeof(BacklightPwmTableCfgData), GET_CFG_KEY( NN_CFG_LCD, NN_CFG_LCD_BACKLIGHT_PWM_TABLE ) );


	s_Window->Printf("\f<BL PWM>\n");
	for( int i=0 ; i<7 ; i++ )
	{
		s_Window->Printf( "luminanceLevel[%d]=%d\n", i, (int)backlightPwmTableCfgData.luminanceLevel[i] );
	}
	PostProcess();
}

/************************************************************************
RcTEhp[^\
 ************************************************************************/
static void Show3DSurround(void)
{
    SurroundCfgData  surroundCfgData;
    GetConfig( &surroundCfgData, sizeof(SurroundCfgData), GET_CFG_KEY(NN_CFG_SOUND, NN_CFG_SOUND_SURROUND_CAL) );

	for( int j=0 ; j<8 ; j++ )
	{
		PreProcess();
		s_Window->Printf("\f<3D Surround> %d/8\n", j+1);
		s_Window->Printf("specialFilter:\n   ");
		for( int i=32*j ; i<32*(j+1) ; i++ )
		{
			s_Window->Printf( " 0x%04X", surroundCfgData.specialFilter[i] & 0xFFFF );
			s_Window->Printf( (i+1)%4==0 ? "\n   " : "," );
		}
		PostProcess();
	}
	PreProcess();
	s_Window->Printf("\f<3D Surround>\n");
	for( int i=0 ; i<5 ; i++ )
	{
		s_Window->Printf( "iirFilter[%d] = 0x%08X\n", i, surroundCfgData.iirFilter[i] );
	}
	PostProcess();
}

/************************************************************************
GR[LZ\
 ************************************************************************/
static void ShowEchoCancel(void)
{
	PreProcess();

    EchoCancelCfgData echoCancelCfgData;
    GetConfig( &echoCancelCfgData, sizeof(EchoCancelCfgData), GET_CFG_KEY(NN_CFG_SOUND, NN_CFG_SOUND_ECHO_CANCEL) );


	s_Window->Printf("\f<ECHO CANCEL>\n");
	s_Window->Printf( "0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n", 
	    echoCancelCfgData.rsv[0], echoCancelCfgData.rsv[1], echoCancelCfgData.rsv[2], echoCancelCfgData.rsv[3],
	    echoCancelCfgData.rsv[4], echoCancelCfgData.rsv[5], echoCancelCfgData.rsv[6], echoCancelCfgData.rsv[7] );
	PostProcess();
}

/************************************************************************
DEBUG PARAMETER\
 ************************************************************************/
static void ShowDebugParam(void)
{
	PreProcess();

    DebugParamCfgData debugParam;
    GetConfig( &debugParam, sizeof(DebugParamCfgData), GET_CFG_KEY( NN_CFG_DBG, NN_CFG_DBG_PARAM ) );

	s_Window->Printf("\f<DEBUG PARAM>\n");
	s_Window->Printf( "param1.general =%s\n", (debugParam.param1.general ? "true" : "false") );

	PostProcess();
}

/************************************************************************
Eula Setting\
 ************************************************************************/
static void EulaSetting(void)
{
	PreProcess();
	
    using namespace nn::cfg::CTR::detail;

    EulaInfoCfgData eulaInfoCfgData;
    size_t          size = sizeof(EulaInfoCfgData);
    bit32           key  = GET_CFG_KEY(NN_CFG_EULA, NN_CFG_EULA_INFO);
    
    // ̐ݒ擾AݒύXAύX̐ݒ𔽉f
    GetConfig( &eulaInfoCfgData, size, key );
    
	s_Window->Printf("\f<EULA SETTING>\n");
	s_Window->Printf( "EulaInfoCfgData\n" );
	s_Window->Printf( "  Agree Version :%02x.%02x(0x%04x)\n", 
	    eulaInfoCfgData.agreeVersion.detailed.majorVersion, 
	    eulaInfoCfgData.agreeVersion.detailed.minorVersion, 
	    eulaInfoCfgData.agreeVersion.version );
	s_Window->Printf( "  Latest Version:%02x.%02x(0x%04x)\n", 
	    eulaInfoCfgData.latestVersion.detailed.majorVersion, 
	    eulaInfoCfgData.latestVersion.detailed.minorVersion, 
	    eulaInfoCfgData.latestVersion.version );

	PostProcess();
}

/************************************************************************
Other Setting\
 ************************************************************************/
static void OtherSetting(void)
{
	PreProcess();
	
    using namespace nn::cfg::CTR::detail;

    //
    // FirstLaunchInfoCfgData
    //
    FirstLaunchInfoCfgData firstLaunchInfoCfgData;
    size_t          size = sizeof(FirstLaunchInfoCfgData);
    bit32           key  = GET_CFG_KEY(NN_CFG_MENU, NN_CFG_MENU_FIRST_LAUNCH);
    
    // ̐ݒ擾AݒύXAύX̐ݒ𔽉f
    GetConfig( &firstLaunchInfoCfgData, size, key );
    
    
    //
    // MenuInfoCfgData
    //
    MenuInfoCfgData menuInfoCfgData;
    size = sizeof(MenuInfoCfgData);
    key  = GET_CFG_KEY(NN_CFG_MENU, NN_CFG_MENU_MENU_INFO);
    
    GetConfig( &menuInfoCfgData, size, key );
    
    
	s_Window->Printf("\f<Other Setting>\n");
	s_Window->Printf( "FirstLaunchInfoCfgData\n" );
	s_Window->Printf( "  mmen        :0x%04x\n", firstLaunchInfoCfgData.mmen );
	s_Window->Printf( "  internet    :0x%02x\n", firstLaunchInfoCfgData.internet );
	s_Window->Printf( "  rsv         :0x%02x\n", firstLaunchInfoCfgData.rsv );
	s_Window->Printf( "MenuInfoCfgData\n" );
	s_Window->Printf( "  programId   :0x%016llx\n", menuInfoCfgData.programId );

	PostProcess();
}

/************************************************************************
 VA񏉊
 ************************************************************************/
static void ResetSerial(void)
{
    uji::sys::Pad pad;
	pad.UpdatePad();

	if( pad.IsButtonPress( Pad::BUTTON_R ) )
	{
		char *message;
		char resetSerial[CFG_SECURE_INFO_SERIAL_NO_LEN];
		
		std::memset( resetSerial, 0x00, sizeof( resetSerial ));

		if( uji::sys::WriteSerialNumber( resetSerial ))
		{
			message = "Success to Reset.";
		}else{
			message = "Fail to Reset.";
		}
		uji::sys::ShowMessage::Open( &Menu::m_WindowManager, message );		
	}

}
