/************************************************************************
b`kj[
 ************************************************************************/
#include <nn.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "sys.h"
#include "../seq/Config.h"
#include "CalSuite.h"
#include "CalMenu.h"
using namespace uji;
using namespace uji::sys;
using namespace nn::drivers::cal::CTR;

static uji::sys::InputTextWindow				*s_Window;

static void PreProcess(void);
static void PostProcess(void);
static void ShowVersion(void);
static void ShowAdjusted(void);
static void ShowLcdFlicker(void);
static void ShowCamera(void);
static void ShowRtc(void);
static void ShowGyro(void);
static void ShowSlidePad(void);
static void ShowTouchPanel();
static void ShowAcc(void);
static void ShowCodec(void);
static void ShowMcu(void);
static void ShowUlcdDelay(void);
static void ShowBlPwm(void);
static void ShowModel(void);
static void Show3DSurround(void);
static void ShowEchoCancel(void);
static void Save(void);
static void Load(void);
static bool SaveBody(void);
static bool LoadBody(void);
static void Initialize(void);
static void EditRtcCal(void);
static void MarkCalAdjusted(void);

/************************************************************************
b`kj[
 ************************************************************************/
void uji::sec::cal::CalMenu(void)
{
    ClassMenu *m = new ClassMenu( "CAL MENU" );
	m->SetColumn(2);
    m->Add             ( "Show Version", ShowVersion );
    m->Add             ( "Show Adjusted", ShowAdjusted );
    m->Add             ( "LcdFlicker", ShowLcdFlicker );
    m->Add             ( "Camera", ShowCamera );
    m->Add             ( "Rtc", ShowRtc );    
    m->Add             ( "Gyro", ShowGyro );
    m->Add             ( "SlidePad", ShowSlidePad );
    m->Add             ( "TouchPanel",ShowTouchPanel );
    m->Add             ( "Acc", ShowAcc );
    m->Add             ( "Codec", ShowCodec );
    m->Add             ( "MCU", ShowMcu );
    m->Add             ( "ULCD Delay", ShowUlcdDelay );
    m->Add             ( "BL PWM", ShowBlPwm );
    m->Add             ( "Show Model", ShowModel );
    m->Add             ( "3D Surround", Show3DSurround );
    m->Add             ( "Echo Cancel", ShowEchoCancel );
#ifdef EVA_START_MENU
    m->Add             ( "!!Save to SD!!", Save, nw::ut::Color8::RED );
    m->Add             ( "!!Load from SD!!", Load, nw::ut::Color8::RED );
	m->Add             ( "!!Initialize!!", Initialize, nw::ut::Color8::RED );
	m->Add             ( "!!Edit RTC CAL!!", EditRtcCal, nw::ut::Color8::RED );
	m->Add             ( "!!Mark CAL Adjusted!!", MarkCalAdjusted, nw::ut::Color8::RED );
#endif
	m->Open();
    delete m;
}



/************************************************************************
ʑO
 ************************************************************************/
static void PreProcess(void)
{
	const int FONT_SIZE = 14;
	s_Window = new InputTextWindow( GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2), GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE, FONT_SIZE );
	s_Window->SetTitle( "CALIBRATION" );
	Menu::m_WindowManager.CreateWindow(s_Window, NN_GX_DISPLAY0,0,0 );    
}

/************************************************************************
{^҂
 ************************************************************************/
static void WaitAnyKey(void)
{
    uji::sys::Pad pad;

    //[X҂
    do
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        pad.UpdatePad();	
    } while (( pad.GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) != 0);		

    //҂
    do
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        pad.UpdatePad();	
    } while (( pad.GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) == 0);		

    //[X҂
    do
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        pad.UpdatePad();	
    } while (( pad.GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) != 0);		

}
/************************************************************************
ʌ㏈ƃ{^҂
 ************************************************************************/
static void PostProcess(void)
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

	Menu::m_WindowManager.Update();
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
	gfx->m_DrawFramework->Clear();        
	Menu::m_WindowManager.DrawDisplay0();
	gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

	Menu::m_WindowManager.Update();
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
	gfx->m_DrawFramework->Clear();        
	Menu::m_WindowManager.DrawDisplay0();
	gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

	WaitAnyKey();

	Menu::m_WindowManager.DestroyWindow(s_Window );    
	delete s_Window;	
}


/************************************************************************
o[W\
 ************************************************************************/
static void ShowVersion(void)
{
	PreProcess();

	Calibration cal;
	cal.Initialize();

	s_Window->Printf("\f");
	s_Window->Printf("CAL VERSION=%d", cal.GetVersion() );

	PostProcess();
}

/************************************************************************
ςݕ\
 ************************************************************************/
static void ShowAdjusted(void)
{
	PreProcess();

	Calibration cal;
	cal.Initialize();

	s_Window->Printf("\f");
	s_Window->Printf("FCRAM         %c  ", cal.IsAdjusted(CAL_DATA_FCRAM)?'O':'X' );
	s_Window->Printf("LCD FLICKER   %c\n", cal.IsAdjusted(CAL_DATA_LCD_FLICKER)?'O':'X' );
	s_Window->Printf("CAMERA        %c  ", cal.IsAdjusted(CAL_DATA_CAMERA)?'O':'X' );
	s_Window->Printf("TOUCH PANEL   %c\n", cal.IsAdjusted(CAL_DATA_TOUCH_PANEL)?'O':'X' );
	s_Window->Printf("ANALOG STICK  %c  ", cal.IsAdjusted(CAL_DATA_ANALOG_STICK)?'O':'X' );
	s_Window->Printf("CODEC         %c\n", cal.IsAdjusted(CAL_DATA_CODEC)?'O':'X' );
	s_Window->Printf("GYRO SCOPE    %c  ", cal.IsAdjusted(CAL_DATA_GYRO_SCOPE)?'O':'X' );
	s_Window->Printf("RTC           %c\n", cal.IsAdjusted(CAL_DATA_RTC)?'O':'X' );
	s_Window->Printf("ACCEL         %c  ", cal.IsAdjusted(CAL_DATA_ACCEL)?'O':'X' );
	s_Window->Printf("SURROUND      %c\n", cal.IsAdjusted(CAL_DATA_SURROUND)?'O':'X' );
	s_Window->Printf("ABL           %c  ", cal.IsAdjusted(CAL_DATA_ABL)?'O':'X' );
	s_Window->Printf("ULCD          %c\n", cal.IsAdjusted(CAL_DATA_ULCD)?'O':'X' );
	s_Window->Printf("BL_PWM        %c  ", cal.IsAdjusted(CAL_DATA_BL_PWM)?'O':'X' );
	s_Window->Printf("ANALOG STICKA %c\n", cal.IsAdjusted(CAL_DATA_ANALOG_STICK_APPEND)?'O':'X' );
	s_Window->Printf("CAMERA APPEND %c  ", cal.IsAdjusted(CAL_DATA_CAMERA_APPEND)?'O':'X' );
	s_Window->Printf("ABL LGY       %c\n", cal.IsAdjusted(CAL_DATA_ABL_LGY)?'O':'X' );
	s_Window->Printf("MCU           %c  ", cal.IsAdjusted(CAL_DATA_MCU)?'O':'X' );
	s_Window->Printf("ULCD DELAY    %c\n", cal.IsAdjusted(CAL_DATA_ULCD_DELAY)?'O':'X' );
	s_Window->Printf("ECHO CANCEL   %c\n", cal.IsAdjusted(CAL_DATA_ECHO_CANCEL)?'O':'X' );
	PostProcess();
}

/************************************************************************
ekhbjdq\
 ************************************************************************/
static void ShowLcdFlicker(void)
{
	PreProcess();

	Calibration cal;
	LcdFlickerInfo lcdFlickerInfo;

	cal.Initialize();
    cal.Get(&lcdFlickerInfo, CAL_DATA_LCD_FLICKER);

	s_Window->Printf("\f<FLICKER>\n");
	s_Window->Printf( "vcomTop   =%d\n", lcdFlickerInfo.vcomTop );
	s_Window->Printf( "vcomBottom=%d\n", lcdFlickerInfo.vcomBottom );

	PostProcess();
}

/************************************************************************
JLu[Vl\
 ************************************************************************/
static void ShowCamera(void)
{
	PreProcess();

	Calibration cal;
	CameraCalDataCore cameraCalData;
	CameraCalAppendCore cameraCalAppend;

	cal.Initialize();
    cal.Get(&cameraCalData, CAL_DATA_CAMERA);
    cal.Get(&cameraCalAppend, CAL_DATA_CAMERA_APPEND);

	s_Window->Printf("\f<CAMERA POSITON>\n");
	s_Window->Printf( "flags            =%d\n",cameraCalData.position.flags );
	s_Window->Printf( "scale            =%f\n",cameraCalData.position.scale );
	s_Window->Printf( "rotationZ        =%f\n",cameraCalData.position.rotationZ );
	s_Window->Printf( "translationX	    =%f\n",cameraCalData.position.translationX );
	s_Window->Printf( "translationY	    =%f\n",cameraCalData.position.translationY );
	s_Window->Printf( "rotationX        =%f\n",cameraCalData.position.rotationX );
	s_Window->Printf( "rotationY        =%f\n",cameraCalData.position.rotationY );
	s_Window->Printf( "angleOfViewRight =%f\n",cameraCalData.position.angleOfViewRight );
	s_Window->Printf( "angleOfViewLeft  =%f\n",cameraCalData.position.angleOfViewLeft );
	s_Window->Printf( "distanceToChart  =%f\n",cameraCalData.position.distanceToChart );
	s_Window->Printf( "distanceCameras  =%f\n",cameraCalData.position.distanceCameras );
	s_Window->Printf( "imageWidth       =%d\n",cameraCalData.position.imageWidth );
	s_Window->Printf( "imageHeight      =%d\n",cameraCalData.position.imageHeight );
	s_Window->Printf( "reserved=[%04X][%04X][%04X][%04X]\n",
											   cameraCalData.position.reserved[0],
											   cameraCalData.position.reserved[1],
											   cameraCalData.position.reserved[2],
											   cameraCalData.position.reserved[3]);

	PostProcess();
	PreProcess();

	s_Window->Printf("\f<CAMERA QUALITY>\n");
	s_Window->Printf( "aeBaseTarget     =%d\n",cameraCalData.quality.aeBaseTarget );
	s_Window->Printf( "kRL              =%d\n",cameraCalData.quality.kRL );
	s_Window->Printf( "kGL              =%d\n",cameraCalData.quality.kGL );
	s_Window->Printf( "kBL              =%d\n",cameraCalData.quality.kBL );
	s_Window->Printf( "ccmPosition      =%d\n",cameraCalData.quality.ccmPosition );

	s_Window->Printf("\n<CAMERA APPEND>\n");
	s_Window->Printf( "awbCcmL9Right    =%d\n",cameraCalAppend.awbCcmL9Right );
	s_Window->Printf( "awbCcmL9Left     =%d\n",cameraCalAppend.awbCcmL9Left  );
	s_Window->Printf( "awbCcmL10Right   =%d\n",cameraCalAppend.awbCcmL10Right );
	s_Window->Printf( "awbCcmL10Left    =%d\n",cameraCalAppend.awbCcmL10Left  );
	s_Window->Printf( "awbX0Right       =%d\n",cameraCalAppend.awbX0Right );
	s_Window->Printf( "awbX0Left        =%d\n",cameraCalAppend.awbX0Left  );


	PostProcess();
}

/************************************************************************
RTC␳l\
 ************************************************************************/
static void ShowRtc(void)
{
	PreProcess();

	Calibration cal;
	RtcCompensation rtcCompensation;

	cal.Initialize();
    cal.Get(&rtcCompensation, CAL_DATA_RTC);

	s_Window->Printf("\f<RTC>\n");
	s_Window->Printf( "RTCCompensationValue =%02Xh\n", rtcCompensation.RTCCompensationValue );

	PostProcess();
}

/************************************************************************
WCLu[Vl\
 ************************************************************************/
static void ShowGyro(void)
{
	PreProcess();

	Calibration cal;
	GyroscopeCalDataCore gyroCalDataCore;

	cal.Initialize();
    cal.Get(&gyroCalDataCore, CAL_DATA_GYRO_SCOPE);

	s_Window->Printf("\f<GYRO>\n");
	s_Window->Printf( "X_RPM_0        =%+-d\n",   gyroCalDataCore.x.raw_rpm_0);
	s_Window->Printf( "X_RPM_POSITIVE =%+-d\n",   gyroCalDataCore.x.raw_rpm_positive_78);
	s_Window->Printf( "X_RPM_NEGATIVE =%+-d\n",   gyroCalDataCore.x.raw_rpm_negative_78);
	s_Window->Printf( "Y_RPM_0        =%+-d\n",   gyroCalDataCore.y.raw_rpm_0);
	s_Window->Printf( "Y_RPM_POSITIVE =%+-d\n",   gyroCalDataCore.y.raw_rpm_positive_78);
	s_Window->Printf( "Y_RPM_NEGATIVE =%+-d\n",   gyroCalDataCore.y.raw_rpm_negative_78);
	s_Window->Printf( "Z_RPM_0        =%+-d\n",   gyroCalDataCore.z.raw_rpm_0);
	s_Window->Printf( "Z_RPM_POSITIVE =%+-d\n",   gyroCalDataCore.z.raw_rpm_positive_78);
	s_Window->Printf( "Z_RPM_NEGATIVE =%+-d\n",   gyroCalDataCore.z.raw_rpm_negative_78);

	PostProcess();
}

/************************************************************************
XChpbh Lu[Vl\
 ************************************************************************/
static void ShowSlidePad(void)
{
	PreProcess();

	Calibration cal;
    AnalogStickCalDataCore   calDataCore;
    AnalogStickCalAppendCore calAppendCore;

	cal.Initialize();
    cal.Get(&calDataCore, 	CAL_DATA_ANALOG_STICK);
    cal.Get(&calAppendCore, CAL_DATA_ANALOG_STICK_APPEND);

	s_Window->Printf("\f<SLIDE PAD>\n");
	s_Window->Printf( "center_x = %d\n", calDataCore.center_x );
	s_Window->Printf( "center_y = %d\n", calDataCore.center_y );
#if NN_VERSION_REVISION==22048
	s_Window->Printf( "in       = %d\n", calDataCore.in );
	s_Window->Printf( "out      = %d\n", calDataCore.out );
#endif
	s_Window->Printf( "\n" );
	s_Window->Printf( "scale_x  = %f\n", calAppendCore.scale_x );
	s_Window->Printf( "scale_y  = %f\n", calAppendCore.scale_y );
	s_Window->Printf( "max_x    = %d\n", calAppendCore.max_x );
	s_Window->Printf( "min_x    = %d\n", calAppendCore.min_x );
	s_Window->Printf( "max_y    = %d\n", calAppendCore.max_y );
	s_Window->Printf( "min_y    = %d\n", calAppendCore.min_y );
	s_Window->Printf( "type     = %d\n", calAppendCore.type );
    
	PostProcess();
}

/************************************************************************
^b`pl Lu[Vl\
 ************************************************************************/
static void ShowTouchPanel()
{
    PreProcess();
    Calibration cal;
    TouchPanelCalDataCore calDataTp;
    
    cal.Initialize();
    cal.Get( &calDataTp, CAL_DATA_TOUCH_PANEL );
    
    s_Window->Printf("\f<TOUCH PANEL>\n");
    s_Window->Printf( "Point0 raw_x = %d\n", calDataTp.point0.raw_x );
    s_Window->Printf( "Point0 raw_y = %d\n", calDataTp.point0.raw_y );
    s_Window->Printf( "Point0 dx    = %d\n", calDataTp.point0.dx    );
    s_Window->Printf( "Point0 dy    = %d\n", calDataTp.point0.dy    );
    s_Window->Printf( "\n" );
    s_Window->Printf( "Point1 raw_x = %d\n", calDataTp.point1.raw_x );
    s_Window->Printf( "Point1 raw_y = %d\n", calDataTp.point1.raw_y );
    s_Window->Printf( "Point1 dx    = %d\n", calDataTp.point1.dx    );
    s_Window->Printf( "Point1 dy    = %d\n", calDataTp.point1.dy    );

    PostProcess();
}

/************************************************************************
xv␳l\
 ************************************************************************/
static void ShowAcc(void)
{
	PreProcess();

	Calibration cal;
	AccelCalDataCore accCalCore;

	cal.Initialize();
    cal.Get(&accCalCore, CAL_DATA_ACCEL);

	s_Window->Printf("\f<ACC>\n");
	s_Window->Printf( "X_OFFSET =%d\n",   accCalCore.x.offset);
	s_Window->Printf( "X_SCALE  =%d\n",   accCalCore.x.scale);
	s_Window->Printf( "Y_OFFSET =%d\n",   accCalCore.y.offset);
	s_Window->Printf( "Y_SCALE  =%d\n",   accCalCore.y.scale);
	s_Window->Printf( "Z_OFFSET =%d\n",   accCalCore.z.offset);
	s_Window->Printf( "Z_SCALE  =%d\n",   accCalCore.z.scale);

	PostProcess();
}

/************************************************************************
R[fbN␳l\
 ************************************************************************/
static void ShowCodec(void)
{
	PreProcess();

	Calibration cal;
    CodecCalDataCore codecCalDataCore;

	cal.Initialize();
    cal.Get(&codecCalDataCore, CAL_DATA_CODEC);

	s_Window->Printf("\f<CODEC>\n");
	s_Window->Printf( "PGA_GAIN =%d\n",   codecCalDataCore.micGainCalibrateParam);
	s_Window->Printf( "interval =%d\n",   codecCalDataCore.AnalogInterfaceParam.interval);
	s_Window->Printf( "xpPullUpRegister=%d\n",   codecCalDataCore.AnalogInterfaceParam.xpPullUpRegister);

	PostProcess();
	PreProcess();

	s_Window->Printf("\f<CODEC>\n");
	s_Window->Printf( "driverGainHP   =%d\n",codecCalDataCore.driverGainHP );
	s_Window->Printf( "driverGainSP   =%d\n",codecCalDataCore.driverGainSP );
	s_Window->Printf( "analogVolumeHP =%d\n",codecCalDataCore.analogVolumeHP );
	s_Window->Printf( "analogVolumeSP =%d\n",codecCalDataCore.analogVolumeSP );
	s_Window->Printf( "shutterVolume1 =%d\n",codecCalDataCore.shutterVolume1 );
	s_Window->Printf( "shutterVolume2 =%d\n",codecCalDataCore.shutterVolume2 );
	s_Window->Printf( "micBias        =%d\n",codecCalDataCore.micBias );
	s_Window->Printf( "quickCharge    =%d\n",codecCalDataCore.quickCharge );
	s_Window->Printf( "micGainCalibrateParam =%d\n",codecCalDataCore.micGainCalibrateParam );
	s_Window->Printf( "reserved={" );
	for( int i=0 ; i<3 ; i++ )
	{
		s_Window->Printf( " %d", (int)codecCalDataCore.pad[i] );
	}
	s_Window->Printf( " }\n" );

	PostProcess();
	PreProcess();

	s_Window->Printf("\f<filterHp32>\n");
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterHp32.biquadA.n0, codecCalDataCore.filterHp32.biquadA.n1, codecCalDataCore.filterHp32.biquadA.n2, codecCalDataCore.filterHp32.biquadA.d1, codecCalDataCore.filterHp32.biquadA.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterHp32.biquadB.n0, codecCalDataCore.filterHp32.biquadB.n1, codecCalDataCore.filterHp32.biquadB.n2, codecCalDataCore.filterHp32.biquadB.d1, codecCalDataCore.filterHp32.biquadB.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterHp32.biquadC.n0, codecCalDataCore.filterHp32.biquadC.n1, codecCalDataCore.filterHp32.biquadC.n2, codecCalDataCore.filterHp32.biquadC.d1, codecCalDataCore.filterHp32.biquadC.d2);

	s_Window->Printf("\n<filterHp47>\n");
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterHp47.biquadA.n0, codecCalDataCore.filterHp47.biquadA.n1, codecCalDataCore.filterHp47.biquadA.n2, codecCalDataCore.filterHp47.biquadA.d1, codecCalDataCore.filterHp47.biquadA.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterHp47.biquadB.n0, codecCalDataCore.filterHp47.biquadB.n1, codecCalDataCore.filterHp47.biquadB.n2, codecCalDataCore.filterHp47.biquadB.d1, codecCalDataCore.filterHp47.biquadB.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterHp47.biquadC.n0, codecCalDataCore.filterHp47.biquadC.n1, codecCalDataCore.filterHp47.biquadC.n2, codecCalDataCore.filterHp47.biquadC.d1, codecCalDataCore.filterHp47.biquadC.d2);

	PostProcess();
	PreProcess();

	s_Window->Printf("\f<filterSp32>\n");
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterSp32.biquadA.n0, codecCalDataCore.filterSp32.biquadA.n1, codecCalDataCore.filterSp32.biquadA.n2, codecCalDataCore.filterSp32.biquadA.d1, codecCalDataCore.filterSp32.biquadA.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterSp32.biquadB.n0, codecCalDataCore.filterSp32.biquadB.n1, codecCalDataCore.filterSp32.biquadB.n2, codecCalDataCore.filterSp32.biquadB.d1, codecCalDataCore.filterSp32.biquadB.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterSp32.biquadC.n0, codecCalDataCore.filterSp32.biquadC.n1, codecCalDataCore.filterSp32.biquadC.n2, codecCalDataCore.filterSp32.biquadC.d1, codecCalDataCore.filterSp32.biquadC.d2);

	s_Window->Printf("\n<filterSp47>\n");
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterSp47.biquadA.n0, codecCalDataCore.filterSp47.biquadA.n1, codecCalDataCore.filterSp47.biquadA.n2, codecCalDataCore.filterSp47.biquadA.d1, codecCalDataCore.filterSp47.biquadA.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterSp47.biquadB.n0, codecCalDataCore.filterSp47.biquadB.n1, codecCalDataCore.filterSp47.biquadB.n2, codecCalDataCore.filterSp47.biquadB.d1, codecCalDataCore.filterSp47.biquadB.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterSp47.biquadC.n0, codecCalDataCore.filterSp47.biquadC.n1, codecCalDataCore.filterSp47.biquadC.n2, codecCalDataCore.filterSp47.biquadC.d1, codecCalDataCore.filterSp47.biquadC.d2);

	PostProcess();
	PreProcess();

	s_Window->Printf("\f<filterMic32>\n");
	s_Window->Printf( "[0X%04X, %d, %d]\n", codecCalDataCore.filterMic32.half.n0, codecCalDataCore.filterMic32.half.n1, codecCalDataCore.filterMic32.half.d1 );
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic32.biquadA.n0, codecCalDataCore.filterMic32.biquadA.n1, codecCalDataCore.filterMic32.biquadA.n2, codecCalDataCore.filterMic32.biquadA.d1, codecCalDataCore.filterMic32.biquadA.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic32.biquadB.n0, codecCalDataCore.filterMic32.biquadB.n1, codecCalDataCore.filterMic32.biquadB.n2, codecCalDataCore.filterMic32.biquadB.d1, codecCalDataCore.filterMic32.biquadB.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic32.biquadC.n0, codecCalDataCore.filterMic32.biquadC.n1, codecCalDataCore.filterMic32.biquadC.n2, codecCalDataCore.filterMic32.biquadC.d1, codecCalDataCore.filterMic32.biquadC.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic32.biquadD.n0, codecCalDataCore.filterMic32.biquadD.n1, codecCalDataCore.filterMic32.biquadD.n2, codecCalDataCore.filterMic32.biquadD.d1, codecCalDataCore.filterMic32.biquadD.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic32.biquadE.n0, codecCalDataCore.filterMic32.biquadE.n1, codecCalDataCore.filterMic32.biquadE.n2, codecCalDataCore.filterMic32.biquadE.d1, codecCalDataCore.filterMic32.biquadE.d2);


	s_Window->Printf("\n<filterMic47>\n");
	s_Window->Printf( "[0X%04X, %d, %d]\n", codecCalDataCore.filterMic47.half.n0, codecCalDataCore.filterMic47.half.n1, codecCalDataCore.filterMic47.half.d1 );
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic47.biquadA.n0, codecCalDataCore.filterMic47.biquadA.n1, codecCalDataCore.filterMic47.biquadA.n2, codecCalDataCore.filterMic47.biquadA.d1, codecCalDataCore.filterMic47.biquadA.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic47.biquadB.n0, codecCalDataCore.filterMic47.biquadB.n1, codecCalDataCore.filterMic47.biquadB.n2, codecCalDataCore.filterMic47.biquadB.d1, codecCalDataCore.filterMic47.biquadB.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic47.biquadC.n0, codecCalDataCore.filterMic47.biquadC.n1, codecCalDataCore.filterMic47.biquadC.n2, codecCalDataCore.filterMic47.biquadC.d1, codecCalDataCore.filterMic47.biquadC.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic47.biquadD.n0, codecCalDataCore.filterMic47.biquadD.n1, codecCalDataCore.filterMic47.biquadD.n2, codecCalDataCore.filterMic47.biquadD.d1, codecCalDataCore.filterMic47.biquadD.d2);
	s_Window->Printf( "[0X%04X, %d, %d, %d, %d]\n", codecCalDataCore.filterMic47.biquadE.n0, codecCalDataCore.filterMic47.biquadE.n1, codecCalDataCore.filterMic47.biquadE.n2, codecCalDataCore.filterMic47.biquadE.d1, codecCalDataCore.filterMic47.biquadE.d2);

	PostProcess();
	PreProcess();

	s_Window->Printf("\f<filterFree>\n");
	s_Window->Printf( "[0X%04X, %d, %d]\n", codecCalDataCore.filterFree.half.n0, codecCalDataCore.filterFree.half.n1, codecCalDataCore.filterFree.half.d1 );
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterFree.biquadA.n0, codecCalDataCore.filterFree.biquadA.n1, codecCalDataCore.filterFree.biquadA.n2, codecCalDataCore.filterFree.biquadA.d1, codecCalDataCore.filterFree.biquadA.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterFree.biquadB.n0, codecCalDataCore.filterFree.biquadB.n1, codecCalDataCore.filterFree.biquadB.n2, codecCalDataCore.filterFree.biquadB.d1, codecCalDataCore.filterFree.biquadB.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterFree.biquadC.n0, codecCalDataCore.filterFree.biquadC.n1, codecCalDataCore.filterFree.biquadC.n2, codecCalDataCore.filterFree.biquadC.d1, codecCalDataCore.filterFree.biquadC.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterFree.biquadD.n0, codecCalDataCore.filterFree.biquadD.n1, codecCalDataCore.filterFree.biquadD.n2, codecCalDataCore.filterFree.biquadD.d1, codecCalDataCore.filterFree.biquadD.d2);
	s_Window->Printf( "[0X%04X, 0X%04X, 0X%04X, 0X%04X, 0X%04X]\n", codecCalDataCore.filterFree.biquadE.n0, codecCalDataCore.filterFree.biquadE.n1, codecCalDataCore.filterFree.biquadE.n2, codecCalDataCore.filterFree.biquadE.d1, codecCalDataCore.filterFree.biquadE.d2);

	PostProcess();
	PreProcess();

	s_Window->Printf("\f<ANALOG INTERFACE>\n");
	s_Window->Printf( "interval         =%d\n",codecCalDataCore.AnalogInterfaceParam.interval );
	s_Window->Printf( "stabilization    =%d\n",codecCalDataCore.AnalogInterfaceParam.stabilization );
	s_Window->Printf( "precharge        =%d\n",codecCalDataCore.AnalogInterfaceParam.precharge );
	s_Window->Printf( "sense            =%d\n",codecCalDataCore.AnalogInterfaceParam.sense );
	s_Window->Printf( "debounce         =%d\n",codecCalDataCore.AnalogInterfaceParam.debounce );
	s_Window->Printf( "xpPullUpRegister =%d\n",codecCalDataCore.AnalogInterfaceParam.xpPullUpRegister );
	s_Window->Printf( "ymDriver         =%d\n",codecCalDataCore.AnalogInterfaceParam.ymDriver );
	s_Window->Printf( "reserve          =%d\n",codecCalDataCore.AnalogInterfaceParam.reserve );

	PostProcess();

}

/************************************************************************
lbtiXCh{[j\
 ************************************************************************/
static void ShowMcu(void)
{
	PreProcess();

	Calibration cal;
	McuCalDataCore mcuCalData;

	cal.Initialize();
    cal.Get(&mcuCalData, CAL_DATA_MCU);

	s_Window->Printf("\f<MCU>\n");
	s_Window->Printf( "SVR2 MIN  =%d\n", mcuCalData.svr2.min );
	s_Window->Printf( "SVR2 MAX  =%d\n", mcuCalData.svr2.max );
	s_Window->Printf( "SOUND MIN =%d\n", mcuCalData.sound.min );
	s_Window->Printf( "SOUND MAX =%d\n", mcuCalData.sound.max );

	PostProcess();
}

/************************************************************************
tkbc@cdk`x\
 ************************************************************************/
static void ShowUlcdDelay(void)
{
	PreProcess();

	Calibration cal;
	UlcdDelayCalDataCore ulcdDelayCalData;

	cal.Initialize();
    cal.Get(&ulcdDelayCalData, CAL_DATA_ULCD_DELAY );

	s_Window->Printf("\f<ULCD DELAY>\n");
	s_Window->Printf( "to2D =%d\n", (int)ulcdDelayCalData.to2D );
	s_Window->Printf( "to3D =%d\n", (int)ulcdDelayCalData.to3D );

	PostProcess();
}

/************************************************************************
akQovl\
 ************************************************************************/
static void ShowBlPwm(void)
{
	PreProcess();

	Calibration cal;
	BacklightCalDataCore backlightCalDataCore;

	cal.Initialize();
    cal.Get(&backlightCalDataCore, CAL_DATA_BL_PWM );

	s_Window->Printf("\f<BL PWM>\n");
    for(int i=0; i<3; i++){
        for(int j=0; j<3; j++){
            s_Window->Printf( "coef[%d][%d]=%f\n", i, j, backlightCalDataCore.coef[i][j] );
        }
    }
	
	s_Window->Printf( "luminanceLevel={" );
	for( int i=0 ; i<7 ; i++ )
	{
		s_Window->Printf( " %d", (int)backlightCalDataCore.luminanceLevel[i] );
	}
	s_Window->Printf( " }\n" );
	PostProcess();
}

/************************************************************************
l\
 ************************************************************************/
static void ShowModel(void)
{
	PreProcess();

	Calibration cal;
	cal.Initialize();

#if (NN_VERSION_MAJOR >= 3)
	s_Window->Printf("\fModel VERSION = %d\n", cal.GetModel() );
#else
	s_Window->Printf("\fCAN'T GET Model VERSION\n" );
#endif

	PostProcess();
}

/************************************************************************
RcTEhp[^\
 ************************************************************************/
static void Show3DSurround(void)
{
	Calibration cal;
	Surround surround;

	cal.Initialize();
    cal.Get(&surround, CAL_DATA_SURROUND );
    
    
	for( int j=0 ; j<8 ; j++ )
	{
		PreProcess();
		s_Window->Printf("\f<3D Surround> %d/8\n", j+1);
		s_Window->Printf("specialFilter:\n   ");
		for( int i=32*j ; i<32*(j+1) ; i++ )
		{
			s_Window->Printf( " 0x%04X", surround.specialFilter[i] & 0xFFFF );
			s_Window->Printf( (i+1)%4==0 ? "\n   " : "," );
		}
		PostProcess();
	}
	PreProcess();
	s_Window->Printf("\f<3D Surround>\n");
	for( int i=0 ; i<5 ; i++ )
	{
		s_Window->Printf( "iirFilter[%d] = 0x%08X\n", i, surround.iirFilter[i] );
	}
	PostProcess();
}

/************************************************************************
ECHO CANCEL\
 ************************************************************************/
static void ShowEchoCancel(void)
{
	PreProcess();

	Calibration cal;
	EchoCancelCalDataCore echoCancelCalDataCore;

	cal.Initialize();
    cal.Get(&echoCancelCalDataCore, CAL_DATA_ECHO_CANCEL);

	s_Window->Printf("\f<ECHO CANCEL>\n");
	s_Window->Printf( "0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",   echoCancelCalDataCore.param[0],
	                                                                echoCancelCalDataCore.param[1],
	                                                                echoCancelCalDataCore.param[2],
	                                                                echoCancelCalDataCore.param[3],
	                                                                echoCancelCalDataCore.param[4],
	                                                                echoCancelCalDataCore.param[5],
	                                                                echoCancelCalDataCore.param[6],
	                                                                echoCancelCalDataCore.param[7] );

	PostProcess();
}


/************************************************************************
b`klrcɃZ[u
 ************************************************************************/
bool uji::sec::cal::SaveToSd( const char *fileName )
{
	bool retValue;
	nn::fs::FileOutputStream ofile;
	nn::Result nnResult;
	Calibration cal;
	cal.Initialize();

	//rcJ[h̃}Eg
	if( !nn::fs::IsSdmcInserted() ) return false;
	if( nn::fs::MountSdmc().IsFailure() ) return false;


	//i[f[^
	uji::sec::cal::CalSuite *calSuite = new uji::sec::cal::CalSuite;

	calSuite->isAdjusted_LcdFlicker			= cal.IsAdjusted(CAL_DATA_LCD_FLICKER				);
	calSuite->isAdjusted_Camera				= cal.IsAdjusted(CAL_DATA_CAMERA					);
	calSuite->isAdjusted_TouchPanel			= cal.IsAdjusted(CAL_DATA_TOUCH_PANEL				);
	calSuite->isAdjusted_AnalogStick		= cal.IsAdjusted(CAL_DATA_ANALOG_STICK				);
	calSuite->isAdjusted_Codec				= cal.IsAdjusted(CAL_DATA_CODEC						);
	calSuite->isAdjusted_GyroScope			= cal.IsAdjusted(CAL_DATA_GYRO_SCOPE				);
	calSuite->isAdjusted_Rtc				= cal.IsAdjusted(CAL_DATA_RTC						);
	calSuite->isAdjusted_Accel				= cal.IsAdjusted(CAL_DATA_ACCEL						);
	calSuite->isAdjusted_AnalogStickAppend	= cal.IsAdjusted(CAL_DATA_ANALOG_STICK_APPEND		);
	calSuite->isAdjusted_CameraAppend		= cal.IsAdjusted(CAL_DATA_CAMERA_APPEND				);
	calSuite->isAdjusted_Mcu				= cal.IsAdjusted(CAL_DATA_MCU						);

	if( !cal.Get( &(calSuite->lcdFlickerInfo),			CAL_DATA_LCD_FLICKER				) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->cameraCalDataCore),		CAL_DATA_CAMERA						) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->touchPanelCalDataCore),	CAL_DATA_TOUCH_PANEL				) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->analogStickCalDataCore),	CAL_DATA_ANALOG_STICK				) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->codecCalDataCore),			CAL_DATA_CODEC					) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->gyroCalDataCore),			CAL_DATA_GYRO_SCOPE					) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->rtcCompensation),			CAL_DATA_RTC						) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->accelCalDataCore),			CAL_DATA_ACCEL					) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->analogStickCalAppendCore),	CAL_DATA_ANALOG_STICK_APPEND	) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->cameraCalAppendCore),		CAL_DATA_CAMERA_APPEND				) ) SYS_PANIC( "CAL ERROR" );
    if( !cal.Get( &(calSuite->mcuCalDataCore),			CAL_DATA_MCU						) ) SYS_PANIC( "CAL ERROR" );


	//t@Cɏ
	if( ofile.TryInitialize( fileName, true ).IsSuccess() )
	{
		if( ofile.Write( calSuite, sizeof(uji::sec::cal::CalSuite) ) == sizeof(uji::sec::cal::CalSuite) )
		{
			retValue = true;
		}else{
			retValue = false;
		}
		ofile.Finalize();
	}else{
		retValue = false;
	}

	delete calSuite;
	nn::fs::Unmount("sdmc:");
	return retValue;

}

static void Save(void)
{
    uji::sys::Pad pad;
	pad.UpdatePad();

	if( pad.IsButtonPress( Pad::BUTTON_R ) )
	{
		char *message;
		nn::fs::MountSdmc();
		nn::fs::TryCreateDirectory(L"sdmc:/uji" );
		nn::fs::TryCreateDirectory(L"sdmc:/uji/cal" );
		nn::fs::Unmount("sdmc:" );

		char fileName[0x100];
		bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
		GetMacAddress( mac );
		Calibration cal;
		cal.Initialize();
		sprintf( fileName, "sdmc:/uji/cal/%02X%02X%02X%02X%02X%02X.Ver%d.cal",
				mac[0],mac[1],mac[2],mac[3],mac[4],mac[5],(int)cal.GetVersion() );


		if( uji::sec::cal::SaveToSd( fileName ) )
		{
			message = "Success to save.";
		}else{
			message = "Fail to save.";
		}
		uji::sys::ShowMessage::Open( &Menu::m_WindowManager, message );		
	}
}

/************************************************************************
b`klrc烍[h
 ************************************************************************/
bool uji::sec::cal::LoadFromSd( const char *fileName)
{
	bool retValue;
	nn::fs::FileInputStream ifile;
	nn::Result nnResult;
	Calibration cal;
	cal.Initialize();

	//rcJ[h̃}Eg
	if( !nn::fs::IsSdmcInserted() ) return false;
	if( nn::fs::MountSdmc().IsFailure() ) return false;

	uji::sec::cal::CalSuite *calSuite = new uji::sec::cal::CalSuite;

	//t@CI[vď{
	if( ifile.TryInitialize( fileName ).IsSuccess() )
	{
		if( ifile.Read( calSuite, sizeof(uji::sec::cal::CalSuite) ) == sizeof(uji::sec::cal::CalSuite) )
		{
			retValue = true;
		}else{
			retValue = false;
		}
		ifile.Finalize();
	}else{
		retValue = false;
	}

	//ς݃f[^b`kɊi[
	if( retValue==true )
	{

		if( calSuite->isAdjusted_LcdFlicker )
		{
			if( !cal.Set( &(calSuite->lcdFlickerInfo), CAL_DATA_LCD_FLICKER) )				SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_Camera )
		{
			if( !cal.Set( &(calSuite->cameraCalDataCore), CAL_DATA_CAMERA ) )				SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_TouchPanel )
		{
		   if( !cal.Set( &(calSuite->touchPanelCalDataCore), CAL_DATA_TOUCH_PANEL) )		SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_AnalogStick )
		{
			if( !cal.Set( &(calSuite->analogStickCalDataCore), CAL_DATA_ANALOG_STICK ) )	SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_Codec )
		{
			if( !cal.Set( &(calSuite->codecCalDataCore), CAL_DATA_CODEC	) )					SYS_PANIC( "CAL ERROR" );;
		}

		if( calSuite->isAdjusted_GyroScope )
		{
			if( !cal.Set( &(calSuite->gyroCalDataCore),	CAL_DATA_GYRO_SCOPE	) )				SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_Rtc )
		{
			if( !cal.Set( &(calSuite->rtcCompensation),	CAL_DATA_RTC ) )					SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_Accel )
		{
			if( !cal.Set( &(calSuite->accelCalDataCore), CAL_DATA_ACCEL	) )					SYS_PANIC( "CAL ERROR" );
		}
		
		if( calSuite->isAdjusted_AnalogStickAppend )
		{
			if( !cal.Set( &(calSuite->analogStickCalAppendCore), CAL_DATA_ANALOG_STICK_APPEND ) ) SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_CameraAppend )
		{
			if( !cal.Set( &(calSuite->cameraCalAppendCore), CAL_DATA_CAMERA_APPEND ) )		SYS_PANIC( "CAL ERROR" );
		}

		if( calSuite->isAdjusted_Mcu )
		{
			if( !cal.Set( &(calSuite->mcuCalDataCore), CAL_DATA_MCU ) )						SYS_PANIC( "CAL ERROR" );
		}
		
		if( !cal.Flush() )																	SYS_PANIC( "CAL ERROR" );
	}

	delete calSuite;
	nn::fs::Unmount("sdmc:");
	return retValue;

}
static void Load(void)
{
    uji::sys::Pad pad;
	pad.UpdatePad();

	if( pad.IsButtonPress( Pad::BUTTON_R ) )
	{
		char *message;

		char fileName[0x100];
		bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
		GetMacAddress( mac );
		Calibration cal;
		cal.Initialize();
		sprintf( fileName, "sdmc:/uji/cal/%02X%02X%02X%02X%02X%02X.Ver%d.cal",
				mac[0],mac[1],mac[2],mac[3],mac[4],mac[5],(int)cal.GetVersion() );

		if( uji::sec::cal::LoadFromSd( fileName ) )
		{
			message = "Success to load.";
		}else{
			message = "Fail to load.";
		}
		uji::sys::ShowMessage::Open( &Menu::m_WindowManager, message );		
	}
}

/************************************************************************
b`klCjVCY
b`k̃t@C폜܂B
 ************************************************************************/

static void Initialize(void)
{
	const wchar_t CAL_FILE0[]=L"nand:/ro/sys/HWCAL0.dat";
	const wchar_t CAL_FILE1[]=L"nand:/ro/sys/HWCAL1.dat";

	uji::sys::Pad pad;
	pad.UpdatePad();

	if( pad.IsButtonPress( Pad::BUTTON_R ) )
	{
		if( uji::sys::ShowMessage::Open( &Menu::m_WindowManager, "Confirm", uji::sys::ShowMessage::SHM_OK_CANCEL ) ){		
			nn::Result nnResult0;
			nn::Result nnResult1;

			nnResult0 = nn::fs::TryDeleteFile( CAL_FILE0 );
			nnResult1 = nn::fs::TryDeleteFile( CAL_FILE1 );

			if( nnResult0.IsFailure() || nnResult1.IsFailure() ){

				if( nnResult0.IsFailure() )	{
					if(nnResult0 <= nn::fs::ResultNotFound()){
						uji::sys::ShowMessage::Open( &Menu::m_WindowManager, "FAIL:HWCAL0.dat ResultNotFound" );
					}else{
						uji::sys::ShowMessage::Open( &Menu::m_WindowManager, "FAIL:HWCAL0.dat Other Error" );
					}
				}

				if( nnResult1.IsFailure() )	{
					if(nnResult1 <= nn::fs::ResultNotFound()){
						uji::sys::ShowMessage::Open( &Menu::m_WindowManager, "FAIL:HWCAL1.dat ResultNotFound" );
					}else{
						uji::sys::ShowMessage::Open( &Menu::m_WindowManager, "FAIL:HWCAL1.dat Other Error" );
					}
				}

			}else{
				uji::sys::ShowMessage::Open( &Menu::m_WindowManager, "Success to Initialize." );
			}
		}
	}
}

/************************************************************************
RTC␳lύXifobOpj
 ************************************************************************/
static void EditRtcCal(void)
{
	uji::sys::Pad pad;
	pad.UpdatePad();

	if( pad.IsButtonPress( Pad::BUTTON_R ) )
	{

		PreProcess();

		Calibration cal;
		RtcCompensation rtcCompensation;

		cal.Initialize();
		cal.Get(&rtcCompensation, CAL_DATA_RTC);

		s_Window->Printf("\f<RTC>\n");
		s_Window->Printf( "RTCCompensationValue =" );
		rtcCompensation.RTCCompensationValue = 
			s_Window->InputData8( rtcCompensation.RTCCompensationValue );

		if( !cal.Set( &rtcCompensation, CAL_DATA_RTC) )	SYS_PANIC( "CAL FAIL" );
		if( !cal.Flush() )								SYS_PANIC( "CAL FAIL" );

		s_Window->Printf("\nSuccess\n");
		PostProcess();

	
	}
}

/************************************************************************
̂b`k𒲐ς݂ɕύXifobOpj

Config->AdjustedCal̐ݒrbgɑΉ鍀ڂ𒲐ς݂ɂ܂B
@l͓ǂ񂾒l߂Ă܂̂ŁAύX܂B

rbgΉ́uuji::sec::cal::TestConfirmCalAdjustedvQƂ̂

************************************************************************/
static void MarkCalAdjusted(void)
{
	uji::sys::Pad pad;
	pad.UpdatePad();

	uji::seq::Config config;

#if 0
    u32 adjustedCal = config.Get().AdjustedCal;		//Ώۂb`k
#else
	u32 adjustedCal ;
    switch(uji::sys::GetPlatformType())
    {
        case PLATFORM_CTR: adjustedCal = config.Get().AdjustedCalCtr; break;
        case PLATFORM_SPR: adjustedCal = config.Get().AdjustedCalSpr; break;
        case PLATFORM_FTR: adjustedCal = config.Get().AdjustedCalFtr; break;
        case PLATFORM_KTR: adjustedCal = config.Get().AdjustedCalKtr; break;
    }
#endif


	char *buffer = new char[DEBUGGER_EEPROM_SIZE];	//Uzނ߂̃obt@
	bool intendToMark;

	if( pad.IsButtonPress( Pad::BUTTON_R ) )
	{

		PreProcess();
		Calibration cal;
		cal.Initialize();

		for( int i=0 ; i<nn::drivers::cal::CTR::CAL_DATA_MAX ; i++ )
		{
			intendToMark = (adjustedCal>>i & 1 )?true:false;

			if( intendToMark )
			{
				s_Window->Printf("Mark %d\n", i );
			    if( !cal.Get( buffer, (nn::drivers::cal::CTR::Type)i ))	SYS_PANIC( "CAL FAIL" );
				if( !cal.Set( buffer, (nn::drivers::cal::CTR::Type)i ))	SYS_PANIC( "CAL FAIL" );
			}
		}
		if( !cal.Flush() )												SYS_PANIC( "CAL FAIL" );

		s_Window->Printf("\nSuccess to mark\n");
		PostProcess();

	
	}

	delete[] buffer;
}
