/*--------------------------------------------------------------------------*
 Project:
 File: Cal2Cfg.h

*--------------------------------------------------------------------------*/
#ifndef CAL2CFG_H_INCLUDED
#define CAL2CFG_H_INCLUDED

#include "sys.h"

namespace uji {
namespace sec {

    enum CAL2CFG_SUBJECT
    {
        FCRAM          =  0,
        LCD_FLICKER    =  1,
        TOUCH_PANEL    =  2,
        GYRO_SCOPE     =  3,
        RTC            =  4,
        ACCEL          =  5,
        CAMERA         =  6,
        ANALOG_STICK   =  7,
        BL_PWM         =  8,
        ABL            =  9,
        ABL_LGY        = 10,
        ULCD           = 11,
        MCU            = 12,
        SURROUND       = 13,
        CODEC          = 14,
        ULCD_DELAY     = 15,
        ECHO_CANCEL    = 16,
        
        CAL2CFG_SUBJECT_NUM = 17
    };

    enum CAL2CFG_RESULT
    {
        PASS           =  1,
        FAIL_SET_CFG   = -1,
        FAIL_FLUSH_CFG = -2
    };
    
    void CalToCfg();
    s32  RetCalToCfg( s32 ret_Cal2Cfg, CAL2CFG_SUBJECT sbj );
    
    s32  CalToCfg_FCRAM();
    s32  CalToCfg_LCD_FLICKER();
    s32  CalToCfg_TOUCH_PANEL();
    s32  CalToCfg_GYRO_SCOPE();
    s32  CalToCfg_RTC();
    s32  CalToCfg_ACCEL();
    s32  CalToCfg_CAMERA();
    s32  CalToCfg_ANALOG_STICK();
    s32  CalToCfg_BL_PWM();
    s32  CalToCfg_ABL();
    s32  CalToCfg_ABL_LGY();
    s32  CalToCfg_ULCD();
    s32  CalToCfg_MCU();
    s32  CalToCfg_SURROUND();
    s32  CalToCfg_CODEC();
    s32  CalToCfg_ULCD_DELAY();
    s32  CalToCfg_ECHO_CANCEL();
    
}
}

/* CAL2CFG_H_INCLUDED */
#endif
